/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImplKt;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/actions/ResumeThreadAction;", "Lcom/intellij/debugger/actions/DebuggerAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.java.debugger.impl"})
@ApiStatus.Internal
public final class ResumeThreadAction
extends DebuggerAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray = DebuggerAction.getSelectedNodes(e.getDataContext());
        if (debuggerTreeNodeImplArray == null) {
            return;
        }
        DebuggerTreeNodeImpl[] selectedNodes = debuggerTreeNodeImplArray;
        DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(e.getDataContext());
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
        DebuggerContextImpl debuggerContext = debuggerContextImpl;
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        for (DebuggerTreeNodeImpl debuggerTreeNode : selectedNodes) {
            DebuggerManagerThreadImpl managerThread;
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNode.getDescriptor();
            Intrinsics.checkNotNull((Object)nodeDescriptorImpl, (String)"null cannot be cast to non-null type com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl");
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)nodeDescriptorImpl;
            if (debuggerContext.getManagerThread() == null) {
                return;
            }
            if (!threadDescriptor.isSuspended()) continue;
            ThreadReferenceProxyImpl threadReferenceProxyImpl = threadDescriptor.getThreadReference();
            Intrinsics.checkNotNullExpressionValue((Object)threadReferenceProxyImpl, (String)"getThreadReference(...)");
            Companion.resumeThread(threadReferenceProxyImpl, debugProcess, managerThread);
            ApplicationManager.getApplication().invokeLater(() -> ResumeThreadAction.actionPerformed$lambda$0(debuggerTreeNode));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] debuggerTreeNodeImplArray;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DebuggerTreeNodeImpl[] selectedNodes = DebuggerAction.getSelectedNodes(e.getDataContext());
        boolean visible = false;
        if (selectedNodes != null && selectedNodes.length > 0) {
            visible = true;
            debuggerTreeNodeImplArray = selectedNodes;
            int n = debuggerTreeNodeImplArray.length;
            for (int i = 0; i < n; ++i) {
                DebuggerTreeNodeImpl selectedNode = debuggerTreeNodeImplArray[i];
                NodeDescriptorImpl threadDescriptor = selectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                visible = false;
                break;
            }
        }
        DebuggerTreeNodeImpl[] $this$update_u24lambda_u240 = debuggerTreeNodeImplArray = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.setEnabledAndVisible(visible);
        $this$update_u24lambda_u240.setText(JavaDebuggerBundle.message((String)"action.resume.thread.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final void actionPerformed$lambda$0(DebuggerTreeNodeImpl $debuggerTreeNode) {
        $debuggerTreeNode.calcValue();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/actions/ResumeThreadAction$Companion;", "", "<init>", "()V", "resumeThread", "", "thread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "managerThread", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "intellij.java.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void resumeThread(@NotNull ThreadReferenceProxyImpl thread, @NotNull DebugProcessImpl debugProcess, @NotNull DebuggerManagerThreadImpl managerThread) {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)managerThread, (String)"managerThread");
            DebuggerManagerThreadImplKt.executeOnDMT$default(managerThread, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(debugProcess, thread, managerThread, null){
                int label;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                final /* synthetic */ ThreadReferenceProxyImpl $thread;
                final /* synthetic */ DebuggerManagerThreadImpl $managerThread;
                {
                    this.$debugProcess = $debugProcess;
                    this.$thread = $thread;
                    this.$managerThread = $managerThread;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            SuspendContextImpl suspendingContext = SuspendManagerUtil.getSuspendingContext(this.$debugProcess.getSuspendManager(), this.$thread);
                            if (suspendingContext != null) {
                                SuspendContextCommandImpl suspendContextCommandImpl = this.$debugProcess.createResumeThreadCommand(suspendingContext, this.$thread);
                                Intrinsics.checkNotNullExpressionValue((Object)suspendContextCommandImpl, (String)"createResumeThreadCommand(...)");
                                this.$managerThread.invokeNow(suspendContextCommandImpl);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

