/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.AsyncStackTracesOverheadUtilsKt;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerAgentParametersModifier;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SyntheticMethodBreakpoint;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.testFramework.TestDebuggerAgentArtifactsProvider;
import com.intellij.debugger.ui.breakpoints.JavaCollectionBreakpointType;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.idea.AppMode;
import com.intellij.java.debugger.impl.shared.JavaDebuggerSharedBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.BazelEnvironmentUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XStackFrameWithSeparatorAbove;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.LocatableEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.BuildDependenciesJps;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;

public final class AsyncStacksUtils {
    private static final Logger LOG = Logger.getInstance(AsyncStacksUtils.class);
    public static final String CAPTURE_STORAGE_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureStorage";
    public static final String CAPTURE_AGENT_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureAgent";
    private static final String AGENT_JAR_NAME = "debugger-agent.jar";
    private static final Key<Boolean> ASYNC_STACKS_ENABLED = Key.create((String)"ASYNC_STACKS_ENABLED");
    private static final Key<Pair<ClassType, Method>> CAPTURE_STORAGE_METHOD = Key.create((String)"CAPTURE_STORAGE_METHOD");
    private static final Pair<ClassType, Method> NO_CAPTURE_AGENT = Pair.empty();

    @ApiStatus.Internal
    public static Boolean isAsyncStacksEnabled(XDebugSessionImpl session) {
        return (Boolean)ASYNC_STACKS_ENABLED.get((UserDataHolder)session.getSessionData(), (Object)true);
    }

    @ApiStatus.Internal
    public static void setAsyncStacksEnabled(XDebugSessionImpl session, Boolean state) {
        ASYNC_STACKS_ENABLED.set((UserDataHolder)session.getSessionData(), (Object)state);
    }

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    public static boolean isSuspendHelperEnabled() {
        return AsyncStacksUtils.isAgentEnabled() && Registry.is((String)"debugger.run.suspend.helper");
    }

    @Nullable
    public static @Nullable List<@Nullable StackFrameItem> getAgentRelatedStack(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
        if (frame == null) {
            AsyncStacksUtils.$$$reportNull$$$0(0);
        }
        if (suspendContext == null) {
            AsyncStacksUtils.$$$reportNull$$$0(1);
        }
        if (!AsyncStacksUtils.isAgentEnabled()) {
            return null;
        }
        try {
            Method method = DebuggerUtilsEx.getMethod(frame.location());
            if (method != null && method.name().endsWith("$$$capture")) {
                return AsyncStacksUtils.getCapturedStackForThread(new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy()), frame.threadProxy().getThreadReference());
            }
        }
        catch (EvaluateException e) {
            ObjectReference targetException = e.getExceptionFromTargetVM();
            if (e.getCause() instanceof IncompatibleThreadStateException) {
                LOG.warn((Throwable)e);
            }
            if (targetException != null && DebuggerUtils.instanceOf((Type)targetException.type(), (String)"java.lang.StackOverflowError")) {
                LOG.warn((Throwable)e);
            }
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static List<StackFrameItem> getCapturedStackForThread(EvaluationContextImpl evalContext, ThreadReference threadReference) throws EvaluateException {
        EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl process = evaluationContext.getDebugProcess();
        VirtualMachineProxyImpl virtualMachineProxy = evalContext.getVirtualMachineProxy();
        Pair methodPair = (Pair)virtualMachineProxy.getUserData(CAPTURE_STORAGE_METHOD);
        if (methodPair == null) {
            try {
                ClassType captureClass = (ClassType)process.findClass(evaluationContext, CAPTURE_STORAGE_CLASS_NAME, null);
                if (captureClass == null) {
                    methodPair = NO_CAPTURE_AGENT;
                    LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    methodPair = Pair.create((Object)captureClass, (Object)DebuggerUtils.findMethod((ReferenceType)captureClass, (String)"getCapturedStackForThread", null));
                }
            }
            catch (EvaluateException e) {
                methodPair = NO_CAPTURE_AGENT;
                LOG.debug("Error loading debug agent", (Throwable)e);
            }
            virtualMachineProxy.putUserData(CAPTURE_STORAGE_METHOD, methodPair);
        }
        if (methodPair == NO_CAPTURE_AGENT) {
            return null;
        }
        Pair finalMethodPair = methodPair;
        List<Value> args = Arrays.asList(evaluationContext.getVirtualMachineProxy().mirrorOf(AsyncStacksUtils.getMaxStackLength()), threadReference);
        String value = (String)DebuggerUtils.getInstance().processCollectibleValue(() -> process.invokeMethod(evaluationContext, (ClassType)finalMethodPair.first, (Method)finalMethodPair.second, args, 1, true), result -> result instanceof StringReference ? ((StringReference)result).value() : null, (EvaluationContext)evaluationContext);
        if (value != null) {
            return AsyncStacksUtils.parseAgentAsyncStackTrace(value, virtualMachineProxy);
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static @Nullable List<@Nullable StackFrameItem> parseAgentAsyncStackTrace(String value, VirtualMachineProxyImpl vm) {
        List<StackFrameItem> list;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(value.getBytes(StandardCharsets.ISO_8859_1)));
        try {
            list = AsyncStacksUtils.parseAgentAsyncStackTrace(dis, vm);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                DebuggerUtilsImpl.logError(e);
                return null;
            }
        }
        dis.close();
        return list;
    }

    @ApiStatus.Internal
    @Nullable
    public static @Nullable List<@Nullable StackFrameItem> parseAgentAsyncStackTrace(DataInputStream dis, VirtualMachineProxyImpl vm) {
        try {
            ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>();
            while (dis.available() > 0) {
                StackFrameItem item = null;
                if (dis.readBoolean()) {
                    String className = dis.readUTF();
                    String methodName = dis.readUTF();
                    int line = dis.readInt();
                    if ("< Unknown".equals(className) && "Stack > ".equals(methodName)) {
                        item = new ThrottledStackFrameItem(vm.getVirtualMachine());
                    } else {
                        Location location = DebuggerUtilsEx.findOrCreateLocation(vm.getVirtualMachine(), className, methodName, line);
                        item = new StackFrameItem(location, null);
                    }
                }
                res.add(item);
            }
            return res;
        }
        catch (Exception e) {
            DebuggerUtilsImpl.logError(e);
            return null;
        }
    }

    public static void setupAgent(final DebugProcessImpl process) {
        Properties properties;
        if (!AsyncStacksUtils.isAgentEnabled()) {
            return;
        }
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            AsyncStacksUtils.enableAgentDebug(process);
        }
        AsyncStacksUtils.initializeOverheadDetector(process);
        if (DebuggerUtilsImpl.isRemote(process) && !(properties = CaptureSettingsProvider.getPointsProperties(process.getProject())).isEmpty()) {
            process.addDebugProcessListener(new DebugProcessAdapterImpl(){

                @Override
                public void paused(SuspendContextImpl suspendContext) {
                    if (process.isEvaluationPossible()) {
                        try {
                            StackCapturingLineBreakpoint.deleteAll(process);
                            try {
                                AsyncStacksUtils.addAgentCapturePoints(new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy()), properties);
                                process.removeDebugProcessListener(this);
                            }
                            finally {
                                process.onHotSwapFinished();
                                StackCapturingLineBreakpoint.createAll(process);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                }

                @Override
                public void processDetached(DebugProcessImpl process2, boolean closedByUser) {
                    process2.removeDebugProcessListener(this);
                }
            });
        }
    }

    private static void enableAgentDebug(DebugProcessImpl process) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerUtilsEx.setStaticBooleanField(process, CAPTURE_STORAGE_CLASS_NAME, "DEBUG", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAgentCapturePoints(EvaluationContextImpl evalContext, Properties properties) {
        block8: {
            EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
            DebugProcessImpl process = evaluationContext.getDebugProcess();
            try {
                ClassType captureClass = (ClassType)process.findClass(evaluationContext, CAPTURE_AGENT_CLASS_NAME, null);
                if (captureClass == null) {
                    LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
                    break block8;
                }
                Method method = DebuggerUtils.findMethod((ReferenceType)captureClass, (String)"addCapturePoints", null);
                if (method == null) break block8;
                StringWriter writer = new StringWriter();
                try {
                    properties.store(writer, null);
                    StringReference stringArgs = DebuggerUtilsEx.mirrorOfString(writer.toString(), evalContext);
                    List<StringReference> args = Collections.singletonList(stringArgs);
                    try {
                        process.invokeMethod(evaluationContext, captureClass, method, args, 1, true);
                    }
                    finally {
                        DebuggerUtilsEx.enableCollection(stringArgs);
                    }
                }
                catch (Exception e) {
                    DebuggerUtilsImpl.logError(e);
                }
            }
            catch (EvaluateException e) {
                LOG.debug("Error loading debug agent", (Throwable)e);
            }
        }
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key, @Nullable T value, DebugProcessImpl debugProcess) {
        if (key == null) {
            AsyncStacksUtils.$$$reportNull$$$0(2);
        }
        debugProcess.putUserData(key, value);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                if (process == null) {
                    2.$$$reportNull$$$0(0);
                }
                process.putUserData(key, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/engine/AsyncStacksUtils$2", "processDetached"));
            }
        });
    }

    public static int getMaxStackLength() {
        return Registry.intValue((String)"debugger.async.stacks.max.depth", (int)500);
    }

    public static void addDebuggerAgent(JavaParameters parameters, @Nullable Project project, boolean checkJdkVersion) {
        AsyncStacksUtils.addDebuggerAgent(parameters, project, checkJdkVersion, null);
    }

    public static void addDebuggerAgent(JavaParameters parameters, @Nullable Project project, boolean checkJdkVersion, @Nullable Disposable disposable) {
        AsyncStacksUtils.addDebuggerAgent(parameters, project, checkJdkVersion, disposable, false);
    }

    public static void addDebuggerAgent(JavaParameters parameters, @Nullable Project project, boolean checkJdkVersion, @Nullable Disposable disposable, boolean matchWithExecutionTarget) {
        if (AsyncStacksUtils.isAgentEnabled()) {
            String prefix = "-javaagent:";
            ParametersList parametersList = parameters.getVMParametersList();
            if (!ContainerUtil.exists((Iterable)parametersList.getParameters(), p -> p.startsWith(prefix) && p.contains(AGENT_JAR_NAME))) {
                JavaSdkVersion sdkVersion;
                Sdk jdk = parameters.getJdk();
                if (checkJdkVersion && jdk == null) {
                    return;
                }
                JavaSdkVersion javaSdkVersion = sdkVersion = jdk != null ? JavaSdk.getInstance().getVersion(jdk) : null;
                if (checkJdkVersion && (sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7))) {
                    LOG.warn("Capture agent is not supported for JRE " + String.valueOf(sdkVersion));
                    return;
                }
                AsyncStacksUtils.extendParametersForAgent(project, disposable, parametersList, prefix, matchWithExecutionTarget);
            }
        }
    }

    private static void extendParametersForAgent(@Nullable Project project, @Nullable Disposable disposable, @NotNull ParametersList parametersList, @NotNull String prefix, boolean targetedPath) {
        Path agentNativePath;
        if (parametersList == null) {
            AsyncStacksUtils.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            AsyncStacksUtils.$$$reportNull$$$0(4);
        }
        if ((agentNativePath = AsyncStacksUtils.getAgentArtifactPath(project, disposable)) == null) {
            return;
        }
        String agentPath = targetedPath ? EelNioBridgeServiceKt.asEelPath((Path)agentNativePath).toString() : agentNativePath.toString();
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-307303, EA-835503");){
            parametersList.prepend(prefix + agentPath + AsyncStacksUtils.generateAgentSettings(project));
        }
        if (Registry.is((String)"debugger.async.stacks.coroutines", (boolean)false)) {
            parametersList.addProperty("kotlinx.coroutines.debug.enable.creation.stack.trace", "false");
            parametersList.addProperty("debugger.agent.enable.coroutines", "true");
            if (Registry.is((String)"debugger.async.stacks.flows", (boolean)false)) {
                parametersList.addProperty("kotlinx.coroutines.debug.enable.flows.stack.trace", "true");
            }
            if (Registry.is((String)"debugger.async.stacks.state.flows", (boolean)false)) {
                parametersList.addProperty("kotlinx.coroutines.debug.enable.mutable.state.flows.stack.trace", "true");
            }
        }
        if (!Registry.is((String)"debugger.async.stack.trace.for.exceptions.printing", (boolean)false)) {
            parametersList.addProperty("debugger.agent.support.throwable", "false");
        }
        if (Registry.is((String)"debugger.async.stack.trace.for.all.threads")) {
            parametersList.addProperty("debugger.async.stack.trace.for.all.threads", "true");
        }
        for (DebuggerAgentParametersModifier modifier : DebuggerAgentParametersModifier.getAgentModifiers()) {
            modifier.modifyParameters(parametersList, project);
        }
    }

    @Nullable
    private static Path getAgentArtifactPath(@Nullable Project project, @Nullable Disposable disposable) {
        if (PluginManagerCore.isRunningFromSources() && !AppMode.isRunningFromDevBuild()) {
            return AsyncStacksUtils.getArtifactPathForDownloadedAgent(project, disposable);
        }
        return AsyncStacksUtils.getArtifactPathForBundledAgent(project, disposable);
    }

    @NotNull
    private static Path getArtifactPathForDownloadedAgent(@Nullable Project project, @Nullable Disposable disposable) {
        Path path;
        try {
            Path downloadedAgent;
            Path agentArtifactPath = AsyncStacksUtils.createTemporaryAgentPath(project, disposable);
            if (PluginManagerCore.isUnitTestMode && BazelEnvironmentUtil.isBazelTestRun()) {
                ServiceLoader<TestDebuggerAgentArtifactsProvider> providerClasses = ServiceLoader.load(TestDebuggerAgentArtifactsProvider.class);
                Iterator<TestDebuggerAgentArtifactsProvider> iterator = providerClasses.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalStateException("TestDebuggerAgentArtifactsProvider service provider not found");
                }
                TestDebuggerAgentArtifactsProvider provider = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalStateException("more than one TestDebuggerAgentArtifactsProvider service providers found. Only one is expected");
                }
                downloadedAgent = provider.getDebuggerAgentJar();
            } else {
                Path communityRoot = Path.of(PathManager.getCommunityHomePath(), new String[0]);
                Path iml = BuildDependenciesJps.getProjectModule((Path)communityRoot, (String)"intellij.java.debugger.agent.holder");
                downloadedAgent = BuildDependenciesJps.INSTANCE.getModuleLibrarySingleRootSync(iml, "debugger-agent", "https://cache-redirector.jetbrains.com/intellij-dependencies", new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0])));
            }
            Files.copy(downloadedAgent.toRealPath(new LinkOption[0]), agentArtifactPath, new CopyOption[0]);
            path = agentArtifactPath;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (path == null) {
            AsyncStacksUtils.$$$reportNull$$$0(5);
        }
        return path;
    }

    @Nullable
    private static Path getArtifactPathForBundledAgent(@Nullable Project project, @Nullable Disposable disposable) {
        EelDescriptor projectEelDescriptor;
        Path pluginDistDir = PluginManagerCoreKt.getPluginDistDirByClass(JavaDebuggerSharedBundle.class);
        if (pluginDistDir == null || !Files.isDirectory(pluginDistDir, new LinkOption[0])) {
            LOG.error("Unable to find the (java) plugin distribution directory by class AsyncStacksUtils");
            return null;
        }
        Path bundledAgentPath = pluginDistDir.resolve("lib").resolve("rt").resolve(AGENT_JAR_NAME);
        if (!Files.exists(bundledAgentPath, new LinkOption[0])) {
            LOG.error("Unable to find bundled debugger agent under the (java) plugin directory: " + String.valueOf(bundledAgentPath));
            return null;
        }
        EelDescriptor eelDescriptor = projectEelDescriptor = project == null ? null : EelProviderUtil.getEelDescriptor((Project)project);
        if (project == null || LocalEelDescriptor.INSTANCE.equals((Object)projectEelDescriptor)) {
            String processedAgentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)bundledAgentPath.toAbsolutePath().toString(), (String)"captureAgent", null, f -> f.getName().startsWith("debugger-agent"));
            if (processedAgentPath != null) {
                return Path.of(processedAgentPath, new String[0]);
            }
            return null;
        }
        Path temporaryAgentPath = AsyncStacksUtils.createTemporaryAgentPath(project, disposable);
        try {
            EelPathUtils.transferLocalContentToRemote((Path)bundledAgentPath.toRealPath(new LinkOption[0]), (EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(temporaryAgentPath));
        }
        catch (IOException e) {
            LOG.error(String.format("Unable to copy the java-debugger agent file from %s to %s", bundledAgentPath, temporaryAgentPath), (Throwable)e);
            return null;
        }
        return temporaryAgentPath;
    }

    @NotNull
    private static Path createTemporaryAgentPath(@Nullable Project project, @Nullable Disposable disposable) {
        Path debuggerAgentDir = EelPathUtils.createTemporaryDirectory((Project)project, (String)"debugger-agent", (String)"", (disposable == null ? 1 : 0) != 0);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> {
                try {
                    FileUtilRt.deleteRecursively((Path)debuggerAgentDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        Path path = debuggerAgentDir.resolve(AGENT_JAR_NAME);
        if (path == null) {
            AsyncStacksUtils.$$$reportNull$$$0(6);
        }
        return path;
    }

    private static String generateAgentSettings(@Nullable Project project) {
        Properties properties = CaptureSettingsProvider.getPointsProperties(project);
        for (DebuggerAgentParametersModifier modifier : DebuggerAgentParametersModifier.getAgentModifiers()) {
            modifier.modifyProperties(properties, project);
        }
        if (AsyncStacksUtils.isSuspendHelperEnabled()) {
            properties.setProperty("suspendHelper", "true");
        }
        boolean throttling = DebuggerSettings.getInstance().AGENT_THROTTLING;
        properties.setProperty("throttling", Boolean.toString(throttling));
        double overhead = Registry.doubleValue((String)"debugger.async.stack.trace.overhead.percent");
        properties.setProperty("overheadPercent", Double.toString(overhead));
        if (JavaCollectionBreakpointType.isEnabled()) {
            properties.setProperty("collectionBreakpoints", "true");
        }
        if (!properties.isEmpty()) {
            String string;
            block12: {
                Path path = EelPathUtils.createTemporaryFile((Project)project, (String)"capture", (String)".props", (boolean)true);
                OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
                try {
                    properties.store(out, null);
                    string = "=" + EelPathUtils.getUriLocalToEel((Path)path).toASCIIString();
                    if (out == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                out.close();
            }
            return string;
        }
        return "";
    }

    private static void initializeOverheadDetector(final DebugProcessImpl process) {
        AsyncStackTracesOverheadUtilsKt.initializeOverheadListener(process);
        String className = "com.intellij.rt.debugger.agent.OverheadDetector";
        String methodName = "overheadDetected";
        SyntheticMethodBreakpoint breakpoint = new SyntheticMethodBreakpoint(className, methodName, null, process.getProject()){

            @Override
            public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) {
                if (action == null) {
                    3.$$$reportNull$$$0(0);
                }
                AsyncStackTracesOverheadUtilsKt.onOverheadDetected(process);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/debugger/engine/AsyncStacksUtils$3", "processLocatableEvent"));
            }
        };
        breakpoint.setSuspendPolicy("SuspendThread");
        breakpoint.createRequest(process);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/AsyncStacksUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/AsyncStacksUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPathForDownloadedAgent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryAgentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAgentRelatedStack";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putProcessUserData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extendParametersForAgent";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class ThrottledStackFrameItem
    extends StackFrameItem {
        ThrottledStackFrameItem(VirtualMachine vm) {
            super(ThrottledStackFrameItem.createSyntheticLocation(vm), Collections.emptyList());
        }

        private static Location createSyntheticLocation(VirtualMachine vm) {
            return DebuggerUtilsEx.findOrCreateLocation(vm, "", "", -1);
        }

        @Override
        public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess, @Nullable SourcePosition sourcePosition) {
            if (debugProcess == null) {
                ThrottledStackFrameItem.$$$reportNull$$$0(0);
            }
            return new ThrottledFrame();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/AsyncStacksUtils$ThrottledStackFrameItem", "createFrame"));
        }
    }

    private static class ThrottledFrame
    extends XStackFrame
    implements XStackFrameWithSeparatorAbove {
        private boolean myWithSeparator;

        private ThrottledFrame() {
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            if (component == null) {
                ThrottledFrame.$$$reportNull$$$0(0);
            }
            component.setIcon(AllIcons.Empty);
            component.append(JavaDebuggerBundle.message((String)"async.stack.throttled.frame.label", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                ThrottledFrame.$$$reportNull$$$0(1);
            }
            node.setMessage(JavaDebuggerBundle.message((String)"async.stack.throttled.frame.info", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, StackFrameItem.CAPTURE_SETTINGS_OPENER);
            node.addChildren(XValueChildrenList.EMPTY, true);
        }

        public String getCaptionAboveOf() {
            return StackFrameItem.getAsyncStacktraceMessage();
        }

        public boolean hasSeparatorAbove() {
            return this.myWithSeparator;
        }

        public void setWithSeparator(boolean withSeparator) {
            this.myWithSeparator = withSeparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/AsyncStacksUtils$ThrottledFrame";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizePresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

