/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.CollectionBreakpointUtils;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.SuspendOtherThreadsRequestor;
import com.intellij.debugger.engine.ThreadSteppingMonitor;
import com.intellij.debugger.engine.evaluation.DebuggerImplicitEvaluationContextUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.InstrumentationTracker;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.SyntheticBreakpoint;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.frame.ShowSessionTabUtils;
import com.jetbrains.jdi.EventRequestManagerImpl;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger LOG = Logger.getInstance(DebugProcessEvents.class);
    private static final String REQUEST_HANDLER = "REQUEST_HANDLER";
    private final Map<VirtualMachine, DebuggerEventThread> myEventThreads = new HashMap<VirtualMachine, DebuggerEventThread>();
    private final AtomicBoolean myNotificationsCoolDown = new AtomicBoolean();

    public DebugProcessEvents(Project project) {
        super(project);
        DebuggerSettings.getInstance().addCapturePointsSettingsListener(this::createStackCapturingBreakpoints, (Disposable)this.disposable);
    }

    @Override
    @NotNull
    protected VirtualMachineProxyImpl commitVM(VirtualMachine vm) {
        VirtualMachineProxyImpl proxy = super.commitVM(vm);
        if (vm != null) {
            this.vmAttached(proxy);
            if (vm.canBeModified()) {
                DebuggerManagerThreadImpl managerThread = DebuggerManagerThreadImpl.getCurrentThread();
                DebuggerEventThread eventThread = this.myEventThreads.computeIfAbsent(vm, __ -> new DebuggerEventThread(managerThread));
                ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)"DebugProcessEvents", (Runnable)eventThread));
            }
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = proxy;
        if (virtualMachineProxyImpl == null) {
            DebugProcessEvents.$$$reportNull$$$0(0);
        }
        return virtualMachineProxyImpl;
    }

    private static void showStatusText(DebugProcessEvents debugProcess, Event event) {
        Requestor requestor2 = RequestManagerImpl.findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor2 instanceof Breakpoint) {
            Breakpoint b;
            breakpoint = b = (Breakpoint)requestor2;
        }
        String text = debugProcess.getEventText(Pair.create(breakpoint, (Object)event));
        debugProcess.showStatusText(text);
    }

    @Nls
    public String getEventText(Pair<Breakpoint<?>, Event> descriptor) {
        String text = "";
        Event event = (Event)descriptor.getSecond();
        Breakpoint breakpoint = (Breakpoint)descriptor.getFirst();
        if (event instanceof LocatableEvent) {
            LocatableEvent locatableEvent = (LocatableEvent)event;
            try {
                text = breakpoint != null ? breakpoint.getEventMessage(locatableEvent) : JavaDebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
            catch (InternalException e) {
                text = JavaDebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
        } else if (event instanceof VMStartEvent) {
            text = JavaDebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            text = JavaDebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            text = JavaDebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(this.getConnection())});
        }
        return text;
    }

    private static void preprocessEvent(SuspendContextImpl suspendContext, ThreadReference thread) {
        ThreadReferenceProxyImpl oldThread = suspendContext.getEventThread();
        suspendContext.setThread(thread);
        if (oldThread == null) {
            switch (suspendContext.getSuspendPolicy()) {
                case 2: {
                    suspendContext.getVirtualMachineProxy().addedSuspendAllContext();
                    break;
                }
                case 1: {
                    Objects.requireNonNull(suspendContext.getEventThread()).threadWasSuspended();
                }
            }
            suspendContext.getDebugProcess().beforeSuspend(suspendContext);
        }
    }

    private static Consumer<? super Event> getEventRequestHandler(Event event) {
        Object property;
        EventRequest request = event.request();
        Object object = property = request != null ? request.getProperty(REQUEST_HANDLER) : null;
        if (property instanceof Consumer) {
            Consumer consumer = (Consumer)property;
            return consumer;
        }
        return null;
    }

    public static void enableRequestWithHandler(EventRequest request, Consumer<? super Event> handler) {
        request.putProperty(REQUEST_HANDLER, handler);
        DebuggerUtilsAsync.setEnabled(request, true);
    }

    public static void enableNonSuspendingRequest(EventRequest request, Consumer<? super Event> handler) {
        request.setSuspendPolicy(0);
        DebugProcessEvents.enableRequestWithHandler(request, handler);
    }

    private static EventRequest platformThreadsOnly(EventRequest eventRequest) {
        block2: {
            try {
                eventRequest.getClass().getMethod("addPlatformThreadsOnlyFilter", new Class[0]).invoke((Object)eventRequest, new Object[0]);
            }
            catch (Exception e) {
                if (!(eventRequest instanceof EventRequestManagerImpl.ThreadLifecycleEventRequestImpl)) break block2;
                EventRequestManagerImpl.ThreadLifecycleEventRequestImpl lifecycleEventRequest = (EventRequestManagerImpl.ThreadLifecycleEventRequestImpl)eventRequest;
                lifecycleEventRequest.addPlatformThreadsOnlyFilter();
            }
        }
        return eventRequest;
    }

    private void processVMStartEvent(@NotNull SuspendContextImpl suspendContext, VMStartEvent event) {
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(1);
        }
        suspendContext.getVirtualMachineProxy().threadStarted(event.thread());
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        LOG.debug("enter: processVMStartEvent()");
        DebugProcessEvents.showStatusText(this, event);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private void vmAttached(VirtualMachineProxyImpl machineProxy) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LOG.assertTrue(!this.isAttached());
        if (this.myState.compareAndSet(DebugProcessImpl.State.INITIAL, DebugProcessImpl.State.ATTACHED)) {
            boolean canBeModified = machineProxy.canBeModified();
            if (canBeModified) {
                EventRequestManager requestManager = machineProxy.eventRequestManager();
                if (machineProxy.canGetMethodReturnValues()) {
                    this.myReturnValueWatcher = new MethodReturnValueWatcher(requestManager, this);
                }
                DebugProcessEvents.enableNonSuspendingRequest(DebugProcessEvents.platformThreadsOnly(requestManager.createThreadStartRequest()), event -> {
                    ThreadReference thread = ((ThreadStartEvent)event).thread();
                    machineProxy.threadStarted(thread);
                    DebuggerUtils.forEachSafe((Iterable)this.myDebugProcessListeners, it -> it.threadStarted((DebugProcess)this, thread));
                });
                DebugProcessEvents.enableNonSuspendingRequest(DebugProcessEvents.platformThreadsOnly(requestManager.createThreadDeathRequest()), event -> {
                    ThreadReference thread = ((ThreadDeathEvent)event).thread();
                    this.mySteppingProgressTracker.processTheadDeath(thread);
                    ThreadSteppingMonitor.checkSteppingIsOverOnThreadDeath((SuspendManagerImpl)this.getSuspendManager(), thread);
                    machineProxy.threadStopped(thread);
                    DebuggerUtils.forEachSafe((Iterable)this.myDebugProcessListeners, it -> it.threadStopped((DebugProcess)this, thread));
                });
            }
            PositionManagerFactory.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PositionManagerFactory>(){
                final Map<PositionManagerFactory, PositionManager> mapping = new HashMap<PositionManagerFactory, PositionManager>();

                public void extensionAdded(@NotNull PositionManagerFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DebugProcessEvents.this.getManagerThread().invoke(PrioritizedTask.Priority.NORMAL, () -> {
                        PositionManager manager = extension.createPositionManager((DebugProcess)DebugProcessEvents.this);
                        if (manager != null) {
                            this.mapping.put(extension, manager);
                            DebugProcessEvents.this.appendPositionManager(manager);
                        }
                    });
                }

                public void extensionRemoved(@NotNull PositionManagerFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    DebugProcessEvents.this.getManagerThread().schedule(PrioritizedTask.Priority.NORMAL, () -> {
                        PositionManager manager = this.mapping.remove(extension);
                        if (manager != null) {
                            DebugProcessEvents.this.myPositionManager.removePositionManager(manager);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/engine/DebugProcessEvents$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true, (Disposable)this.disposable);
            DebuggerUtils.forEachSafe((Iterable)this.myDebugProcessListeners, it -> it.processAttached((DebugProcess)this));
            if (canBeModified) {
                this.createStackCapturingBreakpoints();
                AsyncStacksUtils.setupAgent(this);
                CollectionBreakpointUtils.setupCollectionBreakpointAgent(this);
            }
            XDebugSessionImpl session = (XDebugSessionImpl)this.getSession().getXDebugSession();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (session != null) {
                    session.initBreakpoints();
                }
            });
            if (Registry.is((String)"debugger.track.instrumentation", (boolean)true) && canBeModified) {
                this.trackClassRedefinitions();
            }
            this.showStatusText(JavaDebuggerBundle.message((String)"status.connected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(this.getConnection())}));
            LOG.debug("leave: processVMStartEvent()");
            if (session != null) {
                session.setReadOnly(!canBeModified);
                session.setPauseActionSupported(canBeModified);
            }
            if (!canBeModified) {
                SuspendContextImpl suspendContext = this.getSuspendManager().pushSuspendContext(2, 0);
                DebuggerUtils.forEachSafe((Iterable)this.myDebugProcessListeners, it -> it.paused((SuspendContext)suspendContext));
                if (session != null) {
                    ShowSessionTabUtils.showFrames((Project)this.getProject(), (XDebugSessionId)session.getId());
                }
            }
        }
    }

    private void trackClassRedefinitions() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        InstrumentationTracker.track(this);
    }

    private void createStackCapturingBreakpoints() {
        this.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
            StackCapturingLineBreakpoint.deleteAll(this);
            StackCapturingLineBreakpoint.createAll(this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVMDeathEvent(@NotNull SuspendContextImpl suspendContext, @Nullable Event event) {
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(2);
        }
        if (this.isAttached()) {
            VirtualMachine vm = suspendContext.getVirtualMachineProxy().getVirtualMachine();
            if (event == null || vm == event.virtualMachine()) {
                try {
                    DebugProcessEvents.preprocessEvent(suspendContext, null);
                    this.cancelSteppingBreakpoints();
                }
                finally {
                    DebuggerEventThread eventThread = this.myEventThreads.get(vm);
                    if (eventThread != null) {
                        eventThread.stopListening();
                        this.myEventThreads.remove(vm);
                    }
                    this.closeCurrentProcess(false);
                }
            }
        }
        if (event != null) {
            DebugProcessEvents.showStatusText(this, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassPrepareEvent(SuspendContextImpl suspendContext, ClassPrepareEvent event, Set<ClassPrepareRequestor> notifiedRequestors) {
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class prepared: " + event.referenceType().name());
        }
        try {
            suspendContext.getDebugProcess().getRequestsManager().processClassPrepared(event, notifiedRequestors);
        }
        finally {
            this.getSuspendManager().voteResume(suspendContext);
        }
    }

    private void processStepEvent(@NotNull SuspendContextImpl suspendContext, final StepEvent event) {
        RequestHint hint;
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(3);
        }
        DebugProcessEvents.logSuspendContext(suspendContext, () -> "process step event");
        ThreadReference thread = event.thread();
        Requestor requestor2 = RequestManagerImpl.findRequestor(event.request());
        if (requestor2 != null) {
            this.getRequestsManager().deleteRequest(requestor2);
        }
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        final Object commandToken = DebugProcessEvents.getCommandToken(event);
        DebugProcessEvents.removeStepRequests(suspendContext, thread);
        boolean shouldResume = false;
        final Project project = this.getProject();
        for (hint = DebugProcessEvents.getRequestHint(event); hint != null; hint = hint.getParentHint()) {
            RequestHint currentHint = hint;
            Ref stepDepth = Ref.create();
            long timeMs = TimeoutUtil.measureExecutionTime(() -> stepDepth.set((Object)currentHint.getNextStepDepth(suspendContext)));
            StatisticsStorage.addStepping(this, commandToken, timeMs);
            int nextStepDepth = (Integer)stepDepth.get();
            DebugProcessEvents.logSuspendContext(suspendContext, () -> "nextStepDepth is " + nextStepDepth);
            if (nextStepDepth == -100) {
                this.getSession().clearSteppingThrough();
                shouldResume = true;
            } else if (nextStepDepth == 0) {
                if (hint.getParentHint() != null) {
                    continue;
                }
            } else {
                ThreadReferenceProxyImpl threadProxy = suspendContext.getEventThread();
                hint.doStep(this, suspendContext, threadProxy, hint.getSize(), nextStepDepth, commandToken);
                shouldResume = true;
            }
            if (shouldResume || !hint.isRestoreBreakpoints()) break;
            DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().enableBreakpoints(this);
            break;
        }
        if (shouldResume) {
            this.getSuspendManager().voteResume(suspendContext);
        } else {
            StatisticsStorage.stepRequestCompleted(this, commandToken);
            this.showStatusText("");
            this.stopWatchingMethodReturn();
            final RequestHint lastHint = hint;
            suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DebugProcessEvents.this.getSuspendManager().voteSuspend(suspendContext);
                    if (lastHint != null) {
                        MethodFilter methodFilter = lastHint.getMethodFilter();
                        if (methodFilter instanceof NamedMethodFilter) {
                            NamedMethodFilter namedMethodFilter = (NamedMethodFilter)methodFilter;
                            if (!lastHint.wasStepTargetMethodMatched()) {
                                String methodName = namedMethodFilter.getMethodName();
                                String message = JavaDebuggerBundle.message((String)"notification.method.has.not.been.called", (Object[])new Object[]{methodName});
                                XDebuggerManagerImpl.getNotificationGroup().createNotification(message, MessageType.INFO).notify(project);
                                DebuggerStatistics.logMethodSkippedDuringStepping(project, StatisticsStorage.getSteppingStatisticOrNull(commandToken));
                            }
                        }
                        if (lastHint.wasStepTargetMethodMatched()) {
                            suspendContext.getDebugProcess().resetIgnoreSteppingFilters(event.location(), lastHint);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessEvents$2", "contextAction"));
                }
            });
        }
    }

    public static void removeStepRequests(@NotNull SuspendContextImpl suspendContext, @Nullable ThreadReference thread) {
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(4);
        }
        suspendContext.getDebugProcess().deleteStepRequests(suspendContext.getVirtualMachineProxy().eventRequestManager(), thread);
    }

    static void preloadEventInfo(ThreadReference thread, @Nullable Location location) {
        block6: {
            if (Registry.is((String)"debugger.preload.event.info") && DebuggerUtilsAsync.isAsyncEnabled()) {
                ArrayList<CompletableFuture<Method>> commands = new ArrayList<CompletableFuture<Method>>();
                if (thread instanceof ThreadReferenceImpl) {
                    ThreadReferenceImpl t = (ThreadReferenceImpl)thread;
                    commands.addAll(List.of(t.frameCountAsync(), t.nameAsync(), t.statusAsync(), t.frameAsync(0)));
                }
                if (location instanceof LocationImpl) {
                    LocationImpl locationImpl = (LocationImpl)location;
                    commands.add(DebuggerUtilsEx.getMethodAsync(locationImpl));
                }
                try {
                    CompletableFuture.allOf((CompletableFuture[])commands.toArray(CompletableFuture[]::new)).get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | TimeoutException locationImpl) {
                }
                catch (Exception e) {
                    Throwable throwable = DebuggerUtilsAsync.unwrap(e);
                    if (throwable instanceof IncompatibleThreadStateException) break block6;
                    DebuggerUtilsAsync.logError(e);
                }
            }
        }
    }

    private static RequestHint getRequestHint(Event event) {
        return (RequestHint)event.request().getProperty("hint");
    }

    @Nullable
    private static Object getCommandToken(Event event) {
        return event.request().getProperty("commandToken");
    }

    private void processLocatableEvent(SuspendContextImpl suspendContext, final LocatableEvent event) {
        final ThreadReference thread = event.thread();
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            /*
             * Exception decompiling
             */
            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ String lambda$contextAction$6() {
                return "suspend is expected";
            }

            private static /* synthetic */ String lambda$contextAction$5(boolean finalRequestHit, boolean finalResumePreferred) {
                return "Resume: requestHit = " + finalRequestHit + ", resumePreferred = " + finalResumePreferred;
            }

            private static /* synthetic */ boolean lambda$contextAction$4(SuspendContextImpl suspendContext, LocatableEvent event2, RequestHint h) {
                if (h != null) {
                    Integer depth = h.checkCurrentPosition(suspendContext, event2.location());
                    return depth != null && depth != 0;
                }
                return false;
            }

            private /* synthetic */ void lambda$contextAction$3(Breakpoint breakpoint) {
                XBreakpoint xBreakpoint;
                XDebugSession session = DebugProcessEvents.this.getSession().getXDebugSession();
                if (session != null && (xBreakpoint = breakpoint.getXBreakpoint()) != null) {
                    ((XDebugSessionImpl)session).processDependencies(xBreakpoint);
                }
            }

            private static /* synthetic */ String lambda$contextAction$2(LightOrRealThreadInfo filter) {
                return "Skip breakpoint because of filter " + String.valueOf(filter);
            }

            private /* synthetic */ String lambda$contextAction$1(boolean isEvaluationOnCurrentThread) {
                return "Resume because of evaluation: isEvaluationOnCurrentThread = " + isEvaluationOnCurrentThread + ", myThreadBlockedMonitor.isInResumeAllMode() = " + DebugProcessEvents.this.myThreadBlockedMonitor.isInResumeAllMode();
            }

            private static /* synthetic */ String lambda$contextAction$0() {
                return "start locatable event processing";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessEvents$3", "contextAction"));
            }
        });
    }

    static boolean specialSuspendProcessingForAlwaysSwitch(@NotNull SuspendContextImpl suspendContext, @NotNull SuspendManagerImpl suspendManager, @NotNull ThreadReference thread) {
        boolean noStandardSuspendNeeded;
        List<SuspendContextImpl> suspendAllContexts;
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(5);
        }
        if (suspendManager == null) {
            DebugProcessEvents.$$$reportNull$$$0(6);
        }
        if (thread == null) {
            DebugProcessEvents.$$$reportNull$$$0(7);
        }
        DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
        if (suspendContext.getSuspendPolicy() == 2) {
            debugProcess.logError("Special processing called for " + String.valueOf((Object)suspendContext));
            return false;
        }
        if (suspendContext.getSuspendPolicy() != 1) {
            debugProcess.logError("Suspend context " + String.valueOf((Object)suspendContext) + " has non-thread suspend policy");
        }
        if (!(suspendAllContexts = suspendManager.getSuspendAllContexts()).isEmpty()) {
            DebugProcessEvents.logSuspendContext(suspendContext, () -> "join with suspend-all context");
            if (suspendAllContexts.size() > 1) {
                debugProcess.logError("Many suspend all switch contexts: " + String.valueOf(suspendAllContexts));
            }
            noStandardSuspendNeeded = true;
            ThreadReferenceProxyImpl threadProxy = suspendContext.getVirtualMachineProxy().getThreadReferenceProxy(thread);
            SuspendContextImpl firstSuspendAllContext = suspendAllContexts.get(0);
            if (suspendAllContexts.size() == 1 && firstSuspendAllContext.mySteppingThreadForResumeOneSteppingCurrentMode == threadProxy) {
                suspendManager.myExplicitlyResumedThreads.remove(threadProxy);
                suspendManager.scheduleResume(firstSuspendAllContext);
                suspendContext.getVirtualMachineProxy().suspend();
                SuspendOtherThreadsRequestor.switchToSuspendAll(suspendContext, s -> true);
            } else if (suspendManager.myExplicitlyResumedThreads.contains(threadProxy)) {
                for (SuspendContextImpl context : suspendAllContexts) {
                    if (context.suspends(threadProxy)) continue;
                    suspendManager.suspendThread(context, threadProxy);
                }
                suspendManager.myExplicitlyResumedThreads.remove(threadProxy);
                suspendManager.scheduleResume(suspendContext);
                SuspendManagerUtil.switchToThreadInSuspendAllContext(firstSuspendAllContext, threadProxy);
            } else {
                List suspendAllSwitchContexts = ContainerUtil.filter(suspendAllContexts, c -> c.mySuspendAllSwitchedContext);
                if (suspendAllSwitchContexts.size() != 1) {
                    debugProcess.logError("Requires just one suspend all switch context, but have: " + String.valueOf(suspendAllSwitchContexts));
                }
                if (thread.suspendCount() == 1) {
                    debugProcess.logError("This means resuming thread " + String.valueOf(thread) + " to the running state for " + String.valueOf((Object)suspendContext));
                }
                LOG.warn("Yet another thread has been stopped: " + String.valueOf((Object)suspendContext));
                suspendManager.scheduleResume(suspendContext);
                debugProcess.notifyStoppedOtherThreads();
            }
        } else {
            DebugProcessEvents.logSuspendContext(suspendContext, () -> "initiate transfer to suspend-all");
            noStandardSuspendNeeded = SuspendOtherThreadsRequestor.initiateTransferToSuspendAll(suspendContext, c -> true);
        }
        return noStandardSuspendNeeded;
    }

    private void notifySkippedBreakpointInEvaluation(@Nullable LocatableEvent event, @NotNull SuspendContextImpl suspendContext) {
        ThreadReferenceProxyImpl proxy;
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(8);
        }
        if (this.checkContextIsFromImplicitThread(suspendContext)) {
            return;
        }
        SkippedBreakpointReason reason = SkippedBreakpointReason.EVALUATION_IN_ANOTHER_THREAD;
        if (event != null && (proxy = suspendContext.getVirtualMachineProxy().getThreadReferenceProxy(event.thread())) != null && proxy.isEvaluating()) {
            reason = SkippedBreakpointReason.EVALUATION_IN_THE_SAME_THREAD;
        }
        this.notifySkippedBreakpoints(event, reason);
    }

    private boolean checkContextIsFromImplicitThread(@NotNull SuspendContextImpl eventContext) {
        if (eventContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(9);
        }
        DebugProcessImpl debugProcess = eventContext.getDebugProcess();
        LightOrRealThreadInfo implicitThread = DebuggerImplicitEvaluationContextUtil.getImplicitEvaluationThread(debugProcess);
        LightOrRealThreadInfo filterThread = this.getRequestsManager().getFilterThread();
        ThreadReferenceProxyImpl eventThread = eventContext.getThread();
        if (implicitThread == null || eventThread == null) {
            return false;
        }
        if (filterThread != null && !implicitThread.checkSameThread(eventThread.getThreadReference(), eventContext)) {
            return true;
        }
        return implicitThread.checkSameThread(eventThread.getThreadReference(), eventContext);
    }

    private void notifySkippedBreakpoints(@Nullable LocatableEvent event, SkippedBreakpointReason reason) {
        if (event == null) {
            return;
        }
        Requestor requestor2 = RequestManagerImpl.findRequestor(event.request());
        if (requestor2 instanceof SyntheticBreakpoint) {
            return;
        }
        DebuggerStatistics.logBreakpointSkipped(this.getProject(), reason);
        if (!this.myNotificationsCoolDown.compareAndSet(false, true)) {
            return;
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.myNotificationsCoolDown.set(false), 1L, TimeUnit.SECONDS);
        String message = switch (reason.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> JavaDebuggerBundle.message((String)"message.breakpoint.skipped.during.evaluation", (Object[])new Object[]{event.location()});
            case 2 -> JavaDebuggerBundle.message((String)"message.breakpoint.skipped.other.vm", (Object[])new Object[]{event.location()});
            case 3 -> JavaDebuggerBundle.message((String)"message.breakpoint.skipped.during.stepping.in.another.thread", (Object[])new Object[]{event.location()});
        };
        XDebuggerManagerImpl.getNotificationGroup().createNotification(message, MessageType.WARNING).addAction((AnAction)NotificationAction.createSimpleExpiring((String)JavaDebuggerBundle.message((String)"message.breakpoint.skipped.learn.more", (Object[])new Object[0]), () -> BrowserUtil.browse((String)"https://www.jetbrains.com/help/idea/?skipped.breakpoints"))).notify(this.getProject());
    }

    @Nullable
    private static LocatableEvent getLocatableEvent(EventSet eventSet) {
        return StreamEx.of((Collection)eventSet).select(LocatableEvent.class).findFirst().orElse(null);
    }

    private void processDefaultEvent(SuspendContextImpl suspendContext) {
        DebugProcessEvents.preprocessEvent(suspendContext, null);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private static void logSuspendContext(@NotNull SuspendContextImpl suspendContext, @NotNull Supplier<String> message) {
        if (suspendContext == null) {
            DebugProcessEvents.$$$reportNull$$$0(10);
        }
        if (message == null) {
            DebugProcessEvents.$$$reportNull$$$0(11);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("For suspend context " + String.valueOf((Object)suspendContext) + ": " + message.get());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/DebugProcessEvents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "commitVM";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessEvents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processVMStartEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processVMDeathEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processStepEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeStepRequests";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "specialSuspendProcessingForAlwaysSwitch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifySkippedBreakpointInEvaluation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkContextIsFromImplicitThread";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logSuspendContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl myVmProxy;
        private final DebuggerManagerThreadImpl myDebuggerManagerThread;
        private boolean myIsStopped = false;

        DebuggerEventThread(DebuggerManagerThreadImpl managerThread) {
            this.myVmProxy = managerThread.getVmProxy();
            this.myDebuggerManagerThread = managerThread;
        }

        public synchronized void stopListening() {
            this.myIsStopped = true;
        }

        private synchronized boolean isStopped() {
            return this.myIsStopped;
        }

        @Override
        public void run() {
            try {
                EventQueue eventQueue = this.myVmProxy.getVirtualMachine().eventQueue();
                while (!this.isStopped()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        this.myDebuggerManagerThread.invokeAndWait(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

                            @Override
                            protected void action() {
                                int processed = 0;
                                for (Event event : eventSet) {
                                    if (DebugProcessEvents.this.myReturnValueWatcher != null && DebugProcessEvents.this.myReturnValueWatcher.isTrackingEnabled() && DebugProcessEvents.this.myReturnValueWatcher.processEvent(event)) {
                                        ++processed;
                                        continue;
                                    }
                                    Consumer<? super Event> handler = DebugProcessEvents.getEventRequestHandler(event);
                                    if (handler == null) continue;
                                    handler.accept(event);
                                    ++processed;
                                }
                                if (processed == eventSet.size()) {
                                    DebuggerUtilsAsync.resume(eventSet);
                                    return;
                                }
                                LocatableEvent locatableEvent = DebugProcessEvents.getLocatableEvent(eventSet);
                                if (this.skipEvent(locatableEvent)) {
                                    return;
                                }
                                if (eventSet.suspendPolicy() == 2) {
                                    ((SuspendManagerImpl)DebugProcessEvents.this.getSuspendManager()).resumeAllSuspendAllContexts(eventSet);
                                }
                                SuspendContextImpl suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                HashSet<ClassPrepareRequestor> notifiedClassPrepareEventRequestors = null;
                                ReferenceType lastPreparedClass = null;
                                for (Event event : eventSet) {
                                    if (DebugProcessEvents.getEventRequestHandler(event) != null) {
                                        DebugProcessEvents.this.getSuspendManager().voteResume(suspendContext);
                                        continue;
                                    }
                                    try {
                                        if (event instanceof VMStartEvent) {
                                            VMStartEvent startEvent = (VMStartEvent)event;
                                            DebugProcessEvents.this.processVMStartEvent(suspendContext, startEvent);
                                            continue;
                                        }
                                        if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                            DebugProcessEvents.this.processVMDeathEvent(suspendContext, event);
                                            continue;
                                        }
                                        if (event instanceof ClassPrepareEvent) {
                                            ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
                                            if (eventSet.size() > 1 && StreamEx.of((Collection)eventSet).select(ClassPrepareEvent.class).map(ClassPrepareEvent::thread).toSet().size() > 1) {
                                                DebugProcessEvents.this.logError("Two different threads in ClassPrepareEvents: " + String.valueOf(eventSet));
                                            }
                                            if (notifiedClassPrepareEventRequestors == null) {
                                                notifiedClassPrepareEventRequestors = new HashSet<ClassPrepareRequestor>(eventSet.size());
                                            }
                                            ReferenceType type = classPrepareEvent.referenceType();
                                            if (lastPreparedClass != null && !lastPreparedClass.equals(type)) {
                                                DebugProcessEvents.this.logError("EventSet contains ClassPrepareEvents for: " + String.valueOf(lastPreparedClass) + " and " + String.valueOf(type));
                                            }
                                            lastPreparedClass = type;
                                            DebugProcessEvents.this.processClassPrepareEvent(suspendContext, classPrepareEvent, notifiedClassPrepareEventRequestors);
                                            continue;
                                        }
                                        if (event instanceof LocatableEvent) {
                                            LocatableEvent locEvent = (LocatableEvent)event;
                                            DebugProcessEvents.preloadEventInfo(locEvent.thread(), locEvent.location());
                                            if (eventSet.size() > 1 && StreamEx.of((Collection)eventSet).select(LocatableEvent.class).map(LocatableEvent::thread).toSet().size() > 1) {
                                                DebugProcessEvents.this.logError("Two different threads in LocatableEvents: " + String.valueOf(eventSet));
                                            }
                                            if (event instanceof StepEvent) {
                                                StepEvent stepEvent = (StepEvent)event;
                                                DebugProcessEvents.this.processStepEvent(suspendContext, stepEvent);
                                                continue;
                                            }
                                            DebugProcessEvents.this.processLocatableEvent(suspendContext, locEvent);
                                            continue;
                                        }
                                        if (!(event instanceof ClassUnloadEvent)) continue;
                                        DebugProcessEvents.this.processDefaultEvent(suspendContext);
                                    }
                                    catch (VMDisconnectedException e) {
                                        LOG.debug((Throwable)e);
                                    }
                                    catch (InternalException e) {
                                        LOG.info((Throwable)e);
                                    }
                                    catch (Throwable e) {
                                        DebugProcessEvents.this.logError("Top-level error during event processing", e);
                                    }
                                }
                            }

                            private boolean skipEvent(@Nullable LocatableEvent locatableEvent) {
                                if (!DebugProcessEvents.this.isCurrentVirtualMachine(DebuggerEventThread.this.myVmProxy)) {
                                    DebugProcessEvents.this.notifySkippedBreakpoints(locatableEvent, SkippedBreakpointReason.OTHER_VM);
                                    DebuggerUtilsAsync.resume(eventSet);
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    catch (ProcessCanceledException | VMDisconnectedException | InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.debug(e);
                    }
                }
            }
            catch (VMDisconnectedException | InterruptedException e) {
                this.invokeVMDeathEvent();
            }
            finally {
                Thread.interrupted();
            }
        }

        private void invokeVMDeathEvent() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    SuspendContextImpl suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.processVMDeathEvent(suspendContext, null);
                }
            });
        }
    }

    public static enum SkippedBreakpointReason {
        EVALUATION_IN_ANOTHER_THREAD,
        EVALUATION_IN_THE_SAME_THREAD,
        OTHER_VM,
        STEPPING;

    }
}

