/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerActionListener;
import com.intellij.debugger.engine.DebuggerDiagnosticsUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.DelayedRemoteConnection;
import com.intellij.debugger.engine.InvocationResult;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaValueUtilsKt;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.MethodInvokeUtilsKt;
import com.intellij.debugger.engine.ParametersForSuspendAllReplacing;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RealThreadInfo;
import com.intellij.debugger.engine.RemoteConnectionStub;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.RunToCursorManager;
import com.intellij.debugger.engine.ShowStatusManager;
import com.intellij.debugger.engine.SteppingAction;
import com.intellij.debugger.engine.SteppingListener;
import com.intellij.debugger.engine.SteppingProgressTracker;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.ThreadSteppingMonitor;
import com.intellij.debugger.engine.evaluation.DebuggerImplicitEvaluationContextUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.evaluation.expression.RetryEvaluationException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.engine.requests.StepRequestor;
import com.intellij.debugger.impl.DebuggerCompletableFuture;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.jdi.EmptyConnectorArgument;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.statistics.Engine;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.java.debugger.impl.shared.engine.NodeRendererId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.debugger.impl.shared.CoroutineUtilsKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.BazelEnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.frame.FrameNotificationUtils;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.ExactClassNotLoadedException;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger LOG = Logger.getInstance(DebugProcessImpl.class);
    private final Project project;
    private final RequestManagerImpl requestManager;
    private final Deque<VirtualMachineData> myStashedVirtualMachines = new LinkedList<VirtualMachineData>();
    protected final CheckedDisposable disposable = Disposer.newCheckedDisposable();
    protected final DisposableWrapperList<DebugProcessListener> myDebugProcessListeners = new DisposableWrapperList();
    protected final EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> myProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final StringBuilder myTextBeforeStart = new StringBuilder();
    @Nullable
    protected Method myIsUnderBreakpointCheckFn;
    protected final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private volatile ExecutionResult myExecutionResult;
    private volatile RemoteConnection myConnection;
    private JavaDebugProcess myXDebugProcess;
    private volatile Map<String, Connector.Argument> myArguments;
    private final List<NodeRenderer> myRenderers = new ArrayList<NodeRenderer>();
    private final MutableSharedFlow<Unit> myRenderersUpdated = CoroutineUtilsKt.createMutableSharedFlow((int)1, (int)1);
    private final Map<Type, Object> myNodeRenderersMap = Collections.synchronizedMap(new HashMap());
    private final SuspendManagerImpl mySuspendManager = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = CompoundPositionManager.DISABLED;
    @NotNull
    private volatile DebuggerManagerThreadImpl myDebuggerManagerThread;
    private final Semaphore myWaitFor = new Semaphore();
    private final AtomicBoolean myIsFailed = new AtomicBoolean(false);
    private final AtomicBoolean myIsStopped = new AtomicBoolean(false);
    protected volatile DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    private final CoroutineScope myCoroutineScope;
    private final ShowStatusManager myShowStatusManager;
    final ThreadBlockedMonitor myThreadBlockedMonitor = new ThreadBlockedMonitor(this, (Disposable)this.disposable);
    @ApiStatus.Internal
    public final SteppingProgressTracker mySteppingProgressTracker = new SteppingProgressTracker(this);
    @NotNull
    protected final RunToCursorManager myRunToCursorManager;
    volatile ParametersForSuspendAllReplacing myParametersForSuspendAllReplacing = null;
    volatile boolean myPreparingToSuspendAll = false;
    List<Runnable> mySuspendAllListeners = new ArrayList<Runnable>();
    private Job otherThreadsJob;
    private int myOtherThreadsReachBreakpointNumber = 0;
    private final AtomicInteger myMethodInvocations = new AtomicInteger();
    private static final int ourTraceMask;
    private final List<SteppingBreakpoint> mySteppingBreakpoints = new ArrayList<SteppingBreakpoint>();

    protected DebugProcessImpl(Project project) {
        this.project = project;
        CoroutineScope projectScope = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)project)).getCoroutineScope();
        this.myCoroutineScope = CoroutineScopeKt.childScope((CoroutineScope)projectScope, (String)"DebugProcessImpl", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true);
        this.myDebuggerManagerThread = this.createManagerThread();
        this.myShowStatusManager = new ShowStatusManager(project, this.myCoroutineScope);
        this.myRunToCursorManager = new RunToCursorManager(this, this.myCoroutineScope);
        this.requestManager = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this::reloadRenderers, (Disposable)this.disposable);
        NodeRenderer.EP_NAME.addChangeListener(this::reloadRenderers, (Disposable)this.disposable);
        CompoundRendererProvider.EP_NAME.addChangeListener(this::reloadRenderers, (Disposable)this.disposable);
        this.addDebugProcessListener(new DebugProcessListener(){

            public void processAttached(@NotNull DebugProcess process) {
                if (process == null) {
                    1.$$$reportNull$$$0(0);
                }
                DebugProcessImpl.this.reloadRenderers();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/engine/DebugProcessImpl$1", "processAttached"));
            }
        }, (Disposable)this.disposable);
        this.addDebugProcessListener(new DebugProcessListener(){

            public void paused(@NotNull SuspendContext suspendContext) {
                boolean isSuspendAll;
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean bl = isSuspendAll = suspendContext.getSuspendPolicy() == 2;
                if (isSuspendAll && DebuggerUtils.isNewThreadSuspendStateTracking()) {
                    DebugProcessImpl.this.mergeSuspendThreadContextToSuspendAllContext();
                    DebugProcessImpl.this.resumeThreadsUnderEvaluationAndExplicitlyResumedAfterPause((SuspendContextImpl)suspendContext);
                    DebugProcessImpl.this.getRequestsManager().deleteAllStepRequests();
                }
                DebugProcessImpl.this.myThreadBlockedMonitor.stopWatching(!isSuspendAll ? suspendContext.getThread() : null);
                DebuggerDiagnosticsUtil.checkThreadsConsistency(DebugProcessImpl.this, false);
            }

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                if (process == null) {
                    2.$$$reportNull$$$0(1);
                }
                DebuggerStatistics.logProcessStatistics(process);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "process";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paused";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDetached";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private DebuggerManagerThreadImpl createManagerThread() {
        CoroutineScope projectScope = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.project)).getCoroutineScope();
        return new DebuggerManagerThreadImpl((Disposable)this.disposable, projectScope);
    }

    @ApiStatus.Internal
    public Flow<Unit> getRenderersUpdatedFlow() {
        return this.myRenderersUpdated;
    }

    private void reloadRenderers() {
        this.getManagerThread().schedule(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

            @Override
            protected void action() {
                DebugProcessImpl.this.myNodeRenderersMap.clear();
                DebugProcessImpl.this.myRenderers.clear();
                try {
                    DebugProcessImpl.this.myRenderers.addAll(NodeRendererSettings.getInstance().getAllRenderers(DebugProcessImpl.this.project));
                }
                finally {
                    DebugProcessImpl.this.myRenderersUpdated.tryEmit((Object)Unit.INSTANCE);
                    DebuggerInvocationUtil.invokeLaterAnyModality(DebugProcessImpl.this.project, () -> {
                        DebuggerSession session = DebugProcessImpl.this.mySession;
                        if (session != null && session.isAttached()) {
                            DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher watcher = this.myReturnValueWatcher;
        if (watcher == null) {
            return null;
        }
        Method method = watcher.getLastExecutedMethod();
        if (method == null) {
            return null;
        }
        return Pair.create((Object)method, (Object)watcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean enabled) {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.setEnabled(enabled);
        }
    }

    public boolean canGetMethodReturnValue() {
        return this.myReturnValueWatcher != null;
    }

    @NotNull
    public CompletableFuture<List<NodeRenderer>> getApplicableRenderers(Type type) {
        CompletableFuture<List<NodeRenderer>> completableFuture = DebuggerUtilsImpl.getApplicableRenderers(this.myRenderers, type);
        if (completableFuture == null) {
            DebugProcessImpl.$$$reportNull$$$0(0);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @Nullable
    public NodeRenderer getRendererById(@NotNull NodeRendererId id) {
        if (id == null) {
            DebugProcessImpl.$$$reportNull$$$0(1);
        }
        return (NodeRenderer)ContainerUtil.find(this.myRenderers, r -> id.equals((Object)JavaValueUtilsKt.getId(r)));
    }

    @NotNull
    public CompletableFuture<NodeRenderer> getAutoRendererAsync(@Nullable Type type) {
        block12: {
            Object renderer;
            block11: {
                CompletableFuture<NodeRenderer> completableFuture;
                DebuggerManagerThreadImpl.assertIsManagerThread();
                if (!this.isEvaluationPossible()) {
                    CompletableFuture<NodeRenderer> completableFuture2 = CompletableFuture.completedFuture(DebugProcessImpl.getDefaultRenderer(type));
                    if (completableFuture2 == null) {
                        DebugProcessImpl.$$$reportNull$$$0(2);
                    }
                    return completableFuture2;
                }
                try {
                    renderer = this.myNodeRenderersMap.get(type);
                    if (!(renderer instanceof NodeRenderer)) break block11;
                    completableFuture = CompletableFuture.completedFuture((NodeRenderer)renderer);
                }
                catch (ClassNotPreparedException e) {
                    LOG.info((Throwable)e);
                    CompletableFuture<NodeRenderer> completableFuture3 = CompletableFuture.completedFuture(DebugProcessImpl.getDefaultRenderer(type));
                    if (completableFuture3 == null) {
                        DebugProcessImpl.$$$reportNull$$$0(6);
                    }
                    return completableFuture3;
                }
                if (completableFuture == null) {
                    DebugProcessImpl.$$$reportNull$$$0(3);
                }
                return completableFuture;
            }
            if (!(renderer instanceof CompletableFuture)) break block12;
            CompletableFuture future = (CompletableFuture)renderer;
            LOG.assertTrue(!future.isDone(), (Object)("Completed future for " + String.valueOf(type)));
            CompletableFuture completableFuture = future;
            if (completableFuture == null) {
                DebugProcessImpl.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        List enabledRenderers = ContainerUtil.filter(this.myRenderers, NodeRenderer::isEnabled);
        CompletionStage res = DebuggerUtilsImpl.getFirstApplicableRenderer(enabledRenderers, type).handle((r, throwable) -> {
            if (r == null || throwable != null) {
                r = DebugProcessImpl.getDefaultRenderer(type);
                this.myNodeRenderersMap.remove(type);
            } else {
                this.myNodeRenderersMap.put(type, r);
            }
            return r;
        });
        if (!((CompletableFuture)res).isDone()) {
            this.myNodeRenderersMap.putIfAbsent(type, res);
        }
        CompletionStage completionStage = res;
        if (completionStage == null) {
            DebugProcessImpl.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Value value) {
        return DebugProcessImpl.getDefaultRenderer(value != null ? value.type() : null);
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Type type) {
        NodeRendererSettings settings = NodeRendererSettings.getInstance();
        PrimitiveRenderer primitiveRenderer = settings.getPrimitiveRenderer();
        if (primitiveRenderer.isApplicable(type)) {
            PrimitiveRenderer primitiveRenderer2 = primitiveRenderer;
            if (primitiveRenderer2 == null) {
                DebugProcessImpl.$$$reportNull$$$0(7);
            }
            return primitiveRenderer2;
        }
        ArrayRenderer arrayRenderer = settings.getArrayRenderer();
        if (arrayRenderer.isApplicable(type)) {
            ArrayRenderer arrayRenderer2 = arrayRenderer;
            if (arrayRenderer2 == null) {
                DebugProcessImpl.$$$reportNull$$$0(8);
            }
            return arrayRenderer2;
        }
        ClassRenderer classRenderer = settings.getClassRenderer();
        LOG.assertTrue(classRenderer.isApplicable(type), (Object)type.name());
        ClassRenderer classRenderer2 = classRenderer;
        if (classRenderer2 == null) {
            DebugProcessImpl.$$$reportNull$$$0(9);
        }
        return classRenderer2;
    }

    protected int getTraceMask() {
        int mask = ourTraceMask;
        DebugEnvironment environment = this.mySession.getDebugEnvironment();
        if (environment instanceof DefaultDebugEnvironment) {
            mask |= ((DefaultDebugEnvironment)environment).getTraceMode();
        }
        return mask;
    }

    @NotNull
    protected VirtualMachineProxyImpl commitVM(VirtualMachine vm) {
        if (!this.isInInitialState()) {
            this.logError("State is invalid " + String.valueOf((Object)this.myState.get()));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = new CompoundPositionManager(new PositionManagerImpl(this));
        this.project.getMessageBus().connect((Disposable)this.disposable).subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)DebugProcessImpl.this.project).runWhenSmart(() -> DebugProcessImpl.this.getManagerThread().schedule(PrioritizedTask.Priority.HIGH, () -> {
                    DebugProcessImpl.this.myPositionManager.clearCache();
                    DebuggerSession session = DebugProcessImpl.this.mySession;
                    if (session != null && session.isAttached()) {
                        DebuggerUIUtil.invokeLater(() -> session.refresh(true));
                    }
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$4", "rootsChanged"));
            }
        });
        LOG.debug("*******************VM attached******************");
        int mask = this.getTraceMask();
        if (ApplicationManager.getApplication().isUnitTestMode() && vm instanceof VirtualMachineImpl) {
            VirtualMachineImpl extendedVM = (VirtualMachineImpl)vm;
            extendedVM.disableSoftReferences();
            if (mask == 0 && Registry.is((String)"debugger.log.jdi.in.unit.tests")) {
                mask = 0xFFFFFF;
                extendedVM.setDebugTraceConsumer(strings -> LOG.debug(strings.stream().map(s -> "[JDI: " + s + "]").collect(Collectors.joining("\n"))));
            }
        }
        vm.setDebugTraceMode(mask);
        this.checkVirtualMachineVersion(vm);
        VirtualMachineProxyImpl proxy = new VirtualMachineProxyImpl(this, vm);
        DebuggerManagerThreadImpl.getCurrentThread().setVmProxy(proxy);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Alarm alarm = new Alarm((Disposable)this.disposable);
            alarm.addRequest(() -> this.myDebuggerManagerThread.schedule(PrioritizedTask.Priority.HIGH, () -> this.logError("Long debugger test execution")), 180000);
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = proxy;
        if (virtualMachineProxyImpl == null) {
            DebugProcessImpl.$$$reportNull$$$0(10);
        }
        return virtualMachineProxyImpl;
    }

    private void stopConnecting() {
        Map<String, Connector.Argument> arguments = this.myArguments;
        try {
            Connector connector;
            if (arguments == null) {
                return;
            }
            if (this.myConnection.isServerMode() && (connector = this.getConnector()) instanceof ListeningConnector) {
                ((ListeningConnector)connector).stopListening(arguments);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException | IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
        catch (ExecutionException e) {
            this.logError("Evaluation exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToConsole(String text) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.myExecutionResult == null) {
                this.myTextBeforeStart.append(text);
            } else {
                this.printToConsoleImpl(text);
            }
        }
    }

    private void printToConsoleImpl(String text) {
        this.myExecutionResult.getProcessHandler().notifyTextAvailable(text, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        return this.myExecutionResult != null ? this.myExecutionResult.getProcessHandler() : null;
    }

    @ApiStatus.Internal
    public void doStep(@NotNull SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, int size, int depth, RequestHint hint, Object commandToken) {
        if (suspendContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(11);
        }
        if (stepThread == null) {
            return;
        }
        try {
            ThreadReference stepThreadReference = stepThread.getThreadReference();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DO_STEP: creating step request for " + String.valueOf(stepThreadReference));
            }
            this.deleteStepRequests(suspendContext.getVirtualMachineProxy().eventRequestManager(), stepThreadReference);
            EventRequestManager requestManager = suspendContext.getVirtualMachineProxy().eventRequestManager();
            StepRequest stepRequest = requestManager.createStepRequest(stepThreadReference, size, depth);
            String policyFromRequestors = suspendContext.getSuspendPolicyFromRequestors();
            StepRequestor stepRequestor = new StepRequestor(policyFromRequestors);
            this.getRequestsManager().registerRequestInternal(stepRequestor, stepRequest);
            if (!(hint != null && hint.isIgnoreFilters() || DebugProcessImpl.isPositionFiltered(DebugProcessImpl.getLocation(stepThread, suspendContext)))) {
                DebugProcessImpl.getActiveFilters().forEach(f -> stepRequest.addClassExclusionFilter(f.getPattern()));
            }
            int policy = suspendContext.getSuspendPolicy() == 1 && !"SuspendAll".equals(policyFromRequestors) ? 1 : 2;
            stepRequest.setSuspendPolicy(policy);
            stepRequest.addCountFilter(1);
            if (hint != null) {
                stepRequest.putProperty("hint", hint);
            }
            if (commandToken != null) {
                stepRequest.putProperty("commandToken", commandToken);
            }
            DebuggerUtilsAsync.setEnabled(stepRequest, true).whenComplete((__, e) -> {
                if (DebuggerUtilsAsync.unwrap(e) instanceof IllegalThreadStateException) {
                    DebuggerUtilsAsync.deleteEventRequest(requestManager, stepRequest);
                }
            });
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public static boolean isPositionFiltered(@Nullable Location location) {
        ReferenceType referenceType;
        ReferenceType referenceType2 = referenceType = location != null ? location.declaringType() : null;
        if (referenceType == null) {
            return false;
        }
        return DebugProcessImpl.isClassFiltered(referenceType.name());
    }

    public static boolean isClassFiltered(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return DebuggerUtilsEx.isFiltered(name, DebugProcessImpl.getActiveFilters());
    }

    @NotNull
    private static Stream<ClassFilter> getActiveFilters() {
        DebuggerSettings settings = DebuggerSettings.getInstance();
        StreamEx stream = StreamEx.of((Collection)DebuggerClassFilterProvider.EP_NAME.getExtensionList()).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (settings.TRACING_FILTERS_ENABLED) {
            stream = stream.prepend((Object[])settings.getSteppingFilters());
        }
        AbstractStreamEx abstractStreamEx = stream.filter(ClassFilter::isEnabled);
        if (abstractStreamEx == null) {
            DebugProcessImpl.$$$reportNull$$$0(12);
        }
        return abstractStreamEx;
    }

    public static boolean shouldHideStackFramesUsingSteppingFilters() {
        return DebuggerSettings.getInstance().HIDE_STACK_FRAMES_USING_STEPPING_FILTER;
    }

    void deleteStepRequests(@NotNull EventRequestManager requestManager, @Nullable ThreadReference stepThread) {
        if (requestManager == null) {
            DebugProcessImpl.$$$reportNull$$$0(13);
        }
        for (StepRequest request : new ArrayList<StepRequest>(requestManager.stepRequests())) {
            if (stepThread != null && !stepThread.equals(request.thread())) continue;
            try {
                DebuggerUtilsAsync.deleteEventRequest(requestManager, request);
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logError("Exception", e);
            }
        }
    }

    static int getFrameCount(@Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(14);
        }
        if (thread != null) {
            if (thread.equals(suspendContext.getEventThread())) {
                return suspendContext.getCachedThreadFrameCount();
            }
            try {
                return thread.frameCount();
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nullable
    static Location getLocation(@Nullable ThreadReferenceProxyImpl thread, @NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(15);
        }
        if (thread != null) {
            if (thread.equals(suspendContext.getThread())) {
                return suspendContext.getLocation();
            }
            try {
                StackFrameProxyImpl stackFrame;
                if (thread.frameCount() > 0 && (stackFrame = thread.frame(0)) != null) {
                    return stackFrame.location();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    private VirtualMachine createVirtualMachineInt() throws ExecutionException {
        try {
            if (this.myArguments != null) {
                throw new IOException(JavaDebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
            }
            String port = this.myConnection.getDebuggerAddress();
            Connector connector = this.getConnector();
            this.myArguments = connector.defaultArguments();
            if (this.myConnection instanceof PidRemoteConnection && !((PidRemoteConnection)this.myConnection).isFixedAddress()) {
                String pid = ((PidRemoteConnection)this.myConnection).getPid();
                if (StringUtil.isEmpty((String)pid)) {
                    throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.pid", (Object[])new Object[0]));
                }
                this.setConnectorArgument("pid", pid);
            } else if (this.myConnection.isServerMode()) {
                if (port == null) {
                    throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
                }
                debuggerHostName = this.myConnection.getDebuggerHostName();
                if (debuggerHostName != null) {
                    this.setConnectorArgument("localAddress", debuggerHostName);
                }
            } else {
                if (this.myConnection.isUseSockets()) {
                    debuggerHostName = this.myConnection.getDebuggerHostName();
                    if (debuggerHostName != null) {
                        this.setConnectorArgument("hostname", debuggerHostName);
                    }
                    if (port == null) {
                        throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
                    }
                    this.setConnectorArgument("port", port);
                } else {
                    if (port == null) {
                        throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
                    }
                    this.setConnectorArgument("name", port);
                }
                this.setConnectorArgument("timeout", "0");
            }
            VirtualMachine virtualMachine = connector instanceof AttachingConnector ? this.attachConnector((AttachingConnector)connector) : this.connectorListen(port, (ListeningConnector)connector);
            return virtualMachine;
        }
        catch (IOException e) {
            throw new ExecutionException(DebugProcessImpl.processIOException(e, JavaDebuggerBundle.getAddressDisplayName((RemoteConnection)this.myConnection)), (Throwable)e);
        }
        catch (IllegalConnectorArgumentsException e) {
            throw new ExecutionException(DebugProcessImpl.processError(e), (Throwable)e);
        }
        finally {
            this.myArguments = null;
        }
    }

    @Nullable
    private String getConnectorArgument(String name) {
        Connector.Argument argument = this.myArguments.get(name);
        return argument != null ? argument.value() : null;
    }

    private void setConnectorArgument(String name, String value) {
        Connector.Argument argument = this.myArguments.get(name);
        if (argument != null) {
            argument.setValue(value);
        }
    }

    private VirtualMachine connectorListen(String address, ListeningConnector connector) throws CantRunException, IOException, IllegalConnectorArgumentsException {
        Connector.Argument portArg;
        if (address == null) {
            throw new CantRunException(JavaDebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
        }
        Connector.Argument argument = portArg = this.myConnection.isUseSockets() ? this.myArguments.get("port") : this.myArguments.get("name");
        if (portArg != null) {
            portArg.setValue(address);
            if (address.isEmpty() || address.equals("0")) {
                EmptyConnectorArgument uniqueArg = new EmptyConnectorArgument("argForUniqueness");
                this.myArguments.put(uniqueArg.name(), uniqueArg);
            }
        }
        this.setConnectorArgument("timeout", "0");
        try {
            String listeningAddress;
            try {
                listeningAddress = connector.startListening(this.myArguments);
            }
            catch (IOException e) {
                String localAddress = this.getConnectorArgument("localAddress");
                if (BazelEnvironmentUtil.isBazelTestRun() && OS.CURRENT == OS.macOS && ("localhost".equals(localAddress) || "127.0.0.1".equals(localAddress))) {
                    this.setConnectorArgument("localAddress", "::1");
                    listeningAddress = connector.startListening(this.myArguments);
                }
                throw e;
            }
            String port = StringUtil.substringAfterLast((String)listeningAddress, (String)":");
            if (port != null) {
                listeningAddress = port;
            }
            this.myConnection.setDebuggerAddress(listeningAddress);
            this.myConnection.setApplicationAddress(listeningAddress);
            DebuggerUtils.forEachSafe(this.myDebugProcessListeners, it -> it.connectorIsReady());
            VirtualMachine virtualMachine = connector.accept(this.myArguments);
            return virtualMachine;
        }
        catch (IllegalArgumentException e) {
            throw new CantRunException(e.getLocalizedMessage());
        }
        finally {
            if (this.myArguments != null) {
                try {
                    connector.stopListening(this.myArguments);
                }
                catch (IllegalConnectorArgumentsException | IllegalArgumentException exception) {}
            }
        }
    }

    private VirtualMachine attachConnector(AttachingConnector connector) throws IOException, IllegalConnectorArgumentsException, CantRunException {
        DebuggerUtils.forEachSafe(this.myDebugProcessListeners, it -> it.connectorIsReady());
        try {
            return connector.attach(this.myArguments);
        }
        catch (IOException e) {
            String localAddress = this.getConnectorArgument("hostname");
            if (BazelEnvironmentUtil.isBazelTestRun() && OS.CURRENT == OS.macOS && ("localhost".equals(localAddress) || "127.0.0.1".equals(localAddress))) {
                this.setConnectorArgument("hostname", "::1");
                return connector.attach(this.myArguments);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new CantRunException(e.getLocalizedMessage());
        }
    }

    public void showStatusText(@Nls String text) {
        LOG.debug("Show status text: " + text);
        this.myShowStatusManager.showStatus(text);
    }

    private Connector getConnector() throws ExecutionException {
        if (this.myConnection instanceof PidRemoteConnection && !((PidRemoteConnection)this.myConnection).isFixedAddress()) {
            return ((PidRemoteConnection)this.myConnection).getConnector(this);
        }
        return DebugProcessImpl.findConnector(this.myConnection.isUseSockets(), this.myConnection.isServerMode());
    }

    @NotNull
    public static Connector findConnector(boolean useSockets, boolean listen) throws ExecutionException {
        String connectorName = (Registry.is((String)"debugger.jb.jdi") ? "com.jetbrains.jdi." : "com.sun.jdi.") + (useSockets ? "Socket" : "SharedMemory") + (listen ? "Listen" : "Attach");
        return DebugProcessImpl.findConnector(connectorName);
    }

    @NotNull
    public static Connector findConnector(String connectorName) throws ExecutionException {
        Object virtualMachineManager;
        if (connectorName.startsWith("com.jetbrains")) {
            virtualMachineManager = VirtualMachineManagerImpl.virtualMachineManager();
        } else {
            try {
                virtualMachineManager = Bootstrap.virtualMachineManager();
            }
            catch (Error e) {
                throw new ExecutionException(JavaDebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{e.getClass().getName() + " : " + e.getLocalizedMessage()}));
            }
        }
        Connector connector = (Connector)StreamEx.of(virtualMachineManager.allConnectors()).findFirst(c -> connectorName.equals(c.name())).orElseThrow(() -> new CantRunException(JavaDebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{connectorName})));
        if (connector == null) {
            DebugProcessImpl.$$$reportNull$$$0(16);
        }
        return connector;
    }

    protected void checkVirtualMachineVersion(VirtualMachine vm) {
        String versionString = vm.version();
        if ("1.4.0".equals(versionString)) {
            DebuggerInvocationUtil.invokeLaterAnyModality(this.project, () -> Messages.showMessageDialog((Project)this.project, (String)JavaDebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)JavaDebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()));
        }
        if (this.getSession().getAlternativeJre() == null) {
            Sdk runjre = this.getSession().getRunJre();
            JavaVersion version = JavaVersion.tryParse((String)versionString);
            if (version != null && (runjre == null || runjre.getSdkType() instanceof JavaSdkType) && !DebugProcessImpl.versionMatch(runjre, version)) {
                Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).sorted(Comparator.comparing(sdk -> !(sdk.getSdkType() instanceof JavaSdk))).filter(sdk -> DebugProcessImpl.versionMatch(sdk, version)).findFirst().ifPresent(sdk -> {
                    LOG.info(JavaDebuggerBundle.message((String)"message.remote.jre.version.mismatch", (Object[])new Object[]{versionString, runjre != null ? runjre.getVersionString() : "unknown", sdk.getName()}));
                    this.getSession().setAlternativeJre((Sdk)sdk);
                });
            }
        }
    }

    private static boolean versionMatch(@Nullable Sdk sdk, @NotNull JavaVersion version) {
        JavaVersion v;
        if (version == null) {
            DebugProcessImpl.$$$reportNull$$$0(17);
        }
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && (v = JavaVersion.tryParse((String)sdk.getVersionString())) != null) {
            return version.feature == v.feature && version.minor == v.minor && version.update == v.update;
        }
        return false;
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener listener2, Disposable parentDisposable) {
        this.myDebugProcessListeners.add((Object)listener2, parentDisposable);
    }

    public void addDebugProcessListener(DebugProcessListener listener2) {
        if (this.disposable.isDisposed()) {
            return;
        }
        this.myDebugProcessListeners.add((Object)listener2, (Disposable)this.disposable);
    }

    public void removeDebugProcessListener(DebugProcessListener listener2) {
        this.myDebugProcessListeners.remove((Object)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.myProcessListeners.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.myProcessListeners;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.myProcessListeners.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.myConnection;
    }

    public ExecutionResult getExecutionResult() {
        return this.myExecutionResult;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            DebugProcessImpl.$$$reportNull$$$0(18);
        }
        return project;
    }

    public boolean canRedefineClasses() {
        VirtualMachineProxyImpl vm = this.getManagerThread().getVmProxy();
        return vm != null && vm.canRedefineClasses();
    }

    public boolean isInInitialState() {
        return this.myState.get() == State.INITIAL;
    }

    public boolean isAttached() {
        return this.myState.get() == State.ATTACHED;
    }

    public boolean isDetached() {
        return this.myState.get() == State.DETACHED;
    }

    public boolean isDetaching() {
        return this.myState.get() == State.DETACHING;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.requestManager;
    }

    @ApiStatus.Obsolete
    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = VirtualMachineProxyImpl.getCurrent();
        if (virtualMachineProxyImpl == null) {
            DebugProcessImpl.$$$reportNull$$$0(19);
        }
        return virtualMachineProxyImpl;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setSteppingBreakpoint(@NotNull SteppingBreakpoint breakpoint) {
        if (breakpoint == null) {
            DebugProcessImpl.$$$reportNull$$$0(20);
        }
        this.mySteppingBreakpoints.add(breakpoint);
    }

    public void cancelSteppingBreakpoints() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean isRestoreBreakpoints = false;
        for (SteppingBreakpoint runToCursorBreakpoint : this.mySteppingBreakpoints) {
            this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
            isRestoreBreakpoints |= runToCursorBreakpoint.isRestoreBreakpoints();
        }
        if (isRestoreBreakpoints) {
            DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().enableBreakpoints(this);
        }
        this.mySteppingBreakpoints.clear();
    }

    public static void prepareAndSetSteppingBreakpoint(SuspendContextImpl context, @NotNull SteppingBreakpoint breakpoint, RequestHint hint, boolean resetThreadFilter) {
        if (breakpoint == null) {
            DebugProcessImpl.$$$reportNull$$$0(21);
        }
        DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, breakpoint, hint, resetThreadFilter, -1);
    }

    public static void prepareAndSetSteppingBreakpoint(SuspendContextImpl context, @NotNull SteppingBreakpoint breakpoint, RequestHint hint, boolean resetThreadFilter, int suspendPolicy) {
        if (breakpoint == null) {
            DebugProcessImpl.$$$reportNull$$$0(22);
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (resetThreadFilter) {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(debugProcess.getProject()).getBreakpointManager();
            breakpointManager.removeThreadFilter(debugProcess);
        }
        breakpoint.setSuspendPolicy(suspendPolicy == 1 ? "SuspendThread" : "SuspendAll");
        breakpoint.createRequest(debugProcess);
        breakpoint.setRequestHint(hint);
        debugProcess.setSteppingBreakpoint(breakpoint);
    }

    public void resetIgnoreSteppingFilters(@Nullable Location location, @Nullable RequestHint hint) {
        if (hint != null && hint.isResetIgnoreFilters() && location != null && !DebugProcessImpl.isPositionFiltered(location)) {
            this.getSession().resetIgnoreStepFiltersFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachProcess(boolean closedByUser, boolean keepManagerThread, Consumer<@Nullable VirtualMachineData> callback) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myState.compareAndSet(State.INITIAL, State.DETACHING) || this.myState.compareAndSet(State.ATTACHED, State.DETACHING)) {
            DebuggerManagerThreadImpl managerThread = this.myDebuggerManagerThread;
            try {
                if (!keepManagerThread) {
                    managerThread.close();
                }
            }
            finally {
                if (!(this.myConnection instanceof RemoteConnectionStub)) {
                    VirtualMachineData vmData = new VirtualMachineData(managerThread.getVmProxy(), this.myConnection, managerThread);
                    this.myPositionManager = CompoundPositionManager.DISABLED;
                    this.myReturnValueWatcher = null;
                    this.myNodeRenderersMap.clear();
                    this.myRenderers.clear();
                    this.myState.compareAndSet(State.DETACHING, State.DETACHED);
                    try {
                        DebuggerUtils.forEachSafe(this.myDebugProcessListeners, it -> it.processDetached((DebugProcess)this, closedByUser));
                    }
                    finally {
                        callback.accept(vmData);
                    }
                }
            }
        }
    }

    protected void closeCurrentProcess(boolean closedByUser) {
        this.detachProcess(closedByUser, false, vmData -> {
            boolean attachedNewThread;
            if (vmData != null && vmData.vm != null) {
                try {
                    vmData.vm.dispose();
                }
                catch (Throwable throwable) {
                }
                finally {
                    DebuggerManagerThreadImpl.getCurrentThread().setVmProxy(null);
                }
            }
            if (!(attachedNewThread = this.unstashAndReattach())) {
                this.onRootProcessClosed();
            }
        });
    }

    private void onRootProcessClosed() {
        this.myDebuggerManagerThread.cancelScope();
        this.myWaitFor.up();
    }

    @Contract(pure=true)
    private static String formatMessage(String message) {
        int lineLength = 90;
        StringBuilder buf = new StringBuilder(message.length());
        for (int index = 0; index < message.length(); index += 90) {
            buf.append(message, index, Math.min(index + 90, message.length())).append('\n');
        }
        return buf.toString();
    }

    @NlsContexts.DialogMessage
    public static String processError(Exception e) {
        Object message;
        if (e instanceof VMStartException) {
            VMStartException e1 = (VMStartException)e;
            message = e1.getLocalizedMessage();
        } else if (e instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException e1 = (IllegalConnectorArgumentsException)e;
            List<String> invalidArgumentNames = e1.argumentNames();
            message = DebugProcessImpl.formatMessage(JavaDebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{invalidArgumentNames.size()}) + ": " + e1.getLocalizedMessage()) + String.valueOf(invalidArgumentNames);
            LOG.debug((Throwable)e1);
        } else if (e instanceof CantRunException) {
            message = e.getLocalizedMessage();
        } else if (e instanceof VMDisconnectedException) {
            message = JavaDebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (e instanceof IOException) {
            message = DebugProcessImpl.processIOException((IOException)e, null);
        } else if (e instanceof ExecutionException) {
            message = e.getLocalizedMessage();
        } else {
            message = JavaDebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{e.getClass().getName(), e.getLocalizedMessage()});
            LOG.debug((Throwable)e);
        }
        return message;
    }

    @NlsContexts.DialogMessage
    @NotNull
    public static String processIOException(@NotNull IOException e, @Nullable String address) {
        if (e == null) {
            DebugProcessImpl.$$$reportNull$$$0(23);
        }
        if (e instanceof UnknownHostException) {
            if (address != null) {
                String string = JavaDebuggerBundle.message((String)"error.unknown.host.with.address", (Object[])new Object[]{address}) + ":\n" + e.getLocalizedMessage();
                if (string == null) {
                    DebugProcessImpl.$$$reportNull$$$0(24);
                }
                return string;
            }
            String string = JavaDebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]) + ":\n" + e.getLocalizedMessage();
            if (string == null) {
                DebugProcessImpl.$$$reportNull$$$0(25);
            }
            return string;
        }
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException && cause.getCause() != null) {
            String string = cause.getCause().getLocalizedMessage();
            if (string == null) {
                DebugProcessImpl.$$$reportNull$$$0(26);
            }
            return string;
        }
        @Nls StringBuilder buf = new StringBuilder();
        if (address != null) {
            buf.append(JavaDebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
            buf.append(" (").append(address).append("): ");
        }
        buf.append(e.getClass().getName()).append(" ");
        if (!StringUtil.isEmpty((String)e.getLocalizedMessage())) {
            buf.append('\"').append(e.getLocalizedMessage()).append('\"');
        }
        if (cause != null && !StringUtil.isEmpty((String)cause.getLocalizedMessage())) {
            buf.append(" (").append(cause.getLocalizedMessage()).append(')');
        }
        LOG.debug((Throwable)e);
        String string = buf.toString();
        if (string == null) {
            DebugProcessImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
        LOG.debug("Debug has been finished");
        Disposer.dispose((Disposable)this.disposable);
        this.requestManager.setThreadFilter(null);
    }

    @ApiStatus.Obsolete
    @NotNull
    public final DebuggerManagerThreadImpl getManagerThread() {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = this.myDebuggerManagerThread;
        if (debuggerManagerThreadImpl == null) {
            DebugProcessImpl.$$$reportNull$$$0(28);
        }
        return debuggerManagerThreadImpl;
    }

    public boolean isCurrentVirtualMachine(@NotNull VirtualMachineProxyImpl vmProxy) {
        if (vmProxy == null) {
            DebugProcessImpl.$$$reportNull$$$0(29);
        }
        VirtualMachineProxyImpl current = this.getManagerThread().getVmProxy();
        VirtualMachine vm = (VirtualMachine)ObjectUtils.doIfNotNull((Object)current, it -> it.getVirtualMachine());
        return vmProxy.getVirtualMachine() == vm;
    }

    private static int getInvokePolicy(SuspendContext suspendContext) {
        if (suspendContext.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread() || ThreadBlockedMonitor.getSingleThreadedEvaluationThreshold() > 0) {
            return 1;
        }
        return 0;
    }

    public void waitFor() {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor();
    }

    public void waitFor(long timeout) {
        LOG.assertTrue(!DebuggerManagerThreadImpl.isManagerThread());
        this.myWaitFor.waitFor(timeout);
    }

    private void mergeSuspendThreadContextToSuspendAllContext() {
        boolean wasResumedSuspendThreadPausedContexts = false;
        for (SuspendContextImpl anotherPausedContext : this.getSuspendManager().getPausedContexts()) {
            if (anotherPausedContext.getSuspendPolicy() != 1) continue;
            this.getSuspendManager().resume(anotherPausedContext);
            wasResumedSuspendThreadPausedContexts = true;
        }
        if (wasResumedSuspendThreadPausedContexts) {
            XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"message.switched.to.suspend.all.context", (Object[])new Object[0]), MessageType.WARNING).notify(this.getProject());
        }
    }

    private void resumeThreadsUnderEvaluationAndExplicitlyResumedAfterPause(@NotNull SuspendContextImpl suspendAllContext) {
        if (suspendAllContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(30);
        }
        for (SuspendContextImpl suspendContext : this.mySuspendManager.getEventContexts()) {
            EvaluationContextImpl evaluationContext = suspendContext.getEvaluationContext();
            if (evaluationContext == null) continue;
            ThreadReferenceProxyImpl threadForEvaluation = evaluationContext.getThreadForEvaluation();
            if (threadForEvaluation == null) {
                this.logError("Thread for evaluation in evaluating " + String.valueOf((Object)suspendContext) + " is null");
                continue;
            }
            if (threadForEvaluation == suspendAllContext.getEventThread()) {
                this.logError("Paused suspend-all context " + String.valueOf((Object)suspendAllContext) + " for evaluating context " + String.valueOf((Object)suspendContext));
                continue;
            }
            if (!suspendAllContext.suspends(threadForEvaluation)) continue;
            this.mySuspendManager.resumeThread(suspendAllContext, threadForEvaluation);
        }
        ArrayList<ThreadReferenceProxyImpl> threads = new ArrayList<ThreadReferenceProxyImpl>(this.mySuspendManager.myExplicitlyResumedThreads);
        for (ThreadReferenceProxyImpl thread : threads) {
            if (thread == suspendAllContext.getEventThread()) {
                this.mySuspendManager.myExplicitlyResumedThreads.remove(thread);
                continue;
            }
            if (!suspendAllContext.suspends(thread)) continue;
            this.mySuspendManager.resumeThread(suspendAllContext, thread);
        }
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(31);
        }
        if (objRef == null) {
            DebugProcessImpl.$$$reportNull$$$0(32);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(33);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(34);
        }
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args, int invocationOptions) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(35);
        }
        if (objRef == null) {
            DebugProcessImpl.$$$reportNull$$$0(36);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(37);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(38);
        }
        return this.invokeInstanceMethod(evaluationContext, objRef, method, args, invocationOptions, false);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objRef, @NotNull Method method, @NotNull List<? extends Value> args, final int invocationOptions, boolean internalEvaluate) throws EvaluateException {
        InvocationResult result;
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(39);
        }
        if (objRef == null) {
            DebugProcessImpl.$$$reportNull$$$0(40);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(41);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(42);
        }
        if ((result = MethodInvokeUtilsKt.tryInvokeWithHelper(method.declaringType(), objRef, method, args, (EvaluationContextImpl)evaluationContext, invocationOptions, internalEvaluate)).isSuccess()) {
            return result.getValue();
        }
        return new InvokeCommand<Value>(this, method, args, (EvaluationContextImpl)evaluationContext){

            @Override
            protected Value invokeMethod(ThreadReference thread, int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + objRef.type().name() + "." + method.name());
                }
                return objRef.invokeMethod(thread, method, args, invokePolicy | invocationOptions);
            }
        }.start(internalEvaluate);
    }

    @NotNull
    static ThreadReferenceProxy getEvaluationThread(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy evaluationThread;
        ThreadReferenceProxy fromStackFrame = (ThreadReferenceProxy)ObjectUtils.doIfNotNull((Object)evaluationContext.getFrameProxy(), stackFrameProxy -> stackFrameProxy.threadProxy());
        SuspendContextImpl suspendContext = (SuspendContextImpl)evaluationContext.getSuspendContext();
        Object object = evaluationThread = fromStackFrame != null ? fromStackFrame : suspendContext.getThread();
        if (suspendContext.myNotExecutableThreads.contains(evaluationThread)) {
            evaluationThread = suspendContext.getEventThread();
        }
        if (evaluationThread == null) {
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        ThreadReferenceProxy threadReferenceProxy = evaluationThread;
        if (threadReferenceProxy == null) {
            DebugProcessImpl.$$$reportNull$$$0(43);
        }
        return threadReferenceProxy;
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List<? extends Value> args) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, args, 0, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, boolean internalEvaluate) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(44);
        }
        if (classType == null) {
            DebugProcessImpl.$$$reportNull$$$0(45);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(46);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(47);
        }
        return this.invokeMethod(evaluationContext, classType, method, args, 0, internalEvaluate);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, final int extraInvocationOptions, boolean internalEvaluate) throws EvaluateException {
        InvocationResult result;
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(48);
        }
        if (classType == null) {
            DebugProcessImpl.$$$reportNull$$$0(49);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(50);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(51);
        }
        if ((result = MethodInvokeUtilsKt.tryInvokeWithHelper(classType, null, method, args, (EvaluationContextImpl)evaluationContext, extraInvocationOptions, internalEvaluate)).isSuccess()) {
            return result.getValue();
        }
        return new InvokeCommand<Value>(this, method, args, (EvaluationContextImpl)evaluationContext){

            @Override
            protected Value invokeMethod(ThreadReference thread, int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + classType.name() + "." + method.name());
                }
                return classType.invokeMethod(thread, method, args, invokePolicy | extraInvocationOptions);
            }
        }.start(internalEvaluate);
    }

    public Value invokeMethod(EvaluationContext evaluationContext, final InterfaceType interfaceType, Method method, List<? extends Value> args) throws EvaluateException {
        InvocationResult result = MethodInvokeUtilsKt.tryInvokeWithHelper(interfaceType, null, method, args, (EvaluationContextImpl)evaluationContext, 0, false);
        if (result.isSuccess()) {
            return result.getValue();
        }
        return new InvokeCommand<Value>(this, method, args, (EvaluationContextImpl)evaluationContext){

            @Override
            protected Value invokeMethod(ThreadReference thread, int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoking " + interfaceType.name() + "." + method.name());
                }
                try {
                    return interfaceType.invokeMethod(thread, method, args, invokePolicy);
                }
                catch (LinkageError e) {
                    throw new IllegalStateException("Interface method invocation is not supported in JVM " + SystemInfo.JAVA_VERSION + ". Use JVM 1.8.0_45 or higher to run " + ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }
        }.start(false);
    }

    public ArrayReference newInstance(ArrayType arrayType, int dimension) throws EvaluateException {
        try {
            return arrayType.newInstance(dimension);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args) throws EvaluateException {
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(52);
        }
        if (classType == null) {
            DebugProcessImpl.$$$reportNull$$$0(53);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(54);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(55);
        }
        return this.newInstance(evaluationContext, classType, method, args, 0, false);
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> args, final int invocationOptions, boolean internalEvaluate) throws EvaluateException {
        InvocationResult result;
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(56);
        }
        if (classType == null) {
            DebugProcessImpl.$$$reportNull$$$0(57);
        }
        if (method == null) {
            DebugProcessImpl.$$$reportNull$$$0(58);
        }
        if (args == null) {
            DebugProcessImpl.$$$reportNull$$$0(59);
        }
        if ((result = MethodInvokeUtilsKt.tryInvokeWithHelper(classType, null, method, args, (EvaluationContextImpl)evaluationContext, invocationOptions, internalEvaluate)).isSuccess()) {
            return (ObjectReference)result.getValue();
        }
        InvokeCommand<ObjectReference> invokeCommand2 = new InvokeCommand<ObjectReference>(this, method, args, (EvaluationContextImpl)evaluationContext){

            @Override
            protected ObjectReference invokeMethod(ThreadReference thread, int invokePolicy, Method method, List<? extends Value> args) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New instance " + classType.name() + "." + method.name());
                }
                return classType.newInstance(thread, method, args, invokePolicy | invocationOptions);
            }
        };
        return (ObjectReference)invokeCommand2.start(internalEvaluate);
    }

    public void clearCashes(@NotNull SuspendContextImpl context) {
        if (context == null) {
            DebugProcessImpl.$$$reportNull$$$0(60);
        }
        if (!this.isAttached()) {
            return;
        }
        switch (context.getSuspendPolicy()) {
            case 1: 
            case 2: {
                context.getVirtualMachineProxy().clearCaches();
            }
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContext) {
        this.clearCashes(suspendContext);
    }

    private void beforeMethodInvocation(SuspendContextImpl suspendContext, Method method, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("before invocation in  thread " + suspendContext.getThread().name() + " method " + (method == null ? "null" : method.name()));
        }
        if (!internalEvaluate) {
            if (method != null) {
                this.showStatusText(JavaDebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
            } else {
                this.showStatusText(JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            }
        }
    }

    private void afterMethodInvocation(SuspendContextImpl suspendContext, boolean internalEvaluate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("after invocation in  thread " + suspendContext.getThread().name());
        }
        if (!internalEvaluate) {
            this.showStatusText("");
        }
    }

    public ReferenceType findClass(@Nullable EvaluationContext evaluationContext, String className, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            EvaluationContextImpl evalContext;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContext suspendContext = evaluationContext != null ? evaluationContext.getSuspendContext() : null;
            ReferenceType result = this.findLoadedClass(suspendContext, className, classLoader);
            if (result == null && evaluationContext != null && (evalContext = (EvaluationContextImpl)evaluationContext).isAutoLoadClasses()) {
                return this.loadClass(evalContext, className, classLoader);
            }
            return result;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Nullable
    public ReferenceType findLoadedClass(@Nullable SuspendContext suspendContext, String className, ClassLoaderReference classLoader) {
        List<ReferenceType> types = this.findLoadedClasses(suspendContext, className);
        ReferenceType result = (ReferenceType)ContainerUtil.find(types, refType -> Objects.equals(classLoader, refType.classLoader()));
        if (result == null && classLoader != null) {
            result = (ReferenceType)ContainerUtil.find(types, refType -> DebugProcessImpl.isVisibleFromClassLoader(classLoader, refType));
        }
        return result;
    }

    @NotNull
    public List<ReferenceType> findLoadedClasses(@Nullable SuspendContext suspendContext, String className) {
        List list = ContainerUtil.filter(DebugProcessImpl.getCurrentVm(suspendContext).classesByName(className), ReferenceType::isPrepared);
        if (list == null) {
            DebugProcessImpl.$$$reportNull$$$0(61);
        }
        return list;
    }

    private static VirtualMachineProxyImpl getCurrentVm(@Nullable SuspendContext suspendContext) {
        return suspendContext != null ? ((SuspendContextImpl)suspendContext).getVirtualMachineProxy() : VirtualMachineProxyImpl.getCurrent();
    }

    private static boolean isVisibleFromClassLoader(@NotNull ClassLoaderReference fromLoader, ReferenceType refType) {
        if (fromLoader == null) {
            DebugProcessImpl.$$$reportNull$$$0(62);
        }
        if (fromLoader instanceof ClassLoaderReferenceImpl) {
            return ((ClassLoaderReferenceImpl)fromLoader).isVisible(refType);
        }
        return fromLoader.visibleClasses().contains(refType);
    }

    private static String reformatArrayName(String className) {
        if (className.indexOf(91) == -1) {
            return className;
        }
        int dims = 0;
        while (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
            ++dims;
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buffer, (char)'[', (int)dims);
        String primitiveSignature = JVMNameUtil.getPrimitiveSignature(className);
        if (primitiveSignature != null) {
            buffer.append(primitiveSignature);
        } else {
            buffer.append('L');
            buffer.append(className);
            buffer.append(';');
        }
        return buffer.toString();
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContext, ClassNotLoadedException exception, ClassLoaderReference classLoader) throws ClassNotLoadedException, EvaluateException, IncompatibleThreadStateException, InvocationException, InvalidTypeException {
        if (exception instanceof ExactClassNotLoadedException) {
            ExactClassNotLoadedException ex = (ExactClassNotLoadedException)exception;
            classLoader = ex.getClassLoader();
        }
        return this.loadClass(evaluationContext, exception.className(), classLoader);
    }

    public ReferenceType loadClass(@NotNull EvaluationContextImpl evaluationContext, String qName, ClassLoaderReference classLoader) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        Method forNameMethod;
        if (evaluationContext == null) {
            DebugProcessImpl.$$$reportNull$$$0(63);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        qName = DebugProcessImpl.reformatArrayName(qName);
        VirtualMachineProxyImpl virtualMachine = DebugProcessImpl.getCurrentVm(evaluationContext.getSuspendContext());
        ClassType classClassType = (ClassType)ContainerUtil.getFirstItem(virtualMachine.classesByName("java.lang.Class"));
        if (classClassType == null) {
            this.logError("Unable to find loaded class java.lang.Class");
            return null;
        }
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(DebuggerUtilsEx.mirrorOfString(qName, evaluationContext));
        if (classLoader != null) {
            forNameMethod = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
            args.add(virtualMachine.mirrorOf(true));
            args.add(classLoader);
        } else {
            forNameMethod = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
        }
        if (forNameMethod == null) {
            this.logError("Unable to find forName method in " + String.valueOf(classClassType));
            return null;
        }
        Value classReference = this.invokeMethod(evaluationContext, classClassType, forNameMethod, args, 1024, true);
        if (classReference instanceof ClassObjectReference) {
            ReferenceType refType = ((ClassObjectReference)classReference).reflectedType();
            if (classLoader instanceof ClassLoaderReferenceImpl) {
                ((ClassLoaderReferenceImpl)classLoader).addVisible(refType);
            }
            return refType;
        }
        return null;
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> allThreads = VirtualMachineProxyImpl.getCurrent().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxy : allThreads) {
                    LOG.debug("Thread name=" + threadReferenceProxy.name() + " suspendCount()=" + threadReferenceProxy.getSuspendCount());
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void onHotSwapFinished() {
        this.getPositionManager().clearCache();
        StackCapturingLineBreakpoint.clearCaches(this);
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        SuspendManagerImpl suspendManagerImpl = this.mySuspendManager;
        if (suspendManagerImpl == null) {
            DebugProcessImpl.$$$reportNull$$$0(64);
        }
        return suspendManagerImpl;
    }

    @NotNull
    public CompoundPositionManager getPositionManager() {
        CompoundPositionManager compoundPositionManager = this.myPositionManager;
        if (compoundPositionManager == null) {
            DebugProcessImpl.$$$reportNull$$$0(65);
        }
        return compoundPositionManager;
    }

    public void stop(boolean forceTerminate) {
        this.myIsStopped.set(true);
        this.stopConnecting();
        this.getManagerThread().terminateAndInvoke(this.createStopCommand(forceTerminate), ApplicationManager.getApplication().isUnitTestMode() ? 0 : 3000);
    }

    @NotNull
    public StopCommand createStopCommand(boolean forceTerminate) {
        return new StopCommand(forceTerminate);
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        LOG.assertTrue(this.mySession != null, (Object)"Accessing debug session before its initialization");
        GlobalSearchScope globalSearchScope = this.mySession.getSearchScope();
        if (globalSearchScope == null) {
            DebugProcessImpl.$$$reportNull$$$0(66);
        }
        return globalSearchScope;
    }

    public void reattach(DebugEnvironment environment) {
        this.reattach(environment, false, () -> {});
    }

    public void reattach(DebugEnvironment environment, boolean keepCurrentVM, Runnable vmReadyCallback) {
        this.reattach(environment, () -> {
            if (keepCurrentVM) {
                this.detachProcess(false, true, vmData -> {
                    this.myStashedVirtualMachines.addFirst((VirtualMachineData)vmData);
                    this.myDebuggerManagerThread = this.createManagerThread();
                });
            } else {
                this.closeCurrentProcess(false);
            }
        }, vmReadyCallback);
    }

    private boolean unstashAndReattach() {
        final VirtualMachineData vmData = this.myStashedVirtualMachines.pollFirst();
        if (vmData != null && vmData.vm != null) {
            this.myDebuggerManagerThread = vmData.debuggerManagerThread;
            this.reattach(vmData.connection, () -> {}, () -> this.afterProcessStarted(() -> vmData.debuggerManagerThread.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    try {
                        DebugProcessImpl.this.commitVM(vmData.vm.getVirtualMachine());
                    }
                    catch (VMDisconnectedException e) {
                        DebugProcessImpl.this.fail();
                    }
                }
            })));
            return true;
        }
        return false;
    }

    private void reattach(DebugEnvironment environment, Runnable detachVm, Runnable vmReadyCallback) {
        this.reattach(environment.getRemoteConnection(), detachVm, () -> {
            this.createVirtualMachine(environment);
            vmReadyCallback.run();
        });
    }

    private void reattach(final RemoteConnection connection, final Runnable detachVm, final Runnable attachVm) {
        if (!this.myIsStopped.get()) {
            final DebuggerManagerThreadImpl debuggerManagerThread = this.getManagerThread();
            debuggerManagerThread.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    detachVm.run();
                    this.getCommandManagerThread().processRemaining();
                    this.doReattach();
                }

                @Override
                protected void commandCancelled() {
                    debuggerManagerThread.afterScopeCancellation(this::doReattach);
                }

                private void doReattach() {
                    DebuggerInvocationUtil.invokeLaterAnyModality(DebugProcessImpl.this.project, () -> {
                        ((XDebugSessionImpl)DebugProcessImpl.this.getXdebugProcess().getSession()).reset();
                        DebugProcessImpl.this.myState.set(State.INITIAL);
                        DebugProcessImpl.this.myConnection = connection;
                        DebugProcessImpl.this.getManagerThread().restartIfNeeded();
                        attachVm.run();
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(@NotNull DebugEnvironment environment, @NotNull DebuggerSession session) throws ExecutionException {
        ExecutionResult executionResult;
        if (environment == null) {
            DebugProcessImpl.$$$reportNull$$$0(67);
        }
        if (session == null) {
            DebugProcessImpl.$$$reportNull$$$0(68);
        }
        this.mySession = session;
        this.myWaitFor.down();
        LOG.assertTrue(this.isInInitialState());
        this.myConnection = environment.getRemoteConnection();
        if (!(this.myConnection instanceof RemoteConnectionStub) && !(this.myConnection instanceof DelayedRemoteConnection) && this.myConnection.isServerMode()) {
            this.createVirtualMachine(environment);
            if (this.myIsFailed.get()) {
                this.myExecutionResult = null;
                return null;
            }
        }
        try {
            List<ProcessListener> list = this.myProcessListeners;
            synchronized (list) {
                this.myExecutionResult = executionResult = environment.createExecutionResult();
                if (executionResult == null) {
                    this.fail();
                    return null;
                }
                for (ProcessListener processListener : this.myProcessListeners) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.myProcessListeners.clear();
                if (!this.myTextBeforeStart.isEmpty()) {
                    this.printToConsoleImpl(this.myTextBeforeStart.toString());
                    this.myTextBeforeStart.setLength(0);
                }
            }
        }
        catch (ExecutionException e) {
            this.fail();
            throw e;
        }
        if (this.myConnection instanceof DelayedRemoteConnection) {
            ((DelayedRemoteConnection)this.myConnection).setAttachRunnable(() -> this.createVirtualMachine(environment));
        } else if (!(this.myConnection instanceof RemoteConnectionStub) && !this.myConnection.isServerMode()) {
            this.createVirtualMachine(environment);
            if (this.myIsFailed.get()) {
                this.myExecutionResult = null;
                return null;
            }
        }
        return executionResult;
    }

    private void fail() {
        if (this.myIsFailed.compareAndSet(false, true)) {
            this.stop(false);
        }
    }

    private void createVirtualMachine(DebugEnvironment environment) {
        final String sessionName = environment.getSessionName();
        final long pollTimeout = environment.getPollTimeout();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean connectorIsReady = new AtomicBoolean(false);
        this.addDebugProcessListener(new DebugProcessListener(){

            public void connectorIsReady() {
                connectorIsReady.set(true);
                semaphore.up();
                DebugProcessImpl.this.removeDebugProcessListener(this);
            }

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                if (process == null) {
                    11.$$$reportNull$$$0(0);
                }
                DebugProcessImpl.this.removeDebugProcessListener(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/engine/DebugProcessImpl$11", "processDetached"));
            }
        }, (Disposable)this.disposable);
        this.getManagerThread().schedule(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void action() {
                VirtualMachine vm = null;
                try {
                    long time = System.currentTimeMillis();
                    while (true) {
                        try {
                            vm = DebugProcessImpl.this.createVirtualMachineInt();
                        }
                        catch (ExecutionException e) {
                            if (pollTimeout > 0L && !DebugProcessImpl.this.myConnection.isServerMode() && e.getCause() instanceof IOException) {
                                12 var5_5 = this;
                                synchronized (var5_5) {
                                    try {
                                        this.wait(500L);
                                    }
                                    catch (InterruptedException ignored) {
                                        break;
                                    }
                                }
                            }
                            ProcessHandler processHandler = DebugProcessImpl.this.getProcessHandler();
                            boolean terminated = processHandler != null && (processHandler.isProcessTerminating() || processHandler.isProcessTerminated());
                            try {
                                DebuggerUtils.forEachSafe(DebugProcessImpl.this.myDebugProcessListeners, it -> it.attachException(null, e, DebugProcessImpl.this.myConnection));
                            }
                            catch (Exception ex) {
                                LOG.debug((Throwable)ex);
                            }
                            DebugProcessImpl.this.fail();
                            DebuggerInvocationUtil.invokeLaterAnyModality(() -> {
                                if (!((DebugProcessImpl.this.myExecutionResult == null || terminated) && connectorIsReady.get() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                                    ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.project, (String)"Debug", (String)sessionName, (Throwable)e);
                                }
                            });
                            break;
                            if (System.currentTimeMillis() - time < pollTimeout) continue;
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (vm != null) {
                    final VirtualMachine vm1 = vm;
                    DebugProcessImpl.this.afterProcessStarted(() -> this.getCommandManagerThread().schedule(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

                        @Override
                        protected void action() {
                            try {
                                DebugProcessImpl.this.commitVM(vm1);
                            }
                            catch (VMDisconnectedException e) {
                                DebugProcessImpl.this.fail();
                            }
                        }
                    }));
                } else {
                    DebugProcessImpl.this.fail();
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }
        });
        semaphore.waitFor();
    }

    private void afterProcessStarted(final Runnable run) {
        class MyProcessAdapter
        implements ProcessListener {
            private boolean alreadyRun = false;

            MyProcessAdapter() {
            }

            public synchronized void run() {
                if (!this.alreadyRun) {
                    this.alreadyRun = true;
                    run.run();
                }
                DebugProcessImpl.this.removeProcessListener(this);
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    MyProcessAdapter.$$$reportNull$$$0(0);
                }
                this.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$1MyProcessAdapter", "startNotified"));
            }
        }
        MyProcessAdapter processListener = new MyProcessAdapter();
        this.addProcessListener(processListener);
        if (this.myExecutionResult != null && this.myExecutionResult.getProcessHandler().isStartNotified()) {
            processListener.run();
        }
    }

    @NotNull
    public DebuggerCommandImpl createPauseCommand(@Nullable ThreadReferenceProxyImpl threadProxy) {
        return new PauseCommand(threadProxy);
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext) {
        ResumeCommand resumeCommand = this.createResumeCommand(suspendContext, PrioritizedTask.Priority.HIGH);
        if (resumeCommand == null) {
            DebugProcessImpl.$$$reportNull$$$0(69);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContext, final PrioritizedTask.Priority priority) {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        return new ResumeCommand(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    13.$$$reportNull$$$0(0);
                }
                breakpointManager.removeThreadFilter(DebugProcessImpl.this);
                if (DebugProcessImpl.this.myReturnValueWatcher != null) {
                    DebugProcessImpl.this.myReturnValueWatcher.clear();
                }
                super.contextAction(suspendContext);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return priority;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$13", "contextAction"));
            }
        };
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
        ResumeCommand resumeCommand = this.createStepOverCommand(suspendContext, ignoreBreakpoints, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.$$$reportNull$$$0(70);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        ResumeCommand resumeCommand = this.createStepOverCommand(suspendContext, ignoreBreakpoints, null, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.$$$reportNull$$$0(71);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter, int stepSize) {
        return new StepOverCommand(suspendContext, ignoreBreakpoints, methodFilter, stepSize);
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext) {
        ResumeCommand resumeCommand = this.createStepOutCommand(suspendContext, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.$$$reportNull$$$0(72);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
        return new StepOutCommand(suspendContext, stepSize);
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter) {
        ResumeCommand resumeCommand = this.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, -2);
        if (resumeCommand == null) {
            DebugProcessImpl.$$$reportNull$$$0(73);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContext, boolean ignoreFilters, MethodFilter smartStepFilter, int stepSize) {
        return new StepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
    }

    @NotNull
    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) throws EvaluateException {
        if (position == null) {
            DebugProcessImpl.$$$reportNull$$$0(74);
        }
        RunToCursorCommand runToCursorCommand = new RunToCursorCommand(suspendContext, position, ignoreBreakpoints);
        this.checkRunToCursorIsOk(position, runToCursorCommand);
        RunToCursorCommand runToCursorCommand2 = runToCursorCommand;
        if (runToCursorCommand2 == null) {
            DebugProcessImpl.$$$reportNull$$$0(75);
        }
        return runToCursorCommand2;
    }

    private void checkRunToCursorIsOk(@NotNull XSourcePosition position, RunToCursorCommand runToCursorCommand) throws EvaluateException {
        if (position == null) {
            DebugProcessImpl.$$$reportNull$$$0(76);
        }
        if (runToCursorCommand.myRunToCursorBreakpoint == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(position.getFile());
            throw new EvaluateException(JavaDebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{psiFile != null ? psiFile.getName() : "<No File>", position.getLine()}), null);
        }
    }

    @NotNull
    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl thread) {
        return new FreezeThreadCommand(thread);
    }

    @NotNull
    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContext, @NotNull ThreadReferenceProxyImpl thread) {
        if (thread == null) {
            DebugProcessImpl.$$$reportNull$$$0(77);
        }
        return new ResumeThreadCommand(suspendContext, thread);
    }

    @NotNull
    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl stackFrame) {
        return new PopFrameCommand(context, stackFrame);
    }

    @NotNull
    public DebuggerContextImpl getDebuggerContext() {
        DebuggerContextImpl debuggerContextImpl = this.mySession.getContextManager().getContext();
        if (debuggerContextImpl == null) {
            DebugProcessImpl.$$$reportNull$$$0(78);
        }
        return debuggerContextImpl;
    }

    public void setXDebugProcess(JavaDebugProcess XDebugProcess2) {
        this.myXDebugProcess = XDebugProcess2;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.myXDebugProcess;
    }

    public boolean areBreakpointsMuted() {
        XDebugSession session = this.mySession.getXDebugSession();
        return session != null && session.areBreakpointsMuted();
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    static boolean isResumeOnlyCurrentThread() {
        return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
    }

    public boolean isEvaluationPossible() {
        return this.getSuspendManager().getPausedContext() != null || DebuggerImplicitEvaluationContextUtil.getImplicitEvaluationThread(this) != null;
    }

    public static boolean isInSuspendCommand(SuspendContextImpl suspendContext) {
        SuspendContextCommandImpl suspendContextCommand;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerCommandImpl command2 = DebuggerManagerThreadImpl.getCurrentCommand();
        return command2 instanceof SuspendContextCommandImpl && (suspendContextCommand = (SuspendContextCommandImpl)command2).getSuspendContext() == suspendContext;
    }

    public boolean isEvaluationPossible(SuspendContextImpl suspendContext) {
        return this.mySuspendManager.hasPausedContext(suspendContext);
    }

    public void startWatchingMethodReturn(ThreadReferenceProxyImpl thread) {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.enable(thread.getThreadReference());
        }
    }

    @ApiStatus.Internal
    public void setIsUnderBreakpointCheckFn(@NotNull Method isUnderBreakpointCheckFn) {
        if (isUnderBreakpointCheckFn == null) {
            DebugProcessImpl.$$$reportNull$$$0(79);
        }
        this.myIsUnderBreakpointCheckFn = isUnderBreakpointCheckFn;
    }

    @ApiStatus.Internal
    public boolean isSteppingInProgress() {
        return this.mySteppingProgressTracker.isSteppingInProgress();
    }

    void stopWatchingMethodReturn() {
        if (this.myReturnValueWatcher != null) {
            this.myReturnValueWatcher.disable();
        }
    }

    protected void notifyStoppedOtherThreads() {
        ++this.myOtherThreadsReachBreakpointNumber;
        if (this.otherThreadsJob != null) {
            this.otherThreadsJob.cancel(null);
        }
        this.otherThreadsJob = EdtScheduler.getInstance().schedule(300, ModalityState.defaultModalityState(), () -> {
            this.showNotification(this.myOtherThreadsReachBreakpointNumber);
            this.myOtherThreadsReachBreakpointNumber = 0;
        });
    }

    private void showNotification(int number) {
        if (this.disposable.isDisposed()) {
            return;
        }
        String content = JavaDebuggerBundle.message((String)"message.other.threads.reached.breakpoints", (Object[])new Object[]{number});
        FrameNotificationUtils.showNotification((Project)this.getProject(), (XDebugSession)this.mySession.getXDebugSession(), (String)content);
    }

    String getStateForDiagnostics() {
        String safeInfo = "myState = " + String.valueOf(this.myState) + "\nmyStashedVirtualMachines = " + String.valueOf(this.myStashedVirtualMachines) + "\nmyExecutionResult = " + String.valueOf(this.myExecutionResult) + "\n";
        if (DebuggerDiagnosticsUtil.needAnonymizedReports()) {
            return safeInfo;
        }
        return "myProject = " + String.valueOf(this.project) + "\n" + safeInfo + "myConnection = " + String.valueOf(this.myConnection) + "\nmyArguments = " + String.valueOf(this.myArguments) + "\n";
    }

    public void logError(@NotNull String message, @NotNull Attachment attachment) {
        if (message == null) {
            DebugProcessImpl.$$$reportNull$$$0(80);
        }
        if (attachment == null) {
            DebugProcessImpl.$$$reportNull$$$0(81);
        }
        LOG.error(message, DebuggerDiagnosticsUtil.getAttachments(this, attachment));
    }

    public void logError(@NotNull String message) {
        if (message == null) {
            DebugProcessImpl.$$$reportNull$$$0(82);
        }
        LOG.error(message, DebuggerDiagnosticsUtil.getAttachments(this));
    }

    public void logError(@NotNull String message, @NotNull Throwable e) {
        if (message == null) {
            DebugProcessImpl.$$$reportNull$$$0(83);
        }
        if (e == null) {
            DebugProcessImpl.$$$reportNull$$$0(84);
        }
        LOG.error(message, e, DebuggerDiagnosticsUtil.getAttachments(this));
    }

    @ApiStatus.Internal
    @TestOnly
    public int getMethodInvocationsCount() {
        return this.myMethodInvocations.get();
    }

    static {
        String traceStr = System.getProperty("idea.debugger.trace");
        int mask = 0;
        if (!StringUtil.isEmpty((String)traceStr)) {
            StringTokenizer tokenizer = new StringTokenizer(traceStr);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(token) == 0) {
                    mask |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(token) == 0) {
                    mask |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(token) == 0) {
                    mask |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(token) == 0) {
                    mask |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(token) != 0) continue;
                mask |= 0xFFFFFF;
            }
        }
        ourTraceMask = mask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 11, 13, 14, 15, 17, 20, 21, 22, 23, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 74, 76, 77, 79, 80, 81, 82, 83, 84 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestManager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 23: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmProxy";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendAllContext";
                break;
            }
            case 31: 
            case 35: 
            case 39: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 32: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 46: 
            case 50: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 34: 
            case 38: 
            case 42: 
            case 47: 
            case 51: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 45: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromLoader";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isUnderBreakpointCheckFn";
                break;
            }
            case 80: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableRenderers";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoRendererAsync";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "commitVM";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findConnector";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachineProxy";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "processIOException";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagerThread";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationThread";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "findLoadedClasses";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendManager";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionManager";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createResumeCommand";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOverCommand";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepOutCommand";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepIntoCommand";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunToCursorCommand";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRendererById";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doStep";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteStepRequests";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFrameCount";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "versionMatch";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setSteppingBreakpoint";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndSetSteppingBreakpoint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processIOException";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentVirtualMachine";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resumeThreadsUnderEvaluationAndExplicitlyResumedAfterPause";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "invokeInstanceMethod";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "clearCashes";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleFromClassLoader";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "attachVirtualMachine";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createRunToCursorCommand";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkRunToCursorIsOk";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createResumeThreadCommand";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setIsUnderBreakpointCheckFn";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 11, 13, 14, 15, 17, 20, 21, 22, 23, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 74, 76, 77, 79, 80, 81, 82, 83, 84 -> new IllegalArgumentException(string);
        };
    }

    protected static enum State {
        INITIAL,
        ATTACHED,
        DETACHING,
        DETACHED;

    }

    private record VirtualMachineData(VirtualMachineProxyImpl vm, RemoteConnection connection, DebuggerManagerThreadImpl debuggerManagerThread) {
    }

    private abstract class InvokeCommand<E extends Value> {
        private final Method myMethod;
        private final List<Value> myArgs;
        @NotNull
        protected final EvaluationContextImpl myEvaluationContext;

        protected InvokeCommand(@NotNull Method method, @NotNull List<? extends Value> args, EvaluationContextImpl evaluationContext) {
            if (method == null) {
                InvokeCommand.$$$reportNull$$$0(0);
            }
            if (args == null) {
                InvokeCommand.$$$reportNull$$$0(1);
            }
            if (evaluationContext == null) {
                InvokeCommand.$$$reportNull$$$0(2);
            }
            this.myMethod = method;
            this.myArgs = new ArrayList<Value>(args);
            this.myEvaluationContext = evaluationContext;
        }

        public String toString() {
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(ThreadReference var1, int var2, Method var3, List<? extends Value> var4) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(boolean internalEvaluate) throws EvaluateException {
            ReferenceType lastLoadedClass = null;
            ThreadReferenceProxyImpl lastUsedThread = null;
            while (true) {
                try {
                    ThreadReferenceProxyImpl invokeThread = (ThreadReferenceProxyImpl)DebugProcessImpl.getEvaluationThread(this.myEvaluationContext);
                    if (invokeThread == lastUsedThread) {
                        throw new IllegalStateException("Endless loop while trying to identify thread to successful evaluation: " + String.valueOf(invokeThread));
                    }
                    lastUsedThread = invokeThread;
                    return this.startInternal(internalEvaluate, invokeThread);
                }
                catch (RetryEvaluationException e) {
                    LOG.warn((Throwable)((Object)e));
                    continue;
                }
                catch (ClassNotLoadedException e) {
                    ReferenceType loadedClass = null;
                    try {
                        if (this.myEvaluationContext.isAutoLoadClasses()) {
                            loadedClass = DebugProcessImpl.this.loadClass(this.myEvaluationContext, e, this.myEvaluationContext.getClassLoader());
                        }
                    }
                    catch (Exception ignored) {
                        loadedClass = null;
                    }
                    if (loadedClass == null) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                    }
                    if (loadedClass.equals(lastLoadedClass)) {
                        throw EvaluateExceptionUtil.createEvaluateException((String)("Loading class " + e.className() + " in the wrong classloader " + String.valueOf(this.myEvaluationContext.getClassLoader())));
                    }
                    lastLoadedClass = loadedClass;
                    lastUsedThread = null;
                    continue;
                }
                break;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        E startInternal(boolean internalEvaluate, @NotNull ThreadReferenceProxyImpl invokeThread) throws EvaluateException, ClassNotLoadedException {
            Iterator<SuspendContextImpl> iterator;
            if (invokeThread == null) {
                InvokeCommand.$$$reportNull$$$0(3);
            }
            DebuggerManagerThreadImpl.assertIsManagerThread();
            SuspendContextImpl suspendContext = this.myEvaluationContext.getSuspendContext();
            if (!suspendContext.myInProgress) {
                DebugProcessImpl.this.logError("You can invoke methods only inside commands invoked for SuspendContext. myEvaluationContext = " + String.valueOf((Object)this.myEvaluationContext) + ", invokeThread = " + String.valueOf(invokeThread));
            }
            if (suspendContext.getSuspendPolicy() == 1 && suspendContext.getEventThread() != invokeThread) {
                DebugProcessImpl.this.logError("Event thread context is used to evaluate on another thread, context = " + String.valueOf((Object)suspendContext) + ", invokeThread = " + String.valueOf(invokeThread));
            }
            if (invokeThread.isEvaluating()) {
                throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
            }
            if (!suspendContext.suspends(invokeThread)) {
                throw EvaluateExceptionUtil.THREAD_WAS_RESUMED;
            }
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), invokeThread);
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(suspendContext);
            DebugProcessImpl.this.beforeMethodInvocation(suspendContext, this.myMethod, internalEvaluate);
            Object resumeData = null;
            try {
                for (Object suspendingContext : suspendingContexts) {
                    if (suspendingContext == suspendContext) continue;
                    if (suspendingContext.getSuspendPolicy() == 1) {
                        DebugProcessImpl.this.logError("Evaluating on " + String.valueOf((Object)suspendContext) + ", but found existed event thread context " + String.valueOf(suspendingContext));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resuming " + String.valueOf(invokeThread) + " that is paused by " + String.valueOf(suspendingContext));
                    }
                    DebugProcessImpl.this.getSuspendManager().resumeThread((SuspendContextImpl)((Object)suspendingContext), invokeThread);
                }
                if (!DebuggerUtils.isNewThreadSuspendStateTracking()) {
                    resumeData = SuspendManagerUtil.prepareForResume(suspendContext);
                }
                this.myEvaluationContext.setThreadForEvaluation(invokeThread);
                invokeThread.getVirtualMachineProxy().clearCaches();
                iterator = this.invokeMethodAndFork(suspendContext, invokeThread);
            }
            catch (IncompatibleThreadStateException e) {
                try {
                    if (invokeThread == suspendContext.getEventThread()) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                    }
                    suspendContext.myNotExecutableThreads.add(invokeThread);
                    String m = "Evaluation failed on non-primary thread '%s'. Will be a retry on primary suspended thread '%s'".formatted(invokeThread, suspendContext.getEventThread());
                    throw new RetryEvaluationException(m, e);
                    catch (InternalException | InvalidTypeException | InvocationException | ObjectCollectedException | UnsupportedOperationException e2) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evaluation finished in " + String.valueOf((Object)suspendContext));
                    }
                    this.myEvaluationContext.setThreadForEvaluation(null);
                    if (DebuggerUtils.isNewThreadSuspendStateTracking()) {
                        for (SuspendContextImpl anotherContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                            if (anotherContext == suspendContext || anotherContext.suspends(invokeThread)) continue;
                            boolean shouldSuspendThread = false;
                            if (anotherContext.getSuspendPolicy() == 1 && anotherContext.getEventThread() == invokeThread) {
                                DebugProcessImpl.this.logError("Another event thread context after evaluation on " + String.valueOf(invokeThread) + " (" + String.valueOf((Object)suspendContext) + ") : " + String.valueOf((Object)anotherContext));
                                shouldSuspendThread = true;
                            }
                            if (anotherContext.getSuspendPolicy() == 2) {
                                if (anotherContext.myResumedThreads == null || !anotherContext.myResumedThreads.contains(invokeThread)) {
                                    DebugProcessImpl.this.logError("Suspend all context claims not suspending " + String.valueOf(invokeThread) + " but its resumed threads have no it: " + String.valueOf(anotherContext.myResumedThreads));
                                }
                                if (!DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.contains(invokeThread)) {
                                    shouldSuspendThread = true;
                                }
                            }
                            if (!shouldSuspendThread) continue;
                            DebugProcessImpl.this.mySuspendManager.suspendThread(anotherContext, invokeThread);
                        }
                    } else {
                        if (resumeData != null) {
                            SuspendManagerUtil.restoreAfterResume(suspendContext, resumeData);
                        }
                        for (SuspendContextImpl suspendingContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                            if (!suspendingContexts.contains((Object)suspendingContext) || suspendingContext == suspendContext || suspendingContext.isEvaluating() || suspendingContext.suspends(invokeThread)) continue;
                            DebugProcessImpl.this.mySuspendManager.suspendThread(suspendingContext, invokeThread);
                        }
                    }
                    LOG.debug("getVirtualMachine().clearCaches()");
                    invokeThread.getVirtualMachineProxy().clearCaches();
                    DebugProcessImpl.this.afterMethodInvocation(suspendContext, internalEvaluate);
                    ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContext);
                    throw throwable;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluation finished in " + String.valueOf((Object)suspendContext));
            }
            this.myEvaluationContext.setThreadForEvaluation(null);
            if (DebuggerUtils.isNewThreadSuspendStateTracking()) {
                for (SuspendContextImpl anotherContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                    if (anotherContext == suspendContext || anotherContext.suspends(invokeThread)) continue;
                    boolean shouldSuspendThread = false;
                    if (anotherContext.getSuspendPolicy() == 1 && anotherContext.getEventThread() == invokeThread) {
                        DebugProcessImpl.this.logError("Another event thread context after evaluation on " + String.valueOf(invokeThread) + " (" + String.valueOf((Object)suspendContext) + ") : " + String.valueOf((Object)anotherContext));
                        shouldSuspendThread = true;
                    }
                    if (anotherContext.getSuspendPolicy() == 2) {
                        if (anotherContext.myResumedThreads == null || !anotherContext.myResumedThreads.contains(invokeThread)) {
                            DebugProcessImpl.this.logError("Suspend all context claims not suspending " + String.valueOf(invokeThread) + " but its resumed threads have no it: " + String.valueOf(anotherContext.myResumedThreads));
                        }
                        if (!DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.contains(invokeThread)) {
                            shouldSuspendThread = true;
                        }
                    }
                    if (!shouldSuspendThread) continue;
                    DebugProcessImpl.this.mySuspendManager.suspendThread(anotherContext, invokeThread);
                }
            } else {
                if (resumeData != null) {
                    SuspendManagerUtil.restoreAfterResume(suspendContext, resumeData);
                }
                for (SuspendContextImpl suspendingContext : DebugProcessImpl.this.mySuspendManager.getEventContexts()) {
                    if (!suspendingContexts.contains((Object)suspendingContext) || suspendingContext == suspendContext || suspendingContext.isEvaluating() || suspendingContext.suspends(invokeThread)) continue;
                    DebugProcessImpl.this.mySuspendManager.suspendThread(suspendingContext, invokeThread);
                }
            }
            LOG.debug("getVirtualMachine().clearCaches()");
            invokeThread.getVirtualMachineProxy().clearCaches();
            DebugProcessImpl.this.afterMethodInvocation(suspendContext, internalEvaluate);
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(suspendContext);
            return (E)iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private E invokeMethodAndFork(SuspendContextImpl context, ThreadReferenceProxyImpl thread) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            Ref exception = Ref.create();
            Ref result = Ref.create();
            Ref invocationWatcherRef = Ref.create();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoke in " + String.valueOf((Object)context));
                InvokeCommand.assertThreadSuspended(thread, context);
            }
            ThreadReference threadReference = thread.getThreadReference();
            context.getManagerThread().startLongProcessAndFork(() -> {
                try {
                    try {
                        if ((ourTraceMask & 1) != 0) {
                            StreamEx.of(this.myArgs).nonNull().forEach(Object::toString);
                        }
                        if ((DebugProcessImpl.this.getTraceMask() & 1) != 0) {
                            StreamEx.of(this.myArgs).findAny(ThreadReference.class::isInstance).ifPresent(t -> {
                                System.err.println("[JDI: workaround for invocation of " + String.valueOf(this.myMethod) + "]");
                                this.myMethod.virtualMachine().setDebugTraceMode(DebugProcessImpl.this.getTraceMask() & 0xFFFFFFFE);
                            });
                        }
                        int invokePolicy = DebugProcessImpl.getInvokePolicy(context);
                        invocationWatcherRef.set((Object)DebugProcessImpl.this.myThreadBlockedMonitor.startInvokeWatching(invokePolicy, thread, context));
                        DebugProcessImpl.this.myMethodInvocations.incrementAndGet();
                        result.set(this.invokeMethod(threadReference, invokePolicy, this.myMethod, this.myArgs));
                    }
                    finally {
                        if ((DebugProcessImpl.this.getTraceMask() & 1) != 0) {
                            this.myMethod.virtualMachine().setDebugTraceMode(DebugProcessImpl.this.getTraceMask());
                        }
                    }
                }
                catch (Exception e) {
                    exception.set((Object)e);
                }
            });
            try {
                Exception ex = (Exception)exception.get();
                if (ex != null) {
                    if (ex instanceof InvocationException) {
                        throw (InvocationException)ex;
                    }
                    if (ex instanceof ClassNotLoadedException) {
                        throw (ClassNotLoadedException)ex;
                    }
                    if (ex instanceof IncompatibleThreadStateException) {
                        throw (IncompatibleThreadStateException)ex;
                    }
                    if (ex instanceof InvalidTypeException) {
                        throw (InvalidTypeException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    DebugProcessImpl.this.logError("Unexpected exception", new Throwable(ex));
                }
                Value value = (Value)result.get();
                return (E)value;
            }
            finally {
                ThreadBlockedMonitor.InvocationWatcher invocationWatcher = (ThreadBlockedMonitor.InvocationWatcher)invocationWatcherRef.get();
                if (invocationWatcher != null) {
                    invocationWatcher.invocationFinished();
                }
            }
        }

        private static void assertThreadSuspended(ThreadReferenceProxyImpl thread, SuspendContextImpl context) {
            LOG.assertTrue(context.isEvaluating());
            try {
                boolean isSuspended = thread.isSuspended();
                LOG.assertTrue(isSuspended, (Object)thread);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invokeThread";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$InvokeCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startInternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean myIsTerminateTargetVM;

        public StopCommand(boolean isTerminateTargetVM) {
            this.myIsTerminateTargetVM = isTerminateTargetVM;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void action() {
            if (DebugProcessImpl.this.isAttached()) {
                VirtualMachineProxyImpl virtualMachineProxy = VirtualMachineProxyImpl.getCurrent();
                if (!virtualMachineProxy.canBeModified()) {
                    DebugProcessImpl.this.closeCurrentProcess(false);
                    return;
                }
                if (this.myIsTerminateTargetVM) {
                    virtualMachineProxy.exit(-1);
                    return;
                }
                try {
                    try {
                        virtualMachineProxy.addedSuspendAllContext();
                        virtualMachineProxy.resume();
                        return;
                    }
                    finally {
                        virtualMachineProxy.dispose();
                    }
                }
                catch (VMDisconnectedException e) {
                    DebugProcessImpl.this.closeCurrentProcess(false);
                    throw e;
                }
            }
            try {
                DebugProcessImpl.this.stopConnecting();
                return;
            }
            finally {
                DebugProcessImpl.this.closeCurrentProcess(true);
            }
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        @Nullable
        private final ThreadReferenceProxyImpl myPredefinedThread;

        PauseCommand(ThreadReferenceProxyImpl thread) {
            this.myPredefinedThread = thread;
        }

        private boolean isDebuggerAgentAvailable() {
            return !VirtualMachineProxy.getCurrent().classesByName("com.intellij.rt.debugger.agent.DebuggerAgent").isEmpty();
        }

        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            if (Registry.is((String)"debugger.evaluate.on.pause")) {
                this.stopOnAnyMethodEntryAndGetSuspendContext();
            } else {
                this.fallbackPauseWithNonEvaluatableContext();
                DebuggerStatistics.logEvaluatablePauseDisabled(DebugProcessImpl.this.project);
            }
        }

        private void stopOnAnyMethodEntryAndGetSuspendContext() {
            final DebuggerCompletableFuture evaluatableContextObtained = new DebuggerCompletableFuture();
            final DebuggerCompletableFuture evaluatableContextFuture = new DebuggerCompletableFuture();
            FilteredRequestorImpl requestor2 = new FilteredRequestorImpl(DebugProcessImpl.this.project){

                @Override
                public boolean shouldIgnoreThreadFiltering() {
                    return true;
                }

                @Override
                public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) {
                    if (action == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DebugProcessImpl.this.getRequestsManager().deleteRequest(this);
                    SuspendContextImpl evaluatableContext = action.getSuspendContext();
                    evaluatableContextFuture.complete(evaluatableContext);
                    evaluatableContextObtained.complete(null);
                    DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.clear();
                    return true;
                }

                @Override
                public String getSuspendPolicy() {
                    return "SuspendAll";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/debugger/engine/DebugProcessImpl$PauseCommand$1", "processLocatableEvent"));
                }
            };
            MethodEntryRequest request = DebugProcessImpl.this.getRequestsManager().createMethodEntryRequest(requestor2);
            request.setSuspendPolicy(2);
            DebuggerUtilsAsync.setEnabled(request, true);
            long timeout = Registry.intValue((String)"debugger.evaluate.on.pause.timeout.ms", (int)500);
            evaluatableContextObtained.orTimeout(timeout, TimeUnit.MILLISECONDS).whenComplete((arg_0, arg_1) -> this.lambda$stopOnAnyMethodEntryAndGetSuspendContext$0(requestor2, evaluatableContextFuture, arg_0, arg_1));
        }

        private void setSuspendContextAndCheckConsistency(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                PauseCommand.$$$reportNull$$$0(0);
            }
            DebugProcessImpl.this.logThreads();
            if (this.myPredefinedThread != null && !this.myPredefinedThread.isCollected()) {
                if (suspendContext.getThread() == null) {
                    suspendContext.setThread(this.myPredefinedThread.getThreadReference());
                } else {
                    SuspendManagerUtil.switchToThreadInSuspendAllContext(suspendContext, this.myPredefinedThread);
                }
            }
            DebugProcessImpl.this.myDebuggerManagerThread.schedule(new SuspendContextCommandImpl(suspendContext){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    DebuggerDiagnosticsUtil.checkThreadsConsistency(DebugProcessImpl.this, true);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.LOWEST;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PauseCommand$3", "contextAction"));
                }
            });
        }

        private void fallbackPauseWithNonEvaluatableContext() {
            VirtualMachineProxyImpl vmProxy = VirtualMachineProxyImpl.getCurrent();
            vmProxy.suspend();
            DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.clear();
            DebugProcessImpl.this.mySuspendManager.resumeAllSuspendAllContexts(null);
            SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(2, 0);
            this.setSuspendContextAndCheckConsistency(suspendContext);
            DebuggerUtils.forEachSafe(DebugProcessImpl.this.myDebugProcessListeners, it -> it.paused((SuspendContext)suspendContext));
            XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"evaluation.warning.cannot.evaluate.on.pause", (Object[])new Object[0]), MessageType.WARNING).notify(DebugProcessImpl.this.getProject());
        }

        private /* synthetic */ void lambda$stopOnAnyMethodEntryAndGetSuspendContext$0(final 1 requestor2, final DebuggerCompletableFuture evaluatableContextFuture, Void evaluatableContext, final Throwable error) {
            DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    if (error != null) {
                        DebugProcessImpl.this.getRequestsManager().deleteRequest(requestor2);
                        if (evaluatableContextFuture.isDone()) {
                            SuspendContextImpl evaluatableContext = (SuspendContextImpl)((Object)evaluatableContextFuture.get());
                            assert (evaluatableContext != null);
                            PauseCommand.this.setSuspendContextAndCheckConsistency(evaluatableContext);
                            DebuggerStatistics.logEvaluatablePauseSuccess(DebugProcessImpl.this.project, PauseCommand.this.isDebuggerAgentAvailable());
                        } else {
                            PauseCommand.this.fallbackPauseWithNonEvaluatableContext();
                            DebuggerStatistics.logEvaluatablePauseFailure(DebugProcessImpl.this.project, PauseCommand.this.isDebuggerAgentAvailable());
                        }
                    } else {
                        SuspendContextImpl evaluatableContext = (SuspendContextImpl)((Object)evaluatableContextFuture.get());
                        assert (evaluatableContext != null);
                        PauseCommand.this.setSuspendContextAndCheckConsistency(evaluatableContext);
                        DebuggerStatistics.logEvaluatablePauseSuccess(DebugProcessImpl.this.project, PauseCommand.this.isDebuggerAgentAvailable());
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PauseCommand", "setSuspendContextAndCheckConsistency"));
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        @Nullable
        protected final ThreadReferenceProxyImpl myContextThread;

        public ResumeCommand(SuspendContextImpl suspendContext) {
            JavaExecutionStack activeExecutionStack;
            super(suspendContext);
            ThreadReferenceProxyImpl thread = suspendContext != null ? ((activeExecutionStack = suspendContext.getActiveExecutionStack()) != null ? activeExecutionStack.getThreadProxy() : suspendContext.getThread()) : null;
            this.myContextThread = thread != null ? thread : DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                ResumeCommand.$$$reportNull$$$0(0);
            }
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            if (!(this instanceof StepCommand)) {
                DebuggerUtils.forEachSafe(SteppingListener.getExtensions(), listener2 -> listener2.beforeResume(suspendContext));
            }
            this.resumeAction();
            DebuggerUtils.forEachSafe(DebugProcessImpl.this.myDebugProcessListeners, it -> it.resumed((SuspendContext)suspendContext));
        }

        protected void resumeAction() {
            LOG.debug("Resuming for command " + String.valueOf(this));
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        @Nullable
        public LightOrRealThreadInfo getThreadFilterFromContext(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                ResumeCommand.$$$reportNull$$$0(1);
            }
            return this.myContextThread != null ? new RealThreadInfo(this.myContextThread.getThreadReference()) : null;
        }

        protected void applyThreadFilter(@Nullable LightOrRealThreadInfo threadInfo) {
            boolean isLightThread;
            boolean bl = isLightThread = threadInfo != null && threadInfo.getRealThread() == null;
            if (isLightThread || this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, threadInfo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "suspendContext";
            objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$ResumeCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getThreadFilterFromContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class StepOverCommand
    extends StepCommand {
        private final boolean myIsIgnoreBreakpoints;
        private final int myStepSize;

        public StepOverCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreBreakpoints, MethodFilter methodFilter, int stepSize) {
            super(suspendContext, methodFilter);
            this.myIsIgnoreBreakpoints = ignoreBreakpoints;
            this.myStepSize = stepSize;
        }

        public StepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
            this(suspendContext, ignoreBreakpoints, null, stepSize);
        }

        protected int getStepDepth() {
            return 2;
        }

        @NotNull
        @Nls
        protected String getStatusText() {
            String string = JavaDebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]);
            if (string == null) {
                StepOverCommand.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
            RequestHint hint = new RequestHint(stepThread, suspendContext, -2, 2, this.myMethodFilter, parentHint);
            hint.setRestoreBreakpoints(this.myIsIgnoreBreakpoints);
            hint.setIgnoreFilters(this.myIsIgnoreBreakpoints || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            return hint;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                StepOverCommand.$$$reportNull$$$0(1);
            }
            DebugProcessImpl.this.showStatusText(this.getStatusText());
            this.prepareSteppingRequestsAndHints(suspendContext);
            if (this.myIsIgnoreBreakpoints) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.project).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            super.contextAction(suspendContext);
        }

        public final void prepareSteppingRequestsAndHints(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                StepOverCommand.$$$reportNull$$$0(2);
            }
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = this.getHint(suspendContext, stepThread, null);
            this.applyThreadFilter(this.getThreadFilterFromContext(suspendContext));
            DebugProcessImpl.this.startWatchingMethodReturn(stepThread);
            this.step(suspendContext, stepThread, hint, this.createCommandToken());
        }

        @Override
        public void step(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint hint, Object commandToken) {
            super.step(suspendContext, stepThread, hint, commandToken);
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, this.getStepDepth(), hint, commandToken);
        }

        @Override
        @NotNull
        protected SteppingAction getSteppingAction() {
            SteppingAction steppingAction = SteppingAction.STEP_OVER;
            if (steppingAction == null) {
                StepOverCommand.$$$reportNull$$$0(3);
            }
            return steppingAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepOverCommand";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatusText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$StepOverCommand";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSteppingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contextAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareSteppingRequestsAndHints";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public class StepOutCommand
    extends StepCommand {
        private final int myStepSize;

        public StepOutCommand(SuspendContextImpl suspendContext, int stepSize) {
            this(suspendContext, stepSize, null);
        }

        public StepOutCommand(SuspendContextImpl suspendContext, @Nullable int stepSize, MethodFilter filter) {
            super(suspendContext, filter);
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                StepOutCommand.$$$reportNull$$$0(0);
            }
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            ThreadReferenceProxyImpl thread = this.getContextThread();
            RequestHint hint = this.getHint(suspendContext, thread, null);
            this.applyThreadFilter(this.getThreadFilterFromContext(suspendContext));
            DebugProcessImpl.this.startWatchingMethodReturn(thread);
            this.step(suspendContext, thread, hint, this.createCommandToken());
            super.contextAction(suspendContext);
        }

        @Override
        @NotNull
        public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread, @Nullable RequestHint parentHint) {
            RequestHint hint = new RequestHint(thread, suspendContext, -2, 3, null, parentHint);
            hint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            RequestHint requestHint = hint;
            if (requestHint == null) {
                StepOutCommand.$$$reportNull$$$0(1);
            }
            return requestHint;
        }

        @Override
        public void step(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint hint, Object commandToken) {
            super.step(suspendContext, stepThread, hint, commandToken);
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, 3, hint, commandToken);
        }

        @Override
        @NotNull
        protected SteppingAction getSteppingAction() {
            SteppingAction steppingAction = SteppingAction.STEP_OUT;
            if (steppingAction == null) {
                StepOutCommand.$$$reportNull$$$0(2);
            }
            return steppingAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepOutCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$StepOutCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSteppingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public class StepIntoCommand
    extends StepCommand {
        private final boolean myForcedIgnoreFilters;
        @Nullable
        private final StepIntoBreakpoint myBreakpoint;
        private final int myStepSize;

        public StepIntoCommand(SuspendContextImpl suspendContext, @Nullable boolean ignoreFilters, MethodFilter methodFilter, int stepSize) {
            super(suspendContext, methodFilter);
            this.myForcedIgnoreFilters = ignoreFilters || methodFilter != null;
            this.myBreakpoint = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.project).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.myStepSize = stepSize;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                StepIntoCommand.$$$reportNull$$$0(0);
            }
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
            ThreadReferenceProxyImpl stepThread = this.getContextThread();
            RequestHint hint = this.getHint(suspendContext, stepThread, null);
            if (this.myForcedIgnoreFilters) {
                DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(DebugProcessImpl.getFrameCount(stepThread, suspendContext));
            }
            hint.setIgnoreFilters(this.myForcedIgnoreFilters || DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(this.getThreadFilterFromContext(suspendContext));
            if (this.myBreakpoint != null) {
                DebugProcessImpl.prepareAndSetSteppingBreakpoint(suspendContext, this.myBreakpoint, hint, false);
            }
            this.step(suspendContext, stepThread, hint, this.createCommandToken());
            super.contextAction(suspendContext);
        }

        @Override
        @NotNull
        public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
            RequestHint hint = new RequestHint(stepThread, suspendContext, -2, 1, this.myMethodFilter, parentHint);
            hint.setResetIgnoreFilters(this.myMethodFilter != null && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            RequestHint requestHint = hint;
            if (requestHint == null) {
                StepIntoCommand.$$$reportNull$$$0(1);
            }
            return requestHint;
        }

        @Override
        public void step(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint hint, Object commandToken) {
            super.step(suspendContext, stepThread, hint, this.createCommandToken());
            DebugProcessImpl.this.doStep(suspendContext, stepThread, this.myStepSize, 1, hint, commandToken);
        }

        @Override
        @NotNull
        protected SteppingAction getSteppingAction() {
            SteppingAction steppingAction = SteppingAction.STEP_INTO;
            if (steppingAction == null) {
                StepIntoCommand.$$$reportNull$$$0(2);
            }
            return steppingAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepIntoCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$StepIntoCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSteppingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint myRunToCursorBreakpoint;
        private final boolean myIgnoreBreakpoints;

        public RunToCursorCommand(@NotNull SuspendContextImpl suspendContext, XSourcePosition position, boolean ignoreBreakpoints) {
            if (position == null) {
                RunToCursorCommand.$$$reportNull$$$0(0);
            }
            super(suspendContext, null);
            this.myIgnoreBreakpoints = ignoreBreakpoints;
            this.myRunToCursorBreakpoint = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.project).getBreakpointManager().addRunToCursorBreakpoint(position, ignoreBreakpoints);
        }

        protected boolean shouldExecuteRegardlessOfRequestWarnings() {
            return false;
        }

        @Override
        protected void resumeAction() {
            ((DebuggerActionListener)DebugProcessImpl.this.project.getMessageBus().syncPublisher(DebuggerActionListener.TOPIC)).onRunToCursor(this.getSuspendContext());
            super.resumeAction();
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl context) {
            if (context == null) {
                RunToCursorCommand.$$$reportNull$$$0(1);
            }
            DebugProcessImpl.this.showStatusText(JavaDebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
            DebugProcessImpl.this.cancelSteppingBreakpoints();
            if (this.myRunToCursorBreakpoint == null) {
                return;
            }
            if (this.myIgnoreBreakpoints) {
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.project).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
            }
            LightOrRealThreadInfo threadFilterFromContext = this.getThreadFilterFromContext(context);
            this.applyThreadFilter(threadFilterFromContext);
            this.beforeSteppingAction(context);
            int breakpointSuspendPolicy = context.getSuspendPolicy();
            if (!DebuggerUtils.isAlwaysSuspendThreadBeforeSwitch() && threadFilterFromContext != null && threadFilterFromContext.getRealThread() == null) {
                breakpointSuspendPolicy = 1;
            }
            DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, this.myRunToCursorBreakpoint, null, false, breakpointSuspendPolicy);
            DebugProcessImpl debugProcess = context.getDebugProcess();
            if (this.shouldExecuteRegardlessOfRequestWarnings() || debugProcess.getRequestsManager().getWarning(this.myRunToCursorBreakpoint) == null) {
                DebugProcessImpl.this.myRunToCursorManager.onRunToCursorCommandStarted();
                super.contextAction(context);
            } else {
                DebuggerInvocationUtil.invokeLaterAnyModality(DebugProcessImpl.this.project, () -> {
                    Messages.showErrorDialog((String)JavaDebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{this.myRunToCursorBreakpoint.getFileName(), this.myRunToCursorBreakpoint.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                    DebuggerSession session = debugProcess.getSession();
                    session.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, context), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                });
            }
        }

        @Override
        @NotNull
        protected SteppingAction getSteppingAction() {
            SteppingAction steppingAction = SteppingAction.RUN_TO_CURSOR;
            if (steppingAction == null) {
                RunToCursorCommand.$$$reportNull$$$0(2);
            }
            return steppingAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSteppingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contextAction";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        FreezeThreadCommand(ThreadReferenceProxyImpl thread) {
            this.myThread = thread;
        }

        @Override
        protected void action() {
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.mySuspendManager, this.myThread);
            if (!suspendingContexts.isEmpty()) {
                DebugProcessImpl.this.logError("Trying to freeze already suspended thread " + String.valueOf(this.myThread) + " : " + String.valueOf(suspendingContexts));
            }
            if (this.myThread.isEvaluating()) {
                throw new IllegalStateException("Trying to freeze evaluating thread " + String.valueOf(this.myThread));
            }
            List pausedSuspendAllContexts = ContainerUtil.filter(DebugProcessImpl.this.mySuspendManager.getPausedContexts(), c -> c.getSuspendPolicy() == 2);
            if (!pausedSuspendAllContexts.isEmpty()) {
                if (pausedSuspendAllContexts.size() > 1) {
                    DebugProcessImpl.this.logError("A lot of paused suspend-all contexts: " + String.valueOf(pausedSuspendAllContexts));
                }
                for (SuspendContextImpl suspendAllContext : pausedSuspendAllContexts) {
                    if (suspendAllContext.suspends(this.myThread)) continue;
                    DebugProcessImpl.this.mySuspendManager.suspendThread(suspendAllContext, this.myThread);
                }
                DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.remove(this.myThread);
                SuspendManagerUtil.switchToThreadInSuspendAllContext((SuspendContextImpl)((Object)pausedSuspendAllContexts.get(0)), this.myThread);
                return;
            }
            if (!DebugProcessImpl.this.mySuspendManager.isFrozen(this.myThread)) {
                DebugProcessImpl.this.mySuspendManager.freezeThread(this.myThread);
                SuspendContextImpl suspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(1, 0);
                suspendContext.setThread(this.myThread.getThreadReference());
                DebuggerUtils.forEachSafe(DebugProcessImpl.this.myDebugProcessListeners, it -> it.paused((SuspendContext)suspendContext));
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl myThread;

        ResumeThreadCommand(@NotNull SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            if (thread == null) {
                ResumeThreadCommand.$$$reportNull$$$0(0);
            }
            super(suspendContext);
            this.myThread = thread;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl context) {
            if (context == null) {
                ResumeThreadCommand.$$$reportNull$$$0(1);
            }
            Set<SuspendContextImpl> suspendingContexts = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.mySuspendManager, this.myThread);
            for (SuspendContextImpl suspendContext : suspendingContexts) {
                if (suspendContext.getSuspendPolicy() == 1 && suspendContext.getEventThread() == this.myThread) {
                    DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                    this.getCommandManagerThread().invokeNow(DebugProcessImpl.this.createResumeCommand(suspendContext));
                    continue;
                }
                DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.project).getBreakpointManager().removeThreadFilter(context.getDebugProcess());
                DebugProcessImpl.this.mySuspendManager.resumeThread(suspendContext, this.myThread);
                DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.add(this.myThread);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/DebugProcessImpl$ResumeThreadCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PopFrameCommand
    extends DebuggerContextCommandImpl {
        private final StackFrameProxyImpl myStackFrame;

        PopFrameCommand(DebuggerContextImpl context, StackFrameProxyImpl frameProxy) {
            super(context, frameProxy.threadProxy());
            this.myStackFrame = frameProxy;
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                PopFrameCommand.$$$reportNull$$$0(0);
            }
            ThreadReferenceProxyImpl thread = this.myStackFrame.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(thread)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (ObjectCollectedException ignored) {
                this.notifyCancelled();
                return;
            }
            if (!suspendContext.suspends(thread)) {
                suspendContext.postponeCommand(this);
                return;
            }
            if (this.myStackFrame.isBottom()) {
                DebuggerInvocationUtil.invokeLaterAnyModality(DebugProcessImpl.this.project, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.project, (String)JavaDebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)XDebuggerBundle.message((String)"xdebugger.reset.frame.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()));
                return;
            }
            try {
                thread.popFrames(this.myStackFrame);
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContext);
            }
            catch (NativeMethodException e) {
                this.showError(JavaDebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]));
                LOG.info((Throwable)e);
            }
            catch (EvaluateException e) {
                this.showError(JavaDebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{e.getLocalizedMessage()}));
                LOG.info((Throwable)e);
            }
        }

        private void showError(@NlsContexts.DialogMessage String message) {
            DebuggerInvocationUtil.invokeLaterAnyModality(DebugProcessImpl.this.project, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.project, (String)message, (String)XDebuggerBundle.message((String)"xdebugger.reset.frame.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PopFrameCommand", "threadAction"));
        }
    }

    public abstract class StepCommand
    extends ResumeCommand {
        @Nullable
        protected final MethodFilter myMethodFilter;

        StepCommand(@Nullable SuspendContextImpl suspendContext, MethodFilter filter) {
            super(suspendContext);
            this.myMethodFilter = filter;
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl context = this.getSuspendContext();
            if (context != null && context.getSuspendPolicy() == 1) {
                DebugProcessImpl.this.myThreadBlockedMonitor.startWatching(this.myContextThread);
            }
            if (context != null && DebugProcessImpl.isResumeOnlyCurrentThread() && context.getSuspendPolicy() == 2 && this.myContextThread != null) {
                VirtualMachineProxyImpl.getCurrent().suspend();
                DebugProcessImpl.this.getSuspendManager().resume(context);
                SuspendContextImpl placeholderSuspendContext = DebugProcessImpl.this.mySuspendManager.pushSuspendContext(2, 0);
                placeholderSuspendContext.setEventSet(context.getEventSet());
                if (context.myResumedThreads != null) {
                    for (ThreadReferenceProxyImpl threadReferenceProxy : context.myResumedThreads) {
                        DebugProcessImpl.this.getSuspendManager().resumeThread(placeholderSuspendContext, threadReferenceProxy);
                    }
                }
                ThreadSteppingMonitor.startTrackThreadStepping(this.myContextThread, placeholderSuspendContext);
                DebugProcessImpl.this.mySuspendManager.myExplicitlyResumedThreads.add(this.myContextThread);
                placeholderSuspendContext.mySteppingThreadForResumeOneSteppingCurrentMode = this.myContextThread;
                DebugProcessImpl.this.getSuspendManager().resumeThread(placeholderSuspendContext, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }

        public void step(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, RequestHint hint, Object commandToken) {
            this.beforeSteppingAction(suspendContext);
        }

        protected void beforeSteppingAction(SuspendContextImpl context) {
            if (context != null) {
                DebuggerUtils.forEachSafe(SteppingListener.getExtensions(), listener2 -> listener2.beforeSteppingStarted(context, this.getSteppingAction()));
            }
        }

        @NotNull
        protected Engine getEngine() {
            Engine engine = Engine.JAVA;
            if (engine == null) {
                StepCommand.$$$reportNull$$$0(0);
            }
            return engine;
        }

        @NotNull
        protected abstract SteppingAction getSteppingAction();

        @NotNull
        public final Object createCommandToken() {
            Object object = StatisticsStorage.createSteppingToken(this.getSteppingAction(), this.getEngine());
            if (object == null) {
                StepCommand.$$$reportNull$$$0(1);
            }
            return object;
        }

        @Nullable
        public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/engine/DebugProcessImpl$StepCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEngine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandToken";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

