/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JVMNameUtil {
    private static final Logger LOG = Logger.getInstance(JVMNameUtil.class);
    public static final String CONSTRUCTOR_NAME = "<init>";

    @Nullable
    public static String getPrimitiveSignature(String typeName) {
        if (PsiTypes.booleanType().getCanonicalText().equals(typeName)) {
            return "Z";
        }
        if (PsiTypes.byteType().getCanonicalText().equals(typeName)) {
            return "B";
        }
        if (PsiTypes.charType().getCanonicalText().equals(typeName)) {
            return "C";
        }
        if (PsiTypes.shortType().getCanonicalText().equals(typeName)) {
            return "S";
        }
        if (PsiTypes.intType().getCanonicalText().equals(typeName)) {
            return "I";
        }
        if (PsiTypes.longType().getCanonicalText().equals(typeName)) {
            return "J";
        }
        if (PsiTypes.floatType().getCanonicalText().equals(typeName)) {
            return "F";
        }
        if (PsiTypes.doubleType().getCanonicalText().equals(typeName)) {
            return "D";
        }
        if (PsiTypes.voidType().getCanonicalText().equals(typeName)) {
            return "V";
        }
        return null;
    }

    private static void appendJVMSignature(JVMNameBuffer buffer, PsiType type) {
        if (type == null) {
            return;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append(new JVMRawText("["));
            JVMNameUtil.appendJVMSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(psiType);
            JVMNameUtil.appendJvmClassQualifiedName(buffer, jvmName);
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            LOG.error("unknown type " + type.getCanonicalText());
        }
    }

    private static void appendJvmClassQualifiedName(JVMNameBuffer buffer, final JVMName jvmName) {
        buffer.append("L");
        if (jvmName instanceof JVMRawText) {
            buffer.append(((JVMRawText)jvmName).getName().replace('.', '/'));
        } else {
            buffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl process) throws EvaluateException {
                    return jvmName.getName(process).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    return jvmName.getDisplayName(debugProcess);
                }
            });
        }
        buffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String qualifiedName) {
        return new JVMRawText(qualifiedName);
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(arrayType.getComponentType());
            JVMNameBuffer buffer = new JVMNameBuffer();
            buffer.append(jvmName);
            buffer.append("[]");
            return buffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass == null) {
            return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        String name;
        if (psiClass == null) {
            JVMNameUtil.$$$reportNull$$$0(0);
        }
        if ((name = JVMNameUtil.getClassVMName(psiClass)) != null) {
            return JVMNameUtil.getJVMRawText(name);
        }
        return new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition pos) {
        PsiClass psiClass = JVMNameUtil.getClassAt(pos);
        if (psiClass == null) {
            return null;
        }
        String name = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (name != null) {
            return JVMNameUtil.getJVMRawText(name);
        }
        return new JVMClassAt(pos);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JVMNameUtil.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            return null;
        }
        if (aClass instanceof PsiImplicitClass) {
            PsiImplicitClass a = (PsiImplicitClass)aClass;
            return ClassUtil.getJVMClassName((PsiClass)a);
        }
        String name = aClass.getName();
        if (name == null) {
            return null;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            String parentName = JVMNameUtil.getNonAnonymousClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + name;
        }
        return DebuggerManager.getInstance((Project)aClass.getProject()).getVMClassQualifiedName(aClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod method, @Nullable PsiClass declaringClass) {
        return JVMNameUtil.getJVMSignature(method, true, declaringClass);
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod method) {
        if (method == null) {
            JVMNameUtil.$$$reportNull$$$0(2);
        }
        return JVMNameUtil.getJVMSignature(method, method.isConstructor(), method.getContainingClass());
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod method) {
        if (method == null) {
            JVMNameUtil.$$$reportNull$$$0(3);
        }
        String string = method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
        if (string == null) {
            JVMNameUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static JVMName getJVMSignature(@Nullable PsiMethod method, boolean constructor, @Nullable PsiClass declaringClass) {
        PsiClass outerClass;
        JVMNameBuffer signature = new JVMNameBuffer();
        signature.append("(");
        if (constructor && declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static")) {
            JVMNameUtil.appendJvmClassQualifiedName(signature, JVMNameUtil.getJVMQualifiedName(outerClass));
        }
        if (method != null) {
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                JVMNameUtil.appendJVMSignature(signature, psiParameter.getType());
            }
        }
        signature.append(")");
        if (!constructor && method != null) {
            JVMNameUtil.appendJVMSignature(signature, method.getReturnType());
        } else {
            signature.append(new JVMRawText("V"));
        }
        JVMName jVMName = signature.toName();
        if (jVMName == null) {
            JVMNameUtil.$$$reportNull$$$0(5);
        }
        return jVMName;
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        PsiElement element = position.getElementAt();
        return element != null && element.isValid() ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false) : null;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        List<ReferenceType> allClasses;
        if (position == null) {
            return null;
        }
        Pair res = (Pair)ReadAction.compute(() -> {
            String qName;
            PsiFile positionFile = position.getFile();
            if (positionFile instanceof JspFile) {
                return Pair.create((Object)positionFile.getName(), (Object)false);
            }
            PsiClass psiClass = JVMNameUtil.getClassAt(position);
            if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
                return Pair.create((Object)qName, (Object)false);
            }
            if (psiClass == null) {
                if (positionFile instanceof PsiClassOwner) {
                    return Pair.create((Object)positionFile.getName(), (Object)true);
                }
                return Pair.create((Object)JavaDebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{positionFile.getName(), position.getLine()}), (Object)true);
            }
            return Pair.create((Object)JVMNameUtil.calcClassDisplayName(psiClass), (Object)true);
        });
        if (((Boolean)res.second).booleanValue() && debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty()) {
            return allClasses.getFirst().name();
        }
        return (String)res.first;
    }

    static String calcClassDisplayName(final PsiClass aClass) {
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parent == null) {
            return null;
        }
        String name = aClass.getName();
        if (name != null) {
            return JVMNameUtil.calcClassDisplayName(parent) + "$" + name;
        }
        final Ref classIndex = new Ref((Object)0);
        try {
            parent.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(@NotNull PsiAnonymousClass cls) {
                    if (cls == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    classIndex.set((Object)((Integer)classIndex.get() + 1));
                    if (aClass.equals((Object)cls)) {
                        throw new ProcessCanceledException();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/debugger/engine/JVMNameUtil$2", "visitAnonymousClass"));
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(parent) + "$" + String.valueOf(classIndex.get());
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        String className;
        int dotIndex;
        List<ReferenceType> allClasses;
        if (position == null) {
            return null;
        }
        String res = (String)ReadAction.compute(() -> {
            String name;
            String qName;
            PsiClass toplevel;
            PsiFile positionFile = position.getFile();
            if (positionFile instanceof JspFile) {
                PsiDirectory dir = positionFile.getContainingDirectory();
                return dir != null ? dir.getVirtualFile().getPresentableUrl() : null;
            }
            PsiClass psiClass = JVMNameUtil.getClassAt(position);
            if (psiClass != null && (toplevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (qName = toplevel.getQualifiedName()) != null) {
                int i = qName.lastIndexOf(46);
                return i > 0 ? qName.substring(0, i) : "";
            }
            if (positionFile instanceof PsiClassOwner && !StringUtil.isEmpty((String)(name = ((PsiClassOwner)positionFile).getPackageName()))) {
                return name;
            }
            return null;
        });
        if (res == null && debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty() && (dotIndex = (className = allClasses.getFirst().name()).lastIndexOf(46)) >= 0) {
            return className.substring(0, dotIndex);
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return null;
        }
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            return ClassUtil.getBinaryClassName((PsiClass)containingClass);
        }
        return JVMNameUtil.getNonAnonymousClassName(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JVMNameUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMMethodName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJVMSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJVMQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNonAnonymousClassName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJVMSignature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJVMMethodName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class JVMRawText
    implements JVMName {
        private String myText;

        JVMRawText(String text) {
            this.myText = text;
        }

        @Override
        public String getName(DebugProcessImpl process) {
            return this.myText;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return this.myText;
        }

        public String getName() {
            return this.myText;
        }

        public void setName(String name) {
            this.myText = name;
        }

        public String toString() {
            return this.myText;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> myList = new ArrayList<JVMName>();

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName evaluator) {
            if (evaluator == null) {
                JVMNameBuffer.$$$reportNull$$$0(0);
            }
            this.myList.add(evaluator);
        }

        public void append(char name) {
            this.append(Character.toString(name));
        }

        public void append(String text) {
            this.myList.add(JVMNameUtil.getJVMRawText(text));
        }

        public JVMName toName() {
            final ArrayList<JVMName> optimised = new ArrayList<JVMName>();
            for (JVMName evaluator : this.myList) {
                if (evaluator instanceof JVMRawText) {
                    Object e;
                    JVMRawText rawText = (JVMRawText)evaluator;
                    if (!optimised.isEmpty() && (e = optimised.getLast()) instanceof JVMRawText) {
                        JVMRawText nameEvaluator = (JVMRawText)e;
                        nameEvaluator.setName(nameEvaluator.getName() + rawText.getName());
                        continue;
                    }
                }
                optimised.add(evaluator);
            }
            if (optimised.size() == 1) {
                return (JVMName)optimised.getFirst();
            }
            if (optimised.isEmpty()) {
                return new JVMRawText("");
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl process) throws EvaluateException {
                    if (this.myName == null) {
                        Object name = "";
                        for (JVMName nameEvaluator : optimised) {
                            name = (String)name + nameEvaluator.getName(process);
                        }
                        this.myName = name;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    if (this.myName == null) {
                        Object displayName = "";
                        for (JVMName nameEvaluator : optimised) {
                            displayName = (String)displayName + nameEvaluator.getDisplayName(debugProcess);
                        }
                        return displayName;
                    }
                    return this.myName;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/debugger/engine/JVMNameUtil$JVMNameBuffer", "append"));
        }
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition mySourcePosition;

        JVMClassAt(SourcePosition sourcePosition) {
            this.mySourcePosition = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl process) throws EvaluateException {
            List<ReferenceType> allClasses = process.getPositionManager().getAllClasses(this.mySourcePosition);
            if (allClasses.size() > 1) {
                String name = (String)ReadAction.compute(() -> JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(this.mySourcePosition)));
                if (name != null) {
                    for (ReferenceType aClass : allClasses) {
                        if (!Objects.equals(aClass.name(), name)) continue;
                        return name;
                    }
                } else {
                    String matchingTypeName = allClasses.stream().map(ReferenceType::name).max(Comparator.comparing(String::length)).orElse(null);
                    if (matchingTypeName != null) {
                        return matchingTypeName;
                    }
                }
            }
            if (!allClasses.isEmpty()) {
                return allClasses.getFirst().name();
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(process)}));
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.mySourcePosition);
        }
    }
}

