/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaFramesListRendererUtilsKt;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.ExtraDebugNodesProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XStackFrameUiPresentationContainer;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlinx.coroutines.flow.Flow;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStackFrame
extends XStackFrame
implements JVMStackFrameInfoProvider {
    private static final Logger LOG = Logger.getInstance(JavaStackFrame.class);
    public static final DummyMessageValueNode LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE = new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final XSourcePosition myXSourcePosition;
    private final NodeManagerImpl myNodeManager;
    @NotNull
    private final StackFrameDescriptorImpl myDescriptor;
    private JavaDebuggerEvaluator myEvaluator;
    private final String myEqualityObject;
    private static final Pair<Set<String>, Set<TextWithImports>> EMPTY_USED_VARS = Pair.create(Collections.emptySet(), Collections.emptySet());

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl descriptor, boolean update2) {
        if (descriptor == null) {
            JavaStackFrame.$$$reportNull$$$0(0);
        }
        this.myEvaluator = null;
        this.myDescriptor = descriptor;
        this.myEqualityObject = update2 ? NodeManagerImpl.getContextKeyForFrame(this.myDescriptor.getFrameProxy()) : null;
        this.myDebugProcess = (DebugProcessImpl)descriptor.getDebugProcess();
        this.myNodeManager = this.myDebugProcess.getXdebugProcess().getNodeManager();
        this.myXSourcePosition = DebuggerUtilsEx.toXSourcePosition(this.myDescriptor.getSourcePosition());
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.myDescriptor;
        if (stackFrameDescriptorImpl == null) {
            JavaStackFrame.$$$reportNull$$$0(1);
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new JavaDebuggerEvaluator(this.myDebugProcess, this);
        }
        return this.myEvaluator;
    }

    @ApiStatus.Internal
    public boolean isDocumentEvaluator() {
        return true;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public void customizeTextPresentation(@NotNull ColoredTextContainer component) {
        Location location;
        if (component == null) {
            JavaStackFrame.$$$reportNull$$$0(2);
        }
        if ((location = this.myDescriptor.getLocation()) == null) {
            return;
        }
        component.append(ThreadDumpAction.renderLocation(location), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            JavaStackFrame.$$$reportNull$$$0(3);
        }
        StackFrameDescriptorImpl selectedDescriptor = this.getSelectedDescriptor();
        JavaFramesListRenderer.customizePresentation(this.myDescriptor, component, selectedDescriptor);
    }

    @NotNull
    public @NotNull Flow<@NotNull XStackFrameUiPresentationContainer> customizePresentation() {
        StackFrameDescriptorImpl selectedDescriptor = this.getSelectedDescriptor();
        Flow<XStackFrameUiPresentationContainer> flow = JavaFramesListRendererUtilsKt.computeUiPresentation(this.myDescriptor, selectedDescriptor);
        if (flow == null) {
            JavaStackFrame.$$$reportNull$$$0(4);
        }
        return flow;
    }

    private StackFrameDescriptorImpl getSelectedDescriptor() {
        XStackFrame frame;
        XDebugSession xSession;
        StackFrameDescriptorImpl result = null;
        DebuggerSession session = this.myDebugProcess.getSession();
        if (session != null && (xSession = session.getXDebugSession()) != null && (frame = xSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            result = ((JavaStackFrame)frame).getDescriptor();
        }
        return result;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaStackFrame.$$$reportNull$$$0(5);
        }
        if (node.isObsolete()) {
            return;
        }
        DebuggerContextImpl debuggerContext = this.myDebugProcess.getDebuggerContext();
        Objects.requireNonNull(debuggerContext.getManagerThread()).schedule(new DebuggerContextCommandImpl(debuggerContext, this.myDescriptor.getFrameProxy().threadProxy()){

            @Override
            @NotNull
            public PrioritizedTask.Priority getPriority() {
                PrioritizedTask.Priority priority = PrioritizedTask.Priority.NORMAL;
                if (priority == null) {
                    1.$$$reportNull$$$0(0);
                }
                return priority;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (node.isObsolete()) {
                    return;
                }
                XValueChildrenList children = new XValueChildrenList();
                JavaStackFrame.this.buildVariablesThreadAction(JavaStackFrame.this.getFrameDebuggerContext(this.getDebuggerContext()), children, node);
                node.addChildren(children, true);
            }

            @Override
            protected void commandCancelled() {
                if (!node.isObsolete()) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPriority";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "threadAction";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext(@Nullable DebuggerContextImpl context) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (context == null) {
            context = this.myDebugProcess.getDebuggerContext();
        }
        if (context.getFrameProxy() != this.getStackFrameProxy()) {
            ThreadReferenceProxyImpl thread;
            SuspendManager suspendManager = this.myDebugProcess.getSuspendManager();
            SuspendContextImpl pausedSuspendingContext = SuspendManagerUtil.getPausedSuspendingContext(suspendManager, thread = this.getStackFrameProxy().threadProxy());
            SuspendContextImpl threadSuspendContext = pausedSuspendingContext != null ? pausedSuspendingContext : SuspendManagerUtil.findContextByThread(suspendManager, thread);
            context = DebuggerContextImpl.createDebuggerContext(this.myDebugProcess.mySession, threadSuspendContext, thread, this.getStackFrameProxy());
            context.setPositionCache(this.myDescriptor.getSourcePosition());
            context.initCaches();
        }
        return context;
    }

    @Nullable
    protected XNamedValue createThisNode(EvaluationContextImpl evaluationContext) {
        ObjectReference thisObjectReference = this.myDescriptor.getThisObject();
        if (thisObjectReference != null) {
            return JavaValue.create(this.myNodeManager.getThisDescriptor(null, thisObjectReference), evaluationContext, this.myNodeManager);
        }
        return null;
    }

    protected void addStaticGroup(EvaluationContextImpl evaluationContext, XCompositeNode node) {
        Location location = this.myDescriptor.getLocation();
        if (location != null && this.myDescriptor.getThisObject() == null) {
            ReferenceType type = location.declaringType();
            DebuggerUtilsAsync.allFields(type).thenAccept(__ -> {
                StaticDescriptorImpl staticDescriptor = this.myNodeManager.getStaticDescriptor(this.myDescriptor, type);
                if (staticDescriptor.isExpandable()) {
                    node.addChildren(XValueChildrenList.topGroups(List.of(new JavaStaticGroup(staticDescriptor, evaluationContext, this.myNodeManager))), false);
                }
            });
        }
    }

    @NotNull
    protected List<? extends XNamedValue> createReturnValueNodes(EvaluationContextImpl evaluationContext) {
        Pair<Method, Value> methodValuePair = this.myDebugProcess.getLastExecutedMethod();
        if (methodValuePair != null && this.myDescriptor.getUiIndex() == 0) {
            Value returnValue = (Value)methodValuePair.getSecond();
            if (returnValue instanceof ObjectReference) {
                ObjectReference returnValueObject = (ObjectReference)returnValue;
                evaluationContext.getSuspendContext().keepAsync(returnValueObject);
            }
            ValueDescriptorImpl returnValueDescriptor = this.myNodeManager.getMethodReturnValueDescriptor(this.myDescriptor, (Method)methodValuePair.getFirst(), returnValue);
            List<JavaValue> list = Collections.singletonList(JavaValue.create(returnValueDescriptor, evaluationContext, this.myNodeManager));
            if (list == null) {
                JavaStackFrame.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            JavaStackFrame.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected List<? extends XNamedValue> createExceptionNodes(EvaluationContextImpl evaluationContext) {
        if (this.myDescriptor.getUiIndex() != 0) {
            List list = Collections.emptyList();
            if (list == null) {
                JavaStackFrame.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ((StreamEx)StreamEx.of(DebuggerUtilsEx.getEventDescriptors(evaluationContext.getSuspendContext())).map(p -> (Event)p.getSecond()).select(ExceptionEvent.class).map(ExceptionEvent::exception).nonNull().distinct()).map(e -> JavaValue.create(this.myNodeManager.getThrownExceptionObjectDescriptor(this.myDescriptor, (ObjectReference)e), evaluationContext, this.myNodeManager)).toList();
        if (list == null) {
            JavaStackFrame.$$$reportNull$$$0(9);
        }
        return list;
    }

    protected void buildVariablesThreadAction(DebuggerContextImpl debuggerContext, XValueChildrenList children, XCompositeNode node) {
        try {
            EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
            if (evaluationContext == null) {
                return;
            }
            XNamedValue thisNode = this.createThisNode(evaluationContext);
            if (thisNode != null) {
                children.add(thisNode);
            }
            this.addStaticGroup(evaluationContext, node);
            this.createReturnValueNodes(evaluationContext).forEach(arg_0 -> ((XValueChildrenList)children).add(arg_0));
            this.createExceptionNodes(evaluationContext).forEach(arg_0 -> ((XValueChildrenList)children).add(arg_0));
            try {
                this.buildVariables(debuggerContext, evaluationContext, this.myDebugProcess, children, this.myDescriptor.getThisObject(), this.myDescriptor.getLocation());
            }
            catch (EvaluateException e) {
                node.setErrorMessage(e.getMessage());
            }
            DebuggerUtils.forEachSafe(ExtraDebugNodesProvider.getProviders(), p -> p.addExtraNodes(evaluationContext, children));
        }
        catch (InvalidStackFrameException e) {
            LOG.info((Throwable)e);
        }
        catch (InternalException e) {
            if (e.errorCode() == 35) {
                node.setErrorMessage(JavaDebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}));
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildVariables(DebuggerContextImpl debuggerContext, @NotNull EvaluationContextImpl evaluationContext, @NotNull DebugProcessImpl debugProcess, XValueChildrenList children, ObjectReference thisObjectReference, Location location) throws EvaluateException {
        SmartList outerLocalVariablesAsFields;
        int positionOfLocalVariablesAsFields;
        block20: {
            ReferenceType thisRefType;
            if (evaluationContext == null) {
                JavaStackFrame.$$$reportNull$$$0(10);
            }
            if (debugProcess == null) {
                JavaStackFrame.$$$reportNull$$$0(11);
            }
            HashSet<String> visibleLocals = new HashSet<String>();
            positionOfLocalVariablesAsFields = children.size();
            outerLocalVariablesAsFields = new SmartList();
            if (NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && thisObjectReference != null && evaluationContext.getVirtualMachineProxy().canGetSyntheticAttribute() && (thisRefType = thisObjectReference.referenceType()) instanceof ClassType && location != null && thisRefType.equals(location.declaringType()) && thisRefType.name().contains("$")) {
                for (Field field : thisRefType.fields()) {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)field) || !StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) continue;
                    FieldDescriptorImpl fieldDescriptorImpl = this.myNodeManager.getFieldDescriptor(this.myDescriptor, thisObjectReference, field);
                    outerLocalVariablesAsFields.add(fieldDescriptorImpl);
                    visibleLocals.add(fieldDescriptorImpl.calcValueName());
                }
            }
            boolean myAutoWatchMode = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            try {
                if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !myAutoWatchMode) {
                    this.superBuildVariables(evaluationContext, children);
                } else {
                    void var13_22;
                    SourcePosition sourcePosition = debuggerContext.getSourcePosition();
                    Map visibleVariables = ContainerUtil.map2Map(this.getVisibleVariables(), var -> Pair.create((Object)var.name(), (Object)var));
                    Pair<Set<String>, Set<TextWithImports>> pair = EMPTY_USED_VARS;
                    if (sourcePosition != null) {
                        Pair pair2 = (Pair)ReadAction.compute(() -> DumbService.isDumb((Project)debugProcess.getProject()) ? EMPTY_USED_VARS : JavaStackFrame.findReferencedVars(ContainerUtil.union(visibleVariables.keySet(), (Set)visibleLocals), sourcePosition));
                    }
                    if (myAutoWatchMode) {
                        List<LocalVariableProxyImpl> localVariables = ((Set)var13_22.first).stream().map(var -> (LocalVariableProxyImpl)visibleVariables.get(var)).filter(Objects::nonNull).collect(Collectors.toList());
                        this.buildLocalVariables(evaluationContext, children, localVariables);
                    } else {
                        this.superBuildVariables(evaluationContext, children);
                    }
                    EvaluationContextImpl evalContextCopy = evaluationContext.withAutoLoadClasses(false);
                    if (sourcePosition != null) {
                        Set<TextWithImports> extraVars = JavaStackFrame.computeExtraVars((Pair<Set<String>, Set<TextWithImports>>)var13_22, sourcePosition, evaluationContext);
                        this.addToChildrenFrom(extraVars, children, evaluationContext);
                    }
                    this.addToChildrenFrom((Set)var13_22.second, children, evalContextCopy);
                }
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    children.add((XNamedValue)LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                    try {
                        for (Map.Entry entry : LocalVariablesUtil.fetchValues(this.getStackFrameProxy(), debugProcess, true).entrySet()) {
                            children.add((XNamedValue)JavaValue.create(this.myNodeManager.getArgumentValueDescriptor(null, (DecompiledLocalVariable)entry.getKey(), (Value)entry.getValue()), evaluationContext, this.myNodeManager));
                        }
                    }
                    catch (VMDisconnectedException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        LOG.info((Throwable)ex);
                        break block20;
                    }
                }
                throw e;
            }
        }
        if (!outerLocalVariablesAsFields.isEmpty()) {
            HashSet<String> alreadyAdded = new HashSet<String>();
            for (int i = 0; i < children.size(); ++i) {
                alreadyAdded.add(children.getName(i));
            }
            for (FieldDescriptorImpl fieldDescriptorImpl : outerLocalVariablesAsFields) {
                if (alreadyAdded.contains(fieldDescriptorImpl.calcValueName())) continue;
                children.add(positionOfLocalVariablesAsFields++, (XNamedValue)JavaValue.create(fieldDescriptorImpl, evaluationContext, this.myNodeManager));
            }
        }
    }

    protected void buildLocalVariables(EvaluationContextImpl evaluationContext, XValueChildrenList children, List<LocalVariableProxyImpl> localVariables) {
        for (LocalVariableProxyImpl variable : localVariables) {
            children.add((XNamedValue)JavaValue.create(this.myNodeManager.getLocalVariableDescriptor(null, variable), evaluationContext, this.myNodeManager));
        }
    }

    private static Set<TextWithImports> computeExtraVars(Pair<Set<String>, Set<TextWithImports>> usedVars, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evalContext) {
        if (sourcePosition == null) {
            JavaStackFrame.$$$reportNull$$$0(12);
        }
        if (evalContext == null) {
            JavaStackFrame.$$$reportNull$$$0(13);
        }
        HashSet alreadyCollected = new HashSet((Collection)usedVars.first);
        ((Set)usedVars.second).stream().map(TextWithImports::getText).forEach(alreadyCollected::add);
        HashSet<TextWithImports> extra = new HashSet<TextWithImports>();
        DebuggerUtils.forEachSafe(FrameExtraVariablesProvider.EP_NAME, provider -> {
            if (provider.isAvailable(sourcePosition, evalContext)) {
                extra.addAll(provider.collectVariables(sourcePosition, evalContext, alreadyCollected));
            }
        });
        return extra;
    }

    private void addToChildrenFrom(Set<TextWithImports> expressions, XValueChildrenList children, EvaluationContextImpl evaluationContext) {
        for (TextWithImports text : expressions) {
            WatchItemDescriptor descriptor = this.myNodeManager.getWatchItemDescriptor(null, text, null);
            children.add((XNamedValue)JavaValue.create(descriptor, evaluationContext, this.myNodeManager));
        }
    }

    public static XNamedValue createMessageNode(String text, Icon icon) {
        return new DummyMessageValueNode(text, icon);
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContext, XValueChildrenList children) throws EvaluateException {
        this.buildLocalVariables(evaluationContext, children, this.getVisibleVariables());
    }

    @NotNull
    public StackFrameProxyImpl getStackFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.myDescriptor.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            JavaStackFrame.$$$reportNull$$$0(14);
        }
        return stackFrameProxyImpl;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.myEqualityObject;
    }

    public String toString() {
        if (this.myXSourcePosition != null) {
            return "JavaFrame " + this.myXSourcePosition.getFile().getName() + ":" + this.myXSourcePosition.getLine();
        }
        return "JavaFrame position unknown";
    }

    protected List<LocalVariableProxyImpl> getVisibleVariables() throws EvaluateException {
        return this.getStackFrameProxy().visibleVariables();
    }

    private static boolean shouldSkipLine(PsiFile file, Document doc, int line) {
        int start = doc.getLineStartOffset(line);
        int end = doc.getLineEndOffset(line);
        int _start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)start, (String)" \n\t");
        if (_start >= end) {
            return true;
        }
        TextRange alreadyChecked = null;
        for (PsiElement elem = file.findElementAt(_start); !(elem == null || elem.getTextOffset() > end || alreadyChecked != null && alreadyChecked.contains(elem.getTextRange())); elem = elem.getNextSibling()) {
            PsiElement _elem = elem;
            while (_elem.getTextOffset() >= _start) {
                alreadyChecked = _elem.getTextRange();
                if (_elem instanceof PsiDeclarationStatement) {
                    PsiElement[] declared;
                    for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)_elem).getDeclaredElements()) {
                        if (!(declaredElement instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (_elem instanceof PsiJavaCodeReferenceElement) {
                    try {
                        PsiElement resolved = ((PsiJavaCodeReferenceElement)_elem).resolve();
                        if (resolved instanceof PsiVariable) {
                            return false;
                        }
                    }
                    catch (IndexNotReadyException e) {
                        return false;
                    }
                }
                _elem = _elem.getParent();
            }
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> findReferencedVars(Set<String> visibleVars, @NotNull SourcePosition position) {
        int offset;
        PsiElement element;
        int endLine;
        Document doc;
        int line;
        if (position == null) {
            JavaStackFrame.$$$reportNull$$$0(15);
        }
        if ((line = position.getLine()) < 0) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile positionFile = position.getFile();
        if (!positionFile.isValid() || !positionFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Pair.create(visibleVars, Collections.emptySet());
        }
        VirtualFile vFile = positionFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        TextRange limit = JavaStackFrame.calculateLimitRange(positionFile, doc, line);
        int startLine = Math.max(limit.getStartOffset(), line - 1);
        for (startLine = Math.min(startLine, limit.getEndOffset()); startLine > limit.getStartOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, startLine); --startLine) {
        }
        int startOffset = doc.getLineStartOffset(startLine);
        for (endLine = Math.min(line + 2, limit.getEndOffset()); endLine < limit.getEndOffset() && JavaStackFrame.shouldSkipLine(positionFile, doc, endLine); ++endLine) {
        }
        int endOffset = doc.getLineEndOffset(endLine);
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (!lineRange.isEmpty() && (element = positionFile.findElementAt(offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \t"))) != null) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class});
            if (method != null) {
                element = method;
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiField.class});
                if (field != null) {
                    element = field;
                } else {
                    PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiClassInitializer.class});
                    if (initializer != null) {
                        element = initializer;
                    }
                }
            }
            if (element instanceof PsiCompiledElement) {
                return Pair.create(visibleVars, Collections.emptySet());
            }
            VariablesCollector collector = new VariablesCollector(visibleVars, JavaStackFrame.adjustRange(element, lineRange));
            element.accept((PsiElementVisitor)collector);
            return Pair.create(collector.getVars(), collector.getExpressions());
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange calculateLimitRange(PsiFile file, Document doc, int line) {
        PsiMethod method;
        int offset = doc.getLineStartOffset(line);
        if (offset > 0 && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiMethod.class, (boolean)false)) != null) {
            TextRange elemRange = method.getTextRange();
            return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
        }
        return new TextRange(0, doc.getLineCount() - 1);
    }

    private static TextRange adjustRange(PsiElement element, final TextRange originalRange) {
        final Ref rangeRef = new Ref((Object)originalRange);
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
                TextRange stRange;
                if (statement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (originalRange.intersects(stRange = statement.getTextRange())) {
                    TextRange currentRange = (TextRange)rangeRef.get();
                    int start = Math.min(currentRange.getStartOffset(), stRange.getStartOffset());
                    int end = Math.max(currentRange.getEndOffset(), stRange.getEndOffset());
                    rangeRef.set((Object)new TextRange(start, end));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/debugger/engine/JavaStackFrame$2", "visitExpressionStatement"));
            }
        });
        return (TextRange)rangeRef.get();
    }

    @Override
    public boolean isSynthetic() {
        return this.myDescriptor.isSynthetic();
    }

    @Override
    public boolean isInLibraryContent() {
        return this.myDescriptor.isInLibraryContent();
    }

    @Override
    public boolean shouldHide() {
        return this.myDescriptor.shouldHide();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaStackFrame frame = (JavaStackFrame)o;
        return this.myDescriptor.getFrameProxy().equals(frame.myDescriptor.getFrameProxy());
    }

    public int hashCode() {
        return this.myDescriptor.getFrameProxy().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "customizePresentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReturnValueNodes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExceptionNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeTextPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildVariables";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeExtraVars";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedVars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 8, 9, 14 -> new IllegalStateException(string);
        };
    }

    static class DummyMessageValueNode
    extends XNamedValue {
        private final String myMessage;
        private final Icon myIcon;

        DummyMessageValueNode(String message, Icon icon) {
            super("");
            this.myMessage = message;
            this.myIcon = icon;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place2) {
            if (node == null) {
                DummyMessageValueNode.$$$reportNull$$$0(0);
            }
            if (place2 == null) {
                DummyMessageValueNode.$$$reportNull$$$0(1);
            }
            node.setPresentation(this.myIcon, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    return "";
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                    if (renderer == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    renderer.renderValue(myMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1", "renderValue"));
                }
            }, false);
        }

        public String toString() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> myVisibleLocals;
        private final TextRange myLineRange;
        private final Set<TextWithImports> myExpressions = new HashSet<TextWithImports>();
        private final Set<String> myVars = new HashSet<String>();
        private final boolean myCollectExpressions = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();

        VariablesCollector(Set<String> visibleLocals, TextRange lineRange) {
            this.myVisibleLocals = visibleLocals;
            this.myLineRange = lineRange;
        }

        public Set<String> getVars() {
            return this.myVars;
        }

        public Set<TextWithImports> getExpressions() {
            return this.myExpressions;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                VariablesCollector.$$$reportNull$$$0(0);
            }
            if (this.myLineRange.intersects(element.getTextRange())) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod psiMethod;
            if (expression == null) {
                VariablesCollector.$$$reportNull$$$0(1);
            }
            if (this.myCollectExpressions && (psiMethod = expression.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitMethodCallExpression(expression);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiElement psiElement;
            if (reference == null) {
                VariablesCollector.$$$reportNull$$$0(2);
            }
            if (this.myLineRange.intersects(reference.getTextRange()) && (psiElement = reference.resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)psiElement;
                if (var instanceof PsiField) {
                    if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)reference, this.myVisibleLocals)) {
                        boolean isConstant;
                        PsiModifierList modifierList = var.getModifierList();
                        boolean bl = isConstant = var instanceof PsiEnumConstant || modifierList != null && modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final");
                        if (!isConstant) {
                            this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                        }
                    }
                } else if (this.myVisibleLocals.contains(var.getName())) {
                    this.myVars.add(var.getName());
                } else if (!Comparing.equal((Object)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class)), (Object)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class)))) {
                    this.myExpressions.add(new TextWithImportsImpl((PsiElement)reference));
                }
            }
            super.visitReferenceExpression(reference);
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            if (expression == null) {
                VariablesCollector.$$$reportNull$$$0(3);
            }
            if (this.myCollectExpressions && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)expression, this.myVisibleLocals)) {
                this.myExpressions.add(new TextWithImportsImpl((PsiElement)expression));
            }
            super.visitArrayAccessExpression(expression);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                VariablesCollector.$$$reportNull$$$0(4);
            }
            this.processVariable((PsiVariable)parameter);
            super.visitParameter(parameter);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                VariablesCollector.$$$reportNull$$$0(5);
            }
            this.processVariable((PsiVariable)variable);
            super.visitLocalVariable(variable);
        }

        private void processVariable(PsiVariable variable) {
            if (this.myLineRange.intersects(variable.getTextRange()) && this.myVisibleLocals.contains(variable.getName())) {
                this.myVars.add(variable.getName());
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                VariablesCollector.$$$reportNull$$$0(6);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame$VariablesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

