/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.java.debugger.impl.shared.engine.JavaValueTextModificationPreparatorKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaValueModifier
extends XValueModifier {
    private final JavaValue myJavaValue;

    public JavaValueModifier(JavaValue javaValue) {
        this.myJavaValue = javaValue;
    }

    public void calculateInitialValueEditorText(final XValueModifier.XInitialValueCallback callback) {
        final Value value = this.myJavaValue.getDescriptor().getValue();
        if (value == null || value instanceof PrimitiveValue) {
            String valueString = this.myJavaValue.getDescriptor().getValueText();
            int pos = valueString.lastIndexOf(40);
            if (pos > 1) {
                valueString = valueString.substring(0, pos).trim();
            }
            callback.setValue(valueString);
        } else if (value instanceof StringReference) {
            final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
            evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this, evaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    callback.setValue(JavaValueTextModificationPreparatorKt.convertToJavaStringLiteral((String)DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)value)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$1", "contextAction"));
                }
            });
        } else {
            callback.setValue(null);
        }
    }

    protected static void update(DebuggerContextImpl context) {
        DebuggerInvocationUtil.invokeLaterAnyModality(context.getProject(), () -> {
            DebuggerSession session = context.getDebuggerSession();
            if (session != null) {
                session.refresh(false);
            }
        });
    }

    protected abstract void setValueImpl(@NotNull XExpression var1, @NotNull XValueModifier.XModificationCallback var2);

    public void setValue(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
        ValueDescriptorImpl descriptor;
        if (expression == null) {
            JavaValueModifier.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaValueModifier.$$$reportNull$$$0(1);
        }
        if (!(descriptor = this.myJavaValue.getDescriptor()).canSetValue()) {
            return;
        }
        if (this.myJavaValue.getEvaluationContext().getSuspendContext().isResumed()) {
            callback.errorOccurred(JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            return;
        }
        this.setValueImpl(expression, callback);
    }

    protected static Value preprocessValue(EvaluationContextImpl context, Value value, @NotNull Type varType) throws EvaluateException {
        String v;
        if (varType == null) {
            JavaValueModifier.$$$reportNull$$$0(2);
        }
        if (value != null && "java.lang.String".equals(varType.name()) && !(value instanceof StringReference) && (v = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)value)) != null) {
            value = DebuggerUtilsEx.mirrorOfString(v, context);
        }
        if (value instanceof DoubleValue) {
            double dValue = ((DoubleValue)value).doubleValue();
            if (varType instanceof FloatType && (double)1.4E-45f <= dValue && dValue <= 3.4028234663852886E38) {
                value = context.getVirtualMachineProxy().mirrorOf((float)dValue);
            }
        }
        if (value != null) {
            if (varType instanceof PrimitiveType) {
                if (!(value instanceof PrimitiveValue)) {
                    value = (Value)UnBoxingEvaluator.unbox(value, context);
                }
            } else if (varType instanceof ReferenceType && value instanceof PrimitiveValue) {
                value = (Value)BoxingEvaluator.box(value, context);
            }
        }
        return value;
    }

    @Nullable
    private static ExpressionEvaluator tryDirectAssignment(@NotNull XExpression expression, @Nullable Type varType, @NotNull EvaluationContextImpl evaluationContext) {
        if (expression == null) {
            JavaValueModifier.$$$reportNull$$$0(3);
        }
        if (evaluationContext == null) {
            JavaValueModifier.$$$reportNull$$$0(4);
        }
        if (varType instanceof LongType) {
            try {
                return new ExpressionEvaluatorImpl(new IdentityEvaluator(evaluationContext.getVirtualMachineProxy().mirrorOf(Long.decode(expression.getExpression()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void setValue(ExpressionEvaluator evaluator, EvaluationContextImpl evaluationContext, SetValueRunnable setValueRunnable) throws EvaluateException {
        try {
            Value value = evaluator.evaluate((EvaluationContext)evaluationContext);
            setValueRunnable.setValue(evaluationContext, value);
        }
        catch (IllegalArgumentException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)ex.getMessage());
        }
        catch (InvalidTypeException ex) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.type.mismatch", (Object[])new Object[0]));
        }
        catch (IncompatibleThreadStateException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        catch (ClassNotLoadedException ex) {
            if (!evaluationContext.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)ex);
            }
            try {
                ReferenceType refType = evaluationContext.getDebugProcess().loadClass(evaluationContext, ex, setValueRunnable.getClassLoader(evaluationContext));
                if (refType != null) {
                    JavaValueModifier.setValue(evaluator, evaluationContext, setValueRunnable);
                }
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
        }
    }

    protected void set(final @NotNull XExpression expression, XValueModifier.XModificationCallback callback, DebuggerContextImpl debuggerContext, final SetValueRunnable setValueRunnable) {
        if (expression == null) {
            JavaValueModifier.$$$reportNull$$$0(5);
        }
        final EvaluationContextImpl evaluationContext = this.myJavaValue.getEvaluationContext();
        evaluationContext.getManagerThread().startCommandWithModalProgress(evaluationContext.getProject(), JavaDebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]), (Function1<? super ProgressIndicator, ? extends DebuggerCommandImpl>)((Function1)indicator -> new DebuggerContextCommandImpl(this, debuggerContext, (ProgressIndicator)indicator, callback){
            final /* synthetic */ ProgressIndicator val$indicator;
            final /* synthetic */ XValueModifier.XModificationCallback val$callback;
            {
                this.val$indicator = progressIndicator;
                this.val$callback = xModificationCallback;
                super(arg0);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    ExpressionEvaluator evaluator = JavaValueModifier.tryDirectAssignment(expression, setValueRunnable.getLType(), evaluationContext);
                    if (evaluator == null) {
                        final Project project = evaluationContext.getProject();
                        final SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
                        final PsiElement context = ContextUtil.getContextElement((StackFrameContext)evaluationContext, position);
                        evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project, new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                return EvaluatorBuilderImpl.build(TextWithImportsImpl.fromXExpression(expression), context, position, project);
                            }
                        });
                    }
                    JavaValueModifier.setValue(evaluator, evaluationContext, new SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException {
                            if (!val$indicator.isCanceled()) {
                                setValueRunnable.setValue(evaluationContext, newValue);
                            }
                        }

                        @Override
                        @Nullable
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            return setValueRunnable.getLType();
                        }
                    });
                    this.val$callback.valueModified();
                }
                catch (EvaluateException | ClassNotLoadedException e) {
                    this.val$callback.errorOccurred(e.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaValueModifier$2", "threadAction"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaValueModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryDirectAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface SetValueRunnable {
        public void setValue(EvaluationContextImpl var1, Value var2) throws ClassNotLoadedException, InvalidTypeException, EvaluateException, IncompatibleThreadStateException;

        default public ClassLoaderReference getClassLoader(EvaluationContextImpl evaluationContext) throws EvaluateException {
            return evaluationContext.getClassLoader();
        }

        @Nullable
        public Type getLType() throws ClassNotLoadedException, EvaluateException;
    }
}

