/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaValuePresentation
extends XValueExtendedPresentation
implements XValueCompactPresentation {
    protected final ValueDescriptorImpl myValueDescriptor;

    public JavaValuePresentation(ValueDescriptorImpl valueDescriptor) {
        this.myValueDescriptor = valueDescriptor;
    }

    @Nullable
    public String getType() {
        return this.myValueDescriptor.getIdLabel();
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        if (renderer == null) {
            JavaValuePresentation.$$$reportNull$$$0(0);
        }
        this.renderValue(renderer, null);
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
        if (renderer == null) {
            JavaValuePresentation.$$$reportNull$$$0(1);
        }
        boolean compact = node != null;
        String valueText = this.myValueDescriptor.getValueText();
        EvaluateException exception = this.myValueDescriptor.getEvaluateException();
        if (exception != null) {
            String errorMessage = exception.getMessage();
            if (valueText.endsWith(errorMessage)) {
                renderer.renderValue(valueText.substring(0, valueText.length() - errorMessage.length()));
            }
            renderer.renderError(errorMessage);
        } else {
            String text;
            if (compact && (text = this.myValueDescriptor.getCompactValueText()) != null) {
                renderer.renderValue(text);
                return;
            }
            if (this.myValueDescriptor.isString()) {
                renderer.renderStringValue(valueText, "\"", 1000);
                return;
            }
            String value = JavaValuePresentation.truncateToMaxLength(valueText);
            Renderer lastRenderer = this.myValueDescriptor.getLastLabelRenderer();
            if (lastRenderer instanceof ToStringRenderer) {
                if (!((ToStringRenderer)lastRenderer).isShowValue(this.myValueDescriptor, this.myValueDescriptor.getStoredEvaluationContext())) {
                    return;
                }
                value = StringUtil.wrapWithDoubleQuote((String)value);
            }
            renderer.renderValue(value);
        }
    }

    @NotNull
    public String getSeparator() {
        boolean emptyAfterSeparator = !this.myValueDescriptor.isShowIdLabel() && this.isValueEmpty();
        String declaredType = this.myValueDescriptor.getDeclaredTypeLabel();
        if (!StringUtil.isEmpty((String)declaredType)) {
            Object object = emptyAfterSeparator ? declaredType : declaredType + "  = ";
            if (object == null) {
                JavaValuePresentation.$$$reportNull$$$0(2);
            }
            return object;
        }
        return emptyAfterSeparator ? "" : " = ";
    }

    public boolean isModified() {
        return this.myValueDescriptor.isDirty();
    }

    private boolean isValueEmpty() {
        MyEmptyContainerChecker checker = new MyEmptyContainerChecker();
        this.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl((ColoredTextContainer)checker));
        return checker.isEmpty;
    }

    private static String truncateToMaxLength(@NotNull String value) {
        if (value == null) {
            JavaValuePresentation.$$$reportNull$$$0(3);
        }
        return value.substring(0, Math.min(value.length(), 1000));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaValuePresentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaValuePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "truncateToMaxLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MyEmptyContainerChecker
    implements ColoredTextContainer {
        boolean isEmpty = true;

        private MyEmptyContainerChecker() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (fragment == null) {
                MyEmptyContainerChecker.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                MyEmptyContainerChecker.$$$reportNull$$$0(1);
            }
            if (!fragment.isEmpty()) {
                this.isEmpty = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaValuePresentation$MyEmptyContainerChecker";
            objectArray[2] = "append";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

