/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerDiagnosticsUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.Locatable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001>\b&\u0018\u0000 \u0088\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0088\u0001B3\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010@\u001a\u00020:H\u0016J\u0010\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010DJ\u000e\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020\u0018J\u0012\u0010A\u001a\u00020B2\b\u0010F\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010G\u001a\u00020BH\u0016J\b\u0010O\u001a\u00020BH$J\u000e\u0010P\u001a\u00020B2\u0006\u0010Q\u001a\u00020\u001dJ\b\u0010R\u001a\u00020BH\u0002J\b\u0010S\u001a\u00020BH\u0002J\b\u0010Y\u001a\u00020\u0005H\u0016J\n\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\n\u0010_\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010`\u001a\u00020\u0007H\u0016J\b\u0010e\u001a\u00020bH\u0002J\u0006\u0010f\u001a\u00020BJ\u000e\u0010g\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u0018J\u000e\u0010h\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u0018J\u0012\u0010l\u001a\u00020B2\b\u0010m\u001a\u0004\u0018\u000104H\u0007J\n\u0010n\u001a\u00020bH\u0096\u0080\u0004J\n\u0010o\u001a\u0004\u0018\u00010bH\u0002J\n\u0010r\u001a\u0004\u0018\u00010bH\u0002J\u0006\u0010s\u001a\u00020bJ\u000e\u0010v\u001a\u00020B2\u0006\u0010w\u001a\u000202J\u000e\u0010x\u001a\u00020B2\u0006\u0010w\u001a\u000202J\u000e\u0010y\u001a\u00020B2\u0006\u0010z\u001a\u00020.J\u0006\u0010{\u001a\u00020BJ\b\u0010|\u001a\u0004\u0018\u00010.J\n\u0010}\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010~\u001a\u00020B2\b\u0010\u007f\u001a\u0004\u0018\u00010\u0018J\u0013\u0010\u0080\u0001\u001a\u00020B2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020B2\u0007\u0010\u0084\u0001\u001a\u00020bH\u0002J!\u0010\u0085\u0001\u001a\u00020B2\u0006\u0010\u0017\u001a\u00020\u001d2\u000e\u0010\u0086\u0001\u001a\t\u0012\u0004\u0012\u00020b0\u0087\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001d8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00188\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\u001d8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0004\u0018\u00010!8\u0007@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010'8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180'8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u001d8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u001d8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00100\u001a\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`3X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00105\u001a\u0004\u0018\u0001042\b\u0010\u0017\u001a\u0004\u0018\u000104@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010?R\u0011\u0010H\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0013\u0010K\u001a\u0004\u0018\u00010L8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR(\u0010T\u001a\u0004\u0018\u00010\n2\b\u0010T\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0016\u0010\\\u001a\u0004\u0018\u00010[8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0011\u0010a\u001a\u00020b8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR\u0011\u0010i\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u0011\u0010k\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\bk\u0010jR\u0016\u0010p\u001a\u0004\u0018\u00010b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010dR\u0014\u0010t\u001a\u00020b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bu\u0010d\u00a8\u0006\u0089\u0001"}, d2={"Lcom/intellij/debugger/engine/SuspendContextImpl;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "Lcom/intellij/debugger/engine/SuspendContext;", "Lcom/intellij/openapi/Disposable;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "mySuspendPolicy", "", "myVotesToVote", "myEventSet", "Lcom/sun/jdi/event/EventSet;", "myDebugId", "", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;IILcom/sun/jdi/event/EventSet;J)V", "managerThread", "Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "getManagerThread", "()Lcom/intellij/debugger/engine/DebuggerManagerThreadImpl;", "virtualMachineProxy", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "getVirtualMachineProxy", "()Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "value", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "eventThread", "getEventThread", "()Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "myIsVotedForResume", "", "mySteppingThreadForResumeOneSteppingCurrentMode", "threadFilterWasPassed", "lightThreadFilter", "", "getLightThreadFilter", "()Ljava/lang/Object;", "setLightThreadFilter", "(Ljava/lang/Object;)V", "myResumedThreads", "", "myNotExecutableThreads", "mySuspendAllSwitchedContext", "myIsResumed", "myIsGoingToResume", "myPostponedCommands", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "myInProgress", "myKeptReferences", "Ljava/util/HashSet;", "Lcom/sun/jdi/ObjectReference;", "Lkotlin/collections/HashSet;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluationContext", "getEvaluationContext", "()Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "myFrameCount", "myCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "myActiveExecutionStack", "Lcom/intellij/debugger/engine/JavaExecutionStack;", "myListener", "com/intellij/debugger/engine/SuspendContextImpl$myListener$1", "Lcom/intellij/debugger/engine/SuspendContextImpl$myListener$1;", "getCoroutineScope", "setThread", "", "thread", "Lcom/sun/jdi/ThreadReference;", "resetThread", "threadProxy", "dispose", "cachedThreadFrameCount", "getCachedThreadFrameCount", "()I", "location", "Lcom/sun/jdi/Location;", "getLocation", "()Lcom/sun/jdi/Location;", "resumeImpl", "resume", "callResume", "assertCanBeUsed", "assertNotResumed", "eventSet", "getEventSet", "()Lcom/sun/jdi/event/EventSet;", "setEventSet", "(Lcom/sun/jdi/event/EventSet;)V", "getDebugProcess", "getFrameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "frameProxyFromTechnicalThread", "getFrameProxyFromTechnicalThread", "()Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getThread", "getSuspendPolicy", "suspendPolicyFromRequestors", "", "getSuspendPolicyFromRequestors", "()Ljava/lang/String;", "asStrPolicy", "doNotResumeHack", "isExplicitlyResumed", "suspends", "isEvaluating", "()Z", "isResumed", "setIsEvaluating", "context", "toString", "eventSetAsString", "stackStr", "getStackStr", "oldToString", "toAttachmentString", "suspendPolicyString", "getSuspendPolicyString", "keep", "reference", "keepAsync", "postponeCommand", "command", "cancelAllPostponed", "pollPostponedCommand", "getActiveExecutionStack", "initExecutionStacks", "activeThread", "computeExecutionStacks", "container", "Lcom/intellij/xdebugger/frame/XSuspendContext$XExecutionStackContainer;", "logError", "message", "assertInLog", "supplier", "Ljava/util/function/Supplier;", "Companion", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nSuspendContextImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendContextImpl.kt\ncom/intellij/debugger/engine/SuspendContextImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,500:1\n812#2,12:501\n60#3,5:513\n60#3,5:518\n*S KotlinDebug\n*F\n+ 1 SuspendContextImpl.kt\ncom/intellij/debugger/engine/SuspendContextImpl\n*L\n170#1:501,12\n204#1:513,5\n231#1:518,5\n*E\n"})
public abstract class SuspendContextImpl
extends XSuspendContext
implements SuspendContext,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    private final int mySuspendPolicy;
    @JvmField
    protected int myVotesToVote;
    @Nullable
    private EventSet myEventSet;
    private final long myDebugId;
    @NotNull
    private final DebuggerManagerThreadImpl managerThread;
    @Nullable
    private ThreadReferenceProxyImpl eventThread;
    @JvmField
    public boolean myIsVotedForResume;
    @JvmField
    @Nullable
    public ThreadReferenceProxyImpl mySteppingThreadForResumeOneSteppingCurrentMode;
    @JvmField
    public boolean threadFilterWasPassed;
    @Nullable
    private Object lightThreadFilter;
    @JvmField
    @Nullable
    public Set<ThreadReferenceProxyImpl> myResumedThreads;
    @JvmField
    @NotNull
    protected final Set<ThreadReferenceProxyImpl> myNotExecutableThreads;
    @JvmField
    protected boolean mySuspendAllSwitchedContext;
    private volatile boolean myIsResumed;
    @JvmField
    protected volatile boolean myIsGoingToResume;
    @NotNull
    private final ConcurrentLinkedQueue<SuspendContextCommandImpl> myPostponedCommands;
    @JvmField
    public volatile boolean myInProgress;
    @NotNull
    private final HashSet<ObjectReference> myKeptReferences;
    @Nullable
    private EvaluationContextImpl evaluationContext;
    private int myFrameCount;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    @Nullable
    private JavaExecutionStack myActiveExecutionStack;
    @NotNull
    private final myListener.1 myListener;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Comparator<JavaExecutionStack> THREAD_NAME_COMPARATOR;
    @NotNull
    private static final Comparator<ThreadReferenceProxyImpl> SUSPEND_FIRST_COMPARATOR;
    @NotNull
    private static final Comparator<JavaExecutionStack> THREADS_SUSPEND_AND_NAME_COMPARATOR;

    @ApiStatus.Internal
    public SuspendContextImpl(@NotNull DebugProcessImpl myDebugProcess, int mySuspendPolicy, int myVotesToVote, @Nullable EventSet myEventSet, long myDebugId) {
        Intrinsics.checkNotNullParameter((Object)((Object)myDebugProcess), (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        this.mySuspendPolicy = mySuspendPolicy;
        this.myVotesToVote = myVotesToVote;
        this.myEventSet = myEventSet;
        this.myDebugId = myDebugId;
        this.managerThread = DebuggerManagerThreadImpl.Companion.getCurrentThread();
        this.myIsVotedForResume = true;
        this.threadFilterWasPassed = true;
        this.myNotExecutableThreads = new HashSet();
        this.myPostponedCommands = new ConcurrentLinkedQueue();
        this.myKeptReferences = new HashSet();
        this.myFrameCount = -1;
        this.myCoroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.managerThread.getCoroutineScope(), (String)("SuspendContextImpl " + this.myDebugId), null, (boolean)false, (int)6, null);
        this.myListener = new ThreadReferenceProxyImpl.ThreadListener(this){
            final /* synthetic */ SuspendContextImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void threadSuspended() {
                this.this$0.myNotExecutableThreads.clear();
                SuspendContextImpl.access$setMyFrameCount$p(this.this$0, -1);
            }

            public void threadResumed() {
                this.this$0.myNotExecutableThreads.clear();
                SuspendContextImpl.access$setMyFrameCount$p(this.this$0, -1);
            }
        };
        if (!Disposer.tryRegister((Disposable)this.managerThread, (Disposable)this)) {
            Disposer.dispose((Disposable)this);
        }
    }

    @NotNull
    public final DebuggerManagerThreadImpl getManagerThread() {
        return this.managerThread;
    }

    @NotNull
    public final VirtualMachineProxyImpl getVirtualMachineProxy() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.managerThread.getVmProxy();
        Intrinsics.checkNotNull((Object)virtualMachineProxyImpl);
        return virtualMachineProxyImpl;
    }

    @ApiStatus.Internal
    @Nullable
    public final ThreadReferenceProxyImpl getEventThread() {
        return this.eventThread;
    }

    @ApiStatus.Internal
    @Nullable
    public final Object getLightThreadFilter() {
        return this.lightThreadFilter;
    }

    @ApiStatus.Internal
    public final void setLightThreadFilter(@Nullable Object object) {
        this.lightThreadFilter = object;
    }

    @Nullable
    public final EvaluationContextImpl getEvaluationContext() {
        return this.evaluationContext;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.myCoroutineScope;
    }

    public final void setThread(@Nullable ThreadReference thread) {
        this.assertCanBeUsed();
        ThreadReferenceProxyImpl threadProxy = this.getVirtualMachineProxy().getThreadReferenceProxy(thread);
        this.assertInLog(this.eventThread == null || this.eventThread == threadProxy, () -> SuspendContextImpl.setThread$lambda$0(this, thread));
        this.setThread(threadProxy);
    }

    public final void resetThread(@NotNull ThreadReferenceProxyImpl threadProxy) {
        Intrinsics.checkNotNullParameter((Object)threadProxy, (String)"threadProxy");
        ThreadReferenceProxyImpl currentThread = this.eventThread;
        if (currentThread == threadProxy) {
            return;
        }
        this.assertInLog(this.evaluationContext == null, () -> SuspendContextImpl.resetThread$lambda$0(this));
        this.assertInLog(this.myActiveExecutionStack == null, () -> SuspendContextImpl.resetThread$lambda$1(this));
        this.assertCanBeUsed();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = currentThread;
        if (threadReferenceProxyImpl != null) {
            threadReferenceProxyImpl.removeListener(this.myListener);
        }
        this.myFrameCount = -1;
        this.setThread(threadProxy);
    }

    private final void setThread(ThreadReferenceProxyImpl threadProxy) {
        if (threadProxy != null && this.eventThread != threadProxy && !this.myDebugProcess.disposable.isDisposed()) {
            threadProxy.addListener(this.myListener, this);
        }
        this.eventThread = threadProxy;
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.myCoroutineScope, null, (int)1, null);
        this.cancelAllPostponed();
    }

    public final int getCachedThreadFrameCount() {
        if (this.myFrameCount == -1) {
            try {
                ThreadReferenceProxyImpl threadReferenceProxyImpl = this.eventThread;
                this.myFrameCount = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.frameCount() : 0;
            }
            catch (EvaluateException evaluateException) {
                this.myFrameCount = 0;
            }
        }
        return this.myFrameCount;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Location getLocation() {
        JavaExecutionStack executionStack = this.myActiveExecutionStack;
        ThreadReferenceProxyImpl currentThread = this.eventThread;
        if ((executionStack == null || executionStack.getThreadProxy() == currentThread) && this.myEventSet != null) {
            Locatable event;
            EventSet eventSet = this.myEventSet;
            if (eventSet != null) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = eventSet;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LocatableEvent)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v1 = (LocatableEvent)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            } else {
                v1 = event = null;
            }
            if (event != null && (currentThread == null || Intrinsics.areEqual((Object)currentThread.getThreadReference(), (Object)event.thread()))) {
                return event.location();
            }
        }
        try {
            StackFrameProxyImpl stackFrameProxyImpl = this.getFrameProxy();
            return stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
        }
        catch (Throwable e) {
            LOG.debug(e);
            return null;
        }
    }

    protected abstract void resumeImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume(boolean callResume) {
        this.assertNotResumed();
        if (this.isEvaluating()) {
            this.logError("Resuming context " + this + " while evaluating");
        }
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        try {
            Iterator<ObjectReference> iterator = this.myKeptReferences.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<ObjectReference> iterator2 = iterator;
            while (iterator2.hasNext()) {
                ObjectReference r;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                this.managerThread.schedule(PrioritizedTask.Priority.LOWEST, () -> SuspendContextImpl.resume$lambda$0(r));
            }
            this.myKeptReferences.clear();
            this.cancelAllPostponed();
            if (callResume) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Resuming context " + this, t$iv);
                }
                this.resumeImpl();
            }
        }
        finally {
            this.myIsResumed = true;
            Disposer.dispose((Disposable)this);
        }
    }

    private final void assertCanBeUsed() {
        this.assertNotResumed();
        this.assertInLog(!this.myIsGoingToResume, () -> SuspendContextImpl.assertCanBeUsed$lambda$0(this));
    }

    private final void assertNotResumed() {
        if (this.myIsResumed && this.myDebugProcess.isAttached()) {
            this.logError("Cannot access " + this + " because it is resumed.");
        }
    }

    @Nullable
    public final EventSet getEventSet() {
        return this.myEventSet;
    }

    public final void setEventSet(@Nullable EventSet eventSet) {
        this.assertCanBeUsed();
        this.assertInLog(this.myEventSet == null, () -> SuspendContextImpl._set_eventSet_$lambda$0(this));
        this.myEventSet = eventSet;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Installed set into " + this, t$iv);
        }
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        Object object;
        try {
            Object object2 = this.myActiveExecutionStack;
            if (object2 == null || (object2 = object2.getThreadProxy()) == null || (object2 = ((ThreadReferenceProxyImpl)object2).frame(0)) == null) {
                object2 = this.getFrameProxyFromTechnicalThread();
            }
            object = object2;
        }
        catch (EvaluateException e) {
            this.myDebugProcess.logError("Error in proxy extracting", e);
            object = this.getFrameProxyFromTechnicalThread();
        }
        return object;
    }

    private final StackFrameProxyImpl getFrameProxyFromTechnicalThread() {
        this.assertNotResumed();
        try {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.eventThread;
            if (threadReferenceProxyImpl == null) {
                return null;
            }
            ThreadReferenceProxyImpl currentThread = threadReferenceProxyImpl;
            int frameCount = currentThread.frameCount();
            if (this.myFrameCount != -1 && this.myFrameCount != frameCount) {
                this.logError("Incorrect frame count, cached " + this.myFrameCount + ", now " + frameCount + ", thread " + currentThread + " suspend count " + currentThread.getSuspendCount());
            }
            this.myFrameCount = frameCount;
            if (frameCount > 0) {
                return currentThread.frame(0);
            }
            return null;
        }
        catch (EvaluateException evaluateException) {
            return null;
        }
    }

    @Nullable
    public ThreadReferenceProxyImpl getThread() {
        Object object = this.myActiveExecutionStack;
        if (object == null || (object = object.getThreadProxy()) == null) {
            object = this.eventThread;
        }
        return object;
    }

    public int getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    @NotNull
    public final String getSuspendPolicyFromRequestors() {
        if (this.mySuspendPolicy == 2) {
            return "SuspendAll";
        }
        EventSet eventSet = this.myEventSet;
        if (eventSet == null) {
            return this.asStrPolicy();
        }
        return RequestManagerImpl.hasSuspendAllRequestor(eventSet) ? "SuspendAll" : this.asStrPolicy();
    }

    private final String asStrPolicy() {
        return switch (this.mySuspendPolicy) {
            case 2 -> "SuspendAll";
            case 1 -> "SuspendThread";
            case 0 -> "SuspendNone";
            default -> throw new IllegalStateException("Cannot convert number " + this.mySuspendPolicy);
        };
    }

    public final void doNotResumeHack() {
        this.assertNotResumed();
        this.myVotesToVote = 1000000000;
    }

    public final boolean isExplicitlyResumed(@NotNull ThreadReferenceProxyImpl thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Set<ThreadReferenceProxyImpl> set = this.myResumedThreads;
        return set != null ? set.contains(thread) : false;
    }

    public final boolean suspends(@NotNull ThreadReferenceProxyImpl thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.assertNotResumed();
        EvaluationContextImpl evaluationContextImpl = this.evaluationContext;
        if (thread == (evaluationContextImpl != null ? evaluationContextImpl.getThreadForEvaluation() : null)) {
            return false;
        }
        return switch (this.getSuspendPolicy()) {
            case 2 -> {
                if (!this.isExplicitlyResumed(thread)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (thread == this.eventThread) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public final boolean isEvaluating() {
        this.assertNotResumed();
        return this.evaluationContext != null;
    }

    public final boolean isResumed() {
        return this.myIsResumed || this.myIsGoingToResume;
    }

    @ApiStatus.Internal
    public final void setIsEvaluating(@Nullable EvaluationContextImpl context) {
        this.assertCanBeUsed();
        this.evaluationContext = context;
    }

    @NotNull
    public String toString() {
        return "{" + this.myDebugId + "} SP=" + this.getSuspendPolicyString() + " " + this.oldToString();
    }

    private final String eventSetAsString() {
        EventSet eventSet = this.myEventSet;
        if (eventSet == null) {
            return "null";
        }
        EventSet eventSet2 = eventSet;
        if (!DebuggerDiagnosticsUtil.needAnonymizedReports()) {
            return eventSet2.toString();
        }
        return "EventSet" + DebuggerDiagnosticsUtil.getEventSetClasses(eventSet2) + " in " + this.eventThread;
    }

    private final String getStackStr() {
        JavaExecutionStack javaExecutionStack = this.myActiveExecutionStack;
        if (javaExecutionStack == null) {
            return "null";
        }
        JavaExecutionStack executionStack = javaExecutionStack;
        return DebuggerDiagnosticsUtil.needAnonymizedReports() ? "Stack in " + this.eventThread : executionStack.toString();
    }

    private final String oldToString() {
        if (this.myEventSet != null) {
            return this.eventSetAsString();
        }
        Object object = this.eventThread;
        if (object == null || (object = ((ThreadReferenceProxyImpl)object).toString()) == null) {
            String string = JavaDebuggerBundle.message((String)"string.null.context", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        return object;
    }

    @NotNull
    public final String toAttachmentString() {
        StringBuilder sb = new StringBuilder();
        sb.append("------------------\ncontext ").append((Object)this).append(":\n");
        sb.append("myDebugId = ").append(this.myDebugId).append("\n");
        sb.append("myThread = ").append(this.eventThread).append("\n");
        sb.append("Suspend policy = ").append(this.getSuspendPolicyString()).append("\n");
        sb.append("myEventSet = ").append(this.eventSetAsString()).append("\n");
        sb.append("myInProgress = ").append(this.myInProgress).append("\n");
        sb.append("myEvaluationContext = ").append((Object)this.evaluationContext).append("\n");
        sb.append("myFrameCount = ").append(this.myFrameCount).append("\n");
        sb.append("myActiveExecutionStack = ").append(this.getStackStr()).append("\n");
        Set<ThreadReferenceProxyImpl> resumedThreads = this.myResumedThreads;
        Iterator<ThreadReferenceProxyImpl> iterator = resumedThreads;
        if (!(iterator == null || iterator.isEmpty())) {
            sb.append("myResumedThreads:\n");
            for (ThreadReferenceProxyImpl thread : resumedThreads) {
                sb.append("  ").append(thread).append("\n");
            }
        }
        if (!this.myNotExecutableThreads.isEmpty()) {
            sb.append("myNotExecutableThreads:\n");
            for (ThreadReferenceProxyImpl thread : this.myNotExecutableThreads) {
                sb.append("  ").append(thread).append("\n");
            }
        }
        sb.append("mySuspendAllSwitchedContext = ").append(this.mySuspendAllSwitchedContext).append("\n");
        sb.append("myPostponedCommands: ").append(this.myPostponedCommands.size()).append("\n");
        sb.append("myKeptReferences: ").append(this.myKeptReferences.size()).append("\n");
        sb.append("myIsVotedForResume = ").append(this.myIsVotedForResume).append("\n");
        sb.append("myVotesToVote = ").append(this.myVotesToVote).append("\n");
        sb.append("myIsResumed = ").append(this.myIsResumed).append("\n");
        sb.append("myIsGoingToResume = ").append(this.myIsGoingToResume).append("\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getSuspendPolicyString() {
        return switch (this.getSuspendPolicy()) {
            case 1 -> "thread";
            case 2 -> "all";
            case 0 -> "none";
            default -> "other";
        };
    }

    public final void keep(@NotNull ObjectReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        boolean added = this.myKeptReferences.add(reference);
        if (added) {
            DebuggerUtilsEx.disableCollection(reference);
        }
    }

    public final void keepAsync(@NotNull ObjectReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        boolean added = this.myKeptReferences.add(reference);
        if (added) {
            DebuggerUtilsAsync.disableCollection(reference);
        }
    }

    public final void postponeCommand(@NotNull SuspendContextCommandImpl command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        if (!this.isResumed()) {
            command2.hold();
            this.myPostponedCommands.add(command2);
        } else {
            command2.notifyCancelled();
        }
    }

    public final void cancelAllPostponed() {
        SuspendContextCommandImpl postponed = this.pollPostponedCommand();
        while (postponed != null) {
            postponed.notifyCancelled();
            postponed = this.pollPostponedCommand();
        }
    }

    @Nullable
    public final SuspendContextCommandImpl pollPostponedCommand() {
        return this.myPostponedCommands.poll();
    }

    @Nullable
    public JavaExecutionStack getActiveExecutionStack() {
        return this.myActiveExecutionStack;
    }

    public final void initExecutionStacks(@Nullable ThreadReferenceProxyImpl activeThread) {
        this.assertCanBeUsed();
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        if (this.eventThread == null) {
            this.setThread(activeThread);
        }
        if (activeThread != null) {
            if (this.mySuspendPolicy == 1 && activeThread != this.eventThread) {
                this.logError("Thread " + activeThread + " was set as active into " + this);
            }
            JavaExecutionStack javaExecutionStack = this.myActiveExecutionStack = new JavaExecutionStack(activeThread, this.myDebugProcess, this.eventThread == activeThread);
            Intrinsics.checkNotNull((Object)((Object)javaExecutionStack));
            javaExecutionStack.initTopFrame();
        }
    }

    public void computeExecutionStacks(@NotNull XSuspendContext.XExecutionStackContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.managerThread.schedule(new SuspendContextCommandImpl(this, container){
            private final HashSet<ThreadReferenceProxyImpl> myAddedThreads;
            final /* synthetic */ SuspendContextImpl this$0;
            final /* synthetic */ XSuspendContext.XExecutionStackContainer $container;
            {
                this.this$0 = $receiver;
                this.$container = $container;
                super($receiver);
                this.myAddedThreads = new HashSet<E>();
            }

            public final HashSet<ThreadReferenceProxyImpl> getMyAddedThreads() {
                return this.myAddedThreads;
            }

            /*
             * WARNING - void declaration
             */
            public void contextAction(SuspendContextImpl suspendContext) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
                List<SuspendContextImpl> list = SuspendContextImpl.access$getMyDebugProcess$p(this.this$0).getSuspendManager().getPausedContexts();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPausedContexts(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ThreadReferenceProxyImpl it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SuspendContextImpl it = (SuspendContextImpl)((Object)element$iv$iv);
                    boolean bl2 = false;
                    if (it.getEventThread() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List pausedThreads = (List)destination$iv$iv;
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(pausedThreads).thenCompose(arg_0 -> computeExecutionStacks.1.contextAction$lambda$2(arg_0 -> computeExecutionStacks.1.contextAction$lambda$1(this, arg_0), arg_0))).thenCompose(arg_0 -> computeExecutionStacks.1.contextAction$lambda$4(arg_0 -> computeExecutionStacks.1.contextAction$lambda$3(suspendContext, arg_0), arg_0))).thenCompose(arg_0 -> computeExecutionStacks.1.contextAction$lambda$6(arg_0 -> computeExecutionStacks.1.contextAction$lambda$5(this, arg_0), arg_0))).exceptionally(computeExecutionStacks.1::contextAction$lambda$7);
            }

            /*
             * WARNING - void declaration
             */
            public final CompletableFuture<Boolean> addThreads(Collection<ThreadReferenceProxyImpl> threads, Comparator<? super JavaExecutionStack> comparator, boolean last) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
                DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
                Iterable iterable = CollectionsKt.filterNotNull((Iterable)threads);
                CompletableFuture[] completableFutureArray = this.$container;
                SuspendContextImpl suspendContextImpl = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var9_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    CompletableFuture<JavaExecutionStack> it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    ThreadReferenceProxyImpl thread = (ThreadReferenceProxyImpl)element$iv$iv;
                    boolean bl2 = false;
                    if (completableFutureArray.isObsolete()) {
                        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                        return completableFuture;
                    }
                    if ((!this.myAddedThreads.add(thread) ? null : JavaExecutionStack.create(thread, SuspendContextImpl.access$getMyDebugProcess$p(suspendContextImpl), thread == suspendContextImpl.getEventThread())) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List futures = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = futures;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
                CompletionStage completionStage = DebuggerUtilsAsync.reschedule(CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length))).thenApply(arg_0 -> computeExecutionStacks.1.addThreads$lambda$10(arg_0 -> computeExecutionStacks.1.addThreads$lambda$9(this.$container, futures, comparator, last, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
                return completionStage;
            }

            private static final CompletionStage contextAction$lambda$1(computeExecutionStacks.1 this$0, List tds) {
                Intrinsics.checkNotNull((Object)tds);
                return this$0.addThreads(tds, SuspendContextImpl.access$getTHREAD_NAME_COMPARATOR$cp(), false);
            }

            private static final CompletionStage contextAction$lambda$2(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final CompletionStage contextAction$lambda$3(SuspendContextImpl $suspendContext, Boolean res) {
                return res != false ? $suspendContext.getVirtualMachineProxy().allThreadsAsync() : CompletableFuture.completedFuture(CollectionsKt.emptyList());
            }

            private static final CompletionStage contextAction$lambda$4(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final CompletionStage contextAction$lambda$5(computeExecutionStacks.1 this$0, Collection tds) {
                Intrinsics.checkNotNull((Object)tds);
                return this$0.addThreads(tds, SuspendContextImpl.access$getTHREADS_SUSPEND_AND_NAME_COMPARATOR$cp(), true);
            }

            private static final CompletionStage contextAction$lambda$6(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final Boolean contextAction$lambda$7(Throwable it) {
                return (Boolean)DebuggerUtilsAsync.logError(it);
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean addThreads$lambda$9(XSuspendContext.XExecutionStackContainer $container, List $futures, Comparator $comparator, boolean $last, Void it) {
                void $this$mapNotNullTo$iv$iv;
                if ($container.isObsolete()) {
                    return true;
                }
                Iterable $this$mapNotNull$iv = $futures;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JavaExecutionStack it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    CompletableFuture it2 = (CompletableFuture)element$iv$iv;
                    boolean bl2 = false;
                    if ((JavaExecutionStack)((Object)it2.join()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List stacks = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)$comparator);
                $container.addExecutionStack(stacks, $last);
                return true;
            }

            private static final Boolean addThreads$lambda$10(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
    }

    private final void logError(String message) {
        this.myDebugProcess.logError(message);
    }

    private final void assertInLog(boolean value, Supplier<String> supplier) {
        if (!value) {
            this.myDebugProcess.logError(supplier.get());
        }
    }

    private static final String setThread$lambda$0(SuspendContextImpl this$0, ThreadReference $thread) {
        return "Invalid thread setting in " + this$0 + ": myThread = " + this$0.eventThread + ", thread = " + $thread;
    }

    private static final String resetThread$lambda$0(SuspendContextImpl this$0) {
        return "Resetting thread during evaluation is not supported: " + this$0;
    }

    private static final String resetThread$lambda$1(SuspendContextImpl this$0) {
        return "Thread should be retested before the active execution stack initialization: " + this$0;
    }

    private static final void resume$lambda$0(ObjectReference $r) {
        DebuggerUtilsEx.enableCollection($r);
    }

    private static final String assertCanBeUsed$lambda$0(SuspendContextImpl this$0) {
        return "Context " + this$0 + " is going to resume.";
    }

    private static final String _set_eventSet_$lambda$0(SuspendContextImpl this$0) {
        return "Event set in " + this$0 + " should be empty";
    }

    private static final String THREAD_NAME_COMPARATOR$lambda$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Boolean SUSPEND_FIRST_COMPARATOR$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ThreadReferenceProxyImpl THREADS_SUSPEND_AND_NAME_COMPARATOR$lambda$0(Function1 $tmp0, Object p0) {
        return (ThreadReferenceProxyImpl)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DebugProcessImpl access$getMyDebugProcess$p(SuspendContextImpl $this) {
        return $this.myDebugProcess;
    }

    public static final /* synthetic */ Comparator access$getTHREAD_NAME_COMPARATOR$cp() {
        return THREAD_NAME_COMPARATOR;
    }

    public static final /* synthetic */ Comparator access$getTHREADS_SUSPEND_AND_NAME_COMPARATOR$cp() {
        return THREADS_SUSPEND_AND_NAME_COMPARATOR;
    }

    public static final /* synthetic */ void access$setMyFrameCount$p(SuspendContextImpl $this, int n) {
        $this.myFrameCount = n;
    }

    static {
        Logger logger = Logger.getInstance(SuspendContextImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> SuspendContextImpl.THREAD_NAME_COMPARATOR$lambda$0(Companion.THREAD_NAME_COMPARATOR.1.INSTANCE, arg_0), String.CASE_INSENSITIVE_ORDER);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        THREAD_NAME_COMPARATOR = comparator;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> SuspendContextImpl.SUSPEND_FIRST_COMPARATOR$lambda$0(Companion.SUSPEND_FIRST_COMPARATOR.1.INSTANCE, arg_0)).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"reversed(...)");
        SUSPEND_FIRST_COMPARATOR = comparator2;
        Comparator<JavaExecutionStack> comparator3 = Comparator.comparing(arg_0 -> SuspendContextImpl.THREADS_SUSPEND_AND_NAME_COMPARATOR$lambda$0(Companion.THREADS_SUSPEND_AND_NAME_COMPARATOR.1.INSTANCE, arg_0), SUSPEND_FIRST_COMPARATOR).thenComparing(THREAD_NAME_COMPARATOR);
        Intrinsics.checkNotNullExpressionValue(comparator3, (String)"thenComparing(...)");
        THREADS_SUSPEND_AND_NAME_COMPARATOR = comparator3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\bj\b\u0012\u0004\u0012\u00020\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/engine/SuspendContextImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "THREAD_NAME_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/debugger/engine/JavaExecutionStack;", "Lkotlin/Comparator;", "SUSPEND_FIRST_COMPARATOR", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "THREADS_SUSPEND_AND_NAME_COMPARATOR", "intellij.java.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

