/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.DebuggerComputableValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluationContextImpl
extends UserDataHolderBase
implements EvaluationContext {
    private final DebuggerComputableValue myThisObject;
    @NotNull
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses;
    private ClassLoaderReference myClassLoader;
    @Nullable
    private ThreadReferenceProxyImpl myThreadForEvaluation;
    @Nullable
    private ThreadReferenceProxyImpl myPreferableThread;
    private boolean myMayRetryEvaluation;

    private EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull DebuggerComputableValue thisObjectComputableValue) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(0);
        }
        if (thisObjectComputableValue == null) {
            EvaluationContextImpl.$$$reportNull$$$0(1);
        }
        this.myAutoLoadClasses = true;
        this.myThreadForEvaluation = null;
        this.myPreferableThread = null;
        this.myMayRetryEvaluation = false;
        this.myThisObject = thisObjectComputableValue;
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull EvaluatingComputable<? extends Value> thisObjectFactory) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(2);
        }
        if (thisObjectFactory == null) {
            EvaluationContextImpl.$$$reportNull$$$0(3);
        }
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObjectFactory));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @Nullable Value thisObject) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(4);
        }
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObject));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        if (suspendContext == null) {
            EvaluationContextImpl.$$$reportNull$$$0(5);
        }
        this(suspendContext, frameProxy, () -> frameProxy != null ? frameProxy.thisObject() : null);
    }

    @Nullable
    public Value computeThisObject() throws EvaluateException {
        return this.myThisObject.getValue();
    }

    @NotNull
    public SuspendContextImpl getSuspendContext() {
        SuspendContextImpl suspendContextImpl = this.mySuspendContext;
        if (suspendContextImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(6);
        }
        return suspendContextImpl;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.mySuspendContext.getVirtualMachineProxy();
        if (virtualMachineProxyImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(7);
        }
        return virtualMachineProxyImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.getSuspendContext().getDebugProcess();
        if (debugProcessImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(8);
        }
        return debugProcessImpl;
    }

    @NotNull
    public DebuggerManagerThreadImpl getManagerThread() {
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = this.getSuspendContext().getManagerThread();
        if (debuggerManagerThreadImpl == null) {
            EvaluationContextImpl.$$$reportNull$$$0(9);
        }
        return debuggerManagerThreadImpl;
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess.getProject();
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        this.copyUserDataTo(copy);
        return copy;
    }

    @Nullable
    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public void setClassLoader(ClassLoaderReference classLoader) {
        this.myClassLoader = classLoader;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }

    @ApiStatus.Internal
    @Nullable
    public ThreadReferenceProxyImpl getThreadForEvaluation() {
        return this.myThreadForEvaluation;
    }

    @ApiStatus.Internal
    public void setThreadForEvaluation(@Nullable ThreadReferenceProxyImpl threadForEvaluation) {
        if (threadForEvaluation != null) {
            assert (this.myThreadForEvaluation == null);
            assert (!this.mySuspendContext.isEvaluating());
            assert (!threadForEvaluation.isEvaluating());
            threadForEvaluation.setEvaluating(true);
            this.mySuspendContext.setIsEvaluating(this);
        } else {
            assert (this.myThreadForEvaluation != null);
            assert (this.myThreadForEvaluation.isEvaluating());
            assert (this.mySuspendContext.getEvaluationContext() == this);
            this.mySuspendContext.setIsEvaluating(null);
            this.myThreadForEvaluation.setEvaluating(false);
        }
        this.myThreadForEvaluation = threadForEvaluation;
        if (threadForEvaluation != null && this.myFrameProxy != null) {
            this.myPreferableThread = this.myFrameProxy.threadProxy();
        }
    }

    public EvaluationContextImpl withAutoLoadClasses(boolean autoLoadClasses) {
        if (this.myAutoLoadClasses == autoLoadClasses) {
            return this;
        }
        EvaluationContextImpl copy = new EvaluationContextImpl(this.mySuspendContext, this.myFrameProxy, this.myThisObject);
        copy.setAutoLoadClasses(autoLoadClasses);
        this.copyUserDataTo(copy);
        return copy;
    }

    public void keep(Value value) {
        if (value instanceof ObjectReference) {
            this.getSuspendContext().keep((ObjectReference)value);
        }
    }

    public <T extends Value> T computeAndKeep(@NotNull ThrowableComputable<T, EvaluateException> computable) throws EvaluateException {
        if (computable == null) {
            EvaluationContextImpl.$$$reportNull$$$0(10);
        }
        return (T)((Value)DebuggerUtils.getInstance().processCollectibleValue(computable, value -> {
            this.keep((Value)value);
            return value;
        }, (EvaluationContext)this));
    }

    public boolean isEvaluationPossible() {
        return this.getSuspendContext().getDebugProcess().isEvaluationPossible(this.getSuspendContext());
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        if (this.myPreferableThread == this.myThreadForEvaluation) {
            String string = "Evaluating on " + String.valueOf(this.myPreferableThread) + " for " + String.valueOf((Object)this.mySuspendContext);
            if (string == null) {
                EvaluationContextImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = "Evaluating requested on " + String.valueOf(this.myPreferableThread) + ", started on " + String.valueOf(this.myThreadForEvaluation) + " for " + String.valueOf((Object)this.mySuspendContext);
        if (string == null) {
            EvaluationContextImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @ApiStatus.Internal
    public boolean isMayRetryEvaluation() {
        return this.myMayRetryEvaluation;
    }

    @ApiStatus.Internal
    public void setMayRetryEvaluation(boolean mayRetryEvaluation) {
        this.myMayRetryEvaluation = mayRetryEvaluation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObjectComputableValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObjectFactory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/EvaluationContextImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/EvaluationContextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachineProxy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagerThread";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeAndKeep";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }
}

