/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.AdditionalContextElement;
import com.intellij.debugger.engine.evaluation.AdditionalContextProvider;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssertStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CaptureTraverser;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DeconstructionPatternEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionListEvaluator;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PatternEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PatternLabelEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SwitchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThrowEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TryEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.codeserver.highlighting.JavaErrorCollector;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethodObject.LightMethodObjectExtractedData;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl ourInstance = new EvaluatorBuilderImpl();

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return ourInstance;
    }

    @NotNull
    public static ExpressionEvaluator build(TextWithImports text, @Nullable PsiElement contextElement, @Nullable SourcePosition position, @NotNull Project project) throws EvaluateException {
        CodeFragmentFactory factory;
        PsiCodeFragment codeFragment;
        if (project == null) {
            EvaluatorBuilderImpl.$$$reportNull$$$0(0);
        }
        if ((codeFragment = (factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, contextElement)).createPsiCodeFragment(text, contextElement, project)) == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{text.getText()}));
        }
        DebuggerUtils.checkSyntax((PsiCodeFragment)codeFragment);
        ExpressionEvaluator expressionEvaluator = factory.getEvaluatorBuilder().build((PsiElement)codeFragment, position);
        if (expressionEvaluator == null) {
            EvaluatorBuilderImpl.$$$reportNull$$$0(1);
        }
        return expressionEvaluator;
    }

    @NotNull
    public ExpressionEvaluator build(PsiElement codeFragment, SourcePosition position) throws EvaluateException {
        ExpressionEvaluator expressionEvaluator = new Builder(position).buildElement(codeFragment);
        if (expressionEvaluator == null) {
            EvaluatorBuilderImpl.$$$reportNull$$$0(2);
        }
        return expressionEvaluator;
    }

    private static void processBoxingConversions(PsiParameter[] declaredParams, PsiExpression[] actualArgumentExpressions, PsiSubstitutor methodResolveSubstitutor, Evaluator[] argumentEvaluators) {
        if (declaredParams.length > 0) {
            int paramCount = Math.max(declaredParams.length, actualArgumentExpressions.length);
            PsiType varargType = null;
            for (int idx = 0; idx < paramCount && idx < actualArgumentExpressions.length; ++idx) {
                PsiType actualArgType;
                PsiType declaredParamType;
                if (idx < declaredParams.length) {
                    declaredParamType = methodResolveSubstitutor.substitute(declaredParams[idx].getType());
                    if (declaredParamType instanceof PsiEllipsisType) {
                        declaredParamType = varargType = ((PsiEllipsisType)declaredParamType).getComponentType();
                    }
                } else {
                    if (varargType == null) break;
                    declaredParamType = varargType;
                }
                if (!TypeConversionUtil.boxingConversionApplicable((PsiType)declaredParamType, (PsiType)(actualArgType = actualArgumentExpressions[idx].getType())) && (declaredParamType == null || actualArgType != null)) continue;
                Evaluator argEval = argumentEvaluators[idx];
                argumentEvaluators[idx] = declaredParamType instanceof PsiPrimitiveType ? new UnBoxingEvaluator(argEval) : new BoxingEvaluator(argEval);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class Builder
    extends JavaElementVisitor {
        private static final Logger LOG = Logger.getInstance(EvaluatorBuilderImpl.class);
        private Evaluator myResult = null;
        private PsiClass myContextPsiClass;
        private CodeFragmentEvaluator myCurrentFragmentEvaluator;
        private final Set<JavaCodeFragment> myVisitedFragments = new HashSet<JavaCodeFragment>();
        @Nullable
        private final PsiClass myPositionPsiClass;
        @Nullable
        private final PsiElement myPositionPsiElement;

        private Builder(@Nullable SourcePosition position) {
            this.myPositionPsiElement = position != null ? position.getElementAt() : null;
            this.myPositionPsiClass = JVMNameUtil.getClassAt(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            if (codeFragment == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myVisitedFragments.add(codeFragment);
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                for (PsiElement child = codeFragment.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept((PsiElementVisitor)this);
                    if (this.myResult != null) {
                        evaluators.add(this.myResult);
                    }
                    this.myResult = null;
                }
                this.myCurrentFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[0]));
                this.myResult = this.myCurrentFragmentEvaluator;
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                Builder.$$$reportNull$$$0(1);
            }
            throw Builder.expressionInvalid((PsiElement)element);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            PsiExpression rExpression;
            if (expression == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if ((rExpression = expression.getRExpression()) == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            rExpression.accept((PsiElementVisitor)this);
            Evaluator rEvaluator = this.myResult;
            PsiExpression lExpression = expression.getLExpression();
            PsiType lType = lExpression.getType();
            if (lType == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{lExpression.getText()}));
            }
            IElementType assignmentType = expression.getOperationTokenType();
            boolean compoundAssignment = assignmentType != JavaTokenType.EQ;
            PsiType rType = rExpression.getType();
            if (!compoundAssignment && !TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)rExpression) && rType != null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{expression.getOperationSign().getText()}));
            }
            lExpression.accept((PsiElementVisitor)this);
            Evaluator lEvaluator = this.myResult;
            if (compoundAssignment) {
                IElementType opType = TypeConversionUtil.convertEQtoOperation((IElementType)assignmentType);
                PsiType typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true);
                if (typeForBinOp == null || rType == null) {
                    throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
                }
                if (!TypeConversionUtil.areTypesConvertible((PsiType)typeForBinOp, (PsiType)lType)) {
                    throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{expression.getOperationSign().getText()}));
                }
                rEvaluator = Builder.createBinaryEvaluator(lEvaluator, lType, rEvaluator, rType, opType, typeForBinOp);
            }
            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(lType, rType, rEvaluator, expression.getProject());
            this.myResult = new AssignmentEvaluator(lEvaluator, rEvaluator);
        }

        private static Evaluator handleAssignmentBoxingAndPrimitiveTypeConversions(PsiType lType, PsiType rType, Evaluator rEvaluator, Project project) {
            PsiClassType rightBoxed;
            PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
            if (unboxedLType != null) {
                if (rType instanceof PsiPrimitiveType && !PsiTypes.nullType().equals(rType)) {
                    if (!rType.equals(unboxedLType)) {
                        rEvaluator = Builder.createTypeCastEvaluator(rEvaluator, (PsiType)unboxedLType);
                    }
                    rEvaluator = new BoxingEvaluator(rEvaluator);
                }
            } else if (lType instanceof PsiPrimitiveType) {
                PsiPrimitiveType unboxedRType;
                PsiPrimitiveType _rType;
                if (rType instanceof PsiClassType) {
                    rEvaluator = new UnBoxingEvaluator(rEvaluator);
                }
                Object object = _rType = (unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType)) != null ? unboxedRType : rType;
                if (_rType instanceof PsiPrimitiveType && !PsiTypes.nullType().equals(_rType) && !lType.equals(_rType)) {
                    rEvaluator = Builder.createTypeCastEvaluator(rEvaluator, lType);
                }
            } else if (lType instanceof PsiClassType && rType instanceof PsiPrimitiveType && !PsiTypes.nullType().equals(rType) && (rightBoxed = ((PsiPrimitiveType)rType).getBoxedType(PsiManager.getInstance((Project)project), ((PsiClassType)lType).getResolveScope())) != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rightBoxed)) {
                rEvaluator = new BoxingEvaluator(rEvaluator);
            }
            return rEvaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(3);
            }
            if (statement.getResourceList() != null) {
                throw Builder.unsupportedExpression("'try-with-resources' statement is not supported");
            }
            Evaluator bodyEvaluator = this.accept((PsiElement)statement.getTryBlock());
            if (bodyEvaluator != null) {
                PsiCatchSection[] catchSections = statement.getCatchSections();
                ArrayList<CatchEvaluator> evaluators = new ArrayList<CatchEvaluator>();
                for (PsiCatchSection catchSection : catchSections) {
                    PsiParameter parameter = catchSection.getParameter();
                    PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                    if (parameter == null || catchBlock == null) continue;
                    CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
                    try {
                        this.myCurrentFragmentEvaluator.setInitialValue(parameter.getName(), null);
                        this.myCurrentFragmentEvaluator.setStatements(this.visitStatements(catchBlock.getStatements()));
                        PsiType type = parameter.getType();
                        List types = type instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type).getDisjunctions() : Collections.singletonList(type);
                        for (PsiType psiType : types) {
                            evaluators.add(new CatchEvaluator(psiType.getCanonicalText(), parameter.getName(), this.myCurrentFragmentEvaluator));
                        }
                    }
                    finally {
                        this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
                    }
                }
                this.myResult = new TryEvaluator(bodyEvaluator, evaluators, this.accept((PsiElement)statement.getFinallyBlock()));
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            Evaluator accept;
            if (statement == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if ((accept = this.accept((PsiElement)statement.getException())) != null) {
                this.myResult = new ThrowEvaluator(accept);
            }
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myResult = new ReturnEvaluator(this.accept((PsiElement)statement.getReturnValue()));
        }

        public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myResult = new SwitchEvaluator.YieldEvaluator(this.accept((PsiElement)statement.getExpression()));
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(7);
            }
            throw Builder.unsupportedExpression("'synchronized' statement is not supported");
        }

        public void visitStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(8);
            }
            LOG.error(JavaDebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement.getText()}));
            throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{statement.getText()}));
        }

        private CodeFragmentEvaluator setNewCodeFragmentEvaluator() {
            CodeFragmentEvaluator old = this.myCurrentFragmentEvaluator;
            this.myCurrentFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
            return old;
        }

        private Evaluator[] visitStatements(PsiStatement[] statements) {
            ArrayList<Evaluator> evaluators = new ArrayList<Evaluator>();
            for (PsiStatement psiStatement : statements) {
                psiStatement.accept((PsiElementVisitor)this);
                if (this.myResult != null) {
                    evaluators.add(DisableGC.create(this.myResult));
                }
                this.myResult = null;
            }
            return evaluators.toArray(new Evaluator[0]);
        }

        public void visitCodeBlock(@NotNull PsiCodeBlock block) {
            if (block == null) {
                Builder.$$$reportNull$$$0(9);
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                this.myResult = new BlockStatementEvaluator(this.visitStatements(block.getStatements()));
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        public void visitBlockStatement(@NotNull PsiBlockStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.visitCodeBlock(statement.getCodeBlock());
        }

        public void visitLabeledStatement(@NotNull PsiLabeledStatement labeledStatement) {
            PsiStatement statement;
            if (labeledStatement == null) {
                Builder.$$$reportNull$$$0(11);
            }
            if ((statement = labeledStatement.getStatement()) != null) {
                statement.accept((PsiElementVisitor)this);
            }
        }

        private static String getLabel(PsiElement element) {
            String label = null;
            if (element.getParent() instanceof PsiLabeledStatement) {
                label = ((PsiLabeledStatement)element.getParent()).getName();
            }
            return label;
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(12);
            }
            Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
            Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
            if (conditionEvaluator != null) {
                this.myResult = new DoWhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(13);
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
                Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
                if (conditionEvaluator != null) {
                    this.myResult = new WhileStatementEvaluator(new UnBoxingEvaluator(conditionEvaluator), bodyEvaluator, Builder.getLabel((PsiElement)statement));
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(14);
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                Evaluator initializerEvaluator = this.accept((PsiElement)statement.getInitialization());
                Evaluator conditionEvaluator = this.accept((PsiElement)statement.getCondition());
                if (conditionEvaluator != null) {
                    conditionEvaluator = new UnBoxingEvaluator(conditionEvaluator);
                }
                Evaluator updateEvaluator = this.accept((PsiElement)statement.getUpdate());
                Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
                if (bodyEvaluator != null) {
                    this.myResult = new ForStatementEvaluator(initializerEvaluator, conditionEvaluator, updateEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement));
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(15);
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                PsiParameter parameter = statement.getIterationParameter();
                String iterationParameterName = parameter.getName();
                this.myCurrentFragmentEvaluator.setInitialValue(iterationParameterName, null);
                SyntheticVariableEvaluator iterationParameterEvaluator = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, iterationParameterName, null);
                Evaluator iteratedValueEvaluator = this.accept((PsiElement)statement.getIteratedValue());
                Evaluator bodyEvaluator = this.accept((PsiElement)statement.getBody());
                if (bodyEvaluator != null) {
                    this.myResult = new ForeachStatementEvaluator(iterationParameterEvaluator, iteratedValueEvaluator, bodyEvaluator, Builder.getLabel((PsiElement)statement));
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        @Nullable
        private Evaluator accept(@Nullable PsiElement element) {
            if (element == null || element instanceof PsiEmptyStatement) {
                return null;
            }
            element.accept((PsiElementVisitor)this);
            return this.myResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(16);
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                PsiExpression condition;
                PsiStatement thenBranch = statement.getThenBranch();
                if (thenBranch == null) {
                    return;
                }
                thenBranch.accept((PsiElementVisitor)this);
                Evaluator thenEvaluator = this.myResult;
                PsiStatement elseBranch = statement.getElseBranch();
                Evaluator elseEvaluator = null;
                if (elseBranch != null) {
                    elseBranch.accept((PsiElementVisitor)this);
                    elseEvaluator = this.myResult;
                }
                if ((condition = statement.getCondition()) == null) {
                    return;
                }
                condition.accept((PsiElementVisitor)this);
                this.myResult = new IfStatementEvaluator(new UnBoxingEvaluator(this.myResult), thenEvaluator, elseEvaluator);
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        private void visitSwitchBlock(PsiSwitchBlock statement) {
            Evaluator expressionEvaluator;
            PsiCodeBlock body = statement.getBody();
            if (body != null && (expressionEvaluator = this.accept((PsiElement)statement.getExpression())) != null) {
                this.myResult = new SwitchEvaluator(expressionEvaluator, this.visitStatements(body.getStatements()), Builder.getLabel((PsiElement)statement));
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(18);
            }
            this.visitSwitchBlock((PsiSwitchBlock)expression);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void visitSwitchLabelStatementBase(PsiSwitchLabelStatementBase statement) {
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                SmartList evaluators = new SmartList();
                PsiCaseLabelElementList labelElementList = statement.getCaseLabelElementList();
                boolean defaultCase = statement.isDefaultCase();
                if (labelElementList != null) {
                    for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                        if (labelElement instanceof PsiDefaultCaseLabelElement) {
                            defaultCase = true;
                            continue;
                        }
                        if (labelElement instanceof PsiPattern) {
                            PsiPattern pattern = (PsiPattern)labelElement;
                            PatternLabelEvaluator evaluator = this.getPatternLabelEvaluator(pattern);
                            if (evaluator == null) continue;
                            evaluators.add(evaluator);
                            continue;
                        }
                        Evaluator evaluator = this.accept((PsiElement)labelElement);
                        if (evaluator == null) continue;
                        evaluators.add(evaluator);
                    }
                }
                Evaluator guardEvaluator = this.accept((PsiElement)statement.getGuardExpression());
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
                    this.myResult = new SwitchEvaluator.SwitchCaseRuleEvaluator((List<? extends Evaluator>)evaluators, guardEvaluator, defaultCase, this.accept((PsiElement)rule.getBody()));
                } else {
                    this.myResult = new SwitchEvaluator.SwitchCaseEvaluator((List<? extends Evaluator>)evaluators, guardEvaluator, defaultCase);
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        @Nullable
        private PatternLabelEvaluator getPatternLabelEvaluator(@NotNull PsiPattern element) {
            PsiSwitchBlock switchBlock;
            if (element == null) {
                Builder.$$$reportNull$$$0(19);
            }
            if ((switchBlock = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSwitchBlock.class)) == null) {
                return null;
            }
            PsiExpression selector = switchBlock.getExpression();
            if (selector == null) {
                return null;
            }
            selector.accept((PsiElementVisitor)this);
            Evaluator selectorEvaluator = this.myResult;
            PsiPrimaryPattern primaryPattern = JavaPsiPatternUtil.getTypedPattern((PsiCaseLabelElement)element);
            PatternEvaluator patternEvaluator = this.createPatternEvaluator((PsiPattern)primaryPattern);
            if (patternEvaluator == null) {
                return null;
            }
            return new PatternLabelEvaluator(selectorEvaluator, patternEvaluator);
        }

        public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(20);
            }
            this.visitSwitchLabelStatementBase((PsiSwitchLabelStatementBase)statement);
        }

        public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(21);
            }
            this.visitSwitchLabelStatementBase((PsiSwitchLabelStatementBase)statement);
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            PsiIdentifier labelIdentifier;
            if (statement == null) {
                Builder.$$$reportNull$$$0(22);
            }
            this.myResult = BreakContinueStatementEvaluator.createBreakEvaluator((labelIdentifier = statement.getLabelIdentifier()) != null ? labelIdentifier.getText() : null);
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            PsiIdentifier labelIdentifier;
            if (statement == null) {
                Builder.$$$reportNull$$$0(23);
            }
            this.myResult = BreakContinueStatementEvaluator.createContinueEvaluator((labelIdentifier = statement.getLabelIdentifier()) != null ? labelIdentifier.getText() : null);
        }

        public void visitExpressionListStatement(@NotNull PsiExpressionListStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(24);
            }
            this.myResult = new ExpressionListEvaluator(ContainerUtil.mapNotNull((Object[])statement.getExpressionList().getExpressions(), this::accept));
        }

        public void visitEmptyStatement(@NotNull PsiEmptyStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(25);
            }
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                Builder.$$$reportNull$$$0(26);
            }
            statement.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(27);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitExpression " + String.valueOf(expression));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression wideExpression) {
            if (wideExpression == null) {
                Builder.$$$reportNull$$$0(28);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitPolyadicExpression " + String.valueOf(wideExpression));
            }
            CodeFragmentEvaluator oldFragmentEvaluator = this.setNewCodeFragmentEvaluator();
            try {
                PsiExpression[] operands = wideExpression.getOperands();
                operands[0].accept((PsiElementVisitor)this);
                Evaluator result = this.myResult;
                PsiType lType = operands[0].getType();
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression expression = operands[i];
                    if (expression == null) {
                        throw Builder.expressionInvalid((PsiElement)wideExpression);
                    }
                    expression.accept((PsiElementVisitor)this);
                    Evaluator rResult = this.myResult;
                    IElementType opType = wideExpression.getOperationTokenType();
                    PsiType rType = expression.getType();
                    if (rType == null) {
                        throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
                    }
                    PsiType typeForBinOp = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opType, (boolean)true);
                    if (typeForBinOp == null) {
                        throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{wideExpression.getText()}));
                    }
                    this.myResult = Builder.createBinaryEvaluator(result, lType, rResult, rType, opType, typeForBinOp);
                    lType = typeForBinOp;
                    result = this.myResult;
                }
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        private static Evaluator createBinaryEvaluator(Evaluator lResult, PsiType lType, Evaluator rResult, @NotNull PsiType rType, @NotNull IElementType operation, @NotNull PsiType expressionExpectedType) {
            if (rType == null) {
                Builder.$$$reportNull$$$0(29);
            }
            if (operation == null) {
                Builder.$$$reportNull$$$0(30);
            }
            if (expressionExpectedType == null) {
                Builder.$$$reportNull$$$0(31);
            }
            if (Builder.isUnboxingInBinaryExpressionApplicable(lType, rType, operation)) {
                if (rType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(rType.getCanonicalText())) {
                    rResult = new UnBoxingEvaluator(rResult);
                }
                if (lType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(lType.getCanonicalText())) {
                    lResult = new UnBoxingEvaluator(lResult);
                }
            }
            if (Builder.isBinaryNumericPromotionApplicable(lType, rType, operation)) {
                PsiType _lType = lType;
                PsiPrimitiveType unboxedLType = PsiPrimitiveType.getUnboxedType((PsiType)lType);
                if (unboxedLType != null) {
                    _lType = unboxedLType;
                }
                PsiType _rType = rType;
                PsiPrimitiveType unboxedRType = PsiPrimitiveType.getUnboxedType((PsiType)rType);
                if (unboxedRType != null) {
                    _rType = unboxedRType;
                }
                if (PsiTypes.doubleType().equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiTypes.doubleType())) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiTypes.doubleType());
                    }
                } else if (PsiTypes.doubleType().equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiTypes.doubleType())) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiTypes.doubleType());
                    }
                } else if (PsiTypes.floatType().equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiTypes.floatType())) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiTypes.floatType());
                    }
                } else if (PsiTypes.floatType().equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiTypes.floatType())) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiTypes.floatType());
                    }
                } else if (PsiTypes.longType().equals((Object)_lType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiTypes.longType())) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiTypes.longType());
                    }
                } else if (PsiTypes.longType().equals((Object)_rType)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiTypes.longType())) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiTypes.longType());
                    }
                } else {
                    if (!PsiTypes.intType().equals((Object)_lType) && TypeConversionUtil.areTypesConvertible((PsiType)_lType, (PsiType)PsiTypes.intType())) {
                        lResult = Builder.createTypeCastEvaluator(lResult, (PsiType)PsiTypes.intType());
                    }
                    if (!PsiTypes.intType().equals((Object)_rType) && TypeConversionUtil.areTypesConvertible((PsiType)_rType, (PsiType)PsiTypes.intType())) {
                        rResult = Builder.createTypeCastEvaluator(rResult, (PsiType)PsiTypes.intType());
                    }
                }
            } else if (ElementType.SHIFT_OPS.contains(operation)) {
                lResult = Builder.handleUnaryNumericPromotion(lType, lResult);
                rResult = Builder.handleUnaryNumericPromotion(rType, rResult);
            }
            return DisableGC.create(new BinaryExpressionEvaluator(lResult, rResult, operation, expressionExpectedType.getCanonicalText()));
        }

        private static boolean isBinaryNumericPromotionApplicable(PsiType lType, PsiType rType, IElementType opType) {
            if (lType == null || rType == null) {
                return false;
            }
            if (!TypeConversionUtil.isNumericType((PsiType)lType) || !TypeConversionUtil.isNumericType((PsiType)rType)) {
                return false;
            }
            if (opType == JavaTokenType.EQEQ || opType == JavaTokenType.NE) {
                if (PsiTypes.nullType().equals(lType) || PsiTypes.nullType().equals(rType)) {
                    return false;
                }
                if (lType instanceof PsiClassType && rType instanceof PsiClassType) {
                    return false;
                }
                if (lType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)lType) != null;
                }
                if (rType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)rType) != null;
                }
                return true;
            }
            return opType == JavaTokenType.ASTERISK || opType == JavaTokenType.DIV || opType == JavaTokenType.PERC || opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.LT || opType == JavaTokenType.LE || opType == JavaTokenType.GT || opType == JavaTokenType.GE || opType == JavaTokenType.AND || opType == JavaTokenType.XOR || opType == JavaTokenType.OR;
        }

        private static boolean isUnboxingInBinaryExpressionApplicable(PsiType lType, PsiType rType, IElementType opCode) {
            if (PsiTypes.nullType().equals(lType) || PsiTypes.nullType().equals(rType)) {
                return false;
            }
            if (opCode == JavaTokenType.EQEQ || opCode == JavaTokenType.NE) {
                return lType instanceof PsiPrimitiveType && rType instanceof PsiClassType || lType instanceof PsiClassType && rType instanceof PsiPrimitiveType;
            }
            if (opCode == JavaTokenType.PLUS && (lType instanceof PsiClassType && lType.equalsToText("java.lang.String") || rType instanceof PsiClassType && rType.equalsToText("java.lang.String"))) {
                return false;
            }
            return lType instanceof PsiClassType || rType instanceof PsiClassType;
        }

        @Nullable
        private static PsiType calcUnaryNumericPromotionType(PsiPrimitiveType type) {
            if (PsiTypes.byteType().equals((Object)type) || PsiTypes.shortType().equals((Object)type) || PsiTypes.charType().equals((Object)type) || PsiTypes.intType().equals((Object)type)) {
                return PsiTypes.intType();
            }
            return null;
        }

        public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
            PsiElement[] declaredElements;
            if (statement == null) {
                Builder.$$$reportNull$$$0(32);
            }
            ArrayList<AssignmentEvaluator> evaluators = new ArrayList<AssignmentEvaluator>();
            for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
                if (declaredElement instanceof PsiLocalVariable) {
                    PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
                    if (this.myCurrentFragmentEvaluator != null) {
                        PsiType lType = localVariable.getType();
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)localVariable.getProject());
                        try {
                            PsiExpression initialValue = elementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)lType), null);
                            Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)initialValue, (boolean)true);
                            this.myCurrentFragmentEvaluator.setInitialValue(localVariable.getName(), value);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        PsiExpression initializer = localVariable.getInitializer();
                        if (initializer == null) continue;
                        try {
                            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)initializer)) {
                                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{localVariable.getName()}));
                            }
                            PsiType rType = initializer.getType();
                            initializer.accept((PsiElementVisitor)this);
                            Evaluator rEvaluator = this.myResult;
                            PsiExpression localVarReference = elementFactory.createExpressionFromText(localVariable.getName(), (PsiElement)initializer);
                            localVarReference.accept((PsiElementVisitor)this);
                            Evaluator lEvaluator = this.myResult;
                            rEvaluator = Builder.handleAssignmentBoxingAndPrimitiveTypeConversions(localVarReference.getType(), rType, rEvaluator, statement.getProject());
                            AssignmentEvaluator assignment = new AssignmentEvaluator(lEvaluator, rEvaluator);
                            evaluators.add(assignment);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{declaredElement.getText()}), null));
            }
            if (!evaluators.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.myCurrentFragmentEvaluator);
                codeFragmentEvaluator.setStatements(evaluators.toArray(new Evaluator[0]));
                this.myResult = codeFragmentEvaluator;
            } else {
                this.myResult = null;
            }
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                Builder.$$$reportNull$$$0(33);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitConditionalExpression " + String.valueOf(expression));
            }
            if ((expectedType = expression.getType()) == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (thenExpression == null || elseExpression == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            PsiExpression condition = expression.getCondition();
            condition.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                throw Builder.expressionInvalid((PsiElement)condition);
            }
            UnBoxingEvaluator conditionEvaluator = new UnBoxingEvaluator(this.myResult);
            thenExpression.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                throw Builder.expressionInvalid((PsiElement)thenExpression);
            }
            Evaluator thenEvaluator = this.myResult;
            elseExpression.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                throw Builder.expressionInvalid((PsiElement)elseExpression);
            }
            Evaluator elseEvaluator = this.myResult;
            this.myResult = new ConditionalExpressionEvaluator(conditionEvaluator, thenEvaluator, elseEvaluator);
            if (expectedType instanceof PsiPrimitiveType) {
                this.myResult = new UnBoxingEvaluator(this.myResult);
            }
            this.myResult = Builder.createTypeCastEvaluator(this.myResult, expectedType);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(34);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitReferenceExpression " + String.valueOf(expression));
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            JavaResolveResult resolveResult = expression.advancedResolve(true);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
                final AdditionalContextElement contextElement = (AdditionalContextElement)element.getUserData(AdditionalContextProvider.getADDITIONAL_CONTEXT_ELEMENT_KEY());
                if (contextElement != null) {
                    this.myResult = new Evaluator(){

                        @Override
                        public Object evaluate(EvaluationContextImpl context) {
                            return contextElement.getValue().invoke((Object)context);
                        }
                    };
                    return;
                }
                Value labeledValue = (Value)element.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                if (labeledValue != null) {
                    this.myResult = new IdentityEvaluator(labeledValue);
                    return;
                }
                PsiVariable psiVar = (PsiVariable)element;
                String localName = psiVar.getName();
                PsiFile containingFile = element.getContainingFile();
                if (this.myCurrentFragmentEvaluator != null && (containingFile instanceof PsiCodeFragment && this.myVisitedFragments.contains(containingFile) || this.myCurrentFragmentEvaluator.hasValue(localName))) {
                    JVMName jvmName = JVMNameUtil.getJVMQualifiedName(CompilingEvaluatorTypesUtil.getVariableType((PsiVariable)element));
                    this.myResult = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, localName, jvmName);
                    return;
                }
                PsiClass variableClass = this.getContainingClass(psiVar);
                PsiClass positionClass = this.getPositionClass();
                if (Objects.equals(positionClass, variableClass)) {
                    PsiElement method = DebuggerUtilsEx.getContainingMethod((PsiElement)(this.myPositionPsiElement != null ? this.myPositionPsiElement : expression));
                    boolean canScanFrames = method instanceof PsiLambdaExpression || ContextUtil.isJspImplicit(element);
                    this.myResult = new LocalVariableEvaluator(localName, canScanFrames);
                    return;
                }
                CaptureTraverser traverser = this.createTraverser((PsiElement)variableClass, "Base class not found for " + psiVar.getName(), false).oneLevelLess();
                if (traverser.isValid()) {
                    Object value;
                    PsiExpression initializer = psiVar.getInitializer();
                    if (initializer != null && (value = JavaPsiFacade.getInstance((Project)psiVar.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) != null) {
                        PsiType type = resolveResult.getSubstitutor().substitute(psiVar.getType());
                        this.myResult = new LiteralEvaluator(value, type.getCanonicalText());
                        return;
                    }
                    ThisEvaluator objectEvaluator = new ThisEvaluator(traverser);
                    this.myResult = Builder.createFallbackEvaluator(new FieldEvaluator(objectEvaluator, FieldEvaluator.createClassFilter(positionClass), "val$" + localName), new LocalVariableEvaluator(localName, true));
                    return;
                }
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{localName}));
            }
            if (element instanceof PsiField) {
                Evaluator objectEvaluator;
                PsiField psiField = (PsiField)element;
                PsiClass fieldClass = psiField.getContainingClass();
                if (fieldClass == null) {
                    throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                }
                if (psiField.hasModifierProperty("static")) {
                    JVMName className = JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField));
                    if (className == null) {
                        className = JVMNameUtil.getJVMQualifiedName(fieldClass);
                    }
                    objectEvaluator = new TypeEvaluator(className);
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else {
                    CaptureTraverser traverser = this.createTraverser((PsiElement)fieldClass, fieldClass.getName(), true);
                    if (!traverser.isValid()) {
                        throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                    }
                    objectEvaluator = new ThisEvaluator(traverser);
                }
                this.myResult = new FieldEvaluator(objectEvaluator, FieldEvaluator.createClassFilter(fieldClass), psiField.getName());
            } else {
                PsiElement nameElement = expression.getReferenceNameElement();
                if (!(nameElement instanceof PsiIdentifier)) {
                    String elementDisplayString = nameElement != null ? nameElement.getText() : "(null)";
                    throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{elementDisplayString}));
                }
                String name = nameElement.getText();
                if (qualifier != null) {
                    PsiElement qualifierTarget;
                    PsiElement psiElement = qualifierTarget = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
                    if (qualifierTarget instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)qualifierTarget;
                        JVMName typeName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.createClassFilter(psiClass), name);
                    } else {
                        qualifier.accept((PsiElementVisitor)this);
                        if (this.myResult == null) {
                            throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{qualifier.getText()}));
                        }
                        this.myResult = new FieldEvaluator(this.myResult, FieldEvaluator.createClassFilter(qualifier.getType()), name);
                    }
                } else {
                    this.myResult = Builder.createFallbackEvaluator(new LocalVariableEvaluator(name, false), new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, name));
                }
            }
        }

        private static Evaluator createFallbackEvaluator(final Evaluator primary, final Evaluator fallback) {
            return new ModifiableEvaluator(){
                private boolean myIsFallback;

                @Override
                @NotNull
                public ModifiableValue evaluateModifiable(@NotNull EvaluationContextImpl context) throws EvaluateException {
                    ModifiableValue modifiableValue;
                    if (context == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        modifiableValue = primary.evaluateModifiable(context);
                    }
                    catch (EvaluateException e) {
                        ModifiableValue modifiableValue2;
                        try {
                            ModifiableValue res = fallback.evaluateModifiable(context);
                            this.myIsFallback = true;
                            modifiableValue2 = res;
                        }
                        catch (EvaluateException e1) {
                            throw e;
                        }
                        if (modifiableValue2 == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return modifiableValue2;
                    }
                    if (modifiableValue == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return modifiableValue;
                }

                @Override
                public Modifier getModifier() {
                    return this.myIsFallback ? fallback.getModifier() : primary.getModifier();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "evaluateModifiable";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "evaluateModifiable";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            };
        }

        @Contract(pure=true)
        private static EvaluateRuntimeException expressionInvalid(PsiElement expression) {
            return Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{expression.getText()}));
        }

        @Contract(pure=true)
        private static EvaluateRuntimeException evaluateException(String message) throws EvaluateRuntimeException {
            return new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)message));
        }

        @Contract(pure=true)
        private static EvaluateRuntimeException unsupportedExpression(String message) throws EvaluateRuntimeException {
            return new EvaluateRuntimeException(new UnsupportedExpressionException(message));
        }

        public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(35);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitSuperExpression " + String.valueOf(expression));
            }
            this.myResult = new SuperEvaluator(this.createTraverser(expression.getQualifier()));
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(36);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitThisExpression " + String.valueOf(expression));
            }
            this.myResult = new ThisEvaluator(this.createTraverser(expression.getQualifier()));
        }

        private CaptureTraverser createTraverser(PsiJavaCodeReferenceElement qualifier) {
            if (qualifier != null) {
                return this.createTraverser(qualifier.resolve(), qualifier.getText(), false);
            }
            return CaptureTraverser.direct();
        }

        private CaptureTraverser createTraverser(PsiElement targetClass, String name, boolean checkInheritance) {
            PsiClass fromClass = this.getPositionClass();
            if (!(targetClass instanceof PsiClass) || fromClass == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{name}));
            }
            try {
                CaptureTraverser traverser = CaptureTraverser.create((PsiClass)targetClass, fromClass, checkInheritance);
                if (!traverser.isValid() && !fromClass.equals((Object)this.myContextPsiClass)) {
                    traverser = CaptureTraverser.create((PsiClass)targetClass, this.myContextPsiClass, checkInheritance);
                }
                if (!traverser.isValid()) {
                    LOG.warn("Unable create valid CaptureTraverser to access 'this'.");
                    traverser = CaptureTraverser.direct();
                }
                return traverser;
            }
            catch (Exception e) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            PsiElement parentOfType;
            if (expression == null) {
                Builder.$$$reportNull$$$0(37);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitInstanceOfExpression " + String.valueOf(expression));
            }
            CodeFragmentEvaluator oldFragmentEvaluator = (parentOfType = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiWhileStatement.class, PsiIfStatement.class, PsiPolyadicExpression.class, PsiConditionalExpression.class})) != null ? this.myCurrentFragmentEvaluator : this.setNewCodeFragmentEvaluator();
            try {
                PatternEvaluator patternEvaluator;
                PsiTypeElement checkType = expression.getCheckType();
                PsiPrimaryPattern pattern = expression.getPattern();
                if (checkType == null && pattern == null) {
                    throw Builder.expressionInvalid((PsiElement)expression);
                }
                expression.getOperand().accept((PsiElementVisitor)this);
                Evaluator operandEvaluator = this.myResult;
                if (checkType != null) {
                    PsiType type = checkType.getType();
                    patternEvaluator = new PatternEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)), null);
                } else {
                    patternEvaluator = this.createPatternEvaluator((PsiPattern)pattern);
                    if (patternEvaluator == null) {
                        throw Builder.expressionInvalid((PsiElement)expression);
                    }
                }
                this.myResult = new InstanceofEvaluator(operandEvaluator, patternEvaluator);
            }
            finally {
                this.myCurrentFragmentEvaluator = oldFragmentEvaluator;
            }
        }

        @Nullable
        private PatternEvaluator createPatternEvaluator(@Nullable PsiPattern pattern) {
            SyntheticVariableEvaluator variableEvaluator;
            PsiType type = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)pattern);
            if (type == null) {
                return null;
            }
            PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)pattern);
            if (variable != null) {
                String variableName = variable.getName();
                this.myCurrentFragmentEvaluator.setInitialValue(variableName, null);
                variableEvaluator = new SyntheticVariableEvaluator(this.myCurrentFragmentEvaluator, variableName, null);
            } else {
                variableEvaluator = null;
            }
            if (pattern instanceof PsiDeconstructionPattern) {
                PsiPattern[] components;
                PsiClass recordClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (recordClass == null) {
                    throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.type", (Object[])new Object[]{type.getCanonicalText()}));
                }
                if (!recordClass.isRecord()) {
                    throw Builder.evaluateException(JavaErrorBundle.message((String)"deconstruction.pattern.requires.record", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)type)}));
                }
                ArrayList<PatternEvaluator> componentEvaluators = new ArrayList<PatternEvaluator>();
                for (PsiPattern component : components = ((PsiDeconstructionPattern)pattern).getDeconstructionList().getDeconstructionComponents()) {
                    componentEvaluators.add(this.createPatternEvaluator(component));
                }
                TypeEvaluator typeEvaluator = new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(recordClass));
                List recordComponentNames = ContainerUtil.map((Object[])recordClass.getRecordComponents(), PsiRecordComponent::getName);
                return new DeconstructionPatternEvaluator(typeEvaluator, variableEvaluator, componentEvaluators, recordComponentNames);
            }
            if (type instanceof PsiPrimitiveType) {
                return new PatternEvaluator(type.getCanonicalText(), variableEvaluator);
            }
            return new PatternEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)), variableEvaluator);
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            PsiExpression expr;
            if (expression == null) {
                Builder.$$$reportNull$$$0(38);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitParenthesizedExpression " + String.valueOf(expression));
            }
            if ((expr = expression.getExpression()) != null) {
                expr.accept((PsiElementVisitor)this);
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(39);
            }
            if (expression.getType() == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            PsiExpression operandExpression = expression.getOperand();
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            IElementType operation = expression.getOperationTokenType();
            PsiType operandType = operandExpression.getType();
            @Nullable PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            if (operandType == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{operandExpression.getText()}));
            }
            Evaluator incrementImpl = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiTypes.intType(), operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
            if (unboxedOperandType != null) {
                incrementImpl = new BoxingEvaluator(incrementImpl);
            }
            this.myResult = new PostfixOperationEvaluator(operandEvaluator, incrementImpl);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            PsiType expressionType;
            if (expression == null) {
                Builder.$$$reportNull$$$0(40);
            }
            if ((expressionType = expression.getType()) == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{expression.getText()}));
            }
            PsiExpression operandExpression = expression.getOperand();
            if (operandExpression == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{expression.getText()}));
            }
            operandExpression.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiType operandType = operandExpression.getType();
            @Nullable PsiPrimitiveType unboxedOperandType = PsiPrimitiveType.getUnboxedType((PsiType)operandType);
            IElementType operation = expression.getOperationTokenType();
            if (operation == JavaTokenType.PLUSPLUS || operation == JavaTokenType.MINUSMINUS) {
                try {
                    if (operandType == null) {
                        throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{operandExpression.getText()}));
                    }
                    Evaluator rightEval = Builder.createBinaryEvaluator(operandEvaluator, operandType, new LiteralEvaluator(1, "int"), (PsiType)PsiTypes.intType(), operation == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(unboxedOperandType != null ? unboxedOperandType : operandType));
                    this.myResult = new AssignmentEvaluator(operandEvaluator, unboxedOperandType != null ? new BoxingEvaluator(rightEval) : rightEval);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                if (JavaTokenType.PLUS.equals(operation) || JavaTokenType.MINUS.equals(operation) || JavaTokenType.TILDE.equals(operation)) {
                    operandEvaluator = Builder.handleUnaryNumericPromotion(operandType, operandEvaluator);
                } else if (unboxedOperandType != null) {
                    operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
                }
                this.myResult = new UnaryExpressionEvaluator(operation, expressionType.getCanonicalText(), operandEvaluator, expression.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression element;
            Evaluator objectEvaluator;
            if (expression == null) {
                Builder.$$$reportNull$$$0(41);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("visitMethodCallExpression " + String.valueOf(expression));
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            Object[] argExpressions = argumentList.getExpressions();
            Evaluator[] argumentEvaluators = new Evaluator[argExpressions.length];
            for (int idx = 0; idx < argExpressions.length; ++idx) {
                PsiExpression psiExpression = argExpressions[idx];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.myResult == null) {
                    throw Builder.expressionInvalid((PsiElement)psiExpression);
                }
                argumentEvaluators[idx] = DisableGC.create(this.myResult);
            }
            PsiReferenceExpression methodExpr = expression.getMethodExpression();
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod psiMethod = CompilingEvaluatorTypesUtil.getReferencedMethod(resolveResult);
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            JVMName contextClass = null;
            JVMName signature = null;
            if (psiMethod != null) {
                signature = JVMNameUtil.getJVMSignature(psiMethod);
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
                    throw Builder.unsupportedExpression(JavaDebuggerBundle.message((String)"evaluation.error.signature.polymorphic.call.evaluation.not.supported", (Object[])new Object[0]));
                }
                PsiClass methodPsiClass = psiMethod.getContainingClass();
                if (PsiUtil.isArrayClass((PsiElement)methodPsiClass)) {
                    contextClass = JVMNameUtil.getJVMRawText("java.lang.Object");
                    if ("clone".equals(psiMethod.getName())) {
                        signature = null;
                    }
                } else {
                    contextClass = JVMNameUtil.getJVMQualifiedName(methodPsiClass);
                }
                if (psiMethod.hasModifierProperty("static")) {
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else if (qualifier != null) {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                } else {
                    CaptureTraverser traverser = CaptureTraverser.direct();
                    PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
                    if (currentFileResolveScope instanceof PsiClass) {
                        traverser = this.createTraverser(currentFileResolveScope, ((PsiClass)currentFileResolveScope).getName(), false);
                    }
                    objectEvaluator = new ThisEvaluator(traverser);
                }
            } else if (qualifier != null) {
                PsiType type = qualifier.getType();
                if (type != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(type);
                }
                if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                    if (contextClass == null) {
                        contextClass = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)qualifier).getQualifiedName());
                    }
                    objectEvaluator = new TypeEvaluator(contextClass);
                } else {
                    qualifier.accept((PsiElementVisitor)this);
                    objectEvaluator = this.myResult;
                }
            } else {
                objectEvaluator = new ThisEvaluator();
                PsiClass positionClass = this.getPositionClass();
                if (positionClass != null) {
                    contextClass = JVMNameUtil.getJVMQualifiedName(positionClass);
                }
            }
            if (objectEvaluator == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            if (psiMethod != null && !psiMethod.isConstructor() && psiMethod.getReturnType() == null) {
                throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
            }
            boolean mustBeVararg = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.processBoxingConversions(psiMethod.getParameterList().getParameters(), (PsiExpression[])argExpressions, resolveResult.getSubstitutor(), argumentEvaluators);
                mustBeVararg = psiMethod.isVarArgs();
            }
            boolean lastArgumentIsNotArray = false;
            if (mustBeVararg && (element = (PsiExpression)ArrayUtil.getLastElement((Object[])argExpressions)) != null) {
                PsiType type = element.getType();
                lastArgumentIsNotArray = !(type instanceof PsiArrayType) && !PsiTypes.nullType().equals(type);
            }
            this.myResult = new MethodEvaluator(objectEvaluator, contextClass, methodExpr.getReferenceName(), signature, argumentEvaluators, mustBeVararg, lastArgumentIsNotArray);
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            JavaCompilationError error;
            if (expression == null) {
                Builder.$$$reportNull$$$0(42);
            }
            if ((error = JavaErrorCollector.findSingleError((PsiElement)expression)) != null && error.kind() != JavaErrorKinds.UNSUPPORTED_FEATURE) {
                throw Builder.evaluateException(error.description());
            }
            PsiType type = expression.getType();
            if (type == null) {
                throw Builder.evaluateException(String.valueOf(expression) + ": null type");
            }
            this.myResult = new LiteralEvaluator(expression.getValue(), type.getCanonicalText());
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            PsiExpression indexExpression;
            if (expression == null) {
                Builder.$$$reportNull$$$0(43);
            }
            if ((indexExpression = expression.getIndexExpression()) == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            indexExpression.accept((PsiElementVisitor)this);
            Evaluator indexEvaluator = Builder.handleUnaryNumericPromotion(indexExpression.getType(), this.myResult);
            expression.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator arrayEvaluator = this.myResult;
            this.myResult = new ArrayAccessEvaluator(arrayEvaluator, indexEvaluator);
        }

        private static Evaluator handleUnaryNumericPromotion(PsiType operandExpressionType, Evaluator operandEvaluator) {
            PsiType promotionType;
            PsiPrimitiveType _unboxedIndexType;
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)operandExpressionType);
            if (unboxedType != null && !PsiTypes.booleanType().equals((Object)unboxedType)) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            Object object = _unboxedIndexType = unboxedType != null ? unboxedType : operandExpressionType;
            if (_unboxedIndexType instanceof PsiPrimitiveType && (promotionType = Builder.calcUnaryNumericPromotionType(_unboxedIndexType)) != null) {
                operandEvaluator = Builder.createTypeCastEvaluator(operandEvaluator, promotionType);
            }
            return operandEvaluator;
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            boolean performCastToWrapperClass;
            PsiExpression operandExpr;
            if (expression == null) {
                Builder.$$$reportNull$$$0(44);
            }
            if ((operandExpr = expression.getOperand()) == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            operandExpr.accept((PsiElementVisitor)this);
            Evaluator operandEvaluator = this.myResult;
            PsiTypeElement castTypeElem = expression.getCastType();
            if (castTypeElem == null) {
                throw Builder.expressionInvalid((PsiElement)expression);
            }
            PsiType castType = castTypeElem.getType();
            PsiType operandType = operandExpr.getType();
            if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType) && PsiUtil.resolveClassInType((PsiType)operandType) != null) {
                throw new EvaluateRuntimeException(new EvaluateException(JavaErrorBundle.message((String)"inconvertible.type.cast", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)operandType), JavaHighlightUtil.formatType((PsiType)castType)})));
            }
            boolean shouldPerformBoxingConversion = operandType != null && TypeConversionUtil.boxingConversionApplicable((PsiType)castType, (PsiType)operandType);
            boolean castingToPrimitive = castType instanceof PsiPrimitiveType;
            if (shouldPerformBoxingConversion && castingToPrimitive) {
                operandEvaluator = new UnBoxingEvaluator(operandEvaluator);
            }
            boolean bl = performCastToWrapperClass = shouldPerformBoxingConversion && !castingToPrimitive;
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)castType) instanceof PsiTypeParameter)) {
                if (performCastToWrapperClass) {
                    castType = (PsiType)ObjectUtils.notNull((Object)PsiPrimitiveType.getUnboxedType((PsiType)castType), (Object)operandType);
                }
                this.myResult = Builder.createTypeCastEvaluator(operandEvaluator, castType);
            }
            if (performCastToWrapperClass) {
                this.myResult = new BoxingEvaluator(this.myResult);
            }
        }

        private static TypeCastEvaluator createTypeCastEvaluator(Evaluator operandEvaluator, @NotNull PsiType castType) {
            if (castType == null) {
                Builder.$$$reportNull$$$0(45);
            }
            if (castType instanceof PsiPrimitiveType) {
                return new TypeCastEvaluator(operandEvaluator, castType.getCanonicalText());
            }
            return new TypeCastEvaluator(operandEvaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(castType)));
        }

        public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
            PsiType type;
            if (expression == null) {
                Builder.$$$reportNull$$$0(46);
            }
            if ((type = expression.getOperand().getType()) instanceof PsiPrimitiveType) {
                JVMName typeName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)type).getBoxedTypeName());
                this.myResult = new FieldEvaluator(new TypeEvaluator(typeName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.myResult = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)));
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(47);
            }
            throw Builder.unsupportedExpression(JavaDebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0]));
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(48);
            }
            PsiElement qualifier = expression.getQualifier();
            PsiType interfaceType = expression.getFunctionalInterfaceType();
            if (!Registry.is((String)"debugger.compiling.evaluator.method.refs") && interfaceType != null && qualifier != null) {
                String code = null;
                try {
                    PsiElement resolved = expression.resolve();
                    if (resolved instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)resolved;
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass != null) {
                            String find;
                            boolean bind = false;
                            if (method.isConstructor()) {
                                find = "findConstructor(" + containingClass.getQualifiedName() + ".class, mt)";
                            } else if (qualifier instanceof PsiSuperExpression) {
                                find = "in(" + containingClass.getQualifiedName() + ".class).findSpecial(" + containingClass.getQualifiedName() + ".class, \"" + method.getName() + "\", mt, " + containingClass.getQualifiedName() + ".class)";
                                bind = true;
                            } else {
                                find = containingClass.getQualifiedName() + ".class, \"" + method.getName() + "\", mt)";
                                if (method.hasModifier(JvmModifier.STATIC)) {
                                    find = "findStatic(" + find;
                                } else {
                                    find = "findVirtual(" + find;
                                    if (qualifier instanceof PsiReference) {
                                        PsiElement resolve = ((PsiReference)qualifier).resolve();
                                        if (!(resolve instanceof PsiClass)) {
                                            bind = true;
                                        }
                                    } else {
                                        bind = true;
                                    }
                                }
                            }
                            String bidStr = bind ? "mh = mh.bindTo(" + qualifier.getText() + ");\n" : "";
                            code = "MethodType mt = MethodType.fromMethodDescriptorString(\"" + String.valueOf(JVMNameUtil.getJVMSignature(method)) + "\", null);\nMethodHandle mh = MethodHandles.lookup()." + find + ";\n" + bidStr + "MethodHandleProxies.asInterfaceInstance(" + interfaceType.getCanonicalText() + ".class, mh.asFixedArity());";
                        }
                    } else if (PsiUtil.isArrayClass((PsiElement)resolved)) {
                        code = "MethodType mt = MethodType.methodType(Object.class, Class.class, int.class);\nMethodHandle mh = MethodHandles.publicLookup().findStatic(Array.class, \"newInstance\", mt);\nmh = mh.bindTo(" + StringUtil.substringBeforeLast((String)qualifier.getText(), (String)"[]") + ".class)\nMethodHandleProxies.asInterfaceInstance(" + interfaceType.getCanonicalText() + ".class, mh);";
                    }
                    if (code != null) {
                        this.myResult = this.buildFromJavaCode(code, "java.lang.invoke.MethodHandle,java.lang.invoke.MethodHandleProxies,java.lang.invoke.MethodHandles,java.lang.invoke.MethodType,java.lang.reflect.Array", (PsiElement)expression);
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            throw Builder.unsupportedExpression(JavaDebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0]));
        }

        private Evaluator buildFromJavaCode(String code, String imports, @NotNull PsiElement context) {
            if (context == null) {
                Builder.$$$reportNull$$$0(49);
            }
            TextWithImportsImpl text = new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, code, imports, (FileType)JavaFileType.INSTANCE);
            JavaCodeFragment codeFragment = DefaultCodeFragmentFactory.getInstance().createPsiCodeFragment(text, context, context.getProject());
            return this.accept((PsiElement)codeFragment);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expressionPsiType;
            if (expression == null) {
                Builder.$$$reportNull$$$0(50);
            }
            if ((expressionPsiType = expression.getType()) instanceof PsiArrayType) {
                Evaluator dimensionEvaluator = null;
                PsiExpression[] dimensions = expression.getArrayDimensions();
                if (dimensions.length == 1) {
                    PsiExpression dimensionExpression = dimensions[0];
                    dimensionExpression.accept((PsiElementVisitor)this);
                    if (this.myResult == null) throw Builder.evaluateException(JavaDebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{dimensionExpression.getText()}));
                    dimensionEvaluator = Builder.handleUnaryNumericPromotion(dimensionExpression.getType(), this.myResult);
                } else if (dimensions.length > 1) {
                    throw Builder.unsupportedExpression(JavaDebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                }
                Evaluator initializerEvaluator = null;
                PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
                if (arrayInitializer != null) {
                    if (dimensionEvaluator != null) {
                        throw Builder.expressionInvalid((PsiElement)expression);
                    }
                    arrayInitializer.accept((PsiElementVisitor)this);
                    if (this.myResult == null) throw Builder.expressionInvalid((PsiElement)arrayInitializer);
                    initializerEvaluator = Builder.handleUnaryNumericPromotion(arrayInitializer.getType(), this.myResult);
                }
                if (dimensionEvaluator == null && initializerEvaluator == null) {
                    throw Builder.expressionInvalid((PsiElement)expression);
                }
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(expressionPsiType)), dimensionEvaluator, initializerEvaluator);
                return;
            } else if (expressionPsiType instanceof PsiClassType) {
                PsiClass containingClass;
                PsiClass aClass = CompilingEvaluatorTypesUtil.getClass((PsiClassType)expressionPsiType);
                if (aClass instanceof PsiAnonymousClass) {
                    throw Builder.unsupportedExpression(JavaDebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0]));
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    throw Builder.expressionInvalid((PsiElement)expression);
                }
                PsiExpression[] argExpressions = argumentList.getExpressions();
                JavaResolveResult constructorResolveResult = expression.resolveMethodGenerics();
                PsiMethod constructor = CompilingEvaluatorTypesUtil.getReferencedConstructor((PsiMethod)constructorResolveResult.getElement());
                if (constructor == null && argExpressions.length > 0) {
                    throw new EvaluateRuntimeException(new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{expression.getText()}), null));
                }
                Object[] argumentEvaluators = new Evaluator[argExpressions.length];
                for (int idx = 0; idx < argExpressions.length; ++idx) {
                    PsiExpression argExpression = argExpressions[idx];
                    argExpression.accept((PsiElementVisitor)this);
                    if (this.myResult == null) {
                        throw Builder.expressionInvalid((PsiElement)argExpression);
                    }
                    argumentEvaluators[idx] = DisableGC.create(this.myResult);
                }
                if (constructor != null) {
                    EvaluatorBuilderImpl.processBoxingConversions(constructor.getParameterList().getParameters(), argExpressions, constructorResolveResult.getSubstitutor(), (Evaluator[])argumentEvaluators);
                }
                if (aClass != null && (containingClass = aClass.getContainingClass()) != null && !aClass.hasModifierProperty("static")) {
                    PsiExpression qualifier = expression.getQualifier();
                    if (qualifier != null) {
                        qualifier.accept((PsiElementVisitor)this);
                        if (this.myResult != null) {
                            argumentEvaluators = (Evaluator[])ArrayUtil.prepend((Object)this.myResult, (Object[])argumentEvaluators);
                        }
                    } else {
                        argumentEvaluators = (Evaluator[])ArrayUtil.prepend((Object)new ThisEvaluator(this.createTraverser((PsiElement)containingClass, "this", false)), (Object[])argumentEvaluators);
                    }
                }
                JVMName signature = JVMNameUtil.getJVMConstructorSignature(constructor, aClass);
                PsiType instanceType = CompilingEvaluatorTypesUtil.getClassType((PsiClassType)expressionPsiType);
                this.myResult = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(instanceType)), signature, (Evaluator[])argumentEvaluators);
                return;
            } else {
                if (expressionPsiType == null) throw Builder.evaluateException("Unknown type for expression: " + expression.getText());
                throw Builder.evaluateException("Unsupported expression type: " + expressionPsiType.getPresentableText());
            }
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(51);
            }
            PsiExpression[] initializers = expression.getInitializers();
            Evaluator[] evaluators = new Evaluator[initializers.length];
            PsiType type = expression.getType();
            boolean primitive = type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType() instanceof PsiPrimitiveType;
            for (int idx = 0; idx < initializers.length; ++idx) {
                PsiExpression initializer = initializers[idx];
                initializer.accept((PsiElementVisitor)this);
                if (this.myResult == null) {
                    throw Builder.expressionInvalid((PsiElement)initializer);
                }
                Evaluator coerced = primitive ? Builder.handleUnaryNumericPromotion(initializer.getType(), this.myResult) : new BoxingEvaluator(this.myResult);
                evaluators[idx] = DisableGC.create(coerced);
            }
            this.myResult = new ArrayInitializerEvaluator(evaluators);
            if (type != null && !(expression.getParent() instanceof PsiNewExpression)) {
                this.myResult = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(type)), null, this.myResult);
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            PsiExpression condition;
            if (statement == null) {
                Builder.$$$reportNull$$$0(52);
            }
            if ((condition = statement.getAssertCondition()) == null) {
                throw Builder.evaluateException("Assert condition expected in: " + statement.getText());
            }
            PsiExpression description = statement.getAssertDescription();
            String descriptionText = description != null ? description.getText() : "";
            this.myResult = new AssertStatementEvaluator(this.buildFromJavaCode("if (!(" + condition.getText() + ")) { throw new java.lang.AssertionError(" + descriptionText + ");}", "", (PsiElement)statement));
        }

        @Nullable
        private PsiClass getContainingClass(@NotNull PsiVariable variable) {
            PsiClass element;
            if (variable == null) {
                Builder.$$$reportNull$$$0(53);
            }
            return (element = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable.getParent(), PsiClass.class, (boolean)false)) == null ? this.myContextPsiClass : element;
        }

        @Nullable
        private PsiClass getPositionClass() {
            return this.myPositionPsiClass != null ? this.myPositionPsiClass : this.myContextPsiClass;
        }

        private ExpressionEvaluator buildElement(PsiElement element) throws EvaluateException {
            LOG.assertTrue(element.isValid());
            this.setNewCodeFragmentEvaluator();
            this.myContextPsiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            try {
                element.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException e) {
                throw e.getCause();
            }
            if (this.myResult == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{element.toString()}));
            }
            return new ExpressionEvaluatorImpl(this.myResult);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeFragment";
                    break;
                }
                case 1: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 18: 
                case 27: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 32: 
                case 52: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labeledStatement";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wideExpression";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rType";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionExpectedType";
                    break;
                }
                case 45: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "castType";
                    break;
                }
                case 49: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 53: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCodeFragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitErrorElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThrowStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYieldStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCodeBlock";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlockStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLabeledStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPatternLabelEvaluator";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchLabelStatement";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchLabeledRuleStatement";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpressionListStatement";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEmptyStatement";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpressionStatement";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpression";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 29: 
                case 30: 
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createBinaryEvaluator";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDeclarationStatement";
                    break;
                }
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperExpression";
                    break;
                }
                case 36: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 37: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
                case 39: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPostfixExpression";
                    break;
                }
                case 40: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 42: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 43: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
                case 44: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 45: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTypeCastEvaluator";
                    break;
                }
                case 46: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassObjectAccessExpression";
                    break;
                }
                case 47: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 48: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 49: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildFromJavaCode";
                    break;
                }
                case 50: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 51: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 52: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssertStatement";
                    break;
                }
                case 53: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContainingClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompilingEvaluatorTypesUtil {
        private CompilingEvaluatorTypesUtil() {
        }

        @NotNull
        private static PsiType getVariableType(@NotNull PsiVariable variable) {
            PsiType typeToUse;
            PsiType type;
            PsiClass psiClass;
            if (variable == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(0);
            }
            if ((psiClass = PsiTypesUtil.getPsiClass((PsiType)(type = variable.getType()))) != null && (typeToUse = (PsiType)psiClass.getUserData(LightMethodObjectExtractedData.REFERENCED_TYPE)) != null) {
                type = typeToUse;
            }
            PsiType psiType = type;
            if (psiType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Nullable
        private static PsiMethod getReferencedMethod(@NotNull JavaResolveResult resolveResult) {
            PsiMethod psiMethod;
            PsiMethod methodToUseInstead;
            if (resolveResult == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(2);
            }
            PsiMethod psiMethod2 = methodToUseInstead = (psiMethod = (PsiMethod)resolveResult.getElement()) == null ? null : (PsiMethod)psiMethod.getUserData(LightMethodObjectExtractedData.REFERENCE_METHOD);
            if (methodToUseInstead != null) {
                psiMethod = methodToUseInstead;
            }
            return psiMethod;
        }

        @Nullable
        private static PsiClass getClass(@NotNull PsiClassType classType) {
            PsiClass aClass;
            PsiType type;
            if (classType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(3);
            }
            PsiType psiType = type = (aClass = classType.resolve()) == null ? null : (PsiType)aClass.getUserData(LightMethodObjectExtractedData.REFERENCED_TYPE);
            if (type != null) {
                return PsiTypesUtil.getPsiClass((PsiType)type);
            }
            return aClass;
        }

        @Contract(value="null -> null")
        @Nullable
        private static PsiMethod getReferencedConstructor(@Nullable PsiMethod originalConstructor) {
            if (originalConstructor == null) {
                return null;
            }
            PsiMethod methodToUseInstead = (PsiMethod)originalConstructor.getUserData(LightMethodObjectExtractedData.REFERENCE_METHOD);
            return methodToUseInstead == null ? originalConstructor : methodToUseInstead;
        }

        @NotNull
        private static PsiType getClassType(@NotNull PsiClassType expressionPsiType) {
            PsiClass aClass;
            if (expressionPsiType == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(4);
            }
            PsiType type = (aClass = expressionPsiType.resolve()) == null ? null : (PsiType)aClass.getUserData(LightMethodObjectExtractedData.REFERENCED_TYPE);
            Object object = type != null ? type : expressionPsiType;
            if (object == null) {
                CompilingEvaluatorTypesUtil.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$CompilingEvaluatorTypesUtil";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveResult";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionPsiType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$CompilingEvaluatorTypesUtil";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableType";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencedMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 5 -> new IllegalStateException(string);
            };
        }
    }
}

