/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalVariableEvaluator
implements ModifiableEvaluator {
    private static final Logger LOG = Logger.getInstance(LocalVariableEvaluator.class);
    private final String myLocalVariableName;
    private final boolean myCanScanFrames;
    @Deprecated
    private EvaluationContextImpl myContext;
    @Deprecated
    private LocalVariableProxyImpl myEvaluatedVariable;
    @Deprecated
    private DecompiledLocalVariable myEvaluatedDecompiledVariable;

    LocalVariableEvaluator(String localVariableName, boolean canScanFrames) {
        this.myLocalVariableName = localVariableName;
        this.myCanScanFrames = canScanFrames;
    }

    @Override
    @NotNull
    public ModifiableValue evaluateModifiable(EvaluationContextImpl context) throws EvaluateException {
        StackFrameProxyImpl frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
        }
        try {
            ThreadReferenceProxyImpl threadProxy = null;
            int lastFrameIndex = -1;
            PsiVariable variable = null;
            DebugProcessImpl process = context.getDebugProcess();
            boolean topFrame = true;
            while (true) {
                int currentFrameIndex;
                try {
                    LocalVariableProxyImpl local = frameProxy.visibleVariableByName(this.myLocalVariableName);
                    if (local != null && (topFrame || variable.equals((Object)LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process)))) {
                        this.myEvaluatedVariable = local;
                        this.myContext = context;
                        return new ModifiableValue(frameProxy.getValue(local), new MyModifier(context, local, null));
                    }
                }
                catch (EvaluateException e) {
                    if (!(e.getCause() instanceof AbsentInformationException)) {
                        throw e;
                    }
                    try {
                        Map<DecompiledLocalVariable, Value> vars = LocalVariablesUtil.fetchValues(frameProxy, process, true);
                        for (Map.Entry<DecompiledLocalVariable, Value> entry : vars.entrySet()) {
                            DecompiledLocalVariable var = entry.getKey();
                            if (!var.getMatchedNames().contains(this.myLocalVariableName) && !var.getDefaultName().equals(this.myLocalVariableName)) continue;
                            this.myEvaluatedDecompiledVariable = var;
                            this.myContext = context;
                            return new ModifiableValue(entry.getValue(), new MyModifier(context, null, var));
                        }
                    }
                    catch (Exception e1) {
                        LOG.info((Throwable)e1);
                    }
                }
                if (!this.myCanScanFrames || topFrame && (variable = LocalVariableEvaluator.resolveVariable(frameProxy, this.myLocalVariableName, context.getProject(), process)) == null) break;
                if (threadProxy == null) {
                    threadProxy = frameProxy.threadProxy();
                    lastFrameIndex = threadProxy.frameCount() - 1;
                }
                if ((currentFrameIndex = frameProxy.getFrameIndex()) >= lastFrameIndex || (frameProxy = threadProxy.frame(currentFrameIndex + 1)) == null) break;
                topFrame = false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.myLocalVariableName}));
        }
        catch (EvaluateException e) {
            this.myEvaluatedVariable = null;
            this.myContext = null;
            throw e;
        }
    }

    @Override
    public Modifier getModifier() {
        if ((this.myEvaluatedVariable != null || this.myEvaluatedDecompiledVariable != null) && this.myContext != null) {
            return new MyModifier(this.myContext, this.myEvaluatedVariable, this.myEvaluatedDecompiledVariable);
        }
        return null;
    }

    @Nullable
    private static PsiVariable resolveVariable(StackFrameProxy frame, String name, Project project, DebugProcess process) {
        PsiElement place2 = ContextUtil.getContextElement(new SimpleStackFrameContext(frame, process));
        if (place2 == null) {
            return null;
        }
        return (PsiVariable)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(name, place2));
    }

    public String toString() {
        return this.myLocalVariableName;
    }

    private static class MyModifier
    implements Modifier {
        private final EvaluationContextImpl myContext;
        private final LocalVariableProxyImpl myEvaluatedVariable;
        private final DecompiledLocalVariable myEvaluatedDecompiledVariable;

        private MyModifier(EvaluationContextImpl context, LocalVariableProxyImpl evaluatedVariable, DecompiledLocalVariable evaluatedDecompiledVariable) {
            this.myContext = context;
            this.myEvaluatedVariable = evaluatedVariable;
            this.myEvaluatedDecompiledVariable = evaluatedDecompiledVariable;
        }

        public boolean canInspect() {
            return true;
        }

        public boolean canSetValue() {
            return true;
        }

        public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
            StackFrameProxyImpl frameProxy = this.myContext.getFrameProxy();
            try {
                assert (frameProxy != null);
                if (this.myEvaluatedVariable != null) {
                    frameProxy.setValue(this.myEvaluatedVariable, value);
                } else {
                    LocalVariablesUtil.setValue(frameProxy.getStackFrame(), this.myEvaluatedDecompiledVariable, value);
                }
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
            }
        }

        public Type getExpectedType() throws ClassNotLoadedException {
            try {
                return this.myEvaluatedVariable.getType();
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        public NodeDescriptorImpl getInspectItem(Project project) {
            return new LocalVariableDescriptorImpl(project, this.myEvaluatedVariable);
        }
    }
}

