/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnBoxingEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(UnBoxingEvaluator.class);
    private final Evaluator myOperand;
    private static final Map<String, Couple<String>> TYPES_TO_CONVERSION_METHOD_MAP = new HashMap<String, Couple<String>>();

    public static boolean isTypeUnboxable(String typeName) {
        return TYPES_TO_CONVERSION_METHOD_MAP.containsKey(typeName);
    }

    public UnBoxingEvaluator(@NotNull Evaluator operand) {
        if (operand == null) {
            UnBoxingEvaluator.$$$reportNull$$$0(0);
        }
        this.myOperand = DisableGC.create(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return UnBoxingEvaluator.unbox(this.myOperand.evaluate(context), context);
    }

    public static Object unbox(@Nullable Object value, EvaluationContext context) throws EvaluateException {
        String valueTypeName;
        Couple<String> pair;
        if (value == null) {
            throw new EvaluateException("java.lang.NullPointerException: cannot unbox null value");
        }
        if (value instanceof ObjectReference && (pair = TYPES_TO_CONVERSION_METHOD_MAP.get(valueTypeName = ((ObjectReference)value).type().name())) != null) {
            return UnBoxingEvaluator.convertToPrimitive(context, (ObjectReference)value, (String)pair.getFirst(), (String)pair.getSecond());
        }
        return value;
    }

    private static Value convertToPrimitive(EvaluationContext context, ObjectReference value, String conversionMethodName, String conversionMethodSignature) throws EvaluateException {
        Value primitiveValue = UnBoxingEvaluator.getInnerPrimitiveValue(value, true).join();
        if (primitiveValue != null) {
            return primitiveValue;
        }
        Method method = DebuggerUtils.findMethod((ReferenceType)value.referenceType(), (String)conversionMethodName, (String)conversionMethodSignature);
        if (method == null) {
            throw new EvaluateException("Cannot convert to primitive value of type " + String.valueOf(value.type()) + ": Unable to find method " + conversionMethodName + conversionMethodSignature);
        }
        return context.getDebugProcess().invokeMethod(context, value, method, Collections.emptyList());
    }

    public static CompletableFuture<PrimitiveValue> getInnerPrimitiveValue(@Nullable ObjectReference value, boolean now) {
        if (value != null) {
            ReferenceType type = value.referenceType();
            return UnBoxingEvaluator.fields(type, now).thenCompose(fields -> {
                Field valueField = (Field)ContainerUtil.find((Iterable)fields, f -> "value".equals(f.name()));
                if (valueField != null) {
                    return UnBoxingEvaluator.getValue(value, valueField, now).thenApply(primitiveValue -> {
                        if (primitiveValue instanceof PrimitiveValue) {
                            String expected = PsiJavaParserFacadeImpl.getPrimitiveType((String)primitiveValue.type().name()).getBoxedTypeName();
                            String actual = type.name();
                            LOG.assertTrue(actual.equals(expected), (Object)("Unexpected unboxable value type\nType: " + actual + "\nPrimitive value type: " + String.valueOf(primitiveValue.type()) + "\nBoxed type: " + expected));
                            return (PrimitiveValue)primitiveValue;
                        }
                        return null;
                    });
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private static CompletableFuture<List<Field>> fields(ReferenceType type, boolean now) {
        return now ? CompletableFuture.completedFuture(type.fields()) : DebuggerUtilsAsync.fields(type);
    }

    private static CompletableFuture<Value> getValue(ObjectReference ref, Field field, boolean now) {
        return now ? CompletableFuture.completedFuture(ref.getValue(field)) : DebuggerUtilsAsync.getValue(ref, field);
    }

    static {
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Boolean", (Couple<String>)Couple.of((Object)"booleanValue", (Object)"()Z"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Byte", (Couple<String>)Couple.of((Object)"byteValue", (Object)"()B"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Character", (Couple<String>)Couple.of((Object)"charValue", (Object)"()C"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Short", (Couple<String>)Couple.of((Object)"shortValue", (Object)"()S"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Integer", (Couple<String>)Couple.of((Object)"intValue", (Object)"()I"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Long", (Couple<String>)Couple.of((Object)"longValue", (Object)"()J"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Float", (Couple<String>)Couple.of((Object)"floatValue", (Object)"()F"));
        TYPES_TO_CONVERSION_METHOD_MAP.put("java.lang.Double", (Couple<String>)Couple.of((Object)"doubleValue", (Object)"()D"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/debugger/engine/evaluation/expression/UnBoxingEvaluator", "<init>"));
    }
}

