/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerGlobalSearchScope;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RemoteConnectionStub;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebugUtilsKt;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.debugger.impl.shared.CoroutineUtilsKt;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.JavaVersionBasedScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger LOG = Logger.getInstance(DebuggerSession.class);
    private final MyDebuggerStateManager myContextManager;
    private volatile int myIgnoreFiltersFrameCountThreshold;
    private final MutableStateFlow<DebuggerSessionState> myStateFlow;
    private final String mySessionName;
    private final DebugProcessImpl myDebugProcess;
    private final DebugEnvironment myDebugEnvironment;
    private final GlobalSearchScope myBaseScope;
    private GlobalSearchScope mySearchScope;
    private Sdk myAlternativeJre;
    private final Sdk myRunJre;
    private final DebuggerContextImpl SESSION_EMPTY_CONTEXT;
    private final AtomicReference<ThreadReferenceProxyImpl> mySteppingThroughThread;
    private final AtomicReference<ThreadReferenceProxyImpl> myLastThread;
    private final SingleEdtTaskScheduler updateAlarm;
    private boolean myModifiedClassesScanRequired;

    public void setSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        LightOrRealThreadInfo filterThread = this.myDebugProcess.getRequestsManager().getFilterThread();
        if (filterThread == null || filterThread.getRealThread() != null) {
            this.mySteppingThroughThread.set(threadProxy);
        } else {
            this.mySteppingThroughThread.set(null);
        }
    }

    public void clearSteppingThrough() {
        this.mySteppingThroughThread.set(null);
        this.resetIgnoreStepFiltersFlag();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            DebuggerSession.$$$reportNull$$$0(0);
        }
        return globalSearchScope;
    }

    public Sdk getAlternativeJre() {
        return this.myAlternativeJre;
    }

    public void setAlternativeJre(Sdk sdk) {
        this.myAlternativeJre = sdk;
        this.updateScope();
        ((AlternativeJreClassFinder)((Object)PsiElementFinder.EP.findExtension(AlternativeJreClassFinder.class, (AreaInstance)this.getProject()))).clearCache();
    }

    public Sdk getRunJre() {
        return this.myRunJre;
    }

    public DebugEnvironment getDebugEnvironment() {
        return this.myDebugEnvironment;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.myModifiedClassesScanRequired;
    }

    public void setModifiedClassesScanRequired(boolean modifiedClassesScanRequired) {
        this.myModifiedClassesScanRequired = modifiedClassesScanRequired;
    }

    public Flow<State> getSessionStateFlow() {
        return CoroutineUtilsKt.mapFlow(this.myStateFlow, sessionState -> sessionState.myState);
    }

    @VisibleForTesting
    public static DebuggerSession create(@NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) throws ExecutionException {
        if (debugProcess == null) {
            DebuggerSession.$$$reportNull$$$0(1);
        }
        DebuggerSession session = new DebuggerSession(environment.getSessionName(), debugProcess, environment);
        try {
            session.attach();
        }
        catch (ExecutionException e) {
            session.dispose();
            throw e;
        }
        return session;
    }

    private DebuggerSession(@Nls String sessionName, @NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) {
        if (debugProcess == null) {
            DebuggerSession.$$$reportNull$$$0(2);
        }
        this.myIgnoreFiltersFrameCountThreshold = 0;
        this.myStateFlow = CoroutineUtilsKt.createMutableStateFlow((Object)new DebuggerSessionState(State.STOPPED, null));
        this.mySteppingThroughThread = new AtomicReference();
        this.myLastThread = new AtomicReference();
        this.updateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.myModifiedClassesScanRequired = false;
        this.mySessionName = sessionName;
        this.myDebugProcess = debugProcess;
        this.SESSION_EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.myContextManager = new MyDebuggerStateManager();
        this.myDebugProcess.addDebugProcessListener(new MyDebugProcessListener(debugProcess));
        ValueLookupManagerController.getInstance((Project)this.getProject()).startListening();
        this.myDebugEnvironment = environment;
        this.myBaseScope = environment.getSearchScope();
        this.myAlternativeJre = environment.getAlternativeJre();
        this.myRunJre = environment.getRunJre();
        this.updateScope();
    }

    private void updateScope() {
        LanguageLevel level;
        Sdk jre = this.myAlternativeJre;
        if (jre == null) {
            jre = this.myRunJre;
        }
        Object scope = this.myBaseScope;
        if (jre != null && (level = LanguageLevel.parse((String)jre.getVersionString())) != null) {
            GlobalSearchScope globalSearchScope = this.myBaseScope;
            if (globalSearchScope instanceof DebuggerGlobalSearchScope) {
                DebuggerGlobalSearchScope debuggerScope = (DebuggerGlobalSearchScope)globalSearchScope;
                scope = debuggerScope.getDelegate();
            }
            scope = new JavaVersionBasedScope(this.getProject(), scope, level);
            if (this.myBaseScope instanceof DebuggerGlobalSearchScope) {
                scope = new DebuggerGlobalSearchScope((GlobalSearchScope)scope, this.getProject());
            }
        }
        this.mySearchScope = scope;
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.myContextManager;
        if (myDebuggerStateManager == null) {
            DebuggerSession.$$$reportNull$$$0(3);
        }
        return myDebuggerStateManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getProcess().getProject();
        if (project == null) {
            DebuggerSession.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NlsSafe
    public String getSessionName() {
        return this.mySessionName;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        if (debugProcessImpl == null) {
            DebuggerSession.$$$reportNull$$$0(5);
        }
        return debugProcessImpl;
    }

    public State getState() {
        return ((DebuggerSessionState)this.myStateFlow.getValue()).myState;
    }

    @NlsContexts.Label
    public String getStateDescription() {
        String stateDescription = ((DebuggerSessionState)this.myStateFlow.getValue()).myDescription;
        if (stateDescription != null) {
            return stateDescription;
        }
        return switch (this.getState().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 6 -> JavaDebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            case 1 -> JavaDebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            case 4 -> JavaDebuggerBundle.message((String)"status.app.stepping", (Object[])new Object[0]);
            case 2 -> {
                RemoteConnection connection = this.getProcess().getConnection();
                yield DebuggerUtilsImpl.getConnectionWaitStatus(connection);
            }
            case 3 -> JavaDebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            case 5 -> JavaDebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
        };
    }

    private void resumeAction(DebugProcessImpl.ResumeCommand command2, Event event) {
        this.myLastThread.set(this.getContextManager().getContext().getThreadProxy());
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAIT_EVALUATION, event, null);
        this.myDebugProcess.getManagerThread().schedule(command2);
    }

    public void stepOut(int stepSize) {
        this.stepOut(this.getSuspendContext(), stepSize);
    }

    public void stepOut(SuspendContextImpl suspendContext, int stepSize) {
        DebugProcessImpl.ResumeCommand cmd = (DebugProcessImpl.ResumeCommand)DebugUtilsKt.computeSafeIfAny(JvmSteppingCommandProvider.EP_NAME, handler -> handler.getStepOutCommand(suspendContext, stepSize));
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOutCommand(suspendContext, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter, int stepSize) {
        this.stepOver(this.getSuspendContext(), ignoreBreakpoints, methodFilter, stepSize);
    }

    public void stepOver(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @Nullable MethodFilter methodFilter, int stepSize) {
        DebugProcessImpl.ResumeCommand cmd = (DebugProcessImpl.ResumeCommand)DebugUtilsKt.computeSafeIfAny(JvmSteppingCommandProvider.EP_NAME, handler -> handler.getStepOverCommand(suspendContext, ignoreBreakpoints, stepSize));
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints, methodFilter, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepOver(boolean ignoreBreakpoints, int stepSize) {
        this.stepOver(ignoreBreakpoints, null, stepSize);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        this.stepOver(ignoreBreakpoints, -2);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        this.stepInto(this.getSuspendContext(), ignoreFilters, smartStepFilter, stepSize);
    }

    public void stepInto(SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        DebugProcessImpl.ResumeCommand cmd = (DebugProcessImpl.ResumeCommand)DebugUtilsKt.computeSafeIfAny(JvmSteppingCommandProvider.EP_NAME, handler -> handler.getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize));
        if (cmd == null) {
            cmd = this.myDebugProcess.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter, stepSize);
        }
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        this.stepInto(ignoreFilters, smartStepFilter, -2);
    }

    public void stepOverInstruction() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        DebugProcessImpl debugProcessImpl = this.myDebugProcess;
        Objects.requireNonNull(debugProcessImpl);
        DebugProcessImpl.StepOverCommand cmd = new DebugProcessImpl.StepOverCommand(this, debugProcessImpl, suspendContext, false, null, -1){
            {
                DebugProcessImpl debugProcessImpl = x0;
                Objects.requireNonNull(debugProcessImpl);
                super(suspendContext, ignoreBreakpoints, methodFilter, stepSize);
            }

            @Override
            @Nullable
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                return null;
            }
        };
        this.setSteppingThrough(cmd.getContextThread());
        this.resumeAction(cmd, Event.STEP);
    }

    public void runToCursor(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            DebuggerSession.$$$reportNull$$$0(6);
        }
        try {
            SuspendContextImpl suspendContext = this.getSuspendContext();
            DebugProcessImpl.ResumeCommand runToCursorCommand = (DebugProcessImpl.ResumeCommand)DebugUtilsKt.computeSafeIfAny(JvmSteppingCommandProvider.EP_NAME, handler -> handler.getRunToCursorCommand(suspendContext, position, ignoreBreakpoints));
            if (runToCursorCommand == null) {
                runToCursorCommand = this.myDebugProcess.createRunToCursorCommand(suspendContext, position, ignoreBreakpoints);
            }
            this.setSteppingThrough(runToCursorCommand.getContextThread());
            this.resumeAction(runToCursorCommand, Event.STEP);
        }
        catch (EvaluateException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        if (suspendContext != null) {
            this.resumeSuspendContext(suspendContext, PrioritizedTask.Priority.HIGH);
        }
    }

    public void resumeSuspendContext(SuspendContextImpl suspendContext, PrioritizedTask.Priority priority) {
        this.clearSteppingThrough();
        this.resumeAction(this.myDebugProcess.createResumeCommand(suspendContext, priority), Event.RESUME);
    }

    public void resetIgnoreStepFiltersFlag() {
        this.myIgnoreFiltersFrameCountThreshold = 0;
    }

    public void setIgnoreStepFiltersFlag(int currentStackFrameCount) {
        this.myIgnoreFiltersFrameCountThreshold = this.myIgnoreFiltersFrameCountThreshold <= 0 ? currentStackFrameCount : Math.min(this.myIgnoreFiltersFrameCountThreshold, currentStackFrameCount);
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.myIgnoreFiltersFrameCountThreshold > 0;
    }

    public void pause() {
        this.myDebugProcess.getManagerThread().schedule(this.myDebugProcess.createPauseCommand(null));
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.getSuspendContext()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean refreshWithStack) {
        State state = this.getState();
        DebuggerContextImpl context = this.myContextManager.getContext();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(this, context.getSuspendContext(), context.getThreadProxy(), context.getFrameProxy());
        this.myContextManager.setState(newContext, state, refreshWithStack ? Event.REFRESH_WITH_STACK : Event.REFRESH, null);
    }

    public void dispose() {
        this.updateAlarm.dispose();
        this.getProcess().dispose();
        this.clearSteppingThrough();
        this.myLastThread.set(null);
        DebuggerInvocationUtil.invokeLaterAnyModality(this.getProject(), () -> {
            this.myContextManager.setState(this.SESSION_EMPTY_CONTEXT, State.DISPOSED, Event.DISPOSE, null);
            this.myContextManager.dispose();
        });
    }

    public boolean isStopped() {
        return this.getState() == State.STOPPED;
    }

    public boolean isAttached() {
        return DebuggerSession.isAttached(this.getState());
    }

    @ApiStatus.Internal
    public static boolean isAttached(State state) {
        return state != State.STOPPED && state != State.WAITING_ATTACH;
    }

    public boolean isPaused() {
        return this.getState() == State.PAUSED;
    }

    public boolean isConnecting() {
        return this.getState() == State.WAITING_ATTACH;
    }

    public boolean isRunning() {
        return this.getState() == State.RUNNING && !this.getProcess().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl getSuspendContext() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    private void attach() throws ExecutionException {
        RemoteConnection remoteConnection = this.myDebugEnvironment.getRemoteConnection();
        this.myDebugProcess.attachVirtualMachine(this.myDebugEnvironment, this);
        StringBuilder description = new StringBuilder(JavaDebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[0]));
        if (!(remoteConnection instanceof RemoteConnectionStub)) {
            String connectionName = DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection);
            description.append("; ").append(JavaDebuggerBundle.message((String)"status.waiting.attach.address", (Object[])new Object[]{connectionName}));
        }
        DebuggerInvocationUtil.invokeLaterAnyModality(() -> this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, description.toString()));
    }

    private void switchToActiveSteppingContext(@Nullable ThreadReferenceProxyImpl steppingThread) {
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(this, null, steppingThread, null);
        this.getContextManager().setState(debuggerContext, State.IN_STEPPING, Event.CONTEXT, DebuggerSession.getDescription(debuggerContext));
    }

    public static void switchContext(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebuggerSession.$$$reportNull$$$0(7);
        }
        final DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
        suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                DebuggerSession session = debugProcess.getSession();
                DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext.getEventThread(), null);
                DebuggerInvocationUtil.invokeLater(debugProcess.getProject(), () -> session.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$2", "contextAction"));
            }
        });
    }

    private static String getDescription(DebuggerContextImpl debuggerContext) {
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        if (suspendContext != null && debuggerContext.getThreadProxy() != suspendContext.getThread()) {
            return JavaDebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public static boolean filterBreakpointsDuringSteppingUsingDebuggerEngine() {
        return Registry.is((String)"debugger.filter.breakpoints.during.stepping.using.debugger.engine");
    }

    public void sessionResumed() {
        XDebugSession session = this.getXDebugSession();
        if (session != null) {
            session.sessionResumed();
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        JavaDebugProcess process = this.myDebugProcess.getXdebugProcess();
        return process != null ? process.getSession() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runToCursor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "switchContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class DebuggerSessionState {
        final State myState;
        final @NlsContexts.Label String myDescription;

        DebuggerSessionState(State state, @NlsContexts.Label String description) {
            this.myState = state;
            this.myDescription = description;
        }
    }

    public static enum State {
        STOPPED,
        RUNNING,
        WAITING_ATTACH,
        PAUSED,
        IN_STEPPING,
        WAIT_EVALUATION,
        DISPOSED;

    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl myDebuggerContext;

        MyDebuggerStateManager() {
            this.myDebuggerContext = DebuggerSession.this.SESSION_EMPTY_CONTEXT;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.myDebuggerContext;
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl context, State state, Event event, @NlsContexts.Label String description) {
            if (context == null) {
                MyDebuggerStateManager.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            DebuggerSession session = context.getDebuggerSession();
            if (description != null) {
                LOG.info(description);
            }
            LOG.assertTrue(session == DebuggerSession.this || session == null);
            final Runnable setStateRunnable = () -> {
                LOG.assertTrue(this.myDebuggerContext.isInitialised());
                this.myDebuggerContext = context;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DebuggerSession state = " + String.valueOf((Object)state) + ", event = " + String.valueOf((Object)event));
                }
                DebuggerSession.this.myStateFlow.setValue((Object)new DebuggerSessionState(state, description));
                this.fireStateChanged(context, event);
            };
            SuspendContextImpl suspendContext = context.getSuspendContext();
            if (suspendContext == null) {
                setStateRunnable.run();
            } else {
                suspendContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        context.initCaches();
                        DebuggerInvocationUtil.invokeLaterAnyModality(DebuggerSession.this.getProject(), setStateRunnable);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager$1", "contextAction"));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;

        MyDebugProcessListener(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                RemoteConnection connection = this.myDebugProcess.getConnection();
                String connectionStatusMessage = JavaDebuggerBundle.message((String)(connection.isServerMode() ? "status.listening" : "status.connecting"), (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(connection)});
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, connectionStatusMessage);
            });
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void paused(SuspendContextImpl suspendContext) {
            SourcePosition position;
            LOG.debug("paused");
            boolean isSteppingEnds = this.myDebugProcess.mySteppingProgressTracker.onPaused(suspendContext);
            ThreadReferenceProxyImpl currentThread = suspendContext.getEventThread();
            if (!this.shouldSetAsActiveContext(suspendContext, isSteppingEnds)) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> descriptors;
                this.notifyThreadsRefresh();
                ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContext.getEventThread();
                if (threadReferenceProxyImpl != null && !(descriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext)).isEmpty()) {
                    XDebuggerManagerImpl.getNotificationGroup().createNotification(JavaDebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{threadReferenceProxyImpl.name()}), JavaDebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION).setListener((NotificationListener)new BreakpointReachedNotificationListener(suspendContext)).notify(DebuggerSession.this.getProject());
                }
                if (this.myDebugProcess.getSuspendManager().getPausedContexts().size() > 1) {
                    return;
                }
                if (!suspendContext.threadFilterWasPassed) return;
                currentThread = DebuggerSession.this.mySteppingThroughThread.get();
            } else if (suspendContext.threadFilterWasPassed) {
                DebuggerSession.this.setSteppingThrough(currentThread);
            }
            this.myDebugProcess.cancelSteppingBreakpoints();
            if (currentThread == null) {
                LOG.assertTrue(suspendContext.getSuspendPolicy() == 2);
                SuspendContextImpl oldContext = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (oldContext != null) {
                    currentThread = oldContext.getThread();
                }
                if (currentThread == null) {
                    Collection<ThreadReferenceProxyImpl> allThreads = suspendContext.getVirtualMachineProxy().allThreads();
                    ThreadReferenceProxyImpl lastThread = DebuggerSession.this.myLastThread.get();
                    if (lastThread != null && allThreads.contains(lastThread)) {
                        currentThread = lastThread;
                    } else {
                        currentThread = (ThreadReferenceProxyImpl)ContainerUtil.find(allThreads, thread -> ThreadDumper.isEDT((String)thread.name()));
                        if (currentThread == null) {
                            currentThread = (ThreadReferenceProxyImpl)ContainerUtil.find(allThreads, thread -> "main".equals(thread.name()));
                        }
                        if (currentThread == null) {
                            Iterator<ThreadReferenceProxyImpl> iterator = allThreads.iterator();
                            while (iterator.hasNext()) {
                                ThreadReferenceProxyImpl thread2;
                                currentThread = thread2 = iterator.next();
                                try {
                                    if (currentThread.status() != 1 || currentThread.frameCount() <= 0) continue;
                                    break;
                                }
                                catch (EvaluateException evaluateException) {
                                }
                            }
                        }
                    }
                }
                StackFrameProxyImpl proxy = null;
                if (currentThread != null) {
                    try {
                        while (!currentThread.isSuspended()) {
                            TimeoutUtil.sleep((long)10L);
                        }
                        proxy = currentThread.frameCount() > 0 ? currentThread.frame(0) : null;
                    }
                    catch (ObjectCollectedException ignored) {
                        proxy = null;
                    }
                    catch (EvaluateException e) {
                        proxy = null;
                        LOG.error((Throwable)e);
                    }
                }
                SimpleStackFrameContext simpleStackFrameContext = new SimpleStackFrameContext(proxy, this.myDebugProcess);
                position = ContextUtil.getSourcePosition(simpleStackFrameContext);
            } else {
                SuspendContextImpl suspendContextImpl = suspendContext;
                position = this.myDebugProcess.getPositionManager().getSourcePosition(suspendContext.getLocation());
            }
            if (currentThread != null) {
                try {
                    int frameCount = currentThread.frameCount();
                    if (frameCount == 0 || frameCount <= DebuggerSession.this.myIgnoreFiltersFrameCountThreshold) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if (position != null) {
                List<Pair<Breakpoint, com.sun.jdi.event.Event>> eventDescriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext);
                RequestManagerImpl requestsManager = suspendContext.getDebugProcess().getRequestsManager();
                PsiFile foundFile = position.getFile();
                boolean sourceMissing = foundFile instanceof PsiCompiledElement;
                for (Pair<Breakpoint, com.sun.jdi.event.Event> eventDescriptor : eventDescriptors) {
                    String className;
                    void var4_7;
                    Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition breakpointPosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (breakpointPosition == null || !sourceMissing && breakpointPosition.getLine() != position.getLine()) {
                        requestsManager.deleteRequest(breakpoint);
                        requestsManager.setInvalid(breakpoint, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!sourceMissing) continue;
                    position = breakpointPosition;
                    StackFrameProxy frameProxy = var4_7.getFrameProxy();
                    try {
                        className = frameProxy != null ? frameProxy.location().declaringType().name() : "";
                    }
                    catch (EvaluateException ignored) {
                        className = "";
                    }
                    requestsManager.setInvalid(breakpoint, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{className}));
                    breakpoint.updateUI();
                }
            }
            if (suspendContext.getThread() == currentThread || suspendContext.getThread() == null) {
                DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContext, currentThread, null);
                debuggerContext.setPositionCache(position);
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.PAUSE, DebuggerSession.getDescription(debuggerContext)));
                return;
            } else {
                ThreadReferenceProxyImpl steppingThread = currentThread;
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.switchToActiveSteppingContext(steppingThread));
            }
        }

        private boolean shouldSetAsActiveContext(SuspendContextImpl suspendContext, boolean isSteppingEnds) {
            if (suspendContext.getSuspendPolicy() == 2) {
                return true;
            }
            if (DebuggerSession.this.getProcess().getSuspendManager().getPausedContexts().size() > 1) {
                return isSteppingEnds;
            }
            ThreadReferenceProxyImpl newThread = suspendContext.getEventThread();
            if ((newThread == null || !this.myDebugProcess.isSteppingInProgress()) && suspendContext.threadFilterWasPassed) {
                return true;
            }
            SuspendContextImpl currentSuspendContext = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
            if ((currentSuspendContext == null || currentSuspendContext.isResumed()) && suspendContext.threadFilterWasPassed) {
                return DebuggerSession.this.mySteppingThroughThread.get() == null;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                ThreadReferenceProxyImpl currentThread = currentSuspendContext.getThread();
                return currentThread == null || Comparing.equal((Object)currentThread.getThreadReference(), (Object)newThread.getThreadReference());
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContext) {
            SuspendContextImpl context = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            ThreadReferenceProxyImpl steppingThread = suspendContext.getSuspendPolicy() == 1 ? suspendContext.getThread() : null;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                if (this.myDebugProcess.isSteppingInProgress() && context != null) {
                    DebuggerSession.this.switchToActiveSteppingContext(steppingThread);
                } else if (context != null) {
                    DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, context, context.getThread(), null);
                    DebuggerSession.this.getContextManager().setState(debuggerContext, State.PAUSED, Event.CONTEXT, DebuggerSession.getDescription(debuggerContext));
                } else {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.CONTEXT, null);
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl process) {
            String message = JavaDebuggerBundle.message((String)"status.connected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(process.getConnection())});
            process.printToConsole(message + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.RUNNING, Event.ATTACHED, message));
        }

        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                Object message = "";
                if (state instanceof RemoteState) {
                    message = JavaDebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)});
                }
                message = (String)message + exception.getMessage();
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, (String)message);
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcess, boolean closedByUser) {
            ProcessHandler processHandler;
            if (!closedByUser && (processHandler = debugProcess.getProcessHandler()) != null) {
                processHandler.notifyTextAvailable(JavaDebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, State.STOPPED, Event.DETACHED, JavaDebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())})));
            DebuggerSession.this.clearSteppingThrough();
        }

        public void threadStarted(@NotNull DebugProcess proc, ThreadReference thread) {
            if (proc == null) {
                MyDebugProcessListener.$$$reportNull$$$0(0);
            }
            this.notifyThreadsRefresh();
        }

        public void threadStopped(@NotNull DebugProcess proc, ThreadReference thread) {
            DebugProcessImpl debugProcess;
            if (proc == null) {
                MyDebugProcessListener.$$$reportNull$$$0(1);
            }
            this.notifyThreadsRefresh();
            ThreadReferenceProxyImpl steppingThread = DebuggerSession.this.mySteppingThroughThread.get();
            if (steppingThread != null && steppingThread.getThreadReference() == thread) {
                DebuggerSession.this.clearSteppingThrough();
            }
            if ((debugProcess = (DebugProcessImpl)proc).getRequestsManager().getFilterRealThread() == thread) {
                DebuggerManagerEx.getInstanceEx(proc.getProject()).getBreakpointManager().removeThreadFilter(debugProcess);
            }
        }

        private void notifyThreadsRefresh() {
            DebuggerSession.this.updateAlarm.cancelAndRequest(ApplicationManager.getApplication().isUnitTestMode() ? 0L : 100L, () -> {
                DebuggerStateManager contextManager = DebuggerSession.this.getContextManager();
                contextManager.fireStateChanged(contextManager.getContext(), Event.THREADS_REFRESH);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "proc";
            objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStopped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Event {
        ATTACHED,
        DETACHED,
        RESUME,
        STEP,
        PAUSE,
        REFRESH,
        CONTEXT,
        START_WAIT_ATTACH,
        DISPOSE,
        REFRESH_WITH_STACK,
        THREADS_REFRESH;

    }

    private static class BreakpointReachedNotificationListener
    extends NotificationListener.Adapter {
        private final WeakReference<SuspendContextImpl> myContextRef;

        BreakpointReachedNotificationListener(SuspendContextImpl suspendContext) {
            this.myContextRef = new WeakReference<SuspendContextImpl>(suspendContext);
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                BreakpointReachedNotificationListener.$$$reportNull$$$0(0);
            }
            if (e == null) {
                BreakpointReachedNotificationListener.$$$reportNull$$$0(1);
            }
            notification.hideBalloon();
            SuspendContextImpl suspendContext = (SuspendContextImpl)((Object)SoftReference.dereference(this.myContextRef));
            if (suspendContext != null) {
                DebuggerSession.switchContext(suspendContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/impl/DebuggerSession$BreakpointReachedNotificationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

