/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.codeInsight.hints.presentation.InlayButtonPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.JavaDebuggerActionsCollector;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.JvmExceptionOccurrenceFilter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public final class JavaDebuggerAddExceptionBreakpointFilter
implements JvmExceptionOccurrenceFilter {
    @Nullable
    public Filter.ResultItem applyFilter(@NotNull String exceptionClassName, @NotNull List<PsiClass> classes, int exceptionStartOffset) {
        if (exceptionClassName == null) {
            JavaDebuggerAddExceptionBreakpointFilter.$$$reportNull$$$0(0);
        }
        if (classes == null) {
            JavaDebuggerAddExceptionBreakpointFilter.$$$reportNull$$$0(1);
        }
        return new CreateExceptionBreakpointResult(exceptionStartOffset, exceptionStartOffset + exceptionClassName.length(), exceptionClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "exceptionClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "classes";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/impl/attach/JavaDebuggerAddExceptionBreakpointFilter";
        objectArray[2] = "applyFilter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CreateExceptionBreakpointResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myExceptionFqn;

        CreateExceptionBreakpointResult(int highlightStartOffset, int highlightEndOffset, String exceptionFqn) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myExceptionFqn = exceptionFqn;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            DebuggerStatistics.logThreadDumpTriggerException(editor.getProject(), this.myExceptionFqn);
            PresentationFactory factory = new PresentationFactory(editor);
            InlayButtonPresentationFactory inlayButtonFactory = new InlayButtonPresentationFactory(editor, factory, DefaultLanguageHighlighterColors.INLAY_BUTTON_DEFAULT, DefaultLanguageHighlighterColors.INLAY_BUTTON_HOVERED, DefaultLanguageHighlighterColors.INLAY_BUTTON_FOCUSED);
            InlayPresentation presentation = inlayButtonFactory.smallText("Create breakpoint").onClick((event, point) -> {
                ExceptionBreakpoint ebpt;
                JavaDebuggerActionsCollector.createExceptionBreakpointInlay.log();
                Project project = editor.getProject();
                Collection exceptionBreakpoints = XDebuggerManager.getInstance((Project)project).getBreakpointManager().getBreakpoints(JavaExceptionBreakpointType.class);
                XBreakpoint breakpoint = (XBreakpoint)ContainerUtil.find((Iterable)exceptionBreakpoints, b -> Objects.equals(this.myExceptionFqn, ((JavaExceptionBreakpointProperties)b.getProperties()).myQualifiedName));
                if (breakpoint == null && (ebpt = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager().addExceptionBreakpoint(this.myExceptionFqn)) != null) {
                    breakpoint = ebpt.getXBreakpoint();
                }
                if (breakpoint != null) {
                    BreakpointsDialogFactory.getInstance((Project)project).showDialog(breakpoint);
                }
            }).build();
            return new PresentationRenderer(presentation);
        }
    }
}

