/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.execution.ExecutionException;
import com.intellij.util.SystemProperties;
import com.sun.jdi.connect.AttachingConnector;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SAPidRemoteConnection
extends PidRemoteConnection {
    private static ClassLoader BASE_SA_JDI_CLASS_LOADER;
    private final String mySAJarPath;

    public SAPidRemoteConnection(String pid, String saJarPath) {
        super(pid);
        this.mySAJarPath = saJarPath;
    }

    @Override
    public AttachingConnector getConnector(DebugProcessImpl debugProcess) throws ExecutionException {
        try {
            Path saJarPath = Paths.get(this.mySAJarPath, new String[0]);
            Class<?> connectorClass = Class.forName("sun.jvm.hotspot.jdi.SAPIDAttachingConnector", true, new JBSAJDIClassLoader(SAPidRemoteConnection.getBaseSAJDIClassLoader(saJarPath), saJarPath));
            return (AttachingConnector)connectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ExecutionException(JavaDebuggerBundle.message((String)"error.unable.to.create.sapidattachingconnector", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @NotNull
    private static synchronized ClassLoader getBaseSAJDIClassLoader(Path fallback) {
        if (BASE_SA_JDI_CLASS_LOADER == null) {
            Path saJdiJar = Paths.get(SystemProperties.getJavaHome(), "lib/sa-jdi.jar");
            if (!Files.exists(saJdiJar, new LinkOption[0]) && !Files.exists(saJdiJar = Paths.get(SystemProperties.getJavaHome(), "../lib/sa-jdi.jar"), new LinkOption[0])) {
                saJdiJar = fallback;
            }
            BASE_SA_JDI_CLASS_LOADER = new JBSAJDIClassLoader(SAPidRemoteConnection.class.getClassLoader(), saJdiJar);
        }
        ClassLoader classLoader = BASE_SA_JDI_CLASS_LOADER;
        if (classLoader == null) {
            SAPidRemoteConnection.$$$reportNull$$$0(0);
        }
        return classLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/attach/SAPidRemoteConnection", "getBaseSAJDIClassLoader"));
    }

    private static class JBSAJDIClassLoader
    extends URLClassLoader {
        JBSAJDIClassLoader(ClassLoader parent, Path classPath) {
            super(new URL[0], parent);
            try {
                this.addURL(classPath.toUri().toURL());
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }

        public synchronized Class loadClass(String name) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (name.startsWith("sun.jvm.hotspot.") && !name.startsWith("sun.jvm.hotspot.debugger.")) {
                    return this.findClass(name);
                }
                return super.loadClass(name);
            }
            return c;
        }

        @Override
        @Nullable
        public URL getResource(String name) {
            URL resource;
            if ("sa.properties".equals(name) && (resource = this.findResource(name)) != null) {
                return resource;
            }
            return super.getResource(name);
        }
    }
}

