/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebugUtilsKt;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.attach.SAJDWPRemoteConnection;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class VirtualMachineProxyImpl
extends UserDataHolderBase
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger LOG = Logger.getInstance(VirtualMachineProxyImpl.class);
    private final DebugProcessImpl myDebugProcess;
    private final VirtualMachine myVirtualMachine;
    private int myTimeStamp;
    private int myModelSuspendCount;
    private final Map<String, StringReference> myStringLiteralCache;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> myAllThreads;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> myThreadGroups;
    private boolean myAllThreadsDirty;
    private List<ReferenceType> myAllClasses;
    private Map<ReferenceType, List<ReferenceType>> myNestedClassesCache;
    private final boolean myVersionHigher_15;
    private final boolean myVersionHigher_14;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcess, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(0);
        }
        this.myTimeStamp = 0;
        this.myModelSuspendCount = 0;
        this.myStringLiteralCache = new HashMap<String, StringReference>();
        this.myAllThreads = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.myThreadGroups = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
        this.myAllThreadsDirty = true;
        this.myNestedClassesCache = new HashMap<ReferenceType, List<ReferenceType>>();
        this.myVirtualMachine = virtualMachine;
        this.myDebugProcess = debugProcess;
        this.myVersionHigher_15 = DebuggerUtils.isAndroidVM((VirtualMachine)this.myVirtualMachine) || this.versionHigher("1.5");
        this.myVersionHigher_14 = this.myVersionHigher_15 || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        if (this.canBeModified()) {
            DebugUtilsKt.preloadAllClasses(virtualMachine);
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.myVirtualMachine;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(1);
        }
        return virtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    public List<ReferenceType> classesByName(@NotNull String s) {
        if (s == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(2);
        }
        return this.myVirtualMachine.classesByName(s);
    }

    public List<ReferenceType> nestedTypes(ReferenceType refType) {
        List<Object> nestedTypes = this.myNestedClassesCache.get(refType);
        if (nestedTypes == null) {
            List<Object> list = Collections.emptyList();
            try {
                list = refType.nestedTypes();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            if (!list.isEmpty()) {
                HashSet<ReferenceType> candidates = new HashSet<ReferenceType>();
                ClassLoaderReference outerLoader = refType.classLoader();
                for (ReferenceType referenceType : list) {
                    try {
                        if (!Objects.equals(outerLoader, referenceType.classLoader())) continue;
                        candidates.add(referenceType);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!candidates.isEmpty()) {
                    HashSet<ReferenceType> nested2 = new HashSet<ReferenceType>();
                    for (ReferenceType candidate : candidates) {
                        VirtualMachineProxyImpl.addNestedTypes(candidate, candidates, nested2);
                    }
                    candidates.removeAll(nested2);
                }
                nestedTypes = candidates.isEmpty() ? Collections.emptyList() : new ArrayList(candidates);
            } else {
                nestedTypes = Collections.emptyList();
            }
            this.myNestedClassesCache.put(refType, nestedTypes);
        }
        return nestedTypes;
    }

    @ApiStatus.Internal
    public static void addNestedTypes(ReferenceType base, Collection<ReferenceType> classes, Collection<ReferenceType> nested) {
        String baseName = base.name();
        int baseLength = baseName.length();
        classes.forEach(type -> {
            char c;
            String name = type.name();
            int length = name.length();
            if (length > baseLength && name.startsWith(baseName) && ((c = name.charAt(baseLength)) == '$' || c == '#')) {
                nested.add((ReferenceType)type);
            }
        });
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> allClasses = this.myAllClasses;
        if (allClasses == null) {
            this.myAllClasses = allClasses = this.myVirtualMachine.allClasses();
        }
        return allClasses;
    }

    public String toString() {
        return this.myVirtualMachine.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.myVirtualMachine.redefineClasses(map2);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myAllThreadsDirty) {
            this.myAllThreadsDirty = false;
            for (ThreadReference threadReference : this.myVirtualMachine.allThreads()) {
                this.getThreadReferenceProxy(threadReference, true);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.myAllThreads.values());
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public Collection<ThreadReferenceProxyImpl> getEvenDirtyAllThreads() {
        Collection<ThreadReferenceProxyImpl> collection = this.myAllThreads.values();
        if (collection == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public CompletableFuture<Collection<ThreadReferenceProxyImpl>> allThreadsAsync() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myAllThreadsDirty) {
            return DebuggerUtilsAsync.allThreads(this.myVirtualMachine).thenApply(threads -> {
                DebuggerManagerThreadImpl.assertIsManagerThread();
                threads.forEach(thread -> this.getThreadReferenceProxy((ThreadReference)thread, true));
                this.myAllThreadsDirty = false;
                return new ArrayList<ThreadReferenceProxyImpl>(this.myAllThreads.values());
            });
        }
        return CompletableFuture.completedFuture(new ArrayList<ThreadReferenceProxyImpl>(this.myAllThreads.values()));
    }

    public void threadStarted(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(thread, true);
    }

    public void threadStopped(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myAllThreads.remove(thread);
    }

    public void suspend() {
        if (!this.canBeModified()) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.myModelSuspendCount;
        DebuggerUtilsAsync.suspend(this.myVirtualMachine).thenRun(this::clearCaches);
    }

    public void resume() {
        if (!this.canBeModified()) {
            return;
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myModelSuspendCount <= 0) {
            this.myDebugProcess.logError("Negative global suspend count number!");
        }
        if (this.myModelSuspendCount > 0) {
            --this.myModelSuspendCount;
        }
        this.clearCaches();
        LOG.debug("before resume VM");
        DebuggerUtilsAsync.resume(this.myVirtualMachine).whenComplete((unused, throwable) -> {
            if (throwable != null && !(DebuggerUtilsAsync.unwrap(throwable) instanceof RejectedExecutionException)) {
                this.myDebugProcess.logError("Error on resume", (Throwable)throwable);
            }
            LOG.debug("VM resumed");
        });
    }

    public @Unmodifiable List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return ContainerUtil.map(this.getVirtualMachine().topLevelThreadGroups(), this::getThreadGroupReferenceProxy);
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl proxy = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.myThreadGroups.put(threadGroupReference, proxy);
        }
    }

    private boolean isJ2ME() {
        return VirtualMachineProxyImpl.isJ2ME(this.getVirtualMachine());
    }

    private static boolean isJ2ME(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myThreadGroups.remove(threadGroupReference);
    }

    public EventRequestManager eventRequestManager() {
        return this.myVirtualMachine.eventRequestManager();
    }

    public VoidValue mirrorOfVoid() {
        return this.myVirtualMachine.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public ByteValue mirrorOf(byte b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public CharValue mirrorOf(char c) {
        return this.myVirtualMachine.mirrorOf(c);
    }

    public ShortValue mirrorOf(short i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public IntegerValue mirrorOf(int i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public LongValue mirrorOf(long l) {
        return this.myVirtualMachine.mirrorOf(l);
    }

    public FloatValue mirrorOf(float v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public DoubleValue mirrorOf(double v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    @ApiStatus.Obsolete
    public StringReference mirrorOf(String s) {
        return this.myVirtualMachine.mirrorOf(s);
    }

    @ApiStatus.Internal
    public StringReference mirrorOfStringLiteral(String s, EvaluationContextImpl context) throws EvaluateException {
        Method internMethod;
        StringReference reference = this.myStringLiteralCache.get(s);
        if (reference != null) {
            try {
                context.keep(reference);
                return reference;
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }
        reference = DebuggerUtilsEx.mirrorOfString(s, context);
        if (Registry.is((String)"debugger.intern.string.literals") && this.versionHigher("1.7") && (internMethod = DebuggerUtils.findMethod((ReferenceType)reference.referenceType(), (String)"intern", (String)"()Ljava/lang/String;")) != null) {
            reference = (StringReference)context.getDebugProcess().invokeMethod((EvaluationContext)context, reference, internMethod, Collections.emptyList());
        }
        this.myStringLiteralCache.put(s, reference);
        return reference;
    }

    public void dispose() {
        try {
            this.myVirtualMachine.dispose();
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Throwable)e);
        }
    }

    public void exit(int i) {
        this.myVirtualMachine.exit(i);
    }

    public boolean canWatchFieldModification() {
        return this.myVirtualMachine.canWatchFieldModification();
    }

    public boolean canWatchFieldAccess() {
        return this.myVirtualMachine.canWatchFieldAccess();
    }

    public boolean canInvokeMethods() {
        return !this.isJ2ME();
    }

    public boolean canGetBytecodes() {
        return this.myVirtualMachine.canGetBytecodes();
    }

    public boolean canGetConstantPool() {
        return this.myVirtualMachine.canGetConstantPool();
    }

    public boolean canGetSourceDebugExtension() {
        return this.myVirtualMachine.canGetSourceDebugExtension();
    }

    public boolean canGetSyntheticAttribute() {
        return this.myVirtualMachine.canGetSyntheticAttribute();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.myVirtualMachine.canGetOwnedMonitorInfo();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.myVirtualMachine.canGetMonitorFrameInfo();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.myVirtualMachine.canGetCurrentContendedMonitor();
    }

    public boolean canGetMonitorInfo() {
        return this.myVirtualMachine.canGetMonitorInfo();
    }

    public boolean canRedefineClasses() {
        return this.myVersionHigher_14 && this.myVirtualMachine.canRedefineClasses();
    }

    public boolean canPopFrames() {
        return this.myVersionHigher_14 && this.myVirtualMachine.canPopFrames();
    }

    public boolean canForceEarlyReturn() {
        return this.myVirtualMachine.canForceEarlyReturn();
    }

    public boolean canBeModified() {
        return !(this.myDebugProcess.getConnection() instanceof SAJDWPRemoteConnection) && this.myVirtualMachine.canBeModified();
    }

    public final boolean versionHigher(String version) {
        return this.myVirtualMachine.version().compareTo(version) >= 0;
    }

    public boolean canGetMethodReturnValues() {
        return this.myVersionHigher_15 && this.myVirtualMachine.canGetMethodReturnValues();
    }

    public boolean canUseSourceNameFilters() {
        return this.myVirtualMachine.canUseSourceNameFilters();
    }

    public String description() {
        return this.myVirtualMachine.description();
    }

    public String version() {
        return this.myVirtualMachine.version();
    }

    public String name() {
        return this.myVirtualMachine.name();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference thread) {
        return this.getThreadReferenceProxy(thread, false);
    }

    private ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference thread, boolean forceCache) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread == null) {
            return null;
        }
        ThreadReferenceProxyImpl proxy = this.myAllThreads.computeIfAbsent(thread, t -> {
            if (!forceCache && thread instanceof ThreadReferenceImpl && thread.isVirtual()) {
                return null;
            }
            return new ThreadReferenceProxyImpl(this, (ThreadReference)t);
        });
        if (proxy == null) {
            proxy = new ThreadReferenceProxyImpl(this, thread);
        }
        return proxy;
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference group) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (group == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl proxy = this.myThreadGroups.get(group);
        if (proxy == null && !this.isJ2ME()) {
            proxy = new ThreadGroupReferenceProxyImpl(this, group);
            this.myThreadGroups.put(group, proxy);
        }
        return proxy;
    }

    public boolean equals(Object obj) {
        LOG.assertTrue(obj instanceof VirtualMachineProxyImpl);
        return this.myVirtualMachine.equals(((VirtualMachineProxyImpl)obj).getVirtualMachine());
    }

    public int hashCode() {
        return this.myVirtualMachine.hashCode();
    }

    public void clearCaches() {
        LOG.debug("VM cleared");
        this.myAllClasses = null;
        if (!this.myNestedClassesCache.isEmpty()) {
            this.myNestedClassesCache = new HashMap<ReferenceType, List<ReferenceType>>(this.myNestedClassesCache.size());
        }
        ++this.myTimeStamp;
    }

    @Override
    public int getCurrentTime() {
        return this.myTimeStamp;
    }

    public DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    public static boolean isCollected(ObjectReference reference) {
        try {
            return !VirtualMachineProxyImpl.isJ2ME(reference.virtualMachine()) && reference.isCollected();
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    public boolean isPausePressed() {
        return this.myModelSuspendCount > 0;
    }

    public boolean isSuspended() {
        return ContainerUtil.exists(this.allThreads(), thread -> thread.getSuspendCount() != 0);
    }

    public int getModelSuspendCount() {
        return this.myModelSuspendCount;
    }

    public void addedSuspendAllContext() {
        ++this.myModelSuspendCount;
    }

    public void resumedSuspendAllContext() {
        if (this.myModelSuspendCount <= 0) {
            this.myDebugProcess.logError("Negative global suspend count number!");
        }
        --this.myModelSuspendCount;
    }

    @ApiStatus.Internal
    @NotNull
    public static VirtualMachineProxyImpl getCurrent() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)VirtualMachineProxy.getCurrent();
        if (virtualMachineProxyImpl == null) {
            VirtualMachineProxyImpl.$$$reportNull$$$0(4);
        }
        return virtualMachineProxyImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvenDirtyAllThreads";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

