/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

final class MemoryAgentInitializer {
    private static final Key<MemoryAgent> MEMORY_AGENT_KEY = Key.create((String)"MEMORY_AGENT_KEY");
    private static final Logger LOG = Logger.getInstance(MemoryAgentInitializer.class);

    MemoryAgentInitializer() {
    }

    @NotNull
    static MemoryAgent getAgent(@NotNull EvaluationContextImpl evaluationContext) {
        MemoryAgent agent;
        if (evaluationContext == null) {
            MemoryAgentInitializer.$$$reportNull$$$0(0);
        }
        MemoryAgent memoryAgent = (agent = (MemoryAgent)evaluationContext.getVirtualMachineProxy().getUserData(MEMORY_AGENT_KEY)) == null ? MemoryAgentInitializer.initializeAgent(evaluationContext) : agent;
        if (memoryAgent == null) {
            MemoryAgentInitializer.$$$reportNull$$$0(1);
        }
        return memoryAgent;
    }

    static MemoryAgent initializeAgent(@NotNull EvaluationContextImpl evaluationContext) {
        if (evaluationContext == null) {
            MemoryAgentInitializer.$$$reportNull$$$0(2);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MemoryAgent agent = MemoryAgentImpl.DISABLED;
        try {
            agent = MemoryAgentImpl.createMemoryAgent(evaluationContext);
        }
        catch (EvaluateException e) {
            LOG.error("Could not initialize memory agent. ", (Throwable)e);
        }
        evaluationContext.getVirtualMachineProxy().putUserData(MEMORY_AGENT_KEY, agent);
        return agent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAgent";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeAgent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

