/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class MemoryAgentPathsToClosestGCRootsProvider
implements ReferringObjectsProvider {
    private final Map<ObjectReference, ReferringObjectsInfo> myCachedRequests = new HashMap<ObjectReference, ReferringObjectsInfo>();
    private final int myPathsToRequestLimit;
    private final int myObjectsToRequestLimit;
    private final ReferringObjectsProvider myDefaultProvider;

    public MemoryAgentPathsToClosestGCRootsProvider(int pathsToRequestLimit, int objectsToRequestLimit, ReferringObjectsProvider defaultProvider) {
        this.myPathsToRequestLimit = pathsToRequestLimit;
        this.myObjectsToRequestLimit = objectsToRequestLimit;
        this.myDefaultProvider = defaultProvider;
    }

    @Override
    @NotNull
    public @Unmodifiable List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value, long limit) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(1);
        }
        if (this.myCachedRequests.containsKey(value)) {
            List<ReferringObject> list = this.myCachedRequests.get(value).getReferringObjects(value, limit);
            if (list == null) {
                MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        for (ReferringObjectsInfo provider : this.myCachedRequests.values()) {
            if (!provider.hasReferringObjectsFor(value)) continue;
            List<ReferringObject> list = provider.getReferringObjects(value, limit);
            if (list == null) {
                MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext);
        if (memoryAgent.isDisabled()) {
            List<ReferringObject> list = this.myDefaultProvider.getReferringObjects(evaluationContext, value, this.myObjectsToRequestLimit);
            if (list == null) {
                MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ReferringObjectsInfo roots = this.getPathsToGcRoots(memoryAgent, evaluationContext, value);
        this.myCachedRequests.put(value, roots);
        List<ReferringObject> list = roots.getReferringObjects(value, limit);
        if (list == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private ReferringObjectsInfo getPathsToGcRoots(@NotNull MemoryAgent memoryAgent, @NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value) throws EvaluateException {
        if (memoryAgent == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(6);
        }
        if (evaluationContext == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(7);
        }
        if (value == null) {
            MemoryAgentPathsToClosestGCRootsProvider.$$$reportNull$$$0(8);
        }
        return memoryAgent.findPathsToClosestGCRoots(evaluationContext, value, this.myPathsToRequestLimit, this.myObjectsToRequestLimit, Registry.get((String)"debugger.memory.agent.action.timeout").asInteger()).getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentPathsToClosestGCRootsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryAgent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentPathsToClosestGCRootsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferringObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferringObjects";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToGcRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

