/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.MemoryAgentArrayReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentConstantPoolReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentFieldReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentKindReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentReferenceKind;
import com.intellij.debugger.memory.agent.MemoryAgentReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentTruncatedReferringObject;
import com.intellij.debugger.memory.agent.parsers.IntArrayParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/MemoryAgentReferringObjectCreator;", "", "<init>", "()V", "createReferringObject", "Lcom/intellij/debugger/memory/agent/MemoryAgentReferringObject;", "referrer", "Lcom/sun/jdi/ObjectReference;", "kind", "Lcom/intellij/debugger/memory/agent/MemoryAgentReferenceKind;", "isWeakSoftReachable", "", "value", "Lcom/sun/jdi/Value;", "getFieldByJVMTIFieldIndex", "Lcom/sun/jdi/Field;", "reference", "index", "", "intellij.java.debugger.impl"})
public final class MemoryAgentReferringObjectCreator {
    @NotNull
    public static final MemoryAgentReferringObjectCreator INSTANCE = new MemoryAgentReferringObjectCreator();

    private MemoryAgentReferringObjectCreator() {
    }

    @NotNull
    public final MemoryAgentReferringObject createReferringObject(@NotNull ObjectReference referrer, @NotNull MemoryAgentReferenceKind kind, boolean isWeakSoftReachable, @Nullable Value value) {
        MemoryAgentReferringObject memoryAgentReferringObject;
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        if (value == null) {
            memoryAgentReferringObject = new MemoryAgentKindReferringObject(referrer, isWeakSoftReachable, kind);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: 
                case 2: {
                    Field field = this.getFieldByJVMTIFieldIndex(referrer, ((Number)IntArrayParser.INSTANCE.parse(value).get(0)).intValue());
                    if (field == null) {
                        return new MemoryAgentKindReferringObject(referrer, isWeakSoftReachable, kind);
                    }
                    Field field2 = field;
                    memoryAgentReferringObject = new MemoryAgentFieldReferringObject(referrer, isWeakSoftReachable, field2);
                    break;
                }
                case 3: {
                    memoryAgentReferringObject = new MemoryAgentConstantPoolReferringObject(referrer, ((Number)IntArrayParser.INSTANCE.parse(value).get(0)).intValue());
                    break;
                }
                case 4: {
                    memoryAgentReferringObject = new MemoryAgentArrayReferringObject((ArrayReference)referrer, isWeakSoftReachable, ((Number)IntArrayParser.INSTANCE.parse(value).get(0)).intValue());
                    break;
                }
                case 5: {
                    memoryAgentReferringObject = new MemoryAgentTruncatedReferringObject(referrer, isWeakSoftReachable, ((Number)IntArrayParser.INSTANCE.parse(value).get(0)).intValue());
                    break;
                }
                default: {
                    memoryAgentReferringObject = new MemoryAgentKindReferringObject(referrer, isWeakSoftReachable, kind);
                }
            }
        }
        return memoryAgentReferringObject;
    }

    private final Field getFieldByJVMTIFieldIndex(ObjectReference reference, int index) {
        if (index < 0) {
            return null;
        }
        List<Field> allFields = reference.referenceType().allFields();
        ListIterator<Field> it = allFields.listIterator(allFields.size());
        int currIndex = index;
        ReferenceType declaringType = null;
        while (it.hasPrevious()) {
            Field field = it.previous();
            if (Intrinsics.areEqual((Object)field.declaringType(), declaringType)) continue;
            declaringType = field.declaringType();
            List<Field> fields = declaringType.fields();
            if (currIndex < fields.size()) {
                return fields.get(currIndex);
            }
            currIndex -= fields.size();
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MemoryAgentReferenceKind.values().length];
            try {
                nArray[MemoryAgentReferenceKind.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryAgentReferenceKind.STATIC_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryAgentReferenceKind.CONSTANT_POOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryAgentReferenceKind.ARRAY_ELEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryAgentReferenceKind.TRUNCATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

