/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.agent.ui.HighlightableTree;
import com.intellij.debugger.memory.agent.ui.MemoryAgentDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import icons.PlatformDebuggerImplIcons;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RetainedSizeDialog
extends MemoryAgentDialog {
    private static final Icon HELD_OBJECTS_MARK_ICON = AllIcons.Nodes.Locked;
    public static final Color HELD_OBJECTS_BACKGROUND_COLOR;
    private final Set<ObjectReference> myHeldObjects;
    private final NodeHighlighter myHighlighter;
    private final String myRootName;
    private final JBLabel myRetainedSizeLabel;

    public RetainedSizeDialog(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, @NotNull String name, @NotNull XValue value, XValueMarkers<?, ?> markers, @Nullable XDebugSession session, boolean rebuildOnSessionEvents) {
        if (project == null) {
            RetainedSizeDialog.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RetainedSizeDialog.$$$reportNull$$$0(1);
        }
        if (value == null) {
            RetainedSizeDialog.$$$reportNull$$$0(2);
        }
        super(project, name, value, session, new HighlightableTree(project, editorsProvider, sourcePosition, "XDebugger.Inspect.Tree.Popup", markers), rebuildOnSessionEvents);
        this.setTitle(JavaDebuggerBundle.message((String)"action.calculate.retained.size.title", (Object[])new Object[]{name}));
        this.myHighlighter = new NodeHighlighter();
        this.myTree.addTreeListener((XDebuggerTreeListener)this.myHighlighter);
        this.myHeldObjects = new HashSet<ObjectReference>();
        this.myRootName = name;
        this.myRetainedSizeLabel = new JBLabel(JavaDebuggerBundle.message((String)"action.calculate.retained.size.waiting.message", (Object[])new Object[0]));
        this.myTopPanel.add((Component)this.myRetainedSizeLabel);
    }

    public void setCalculationTimeoutMessage() {
        this.myRetainedSizeLabel.setText(JavaDebuggerBundle.message((String)"debugger.memory.agent.timeout.error", (Object[])new Object[0]));
    }

    public void setAgentCouldntBeLoadedMessage() {
        this.myRetainedSizeLabel.setText(JavaDebuggerBundle.message((String)"debugger.memory.agent.loading.error", (Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void setHeldObjectsAndSizes(@NotNull Collection<? extends ObjectReference> heldObjects, long shallowSize, long l) {
        void retainedSize;
        if (heldObjects == null) {
            RetainedSizeDialog.$$$reportNull$$$0(3);
        }
        this.myHeldObjects.clear();
        this.myHeldObjects.addAll(heldObjects);
        this.highlightLoadedChildren();
        this.myRetainedSizeLabel.setText(JavaDebuggerBundle.message((String)"action.calculate.retained.size.text", (Object[])new Object[]{this.myRootName, StringUtil.formatFileSize((long)retainedSize), StringUtil.formatFileSize((long)shallowSize)}));
        this.myTree.repaint();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#javadebugger.RetainedSizeDialog";
    }

    private void highlightLoadedChildren() {
        Stack nodes = new Stack();
        XValueNodeImpl parent = (XValueNodeImpl)this.myTree.getRoot();
        nodes.push((Object)parent);
        while (!nodes.empty()) {
            XValueNodeImpl node = (XValueNodeImpl)nodes.pop();
            for (TreeNode child : node.getLoadedChildren()) {
                XValueNodeImpl childImpl;
                if (!(child instanceof XValueNodeImpl) || !this.myHeldObjects.contains(DebuggerTreeAction.getObjectReference(childImpl = (XValueNodeImpl)child))) continue;
                this.myHighlighter.highlightNode(childImpl);
                nodes.push((Object)childImpl);
            }
        }
    }

    @Override
    public ProgressIndicator createProgressIndicator() {
        return new MemoryAgentDialog.MemoryAgentActionProgressIndicator(){

            @Override
            public void stop() {
                super.stop();
                RetainedSizeDialog.this.myInfoLabel.setVisible(true);
                RetainedSizeDialog.this.myInfoLabel.setText(JavaDebuggerBundle.message((String)"action.calculate.retained.size.info", (Object[])new Object[]{RetainedSizeDialog.this.myRootName}));
                RetainedSizeDialog.this.myInfoLabel.setIcon(AllIcons.General.Information);
            }
        };
    }

    static {
        Color background = UIUtil.getTreeSelectionBackground((boolean)true);
        HELD_OBJECTS_BACKGROUND_COLOR = new JBColor(new Color(background.getRed(), background.getGreen(), background.getBlue(), 30), new Color(background.getRed(), background.getGreen(), background.getBlue(), 30));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heldObjects";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/agent/ui/RetainedSizeDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setHeldObjectsAndSizes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class NodeHighlighter
    implements XDebuggerTreeListener {
        private boolean mySkipNotification = false;
        private final Map<Icon, Icon> myCachedIcons = new HashMap<Icon, Icon>();

        NodeHighlighter() {
        }

        public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
            XValuePresentation presentation;
            XValueNodeImpl nodeImpl;
            if (node == null) {
                NodeHighlighter.$$$reportNull$$$0(0);
            }
            if (name == null) {
                NodeHighlighter.$$$reportNull$$$0(1);
            }
            if (!this.mySkipNotification && node instanceof XValueNodeImpl && (nodeImpl = (XValueNodeImpl)node) != nodeImpl.getTree().getRoot() && RetainedSizeDialog.this.myHeldObjects.contains(DebuggerTreeAction.getObjectReference(nodeImpl)) && (presentation = nodeImpl.getValuePresentation()) != null && nodeImpl.getIcon() != PlatformDebuggerImplIcons.PinToTop.UnpinnedItem) {
                this.highlightNode(nodeImpl);
            }
            this.mySkipNotification = false;
        }

        public void highlightNode(@NotNull XValueNodeImpl node) {
            if (node == null) {
                NodeHighlighter.$$$reportNull$$$0(2);
            }
            XValuePresentation presentation = node.getValuePresentation();
            Icon icon = node.getIcon();
            if (presentation != null && icon != PlatformDebuggerImplIcons.PinToTop.UnpinnedItem) {
                this.mySkipNotification = true;
                node.applyPresentation(this.myCachedIcons.computeIfAbsent(icon, nodeIcon -> LayeredIcon.layeredIcon((Icon[])new Icon[]{nodeIcon, HELD_OBJECTS_MARK_ICON})), presentation, !node.isLeaf());
                ((HighlightableTree)RetainedSizeDialog.this.myTree).addColoredPath(node.getPath(), HELD_OBJECTS_BACKGROUND_COLOR);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/agent/ui/RetainedSizeDialog$NodeHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nodeLoaded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

