/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.CollectionBreakpointUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.Component;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002>?B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J \u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020#H\u0002J \u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0016\u00101\u001a\u00020#2\f\u00102\u001a\b\u0012\u0004\u0012\u00020#03H\u0002J\u0016\u00104\u001a\u00020#2\f\u00102\u001a\b\u0012\u0004\u0012\u00020#03H\u0002J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u00020\u001eH\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u00020\u001eH\u0002J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010=\u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/debugger/memory/ui/CollectionHistoryView;", "", "myClsName", "", "myFieldName", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "myValueNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/xdebugger/XDebugProcess;Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;)V", "DEFAULT_SPLITTER_PROPORTION", "", "MAX_INSTANCES_NUMBER", "", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "Lorg/jetbrains/annotations/NotNull;", "myDebugSession", "Lcom/intellij/xdebugger/XDebugSession;", "mySuspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "kotlin.jvm.PlatformType", "myStackFrameList", "Lcom/intellij/debugger/memory/ui/StackFrameList;", "mySplitter", "Lcom/intellij/ui/JBSplitter;", "myNodeManager", "Lcom/intellij/debugger/memory/ui/CollectionHistoryView$MyNodeManager;", "myHistoryInstancesTree", "Lcom/intellij/xdebugger/memory/ui/InstancesTree;", "myHistoryTree", "myMainComponent", "Ljavax/swing/JComponent;", "setupInstancesTree", "", "setupHistoryTreeSelectionListener", "loadFieldHistory", "clsName", "fieldName", "parent", "loadHistory", "createChildren", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "values", "", "Lcom/sun/jdi/Value;", "renderer", "Lcom/intellij/debugger/ui/tree/render/NodeRenderer;", "invokeInDebuggerThread", "runnable", "Lkotlin/Function0;", "invokeLater", "getVirtualMachine", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "getParentNode", "tree", "getSelectedNode", "getObjectReferenceForNode", "Lcom/sun/jdi/ObjectReference;", "node", "getComponent", "MyNodeManager", "CollectionHistoryRenderer", "intellij.java.debugger.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCollectionHistoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionHistoryView.kt\ncom/intellij/debugger/memory/ui/CollectionHistoryView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n777#2:311\n873#2,2:312\n1391#2:314\n1480#2,5:315\n296#2,2:320\n296#2,2:322\n*S KotlinDebug\n*F\n+ 1 CollectionHistoryView.kt\ncom/intellij/debugger/memory/ui/CollectionHistoryView\n*L\n106#1:311\n106#1:312,2\n107#1:314\n107#1:315,5\n119#1:320,2\n120#1:322,2\n*E\n"})
public final class CollectionHistoryView {
    @NotNull
    private final String myClsName;
    @NotNull
    private final String myFieldName;
    @Nullable
    private final XValueNodeImpl myValueNode;
    private final float DEFAULT_SPLITTER_PROPORTION;
    private final long MAX_INSTANCES_NUMBER;
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    @NotNull
    private final XDebugSession myDebugSession;
    private final SuspendContextImpl mySuspendContext;
    @NotNull
    private final StackFrameList myStackFrameList;
    @NotNull
    private final JBSplitter mySplitter;
    @NotNull
    private final MyNodeManager myNodeManager;
    @NotNull
    private final InstancesTree myHistoryInstancesTree;
    @NotNull
    private final InstancesTree myHistoryTree;
    @NotNull
    private final JComponent myMainComponent;

    public CollectionHistoryView(@NotNull String myClsName, @NotNull String myFieldName, @NotNull XDebugProcess debugProcess, @Nullable XValueNodeImpl myValueNode) {
        Intrinsics.checkNotNullParameter((Object)myClsName, (String)"myClsName");
        Intrinsics.checkNotNullParameter((Object)myFieldName, (String)"myFieldName");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.myClsName = myClsName;
        this.myFieldName = myFieldName;
        this.myValueNode = myValueNode;
        this.DEFAULT_SPLITTER_PROPORTION = 0.5f;
        this.MAX_INSTANCES_NUMBER = 1000000L;
        DebugProcessImpl debugProcessImpl = ((JavaDebugProcess)debugProcess).getDebuggerSession().getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debugProcessImpl), (String)"getProcess(...)");
        this.myDebugProcess = debugProcessImpl;
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        this.myDebugSession = xDebugSession;
        this.mySuspendContext = this.myDebugProcess.getSuspendManager().getPausedContext();
        this.myStackFrameList = new StackFrameList(this.myDebugProcess.getProject());
        this.mySplitter = new JBSplitter(false, this.DEFAULT_SPLITTER_PROPORTION);
        this.myNodeManager = new MyNodeManager(this.myDebugSession.getProject());
        this.myHistoryInstancesTree = new InstancesTree(this.myDebugProcess.getProject(), this.myDebugSession.getDebugProcess().getEditorsProvider(), DebuggerUtilsImpl.getValueMarkers(this.myDebugProcess), CollectionHistoryView::myHistoryInstancesTree$lambda$0);
        this.myHistoryTree = new InstancesTree(this.myDebugProcess.getProject(), this.myDebugSession.getDebugProcess().getEditorsProvider(), DebuggerUtilsImpl.getValueMarkers(this.myDebugProcess), CollectionHistoryView::myHistoryTree$lambda$0);
        this.setupHistoryTreeSelectionListener();
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHistoryTree));
        this.mySplitter.setSecondComponent((JComponent)new JBScrollPane((Component)((Object)this.myStackFrameList)));
        if (this.myValueNode == null) {
            this.setupInstancesTree();
            JBSplitter splitter = new JBSplitter(false, 0.3f);
            splitter.setHonorComponentsMinimumSize(false);
            splitter.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHistoryInstancesTree));
            splitter.setSecondComponent((JComponent)this.mySplitter);
            this.myMainComponent = (JComponent)splitter;
        } else {
            this.loadHistory();
            this.myMainComponent = (JComponent)this.mySplitter;
        }
    }

    private final void setupInstancesTree() {
        this.myHistoryInstancesTree.addTreeSelectionListener(arg_0 -> CollectionHistoryView.setupInstancesTree$lambda$0(this, arg_0));
        this.myHistoryInstancesTree.addChildren(this.createChildren(CollectionsKt.emptyList(), null), true);
        this.invokeInDebuggerThread((Function0<Unit>)((Function0)() -> CollectionHistoryView.setupInstancesTree$lambda$1(this)));
    }

    private final void setupHistoryTreeSelectionListener() {
        this.myHistoryTree.addChildren(this.createChildren(CollectionsKt.emptyList(), new CollectionHistoryRenderer()), true);
        this.myHistoryTree.addTreeSelectionListener(arg_0 -> CollectionHistoryView.setupHistoryTreeSelectionListener$lambda$0(this, arg_0));
    }

    private final void loadFieldHistory(String clsName, String fieldName, XValueNodeImpl parent) {
        Mirror mirror = this.getObjectReferenceForNode(parent);
        if (mirror == null || (mirror = mirror.referenceType()) == null || (mirror = mirror.fieldByName(fieldName)) == null) {
            return;
        }
        Mirror field = mirror;
        ObjectReference clsInstance = !field.isStatic() ? this.getObjectReferenceForNode((XValueNodeImpl)(parent instanceof XValueNodeImpl ? parent : null)) : null;
        List<Value> list = CollectionBreakpointUtils.getFieldModificationsHistory(this.mySuspendContext, fieldName, clsName, clsInstance);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFieldModificationsHistory(...)");
        List<Value> fieldModifications = list;
        this.invokeLater((Function0<Unit>)((Function0)() -> CollectionHistoryView.loadFieldHistory$lambda$0(this, fieldModifications)));
    }

    private final void loadHistory() {
        block0: {
            XValueNodeImpl xValueNodeImpl = this.myValueNode;
            if (xValueNodeImpl == null) break block0;
            XValueNodeImpl node = xValueNodeImpl;
            boolean bl = false;
            this.invokeInDebuggerThread((Function0<Unit>)((Function0)() -> CollectionHistoryView.loadHistory$lambda$0$0(node, this)));
        }
    }

    private final XValueChildrenList createChildren(List<? extends Value> values, NodeRenderer renderer) {
        XValueChildrenList children = new XValueChildrenList();
        this.mySuspendContext.getManagerThread().invokeAndWait(new DebuggerCommandImpl(values, this, renderer, children){
            final /* synthetic */ List<Value> $values;
            final /* synthetic */ CollectionHistoryView this$0;
            final /* synthetic */ NodeRenderer $renderer;
            final /* synthetic */ XValueChildrenList $children;
            {
                this.$values = $values;
                this.this$0 = $receiver;
                this.$renderer = $renderer;
                this.$children = $children;
                super(null, 1, null);
            }

            protected void action() {
                for (Value ins : this.$values) {
                    EvaluationContextImpl evalContext = new EvaluationContextImpl(CollectionHistoryView.access$getMySuspendContext$p(this.this$0), CollectionHistoryView.access$getMySuspendContext$p(this.this$0).getFrameProxy());
                    Intrinsics.checkNotNull((Object)ins, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                    InstanceJavaValue value = new InstanceJavaValue(new JavaReferenceInfo((ObjectReference)ins).createDescriptor(CollectionHistoryView.access$getMyDebugProcess$p(this.this$0).getProject()), evalContext, CollectionHistoryView.access$getMyNodeManager$p(this.this$0));
                    if (this.$renderer != null) {
                        value.getDescriptor().setRenderer(this.$renderer);
                    }
                    this.$children.add((XNamedValue)value);
                }
            }
        });
        return children;
    }

    private final void invokeInDebuggerThread(Function0<Unit> runnable) {
        this.mySuspendContext.getManagerThread().schedule(new DebuggerCommandImpl(runnable){
            final /* synthetic */ Function0<Unit> $runnable;
            {
                this.$runnable = $runnable;
                super(null, 1, null);
            }

            protected void action() {
                this.$runnable.invoke();
            }
        });
    }

    private final void invokeLater(Function0<Unit> runnable) {
        ApplicationManager.getApplication().invokeLater(() -> CollectionHistoryView.invokeLater$lambda$0(runnable));
    }

    private final VirtualMachineProxyImpl getVirtualMachine() {
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        StackFrameProxyImpl stackFrameProxyImpl = this.mySuspendContext.getFrameProxy();
        return stackFrameProxyImpl != null ? stackFrameProxyImpl.getVirtualMachine() : null;
    }

    private final XValueNodeImpl getParentNode(InstancesTree tree) {
        TreePath selectionPath;
        TreePath treePath = selectionPath = tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
        if (xValueNodeImpl == null) {
            return null;
        }
        XValueNodeImpl selectedItem = xValueNodeImpl;
        TreeNode treeNode = selectedItem.getParent();
        return treeNode instanceof XValueNodeImpl ? (XValueNodeImpl)treeNode : null;
    }

    private final XValueNodeImpl getSelectedNode(InstancesTree tree) {
        TreePath selectionPath;
        TreePath treePath = selectionPath = tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
        if (xValueNodeImpl == null) {
            return null;
        }
        return xValueNodeImpl;
    }

    private final ObjectReference getObjectReferenceForNode(XValueNodeImpl node) {
        XValueNodeImpl xValueNodeImpl = node;
        XValue xValue = xValueNodeImpl != null ? (XValue)xValueNodeImpl.getValueContainer() : null;
        NodeDescriptorProvider nodeDescriptorProvider = xValue instanceof NodeDescriptorProvider ? (NodeDescriptorProvider)xValue : null;
        if (nodeDescriptorProvider == null) {
            return null;
        }
        NodeDescriptorProvider descriptor = nodeDescriptorProvider;
        NodeDescriptorImpl nodeDescriptorImpl = descriptor.getDescriptor();
        ValueDescriptor valueDescriptor = nodeDescriptorImpl instanceof ValueDescriptor ? (ValueDescriptor)((Object)nodeDescriptorImpl) : null;
        Value value = valueDescriptor != null ? valueDescriptor.getValue() : null;
        return value instanceof ObjectReference ? (ObjectReference)value : null;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.myMainComponent;
    }

    private static final void myHistoryInstancesTree$lambda$0() {
    }

    private static final void myHistoryTree$lambda$0() {
    }

    private static final Unit setupInstancesTree$lambda$0$0(TreeSelectionEvent $it, CollectionHistoryView this$0) {
        TreePath selectionPath;
        TreePath treePath = selectionPath = $it.getPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
        if (xValueNodeImpl == null) {
            return Unit.INSTANCE;
        }
        XValueNodeImpl node = xValueNodeImpl;
        XValueContainer xValueContainer = node.getValueContainer();
        Object object2 = xValueContainer instanceof JavaValue ? (JavaValue)xValueContainer : null;
        if (object2 == null || (object2 = ((JavaValue)object2).getDescriptor()) == null || (object2 = object2.getType()) == null || (object2 = object2.name()) == null) {
            return Unit.INSTANCE;
        }
        Object clsType = object2;
        this$0.loadFieldHistory((String)clsType, this$0.myFieldName, node);
        return Unit.INSTANCE;
    }

    private static final Unit setupInstancesTree$lambda$1$2(CollectionHistoryView this$0, List $instances) {
        this$0.myHistoryInstancesTree.addChildren(this$0.createChildren($instances, null), true);
        return Unit.INSTANCE;
    }

    private static final void setupInstancesTree$lambda$0(CollectionHistoryView this$0, TreeSelectionEvent it) {
        this$0.myHistoryTree.addChildren(this$0.createChildren(CollectionsKt.emptyList(), null), true);
        this$0.myHistoryTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
        this$0.invokeInDebuggerThread((Function0<Unit>)((Function0)() -> CollectionHistoryView.setupInstancesTree$lambda$0$0(it, this$0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setupInstancesTree$lambda$1(CollectionHistoryView this$0) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this$0.getVirtualMachine();
        if (virtualMachineProxyImpl == null) {
            return Unit.INSTANCE;
        }
        VirtualMachineProxyImpl virtualMachineProxy = virtualMachineProxyImpl;
        List<ReferenceType> list = virtualMachineProxy.allClasses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"allClasses(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceType it = (ReferenceType)element$iv$iv;
            boolean bl = false;
            String string = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)string, (String)"$", (String)".", (boolean)false, (int)4, null), (Object)this$0.myClsName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = classes;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType it = (ReferenceType)element$iv$iv;
            boolean bl = false;
            List<ObjectReference> list2 = it.instances(this$0.MAX_INSTANCES_NUMBER);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"instances(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List instances = (List)destination$iv$iv2;
        this$0.invokeLater((Function0<Unit>)((Function0)() -> CollectionHistoryView.setupInstancesTree$lambda$1$2(this$0, instances)));
        return Unit.INSTANCE;
    }

    private static final Unit setupHistoryTreeSelectionListener$lambda$0$2$0(CollectionHistoryView this$0, List $items) {
        this$0.myStackFrameList.setFrameItems($items, this$0.myDebugProcess);
        return Unit.INSTANCE;
    }

    private static final Unit setupHistoryTreeSelectionListener$lambda$0$2(CollectionHistoryView this$0, XValueNodeImpl $parentNode, Integer $parentRow, Integer $childRow) {
        List<StackFrameItem> list;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this$0.getVirtualMachine();
        if (virtualMachineProxyImpl == null) {
            return Unit.INSTANCE;
        }
        VirtualMachineProxyImpl virtualMachineProxy = virtualMachineProxyImpl;
        if (Intrinsics.areEqual((Object)$parentNode, (Object)this$0.myHistoryTree.getRoot())) {
            Object parent;
            Mirror mirror;
            Object object;
            String clsName;
            XValueNodeImpl xValueNodeImpl = this$0.myValueNode;
            Object object2 = xValueNodeImpl != null ? (XValue)xValueNodeImpl.getValueContainer() : null;
            JavaValue javaValue = object2 instanceof JavaValue ? (JavaValue)object2 : null;
            ValueDescriptorImpl valueDescriptorImpl = javaValue != null ? javaValue.getDescriptor() : null;
            FieldDescriptor descriptor = valueDescriptorImpl instanceof FieldDescriptor ? (FieldDescriptor)((Object)valueDescriptorImpl) : null;
            Object object3 = descriptor;
            String string = object3 != null && (object3 = object3.getField()) != null && (object3 = object3.declaringType()) != null ? object3.name() : (clsName = null);
            if (clsName == null) {
                XValueNodeImpl xValueNodeImpl2 = this$0.getSelectedNode(this$0.myHistoryInstancesTree);
                object2 = xValueNodeImpl2 != null ? (XValue)xValueNodeImpl2.getValueContainer() : null;
                Object object4 = object2 instanceof JavaValue ? (JavaValue)object2 : null;
                String string2 = clsName = object4 != null && (object4 = ((JavaValue)object4).getDescriptor()) != null && (object4 = object4.getType()) != null ? object4.name() : null;
            }
            if ((object = this$0.myValueNode) == null || (object = object.getParent()) == null) {
                object = (TreeNode)this$0.getSelectedNode(this$0.myHistoryInstancesTree);
            }
            if ((mirror = this$0.getObjectReferenceForNode((XValueNodeImpl)((parent = object) instanceof XValueNodeImpl ? parent : null))) == null || (mirror = mirror.referenceType()) == null || (mirror = mirror.fieldByName(this$0.myFieldName)) == null) {
                return Unit.INSTANCE;
            }
            Mirror field = mirror;
            ObjectReference clsInstance = !field.isStatic() ? this$0.getObjectReferenceForNode((XValueNodeImpl)(parent instanceof XValueNodeImpl ? parent : null)) : null;
            Integer n = $parentRow;
            Intrinsics.checkNotNull((Object)n);
            IntegerValue modificationIndex = virtualMachineProxy.mirrorOf(n);
            list = CollectionBreakpointUtils.getFieldModificationStack(this$0.mySuspendContext, this$0.myFieldName, clsName, clsInstance, modificationIndex);
        } else {
            if ($childRow == null) {
                return Unit.INSTANCE;
            }
            IntegerValue modificationIndex = virtualMachineProxy.mirrorOf($childRow);
            ObjectReference objectReference = this$0.getObjectReferenceForNode($parentNode);
            if (objectReference == null) {
                return Unit.INSTANCE;
            }
            ObjectReference collectionInstance = objectReference;
            list = CollectionBreakpointUtils.getCollectionModificationStack(this$0.mySuspendContext, collectionInstance, modificationIndex);
        }
        List<StackFrameItem> items2 = list;
        this$0.invokeLater((Function0<Unit>)((Function0)() -> CollectionHistoryView.setupHistoryTreeSelectionListener$lambda$0$2$0(this$0, items2)));
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static final void setupHistoryTreeSelectionListener$lambda$0(CollectionHistoryView this$0, TreeSelectionEvent it) {
        block6: {
            block5: {
                this$0.myStackFrameList.clearFrameItems();
                v0 = this$0.getSelectedNode(this$0.myHistoryTree);
                if (v0 == null) {
                    return;
                }
                selectedNode = v0;
                parentNode = this$0.getParentNode(this$0.myHistoryTree);
                v1 = this$0.myHistoryTree.getRoot().getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getChildren(...)");
                $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)v1);
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    pair = (IndexedValue)element$iv;
                    $i$a$-firstOrNull-CollectionHistoryView$setupHistoryTreeSelectionListener$1$parentRow$1 = false;
                    if (!Intrinsics.areEqual((Object)pair.getValue(), (Object)selectedNode)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            v3 = v2;
            parentRow = v3 != null ? Integer.valueOf(v3.getIndex()) : null;
            v4 = parentNode;
            if (v4 == null || (v4 = v4.getChildren()) == null || (v4 = CollectionsKt.withIndex((Iterable)((Iterable)v4))) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = v4;
            $i$f$firstOrNull = false;
            var11_11 = $this$firstOrNull$iv.iterator();
            while (var11_11.hasNext()) {
                element$iv = var11_11.next();
                pair = (IndexedValue)element$iv;
                $i$a$-firstOrNull-CollectionHistoryView$setupHistoryTreeSelectionListener$1$childRow$1 = false;
                if (!Intrinsics.areEqual((Object)pair.getValue(), (Object)selectedNode)) continue;
                v5 = element$iv;
                break block6;
            }
            v5 = null;
        }
        if ((v4 = (IndexedValue)v5) != null) {
            v6 = v4.getIndex();
        } else lbl-1000:
        // 2 sources

        {
            v6 = null;
        }
        childRow = v6;
        this$0.invokeInDebuggerThread((Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, setupHistoryTreeSelectionListener$lambda$0$2(com.intellij.debugger.memory.ui.CollectionHistoryView com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl java.lang.Integer java.lang.Integer ), ()Lkotlin/Unit;)((CollectionHistoryView)this$0, (XValueNodeImpl)parentNode, (Integer)parentRow, childRow));
    }

    private static final Unit loadFieldHistory$lambda$0(CollectionHistoryView this$0, List $fieldModifications) {
        this$0.myHistoryTree.addChildren(this$0.createChildren($fieldModifications, this$0.new CollectionHistoryRenderer()), true);
        return Unit.INSTANCE;
    }

    private static final Unit loadHistory$lambda$0$0(XValueNodeImpl $node, CollectionHistoryView this$0) {
        Object object = $node.getValueContainer();
        JavaValue javaValue = object instanceof JavaValue ? (JavaValue)object : null;
        ValueDescriptorImpl valueDescriptorImpl = javaValue != null ? javaValue.getDescriptor() : null;
        FieldDescriptor fieldDescriptor = valueDescriptorImpl instanceof FieldDescriptor ? (FieldDescriptor)((Object)valueDescriptorImpl) : null;
        if (fieldDescriptor == null) {
            return Unit.INSTANCE;
        }
        FieldDescriptor descriptor = fieldDescriptor;
        Field field = descriptor.getField();
        object = $node.getParent();
        XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
        if (xValueNodeImpl == null) {
            return Unit.INSTANCE;
        }
        XValueNodeImpl parent = xValueNodeImpl;
        String string = field.declaringType().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String string2 = field.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
        this$0.loadFieldHistory(string, string2, parent);
        return Unit.INSTANCE;
    }

    private static final void invokeLater$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/memory/ui/CollectionHistoryView$CollectionHistoryRenderer;", "Lcom/intellij/debugger/ui/tree/render/ClassRenderer;", "<init>", "(Lcom/intellij/debugger/memory/ui/CollectionHistoryView;)V", "buildChildren", "", "value", "Lcom/sun/jdi/Value;", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "ChildrenRenderer", "intellij.java.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nCollectionHistoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionHistoryView.kt\ncom/intellij/debugger/memory/ui/CollectionHistoryView$CollectionHistoryRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n812#2,12:311\n1586#2:323\n1661#2,3:324\n777#2:327\n873#2,2:328\n1586#2:330\n1661#2,3:331\n*S KotlinDebug\n*F\n+ 1 CollectionHistoryView.kt\ncom/intellij/debugger/memory/ui/CollectionHistoryView$CollectionHistoryRenderer\n*L\n250#1:311,12\n251#1:323\n251#1:324,3\n257#1:327\n257#1:328,2\n258#1:330\n258#1:331,3\n*E\n"})
    private final class CollectionHistoryRenderer
    extends ClassRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        public void buildChildren(@Nullable Value value, @Nullable ChildrenBuilder builder, @Nullable EvaluationContext evaluationContext) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object isAddition;
            ObjectReference element;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            if (evaluationContext == null || builder == null) {
                return;
            }
            ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
            if (objectReference == null) {
                return;
            }
            ObjectReference collectionInstance = objectReference;
            List<Value> list = CollectionBreakpointUtils.getCollectionModificationsHistory(CollectionHistoryView.this.mySuspendContext, collectionInstance);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCollectionModificationsHistory(...)");
            List<Value> collectionModifications = list;
            Iterable iterable = collectionModifications;
            boolean $i$f$filterIsInstance22 = false;
            void var9_11 = $this$filterIsInstance$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ObjectReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            CollectionHistoryView $i$f$filterIsInstance22 = CollectionHistoryView.this;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                com.intellij.openapi.util.Pair<ObjectReference, BooleanValue> modificationInfo;
                ObjectReference objectReference2 = (ObjectReference)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                com.intellij.openapi.util.Pair<ObjectReference, BooleanValue> pair = modificationInfo = CollectionBreakpointUtils.getCollectionModificationInfo($i$f$filterIsInstance22.myDebugProcess, evaluationContext, (ObjectReference)it);
                element = pair != null ? (ObjectReference)pair.first : null;
                com.intellij.openapi.util.Pair<ObjectReference, BooleanValue> pair2 = modificationInfo;
                isAddition = pair2 != null ? (BooleanValue)pair2.second : null;
                collection.add(new Pair((Object)element, isAddition));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            void $i$f$map22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(it.getFirst() != null && it.getSecond() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            CollectionHistoryView collectionHistoryView = CollectionHistoryView.this;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair bl = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                InstanceValueDescriptor descriptor = new InstanceValueDescriptor(collectionHistoryView.myDebugSession.getProject(), (Value)it.getFirst());
                element = (ObjectReference)it.getFirst();
                BooleanValue booleanValue = (BooleanValue)it.getSecond();
                isAddition = booleanValue != null ? Boolean.valueOf(booleanValue.value()) : null;
                descriptor.setRenderer(new ChildrenRenderer(element, (Boolean)isAddition));
                collection.add(collectionHistoryView.myNodeManager.createNode(descriptor, evaluationContext));
            }
            List nodes = (List)destination$iv$iv;
            builder.setChildren(nodes);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002J&\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/intellij/debugger/memory/ui/CollectionHistoryView$CollectionHistoryRenderer$ChildrenRenderer;", "Lcom/intellij/debugger/ui/tree/render/ClassRenderer;", "obj", "Lcom/sun/jdi/ObjectReference;", "isAddition", "", "<init>", "(Lcom/intellij/debugger/memory/ui/CollectionHistoryView$CollectionHistoryRenderer;Lcom/sun/jdi/ObjectReference;Ljava/lang/Boolean;)V", "getObj", "()Lcom/sun/jdi/ObjectReference;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "calcValueIcon", "Ljavax/swing/Icon;", "descriptor", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "listener", "Lcom/intellij/debugger/ui/tree/render/DescriptorLabelListener;", "evaluate", "Lkotlin/Pair;", "Lcom/sun/jdi/Value;", "isMap", "calcLabel", "", "labelListener", "intellij.java.debugger.impl"})
        private final class ChildrenRenderer
        extends ClassRenderer {
            @Nullable
            private final ObjectReference obj;
            @Nullable
            private final Boolean isAddition;

            public ChildrenRenderer(@Nullable ObjectReference obj, Boolean isAddition) {
                this.obj = obj;
                this.isAddition = isAddition;
            }

            @Nullable
            public final ObjectReference getObj() {
                return this.obj;
            }

            @Nullable
            public final Boolean isAddition() {
                return this.isAddition;
            }

            @Override
            @NotNull
            public Icon calcValueIcon(@Nullable ValueDescriptor descriptor, @Nullable EvaluationContext evaluationContext, @Nullable DescriptorLabelListener listener2) {
                Icon icon;
                if (this.isAddition != null && this.isAddition.booleanValue()) {
                    Icon icon2 = AllIcons.General.Add;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Add");
                } else {
                    Icon icon3 = AllIcons.General.Remove;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Remove");
                }
                return icon;
            }

            private final Pair<Value, Value> evaluate(EvaluationContext evaluationContext) {
                ReferenceType referenceType = CollectionHistoryView.this.myDebugProcess.findClass(evaluationContext, "com.intellij.rt.debugger.agent.CollectionBreakpointInstrumentor$Pair", null);
                ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
                if (classType == null) {
                    return null;
                }
                ClassType cls = classType;
                Method method = DebuggerUtils.findMethod((ReferenceType)cls, (String)"getKey", (String)"()Ljava/lang/Object;");
                if (method == null) {
                    return null;
                }
                Method getKey = method;
                Method method2 = DebuggerUtils.findMethod((ReferenceType)cls, (String)"getValue", (String)"()Ljava/lang/Object;");
                if (method2 == null) {
                    return null;
                }
                Method getValue = method2;
                DebugProcessImpl debugProcessImpl = CollectionHistoryView.this.myDebugProcess;
                ObjectReference objectReference = this.obj;
                Intrinsics.checkNotNull((Object)objectReference);
                Value key = debugProcessImpl.invokeInstanceMethod(evaluationContext, objectReference, getKey, CollectionsKt.emptyList(), 0);
                Value value = CollectionHistoryView.this.myDebugProcess.invokeInstanceMethod(evaluationContext, this.obj, getValue, CollectionsKt.emptyList(), 0);
                return new Pair((Object)key, (Object)value);
            }

            private final boolean isMap() {
                XValueNodeImpl xValueNodeImpl = CollectionHistoryView.this.myValueNode;
                XValue xValue = xValueNodeImpl != null ? (XValue)xValueNodeImpl.getValueContainer() : null;
                JavaValue javaValue = xValue instanceof JavaValue ? (JavaValue)xValue : null;
                if (javaValue == null) {
                    return false;
                }
                JavaValue javaValue2 = javaValue;
                Type type = javaValue2.getDescriptor().getType();
                if (type == null) {
                    return false;
                }
                Type type2 = type;
                Project project = CollectionHistoryView.this.myDebugProcess.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                PsiClassType psiClassType = PsiType.getTypeByName((String)type2.name(), (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getTypeByName(...)");
                PsiClassType psiType = psiClassType;
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiType)psiType));
                if (psiClass == null) {
                    return false;
                }
                PsiClass resolved = psiClass;
                return InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Map");
            }

            @Override
            @NotNull
            public String calcLabel(@Nullable ValueDescriptor descriptor, @Nullable EvaluationContext evaluationContext, @Nullable DescriptorLabelListener labelListener) {
                if (this.isMap()) {
                    Pair<Value, Value> pair;
                    EvaluationContext evaluationContext2 = evaluationContext;
                    Intrinsics.checkNotNull((Object)evaluationContext2);
                    Pair<Value, Value> pair2 = pair = this.evaluate(evaluationContext2);
                    Value key = pair2 != null ? (Value)pair2.getFirst() : null;
                    Pair<Value, Value> pair3 = pair;
                    Value value = pair3 != null ? (Value)pair3.getSecond() : null;
                    InstanceValueDescriptor keyDescriptor = new InstanceValueDescriptor(CollectionHistoryView.this.myDebugSession.getProject(), key);
                    InstanceValueDescriptor valueDescriptor = new InstanceValueDescriptor(CollectionHistoryView.this.myDebugSession.getProject(), value);
                    return keyDescriptor + " -> " + valueDescriptor;
                }
                String string = super.calcLabel(descriptor, evaluationContext, labelListener);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"calcLabel(...)");
                return string;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/memory/ui/CollectionHistoryView$MyNodeManager;", "Lcom/intellij/debugger/ui/impl/watch/NodeManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createNode", "Lcom/intellij/debugger/ui/impl/watch/DebuggerTreeNodeImpl;", "descriptor", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "createMessageNode", "Lcom/intellij/debugger/ui/impl/watch/MessageDescriptor;", "message", "", "intellij.java.debugger.impl"})
    private static final class MyNodeManager
    extends NodeManagerImpl {
        public MyNodeManager(@Nullable Project project) {
            super(project, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(@NotNull NodeDescriptor descriptor, @NotNull EvaluationContext evaluationContext) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(@NotNull MessageDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
        }
    }
}

