/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.memory.ui.InstancesViewTreeTableModelKt;
import com.intellij.debugger.memory.ui.SizedReferenceInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001,B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\u0014\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u001a\u0010\u001d\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J$\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0012\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006-"}, d2={"Lcom/intellij/debugger/memory/ui/InstancesViewTreeTableModel;", "Ljavax/swing/tree/DefaultTreeModel;", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "Ljavax/swing/event/TreeModelListener;", "tree", "Lcom/intellij/xdebugger/memory/ui/InstancesTree;", "<init>", "(Lcom/intellij/xdebugger/memory/ui/InstancesTree;)V", "getTree", "()Lcom/intellij/xdebugger/memory/ui/InstancesTree;", "getRoot", "", "getChild", "parent", "index", "", "getChildCount", "isLeaf", "", "node", "getIndexOfChild", "child", "getColumnCount", "getColumnName", "", "column", "getColumnClass", "Ljava/lang/Class;", "getValueAt", "isCellEditable", "setValueAt", "", "aValue", "setTree", "newTree", "Ljavax/swing/JTree;", "createTableCellRenderer", "Ljavax/swing/table/DefaultTableCellRenderer;", "treeNodesChanged", "e", "Ljavax/swing/event/TreeModelEvent;", "treeNodesInserted", "treeNodesRemoved", "treeStructureChanged", "Columns", "intellij.java.debugger.impl"})
public final class InstancesViewTreeTableModel
extends DefaultTreeModel
implements TreeTableModel,
TreeModelListener {
    @NotNull
    private final InstancesTree tree;

    public InstancesViewTreeTableModel(@NotNull InstancesTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super((TreeNode)tree.getRoot());
        this.tree = tree;
        this.tree.getTreeModel().addTreeModelListener(this);
    }

    @NotNull
    public final InstancesTree getTree() {
        return this.tree;
    }

    @Override
    @NotNull
    public Object getRoot() {
        Object object = this.tree.getTreeModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRoot(...)");
        return object;
    }

    @Override
    @NotNull
    public Object getChild(@Nullable Object parent, int index) {
        Object object = this.tree.getTreeModel().getChild(parent, index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getChild(...)");
        return object;
    }

    @Override
    public int getChildCount(@Nullable Object parent) {
        return this.tree.getTreeModel().getChildCount(parent);
    }

    @Override
    public boolean isLeaf(@Nullable Object node) {
        return this.tree.getTreeModel().isLeaf(node);
    }

    @Override
    public int getIndexOfChild(@Nullable Object parent, @Nullable Object child) {
        return this.tree.getTreeModel().getIndexOfChild(parent, child);
    }

    public int getColumnCount() {
        return Columns.values().length;
    }

    @NotNull
    public String getColumnName(int column) {
        return Columns.values()[column].getColumnName();
    }

    @NotNull
    public Class<?> getColumnClass(int column) {
        return Columns.values()[column].getColumnClass();
    }

    @Nullable
    public Object getValueAt(@Nullable Object node, int column) {
        return Columns.values()[column].getValue(node);
    }

    public boolean isCellEditable(@Nullable Object node, int column) {
        return false;
    }

    public void setValueAt(@Nullable Object aValue, @Nullable Object node, int column) {
    }

    public void setTree(@Nullable JTree newTree) {
    }

    @NotNull
    public final DefaultTableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){
            {
                this.setHorizontalAlignment(4);
            }

            protected void setValue(Object value) {
                if (!(value instanceof Long)) {
                    super.setValue(value);
                    return;
                }
                super.setValue(StringUtil.formatFileSize((long)((Number)value).longValue()));
            }
        };
    }

    @Override
    public void treeNodesChanged(@NotNull TreeModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fireTreeNodesChanged(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeNodesInserted(@NotNull TreeModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fireTreeNodesInserted(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeNodesRemoved(@NotNull TreeModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fireTreeNodesRemoved(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
    }

    @Override
    public void treeStructureChanged(@NotNull TreeModelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.fireTreeStructureChanged(e.getSource(), e.getPath(), e.getChildIndices(), e.getChildren());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH&J\f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH&J\b\u0010\f\u001a\u00020\rH'j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/memory/ui/InstancesViewTreeTableModel$Columns;", "", "<init>", "(Ljava/lang/String;I)V", "NODE", "SHALLOW_SIZE", "RETAINED_SIZE", "getValue", "", "node", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "intellij.java.debugger.impl"})
    public static abstract class Columns
    extends Enum<Columns> {
        public static final /* enum */ Columns NODE = new NODE("NODE", 0);
        public static final /* enum */ Columns SHALLOW_SIZE = new SHALLOW_SIZE("SHALLOW_SIZE", 1);
        public static final /* enum */ Columns RETAINED_SIZE = new RETAINED_SIZE("RETAINED_SIZE", 2);
        private static final /* synthetic */ Columns[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Columns() {
        }

        @Nullable
        public abstract Object getValue(@Nullable Object var1);

        @NotNull
        public abstract Class<?> getColumnClass();

        @NlsContexts.ColumnName
        @NotNull
        public abstract String getColumnName();

        public static Columns[] values() {
            return (Columns[])$VALUES.clone();
        }

        public static Columns valueOf(String value) {
            return Enum.valueOf(Columns.class, value);
        }

        @NotNull
        public static EnumEntries<Columns> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Columns(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = columnsArray = new Columns[]{Columns.NODE, Columns.SHALLOW_SIZE, Columns.RETAINED_SIZE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016J\f\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"com/intellij/debugger/memory/ui/InstancesViewTreeTableModel.Columns.NODE", "Lcom/intellij/debugger/memory/ui/InstancesViewTreeTableModel$Columns;", "getValue", "", "node", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "intellij.java.debugger.impl"})
        static final class NODE
        extends Columns {
            /*
             * WARNING - void declaration
             */
            NODE() {
                void var1_1;
            }

            @Override
            @Nullable
            public Object getValue(@Nullable Object node) {
                return null;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }

            @Override
            @NotNull
            public String getColumnName() {
                String string = JavaDebuggerBundle.message((String)"column.name.instances", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0019\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"com/intellij/debugger/memory/ui/InstancesViewTreeTableModel.Columns.RETAINED_SIZE", "Lcom/intellij/debugger/memory/ui/InstancesViewTreeTableModel$Columns;", "getValue", "", "node", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "intellij.java.debugger.impl"})
        static final class RETAINED_SIZE
        extends Columns {
            /*
             * WARNING - void declaration
             */
            RETAINED_SIZE() {
                void var1_1;
            }

            @Override
            @Nullable
            public Long getValue(@Nullable Object node) {
                Object object = node;
                return object != null && (object = InstancesViewTreeTableModelKt.access$getSizedValueDescriptor(object)) != null ? Long.valueOf(((SizedReferenceInfo.SizedValueDescriptor)object).getRetainedSize()) : null;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass() {
                return Long.class;
            }

            @Override
            @NotNull
            public String getColumnName() {
                String string = JavaDebuggerBundle.message((String)"column.name.retained.size", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0019\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"com/intellij/debugger/memory/ui/InstancesViewTreeTableModel.Columns.SHALLOW_SIZE", "Lcom/intellij/debugger/memory/ui/InstancesViewTreeTableModel$Columns;", "getValue", "", "node", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "getColumnClass", "Ljava/lang/Class;", "getColumnName", "", "intellij.java.debugger.impl"})
        static final class SHALLOW_SIZE
        extends Columns {
            /*
             * WARNING - void declaration
             */
            SHALLOW_SIZE() {
                void var1_1;
            }

            @Override
            @Nullable
            public Long getValue(@Nullable Object node) {
                Object object = node;
                return object != null && (object = InstancesViewTreeTableModelKt.access$getSizedValueDescriptor(object)) != null ? Long.valueOf(((SizedReferenceInfo.SizedValueDescriptor)object).getShallowSize()) : null;
            }

            @Override
            @NotNull
            public Class<?> getColumnClass() {
                return Long.class;
            }

            @Override
            @NotNull
            public String getColumnName() {
                String string = JavaDebuggerBundle.message((String)"column.name.shallow.size", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        }
    }
}

