/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.ui.components.JBBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class DebuggerSteppingConfigurable
implements ConfigurableUi<DebuggerSettings> {
    private JCheckBox myCbAlwaysSmartStep;
    private JCheckBox myCbStepInfoFiltersEnabled;
    private JCheckBox myCbSkipSyntheticMethods;
    private JCheckBox myCbSkipConstructors;
    private JCheckBox myCbSkipClassLoaders;
    private ClassFilterEditor mySteppingFilterEditor;
    private JCheckBox myCbSkipSimpleGetters;
    private JCheckBox myCbHideStackFramesUsingSteppingFilter;
    private JRadioButton myRbEvaluateFinallyAlways;
    private JRadioButton myRbEvaluateFinallyNever;
    private JRadioButton myRbEvaluateFinallyAsk;
    private JCheckBox myCbResumeOnlyCurrentThread;

    DebuggerSteppingConfigurable() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            DebuggerSteppingConfigurable.$$$reportNull$$$0(0);
        }
        this.myCbAlwaysSmartStep.setSelected(settings.ALWAYS_SMART_STEP_INTO);
        this.myCbSkipSimpleGetters.setSelected(settings.SKIP_GETTERS);
        this.myCbSkipSyntheticMethods.setSelected(settings.SKIP_SYNTHETIC_METHODS);
        this.myCbSkipConstructors.setSelected(settings.SKIP_CONSTRUCTORS);
        this.myCbSkipClassLoaders.setSelected(settings.SKIP_CLASSLOADERS);
        this.myCbStepInfoFiltersEnabled.setSelected(settings.TRACING_FILTERS_ENABLED);
        this.mySteppingFilterEditor.setFilters(settings.getSteppingFilters());
        this.setEnabledStepFilters();
        if ("EvaluateFinallyAlways".equals(settings.EVALUATE_FINALLY_ON_POP_FRAME)) {
            this.myRbEvaluateFinallyAlways.setSelected(true);
        } else if ("EvaluateFinallyNever".equals(settings.EVALUATE_FINALLY_ON_POP_FRAME)) {
            this.myRbEvaluateFinallyNever.setSelected(true);
        } else {
            this.myRbEvaluateFinallyAsk.setSelected(true);
        }
        this.myCbResumeOnlyCurrentThread.setSelected(settings.RESUME_ONLY_CURRENT_THREAD);
        this.myCbHideStackFramesUsingSteppingFilter.setSelected(settings.HIDE_STACK_FRAMES_USING_STEPPING_FILTER);
    }

    public void apply(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            DebuggerSteppingConfigurable.$$$reportNull$$$0(1);
        }
        this.mySteppingFilterEditor.stopEditing();
        this.getSettingsTo(settings);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)project);
        }
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.ALWAYS_SMART_STEP_INTO = this.myCbAlwaysSmartStep.isSelected();
        settings.SKIP_GETTERS = this.myCbSkipSimpleGetters.isSelected();
        settings.SKIP_SYNTHETIC_METHODS = this.myCbSkipSyntheticMethods.isSelected();
        settings.SKIP_CONSTRUCTORS = this.myCbSkipConstructors.isSelected();
        settings.SKIP_CLASSLOADERS = this.myCbSkipClassLoaders.isSelected();
        settings.TRACING_FILTERS_ENABLED = this.myCbStepInfoFiltersEnabled.isSelected();
        settings.EVALUATE_FINALLY_ON_POP_FRAME = this.myRbEvaluateFinallyAlways.isSelected() ? "EvaluateFinallyAlways" : (this.myRbEvaluateFinallyNever.isSelected() ? "EvaluateFinallyNever" : "EvaluateFinallyAsk");
        settings.RESUME_ONLY_CURRENT_THREAD = this.myCbResumeOnlyCurrentThread.isSelected();
        settings.setSteppingFilters(this.mySteppingFilterEditor.getFilters());
        settings.HIDE_STACK_FRAMES_USING_STEPPING_FILTER = this.myCbHideStackFramesUsingSteppingFilter.isSelected();
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        if (currentSettings == null) {
            DebuggerSteppingConfigurable.$$$reportNull$$$0(2);
        }
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals((Object)currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        Insets insets;
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbAlwaysSmartStep = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.always.smart.step.into", (Object[])new Object[0]));
        this.myCbSkipSyntheticMethods = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.skip.synthetic.methods", (Object[])new Object[0]));
        this.myCbSkipConstructors = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.skip.constructors", (Object[])new Object[0]));
        this.myCbSkipClassLoaders = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.skip.classLoaders", (Object[])new Object[0]));
        this.myCbSkipSimpleGetters = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.skip.simple.getters", (Object[])new Object[0]));
        this.myCbStepInfoFiltersEnabled = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.step.filters.list.header", (Object[])new Object[0]));
        this.myCbHideStackFramesUsingSteppingFilter = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.hide.stack.frames.using.step.filter", (Object[])new Object[0]));
        panel.add((Component)this.myCbAlwaysSmartStep, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)this.myCbSkipSyntheticMethods, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        panel.add((Component)this.myCbSkipConstructors, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)this.myCbSkipClassLoaders, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)this.myCbSkipSimpleGetters, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        panel.add((Component)this.myCbStepInfoFiltersEnabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        this.mySteppingFilterEditor = new ClassFilterEditor(JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables(), null, "reference.viewBreakpoints.classFilters.newPattern");
        panel.add((Component)this.mySteppingFilterEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsLeft((int)5), 0, 0));
        panel.add((Component)this.myCbHideStackFramesUsingSteppingFilter, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        this.myCbStepInfoFiltersEnabled.addActionListener(e -> this.setEnabledStepFilters());
        this.myRbEvaluateFinallyAlways = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.always", (Object[])new Object[0]));
        this.myRbEvaluateFinallyNever = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.never", (Object[])new Object[0]));
        this.myRbEvaluateFinallyAsk = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.ask", (Object[])new Object[0]));
        int cbLeftOffset = 0;
        Border border = this.myCbSkipSimpleGetters.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.myCbSkipSimpleGetters)) != null) {
            cbLeftOffset = insets.left;
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbEvaluateFinallyAlways);
        group.add(this.myRbEvaluateFinallyNever);
        group.add(this.myRbEvaluateFinallyAsk);
        JBBox box = JBBox.createHorizontalBox();
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add((Component)this.myRbEvaluateFinallyAlways);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add((Component)this.myRbEvaluateFinallyNever);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add((Component)this.myRbEvaluateFinallyAsk);
        JPanel evalFinallyPanel = new JPanel(new BorderLayout());
        evalFinallyPanel.add((Component)box, "Center");
        evalFinallyPanel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.evaluate.finally.on.pop", (Object[])new Object[0])), "West");
        panel.add((Component)evalFinallyPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, cbLeftOffset, 0, 0), 0, 0));
        this.myCbResumeOnlyCurrentThread = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.resume.only.current.thread", (Object[])new Object[0]));
        panel.add((Component)this.myCbResumeOnlyCurrentThread, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            DebuggerSteppingConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void setEnabledStepFilters() {
        boolean isEnabled = this.myCbStepInfoFiltersEnabled.isSelected();
        this.mySteppingFilterEditor.setEnabled(isEnabled);
        this.myCbHideStackFramesUsingSteppingFilter.setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/DebuggerSteppingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/DebuggerSteppingConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

