/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class RunHotswapDialog
extends OptionsDialog {
    private final JPanel myPanel;
    private final ElementsChooser<SessionItem> myElementsChooser;
    private final boolean myDisplayHangWarning;

    public RunHotswapDialog(Project project, List<DebuggerSession> sessions, boolean displayHangWarning) {
        super(project);
        this.myDisplayHangWarning = displayHangWarning;
        this.myPanel = new JPanel(new BorderLayout());
        ArrayList<SessionItem> items2 = new ArrayList<SessionItem>(sessions.size());
        for (DebuggerSession session : sessions) {
            items2.add(new SessionItem(session));
        }
        items2.sort(Comparator.comparing(debuggerSession -> debuggerSession.getSession().getSessionName()));
        this.myElementsChooser = new ElementsChooser(items2, true);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)5, (int)0));
        if (!sessions.isEmpty()) {
            this.myElementsChooser.selectElements(items2.subList(0, 1));
        }
        this.myPanel.add((Component)this.myElementsChooser, "Center");
        if (sessions.size() == 1) {
            this.setTitle(JavaDebuggerBundle.message((String)"hotswap.dialog.title.with.session", (Object[])new Object[]{sessions.get(0).getSessionName()}));
            this.myPanel.setVisible(false);
        } else {
            this.setTitle(JavaDebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]));
        }
        this.init();
    }

    protected boolean isToBeShown() {
        return "RunHotswapAsk".equals(DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE);
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        DebuggerSettings.getInstance().RUN_HOTSWAP_AFTER_COMPILE = value ? "RunHotswapAsk" : (onOk ? "RunHotswapAlways" : "RunHotswapNever");
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    protected Action @NotNull [] createActions() {
        this.setOKButtonText(JavaDebuggerBundle.message((String)"hotswap.dialog.reload.action.text", (Object[])new Object[0]));
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            RunHotswapDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(JavaDebuggerBundle.message((String)"hotswap.dialog.run.prompt", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "Center");
        Icon icon = UIUtil.getQuestionIcon();
        label.setIcon(icon);
        label.setIconTextGap(7);
        if (this.myDisplayHangWarning) {
            JLabel warningLabel = new JLabel(JavaDebuggerBundle.message((String)"warning.0", (Object[])new Object[]{JavaDebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0])}));
            warningLabel.setUI((LabelUI)new MultiLineLabelUI());
            panel.add((Component)warningLabel, "South");
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public @Unmodifiable Collection<DebuggerSession> getSessionsToReload() {
        return ContainerUtil.map((Collection)this.myElementsChooser.getMarkedElements(), SessionItem::getSession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/RunHotswapDialog", "createActions"));
    }

    private static class SessionItem {
        private final DebuggerSession mySession;

        SessionItem(DebuggerSession session) {
            this.mySession = session;
        }

        public DebuggerSession getSession() {
            return this.mySession;
        }

        public String toString() {
            return this.mySession.getSessionName();
        }
    }
}

