/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.PossiblySyncCommand;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.statistics.JavaDebuggerEvaluatorStatisticsCollector;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.Value;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelRenderer
extends ReferenceRenderer
implements ValueLabelRenderer,
OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "LabelRenderer";
    public boolean ON_DEMAND;
    private CachedEvaluator myLabelExpression = this.createCachedEvaluator();
    private String myPrefix;

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public LabelRenderer clone() {
        LabelRenderer clone = (LabelRenderer)super.clone();
        clone.myLabelExpression = this.createCachedEvaluator();
        clone.setLabelExpression(this.getLabelExpression());
        return clone;
    }

    @Override
    public String calcLabel(final ValueDescriptor descriptor, EvaluationContext evaluationContext, final DescriptorLabelListener labelListener) throws EvaluateException {
        if (!this.isShowValue(descriptor, evaluationContext)) {
            return this.prefix("");
        }
        final Value value = descriptor.getValue();
        if (value == null) {
            return this.prefix("null");
        }
        final EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
        final DebugProcessImpl debugProcess = evaluationContextImpl.getDebugProcess();
        evaluationContextImpl.getManagerThread().schedule(new PossiblySyncCommand(evaluationContextImpl.getSuspendContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpressionEvaluator evaluator = null;
                long startNs = System.nanoTime();
                try {
                    evaluator = LabelRenderer.this.myLabelExpression.getEvaluator(debugProcess.getProject());
                    if (!debugProcess.isAttached()) {
                        throw EvaluateExceptionUtil.PROCESS_EXITED;
                    }
                    EvaluationContextImpl thisEvaluationContext = evaluationContextImpl.createEvaluationContext(value);
                    XEvaluationOrigin.setOrigin((UserDataHolder)thisEvaluationContext, (XEvaluationOrigin)XEvaluationOrigin.RENDERER);
                    Value labelValue = evaluator.evaluate((EvaluationContext)thisEvaluationContext);
                    JavaDebuggerEvaluatorStatisticsCollector.logEvaluationResult(debugProcess.getProject(), evaluator, true, XEvaluationOrigin.RENDERER);
                    String result = StringUtil.notNullize((String)DebuggerUtils.getValueAsString((EvaluationContext)thisEvaluationContext, (Value)labelValue));
                    descriptor.setValueLabel(LabelRenderer.this.prefix(result));
                }
                catch (EvaluateException ex) {
                    JavaDebuggerEvaluatorStatisticsCollector.logEvaluationResult(debugProcess.getProject(), evaluator, false, XEvaluationOrigin.RENDERER);
                    descriptor.setValueLabelFailed(new EvaluateException(JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + ex.getMessage(), (Throwable)ex));
                }
                finally {
                    NodeRendererImpl nodeRenderer;
                    ValueDescriptorImpl valueDescriptor;
                    Renderer renderer;
                    long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                    if (descriptor instanceof ValueDescriptorImpl && (renderer = (valueDescriptor = (ValueDescriptorImpl)descriptor).getLastRenderer()) instanceof NodeRendererImpl && (nodeRenderer = (NodeRendererImpl)renderer).hasOverhead()) {
                        OverheadTimings.add(debugProcess, new NodeRendererImpl.Overhead(nodeRenderer), 0L, timeMs);
                    }
                }
                labelListener.labelChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/tree/render/LabelRenderer$1", "syncAction"));
            }
        });
        return XDebuggerUIConstants.getCollectingDataMessage();
    }

    private String prefix(String result) {
        return this.myPrefix != null ? this.myPrefix + result : result;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = "\u2026 " + this.getLabelExpression().getText();
        if (string == null) {
            LabelRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports labelExpression = DebuggerUtils.getInstance().readTextWithImports(element, "LABEL_EXPRESSION");
        if (labelExpression != null) {
            this.setLabelExpression(labelExpression);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "LABEL_EXPRESSION", this.getLabelExpression());
    }

    public TextWithImports getLabelExpression() {
        return this.myLabelExpression.getReferenceExpression();
    }

    public void setLabelExpression(TextWithImports expression) {
        this.myLabelExpression.setReferenceExpression(expression);
    }

    public void setPrefix(@Nullable String prefix) {
        this.myPrefix = prefix;
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        return this.ON_DEMAND || OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    public boolean isOnDemand() {
        return this.ON_DEMAND;
    }

    public void setOnDemand(boolean value) {
        this.ON_DEMAND = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/LabelRenderer", "getLinkText"));
    }
}

