/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.spellchecker;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.lang.properties.spellchecker.MnemonicsTokenizer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.PropertiesSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import org.jetbrains.annotations.NotNull;

final class PropertiesSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    private static final ExtensionPointName<MnemonicsTokenizer> MNEMONICS_EP_NAME = ExtensionPointName.create((String)"com.intellij.properties.spellcheckerMnemonicsTokenizer");
    private final Tokenizer<PropertyValueImpl> myPropertyValueTokenizer = new PropertyValueTokenizer();
    private final Tokenizer<PropertyKeyImpl> myPropertyTokenizer = new PropertyKeyTokenizer();

    PropertiesSpellcheckingStrategy() {
    }

    @NotNull
    public Tokenizer<?> getTokenizer(PsiElement element) {
        if (PropertiesSpellcheckingStrategy.isInjectedLanguageFragment((PsiElement)element)) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                PropertiesSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof PropertyValueImpl) {
            Tokenizer<PropertyValueImpl> tokenizer = this.useTextLevelSpellchecking(element) ? EMPTY_TOKENIZER : this.myPropertyValueTokenizer;
            if (tokenizer == null) {
                PropertiesSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof PropertyKeyImpl) {
            Tokenizer<PropertyKeyImpl> tokenizer = this.myPropertyTokenizer;
            if (tokenizer == null) {
                PropertiesSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof Property) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                PropertiesSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            PropertiesSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    public boolean useTextLevelSpellchecking() {
        return Registry.is((String)"spellchecker.grazie.enabled", (boolean)false);
    }

    protected boolean isLiteral(@NotNull PsiElement element) {
        if (element == null) {
            PropertiesSpellcheckingStrategy.$$$reportNull$$$0(5);
        }
        return !super.isComment(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }

    private static class PropertyValueTokenizer
    extends EscapeSequenceTokenizer<PropertyValueImpl> {
        private PropertyValueTokenizer() {
        }

        public void tokenize(@NotNull PropertyValueImpl element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                PropertyValueTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                PropertyValueTokenizer.$$$reportNull$$$0(1);
            }
            String text = element.getText();
            for (MnemonicsTokenizer tokenizer : MNEMONICS_EP_NAME.getExtensionList()) {
                if (!tokenizer.hasMnemonics(text)) continue;
                tokenizer.tokenize(element, consumer);
                return;
            }
            if (!text.contains("\\")) {
                consumer.consumeToken((PsiElement)element, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder(text.length());
                int[] offsets = new int[text.length() + 1];
                CodeInsightUtilCore.parseStringCharacters((String)text, (StringBuilder)unescapedText, (int[])offsets);
                PropertyValueTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy$PropertyValueTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyKeyTokenizer
    extends TokenizerBase<PropertyKeyImpl> {
        private PropertyKeyTokenizer() {
            super((Splitter)PropertiesSplitter.getInstance());
        }

        public void consumeToken(@NotNull PropertyKeyImpl element, @NotNull TokenConsumer consumer, @NotNull Splitter splitter) {
            if (element == null) {
                PropertyKeyTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                PropertyKeyTokenizer.$$$reportNull$$$0(1);
            }
            if (splitter == null) {
                PropertyKeyTokenizer.$$$reportNull$$$0(2);
            }
            consumer.consumeToken((PsiElement)element, true, splitter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "splitter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/properties/spellchecker/PropertiesSpellcheckingStrategy$PropertyKeyTokenizer";
            objectArray[2] = "consumeToken";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

