/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.tabection;

import com.intellij.cwm.plugin.common.control.icons.CircleFactories;
import com.intellij.cwm.plugin.common.toolbar.CodeWithMeUsersGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.impl.tabActions.base.EditorTabBaseAction;
import com.intellij.openapi.fileEditor.impl.tabActions.base.EditorTabDataProvider;
import com.jetbrains.codeWithMe.model.RdUserModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cwm/plugin/common/tabection/CWMSingleUserAction;", "Lcom/intellij/openapi/fileEditor/impl/tabActions/base/EditorTabBaseAction;", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "index", "", "provider", "Lcom/intellij/openapi/fileEditor/impl/tabActions/base/EditorTabDataProvider;", "<init>", "(ILcom/intellij/openapi/fileEditor/impl/tabActions/base/EditorTabDataProvider;)V", "getIndex", "()I", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.cwm.plugin.common"})
public final class CWMSingleUserAction
extends EditorTabBaseAction<RdUserModel> {
    private final int index;

    public CWMSingleUserAction(int index, @NotNull EditorTabDataProvider<RdUserModel> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(provider);
        this.index = index;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = this.getList(e);
        Presentation presentation = e.getPresentation();
        if (list.isEmpty() || this.index >= list.size()) {
            bl = false;
        } else {
            CollectionsKt.sortedWith((Iterable)list, CodeWithMeUsersGroup.Companion.getUserComparator());
            RdUserModel user = (RdUserModel)list.get(this.index);
            e.getPresentation().setIcon(CircleFactories.Companion.createUsersTabIcon(user));
            e.getPresentation().setText(CodeWithMeUsersGroup.Companion.getName$default(CodeWithMeUsersGroup.Companion, user, null, true, 2, null));
            bl = true;
        }
        presentation.setEnabledAndVisible(bl);
        super.update(e);
    }
}

