/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeaderElement;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveHeaderElementQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.editorconfig.backend"})
public final class EditorConfigRemoveHeaderElementQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.header-element.remove.description", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        EditorConfigHeaderElement editorConfigHeaderElement = psiElement instanceof EditorConfigHeaderElement ? (EditorConfigHeaderElement)psiElement : null;
        if (editorConfigHeaderElement == null) {
            return;
        }
        EditorConfigHeaderElement pattern = editorConfigHeaderElement;
        EditorConfigHeader header = pattern.getHeader();
        IntRange globalRange = EditorConfigPsiTreeUtil.INSTANCE.findRemovableRange((PsiElement)pattern);
        int headerOffset = header.getTextRange().getStartOffset();
        IntRange parentRange = new IntRange(globalRange.getStart() - headerOffset, globalRange.getEndInclusive() - headerOffset);
        String string = header.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence text = string;
        CharSequence newText = StringsKt.removeRange((CharSequence)text, (IntRange)parentRange);
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigHeader newHeader = factory.createHeader(newText);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> EditorConfigRemoveHeaderElementQuickFix.applyFix$lambda$0(header, newHeader));
    }

    private static final void applyFix$lambda$0(EditorConfigHeader $header, EditorConfigHeader $newHeader) {
        $header.replace((PsiElement)$newHeader);
    }
}

