/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.lang.ASTNode;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/editorconfig/language/psi/EditorConfigTokenSeparatorGenerator;", "Lcom/intellij/lang/TokenSeparatorGenerator;", "<init>", "()V", "generateWhitespaceBetweenTokens", "Lcom/intellij/lang/ASTNode;", "left", "right", "createLineBreak", "Lcom/intellij/psi/impl/source/tree/LeafElement;", "Lorg/jetbrains/annotations/NotNull;", "manager", "Lcom/intellij/psi/PsiManager;", "createWhitespace", "text", "", "intellij.editorconfig.backend"})
public final class EditorConfigTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    @Nullable
    public ASTNode generateWhitespaceBetweenTokens(@Nullable ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        PsiManager manager = right.getTreeParent().getPsi().getManager();
        ASTNode aSTNode = left;
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)EditorConfigElementTypes.LINE_COMMENT)) {
            Intrinsics.checkNotNull((Object)manager);
            return (ASTNode)this.createLineBreak(manager);
        }
        return null;
    }

    private final LeafElement createLineBreak(PsiManager manager) {
        return this.createWhitespace(manager, "\n");
    }

    private final LeafElement createWhitespace(PsiManager manager, String text) {
        LeafElement leafElement = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)text, (int)0, (int)text.length(), null, (PsiManager)manager);
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"createSingleLeafElement(...)");
        return leafElement;
    }
}

