/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.extensions;

import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.extensions.KernelDebugOptionsCustomizer;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettingsKt;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookFileDebugSession;
import com.intellij.kotlin.jupyter.debug.util.DebugSupportUtilsKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kotlin/jupyter/debug/extensions/NotebookDebugVmOptionCustomizer;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/extensions/KernelDebugOptionsCustomizer;", "<init>", "()V", "getDebugPort", "", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)Ljava/lang/Integer;", "intellij.kotlin.jupyter.debug"})
public final class NotebookDebugVmOptionCustomizer
implements KernelDebugOptionsCustomizer {
    @Nullable
    public Integer getDebugPort(@NotNull Project project, @NotNull Path notebookPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        KotlinNotebookFileDebugSession debugService = KotlinNotebookDebugSessionManager.Companion.getInstance(project).getByPath(notebookPath);
        if (debugService == null) {
            return null;
        }
        boolean isEnabled = DebugSupportUtilsKt.getDebugFeaturesSupported(KotlinNotebookSettingsKt.getSessionRunMode((JupyterNotebook)debugService.getVirtualFile().getNotebook()));
        if (!isEnabled) {
            return null;
        }
        return debugService.provideFreshDebugPort();
    }
}

