/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.extensions.dependencies;

import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.kotlin.jupyter.core.projectModel.extensions.KotlinNotebookModuleDependencyBehaviorRefiner;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.debug.util.DebugSupportUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.task.ProjectTaskContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/debug/extensions/dependencies/NotebookDebugAwareDependenciesRefiner;", "Lcom/intellij/kotlin/jupyter/core/projectModel/extensions/KotlinNotebookModuleDependencyBehaviorRefiner;", "<init>", "()V", "shouldShowOutdatedDependenciesPopup", "", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "refineBuildTaskContext", "Lcom/intellij/task/ProjectTaskContext;", "taskContext", "configureDebugHotSwapOption", "", "intellij.kotlin.jupyter.debug"})
public final class NotebookDebugAwareDependenciesRefiner
implements KotlinNotebookModuleDependencyBehaviorRefiner {
    public boolean shouldShowOutdatedDependenciesPopup(@NotNull Project project, @NotNull Collection<? extends Module> affectedModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        return !DebugSupportUtilsKt.getHasNotebookDebugSession(project);
    }

    @NotNull
    public ProjectTaskContext refineBuildTaskContext(@NotNull Project project, @NotNull ProjectTaskContext taskContext) {
        ProjectTaskContext projectTaskContext;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskContext, (String)"taskContext");
        ProjectTaskContext $this$refineBuildTaskContext_u24lambda_u240 = projectTaskContext = taskContext;
        boolean bl = false;
        this.configureDebugHotSwapOption($this$refineBuildTaskContext_u24lambda_u240, project);
        return projectTaskContext;
    }

    private final void configureDebugHotSwapOption(ProjectTaskContext $this$configureDebugHotSwapOption, Project project) {
        boolean hasAnyNotebookSession;
        if (!DebugSupportUtilsKt.getNotebookDebugFeaturesSupported(project)) {
            return;
        }
        boolean isDirty = $this$configureDebugHotSwapOption.getDirtyOutputPaths().isPresent();
        if (isDirty && (hasAnyNotebookSession = KotlinNotebookDebugSessionManager.Companion.getInstance(project).getHasAnyXDebugSession())) {
            return;
        }
        Key key = HotSwapUIImpl.SKIP_HOT_SWAP_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"SKIP_HOT_SWAP_KEY");
        $this$configureDebugHotSwapOption.withUserData(key, (Object)true);
    }
}

