/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.variables.presentation;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterEnvironmentUpdateListener;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowUtils;
import com.intellij.kotlin.jupyter.core.editor.appearance.data.KotlinNotebookVariablesToolWindowConfiguration;
import com.intellij.kotlin.jupyter.core.jupyter.toolwindow.KotlinNotebookToolWindowManager;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.util.EditorKt;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.kotlin.jupyter.debug.KotlinNotebookDebugEditorsProvider;
import com.intellij.kotlin.jupyter.debug.frame.KotlinNotebookVariablesFrame;
import com.intellij.kotlin.jupyter.debug.i18n.KotlinNotebookDebugBundle;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.kotlin.jupyter.debug.session.KotlinNotebookFileDebugSession;
import com.intellij.kotlin.jupyter.debug.util.DebugSupportUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.platform.debugger.impl.ui.XDebuggerEntityConverter;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\u0012\u0010$\u001a\u00020\u00172\b\b\u0001\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/intellij/kotlin/jupyter/debug/variables/presentation/KotlinNotebookVarsToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "panelSetupData", "Lcom/intellij/kotlin/jupyter/core/editor/appearance/data/KotlinNotebookVariablesToolWindowConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/kotlin/jupyter/core/editor/appearance/data/KotlinNotebookVariablesToolWindowConfiguration;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getPanelSetupData$intellij_kotlin_jupyter_debug", "()Lcom/intellij/kotlin/jupyter/core/editor/appearance/data/KotlinNotebookVariablesToolWindowConfiguration;", "variablesView", "Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;", "clickListener", "Lcom/intellij/ui/ClickListener;", "subscribeToEvents", "", "rebuildView", "shouldFocusOnFile", "", "getShouldFocusOnFile", "()Z", "shouldUpdateVariablesList", "getShouldUpdateVariablesList", "requestFocusOnTab", "initVariablesView", "updateVariablesView", "createClickListener", "removeClickListener", "showMessage", "text", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "createContent", "Lcom/intellij/ui/content/Content;", "getName", "dispose", "VariablesListener", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookVarsToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookVarsToolWindow.kt\ncom/intellij/kotlin/jupyter/debug/variables/presentation/KotlinNotebookVarsToolWindow\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1401#2,2:208\n1#3:210\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookVarsToolWindow.kt\ncom/intellij/kotlin/jupyter/debug/variables/presentation/KotlinNotebookVarsToolWindow\n*L\n108#1:208,2\n*E\n"})
public final class KotlinNotebookVarsToolWindow
extends SimpleToolWindowPanel
implements Disposable,
UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final KotlinNotebookVariablesToolWindowConfiguration panelSetupData;
    @Nullable
    private XStandaloneVariablesView variablesView;
    @Nullable
    private ClickListener clickListener;

    public KotlinNotebookVarsToolWindow(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull KotlinNotebookVariablesToolWindowConfiguration panelSetupData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)panelSetupData, (String)"panelSetupData");
        super(false);
        this.project = project;
        this.notebookFile = notebookFile;
        this.panelSetupData = panelSetupData;
        this.subscribeToEvents();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @NotNull
    public final KotlinNotebookVariablesToolWindowConfiguration getPanelSetupData$intellij_kotlin_jupyter_debug() {
        return this.panelSetupData;
    }

    private final void subscribeToEvents() {
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterEnvironmentUpdateListener.Companion.getTOPIC(), (Object)new VariablesListener());
    }

    private final void rebuildView() {
        if (this.variablesView == null) {
            this.initVariablesView();
        } else {
            this.updateVariablesView();
        }
    }

    private final boolean getShouldFocusOnFile() {
        return DebugSupportUtilsKt.getShouldFocusOnVariablesToolWindow(this.project) && DebugSupportUtilsKt.debugFeaturesSupported(this.notebookFile, this.project) && EditorKt.isCurrentlySelectedInEditor((BackedNotebookVirtualFile)this.notebookFile, (Project)this.project);
    }

    private final boolean getShouldUpdateVariablesList() {
        boolean bl;
        if (this.project.isDisposed() || !DebugSupportUtilsKt.getShouldShowNotebookVariables(this.project)) {
            this.showMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.default.message", new Object[0]));
            bl = false;
        } else if (!DebugSupportUtilsKt.debugFeaturesSupported(this.notebookFile, this.project)) {
            this.showMessage(KotlinNotebookDebugBundle.message("kotlin.jupyter.debug.node.not.enabled.message", new Object[0]));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void requestFocusOnTab() {
        Object object;
        ContentManager contentManager;
        block3: {
            RunnerLayoutUi runnerUi = this.panelSetupData.getUiRunnerLayoutUi();
            ContentManager contentManager2 = runnerUi.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
            contentManager = contentManager2;
            Content[] contentArray = runnerUi.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTabName(), (Object)this.panelSetupData.getTitle())) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Content variablesContent = (Content)object;
        if (variablesContent == null || variablesContent.isSelected()) {
            return;
        }
        contentManager.setSelectedContent(variablesContent, true);
        ToolWindow notebookToolWindow = KotlinNotebookToolWindowManager.Companion.getInstance(this.project).getOrCreateKotlinNotebookToolWindow();
        if (!notebookToolWindow.isActive()) {
            notebookToolWindow.show();
        }
    }

    private final void initVariablesView() {
        if (!this.getShouldUpdateVariablesList()) {
            return;
        }
        this.removeAll();
        KotlinNotebookFileDebugSession debugManager = KotlinNotebookDebugSessionManager.Companion.getForFile(this.project, this.notebookFile);
        KotlinNotebookVariablesFrame stackFrame = new KotlinNotebookVariablesFrame(this.project, null, debugManager);
        this.removeClickListener();
        XStandaloneVariablesView viewReference = this.variablesView = new XStandaloneVariablesView(this.project, (XDebuggerEditorsProvider)new KotlinNotebookDebugEditorsProvider(), (XStackFrame)stackFrame);
        if (viewReference == null) {
            return;
        }
        PopupHandler.installPopupMenu((JComponent)((JComponent)viewReference.getTree()), (String)"Notebook.XDebugger.StateValueGroup", (String)"XDebuggerTreePopup");
        this.add(viewReference.getPanel(), "Center");
        this.clickListener = this.createClickListener();
        ListenerUtil.addClickListener((Component)viewReference.getPanel(), (ClickListener)this.clickListener);
        Disposer.register((Disposable)this, (Disposable)((Disposable)viewReference));
        this.add(viewReference.getPanel(), "Center");
        this.validate();
        this.repaint();
    }

    private final void updateVariablesView() {
        block1: {
            if (!this.getShouldUpdateVariablesList()) {
                return;
            }
            XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
            if (xStandaloneVariablesView == null) break block1;
            xStandaloneVariablesView.rebuildView();
        }
    }

    private final ClickListener createClickListener() {
        return new ClickListener(this){
            final /* synthetic */ KotlinNotebookVarsToolWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JupyterVarsToolWindowUtils.INSTANCE.logViewUsage(this.this$0.getProject());
                return false;
            }
        };
    }

    private final void removeClickListener() {
        XStandaloneVariablesView variablesView = this.variablesView;
        ClickListener listener = this.clickListener;
        if (variablesView != null && listener != null) {
            ListenerUtil.removeClickListener((Component)variablesView.getPanel(), (ClickListener)listener);
        }
        this.clickListener = null;
    }

    private final void showMessage(@NlsContexts.DialogMessage String text) {
        this.removeAll();
        this.add(JupyterVarsToolWindowUtils.INSTANCE.createPlaceholder(text));
        this.variablesView = null;
        this.repaint();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(JupyterHelper.INSTANCE.getFORCED_NOTEBOOK(), (Object)this.notebookFile);
        XDebugSession xDebugSession = KotlinNotebookDebugSessionManager.Companion.getForFile(this.project, this.notebookFile).getCurrentXSession();
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session = xDebugSession;
        sink.set(XDebugSessionProxy.DEBUG_SESSION_PROXY_KEY, (Object)XDebuggerEntityConverter.asProxy((XDebugSession)session));
    }

    @NotNull
    public final Content createContent() {
        Content content;
        KotlinNotebookVariablesToolWindowConfiguration data;
        KotlinNotebookVarsToolWindow panel = this;
        KotlinNotebookVariablesToolWindowConfiguration $this$createContent_u24lambda_u240 = data = this.panelSetupData;
        boolean bl = false;
        Content $this$createContent_u24lambda_u240_u240 = content = $this$createContent_u24lambda_u240.getUiRunnerLayoutUi().createContent($this$createContent_u24lambda_u240.getHelpId() + $this$createContent_u24lambda_u240.getTitle(), (JComponent)((Object)panel), $this$createContent_u24lambda_u240.getTitle(), null, UiUtils.getPreferredFocusedComponent((JComponent)((JComponent)((Object)panel))));
        boolean bl2 = false;
        $this$createContent_u24lambda_u240_u240.setCloseable(false);
        Content content2 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"apply(...)");
        return content2;
    }

    @NotNull
    public String getName() {
        return KotlinNotebookBundle.message((String)"kotlin.jupyter.toolbar.tabs.variables", (Object[])new Object[0]);
    }

    public void dispose() {
        this.removeClickListener();
    }

    public static final /* synthetic */ void access$rebuildView(KotlinNotebookVarsToolWindow $this) {
        $this.rebuildView();
    }

    public static final /* synthetic */ boolean access$getShouldFocusOnFile(KotlinNotebookVarsToolWindow $this) {
        return $this.getShouldFocusOnFile();
    }

    public static final /* synthetic */ void access$requestFocusOnTab(KotlinNotebookVarsToolWindow $this) {
        $this.requestFocusOnTab();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/debug/variables/presentation/KotlinNotebookVarsToolWindow$VariablesListener;", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterEnvironmentUpdateListener;", "<init>", "(Lcom/intellij/kotlin/jupyter/debug/variables/presentation/KotlinNotebookVarsToolWindow;)V", "onRuntimeEnvironmentUpdate", "", "backedNotebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "values", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "intellij.kotlin.jupyter.debug"})
    private final class VariablesListener
    implements JupyterEnvironmentUpdateListener {
        public void onRuntimeEnvironmentUpdate(@NotNull BackedNotebookVirtualFile backedNotebookVirtualFile, @Nullable XValueChildrenList values) {
            Intrinsics.checkNotNullParameter((Object)backedNotebookVirtualFile, (String)"backedNotebookVirtualFile");
            if (!Intrinsics.areEqual((Object)KotlinNotebookVarsToolWindow.this.getNotebookFile(), (Object)backedNotebookVirtualFile) || !DebugSupportUtilsKt.getShouldShowNotebookVariables(KotlinNotebookVarsToolWindow.this.getProject())) {
                return;
            }
            KotlinNotebookPluginScope.Companion.invokeOnEDT((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(KotlinNotebookVarsToolWindow.this, null){
                int label;
                final /* synthetic */ KotlinNotebookVarsToolWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            KotlinNotebookVarsToolWindow.access$rebuildView(this.this$0);
                            if (KotlinNotebookVarsToolWindow.access$getShouldFocusOnFile(this.this$0)) {
                                KotlinNotebookVarsToolWindow.access$requestFocusOnTab(this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
    }
}

