/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.fullLine.controlModel.trigger.polyglot;

import com.intellij.fullLine.controlModel.MLApiControlModel;
import com.intellij.fullLine.controlModel.trigger.MLApiTriggerModelService;
import com.intellij.fullLine.controlModel.trigger.polyglot.PolyglotTriggerModel;
import com.intellij.fullLine.controlModel.trigger.polyglot.PolyglotTriggerModelService;
import com.intellij.ml.inline.completion.impl.control.ControlModel;
import com.intellij.ml.inline.completion.impl.control.ControlModelLoadingState;
import com.intellij.ml.inline.completion.impl.control.ControlModelTag;
import com.intellij.ml.inline.completion.impl.control.trigger.TriggerModelInfo;
import com.intellij.ml.inline.completion.impl.control.trigger.TriggerModelService;
import com.intellij.openapi.editor.EditorKind;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/intellij/fullLine/controlModel/trigger/polyglot/PolyglotTriggerModelService;", "Lcom/intellij/ml/inline/completion/impl/control/trigger/TriggerModelService;", "silent", "Lkotlin/Function0;", "", "randomPassProbability", "", "onlyTriggerRandomPassProbability", "editorKindSuitable", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/EditorKind;", "<init>", "(Lkotlin/jvm/functions/Function0;DDLkotlin/jvm/functions/Function1;)V", "getSilent", "()Lkotlin/jvm/functions/Function0;", "getRandomPassProbability", "()D", "getOnlyTriggerRandomPassProbability", "getEditorKindSuitable", "()Lkotlin/jvm/functions/Function1;", "isSilent", "isEditorKindSuitable", "editorKind", "baseMlApiControlModelService", "Lcom/intellij/fullLine/controlModel/trigger/MLApiTriggerModelService;", "loadingState", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "Lcom/intellij/ml/inline/completion/impl/control/trigger/TriggerModelInfo;", "getLoadingState", "()Lcom/intellij/ml/inline/completion/impl/control/ControlModelLoadingState;", "readLangaugeIds", "", "", "model", "Lcom/intellij/ml/inline/completion/impl/control/ControlModel;", "Companion", "intellij.fullLine.controlModel.trigger.polyglot"})
@ApiStatus.Internal
public final class PolyglotTriggerModelService
implements TriggerModelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Boolean> silent;
    private final double randomPassProbability;
    private final double onlyTriggerRandomPassProbability;
    @NotNull
    private final Function1<EditorKind, Boolean> editorKindSuitable;
    @NotNull
    private final MLApiTriggerModelService baseMlApiControlModelService;
    @NotNull
    public static final String INFO_KEY_LANGUAGE_IDS = "languages_supported";

    public PolyglotTriggerModelService(@NotNull Function0<Boolean> silent, double randomPassProbability, double onlyTriggerRandomPassProbability, @NotNull Function1<? super EditorKind, Boolean> editorKindSuitable) {
        Intrinsics.checkNotNullParameter(silent, (String)"silent");
        Intrinsics.checkNotNullParameter(editorKindSuitable, (String)"editorKindSuitable");
        this.silent = silent;
        this.randomPassProbability = randomPassProbability;
        this.onlyTriggerRandomPassProbability = onlyTriggerRandomPassProbability;
        this.editorKindSuitable = editorKindSuitable;
        ControlModelTag controlModelTag = ControlModelTag.POLYGLOT;
        Function0<Boolean> function0 = this.silent;
        double d = this.getRandomPassProbability();
        double d2 = this.getOnlyTriggerRandomPassProbability();
        Function1<EditorKind, Boolean> function1 = this.editorKindSuitable;
        this.baseMlApiControlModelService = new MLApiTriggerModelService("trigger-model-polyglot-cloud-0.1.1", (Function0)baseMlApiControlModelService.1.INSTANCE, controlModelTag, d, d2, null, function0, function1, true, 32, null);
    }

    @NotNull
    public final Function0<Boolean> getSilent() {
        return this.silent;
    }

    @Override
    public double getRandomPassProbability() {
        return this.randomPassProbability;
    }

    @Override
    public double getOnlyTriggerRandomPassProbability() {
        return this.onlyTriggerRandomPassProbability;
    }

    @NotNull
    public final Function1<EditorKind, Boolean> getEditorKindSuitable() {
        return this.editorKindSuitable;
    }

    @Override
    public boolean isSilent() {
        return (Boolean)this.silent.invoke();
    }

    @Override
    public boolean isEditorKindSuitable(@NotNull EditorKind editorKind) {
        Intrinsics.checkNotNullParameter((Object)editorKind, (String)"editorKind");
        return (Boolean)this.editorKindSuitable.invoke((Object)editorKind);
    }

    @Override
    @NotNull
    public ControlModelLoadingState<TriggerModelInfo> getLoadingState() {
        ControlModelLoadingState controlModelLoadingState;
        ControlModelLoadingState state = this.baseMlApiControlModelService.getLoadingState();
        if (state instanceof ControlModelLoadingState.Error) {
            controlModelLoadingState = state;
        } else if (state instanceof ControlModelLoadingState.Loading) {
            controlModelLoadingState = state;
        } else if (state instanceof ControlModelLoadingState.NotLoaded) {
            controlModelLoadingState = state;
        } else if (state instanceof ControlModelLoadingState.Loaded) {
            controlModelLoadingState = new ControlModelLoadingState.Loaded(new PolyglotTriggerModel(((ControlModelLoadingState.Loaded)state).getModel(), this.readLangaugeIds(((ControlModelLoadingState.Loaded)state).getModel())), ((ControlModelLoadingState.Loaded)state).getInfo());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return controlModelLoadingState;
    }

    private final Set<String> readLangaugeIds(ControlModel model) {
        MLApiControlModel mLApiControlModel = model instanceof MLApiControlModel ? (MLApiControlModel)model : null;
        if (mLApiControlModel == null) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n      Polyglot model can be based only on an ML API-based model, but was " + Reflection.getOrCreateKotlinClass(model.getClass()).getSimpleName() + "\n    ")));
        }
        MLApiControlModel mlApiModel = mLApiControlModel;
        Object idsFromInfoRaw = mlApiModel.getModel().getInfo().get(INFO_KEY_LANGUAGE_IDS);
        Collection collection = idsFromInfoRaw instanceof Collection ? (Collection)idsFromInfoRaw : null;
        if (collection == null) {
            throw new IllegalStateException("Polyglot model with id " + mlApiModel + " was expected to have key languages_supported in the info with a collection of languages, but it was " + idsFromInfoRaw);
        }
        Collection idsFromInfo = collection;
        return CollectionsKt.toSet((Iterable)idsFromInfo);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/fullLine/controlModel/trigger/polyglot/PolyglotTriggerModelService$Companion;", "", "<init>", "()V", "INFO_KEY_LANGUAGE_IDS", "", "intellij.fullLine.controlModel.trigger.polyglot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

