/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.terraform;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexeme;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.HCLCapability;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0014J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/inline/completion/terraform/TfMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "getLexingResult", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexer$LexingResult;", "lexemes", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexeme;", "lexer", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "handleHILToken", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "templateChars", "", "intellij.fullLine.terraform"})
@SourceDebugExtension(value={"SMAP\nTfMLCompletionLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/terraform/TfMLCompletionLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1915#2,2:77\n*S KotlinDebug\n*F\n+ 1 TfMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/terraform/TfMLCompletionLexer\n*L\n47#1:77,2\n*E\n"})
public final class TfMLCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    private final TokenSet bracketsSet;
    @NotNull
    private final List<Character> templateChars;

    public TfMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosures) {
        Intrinsics.checkNotNullParameter((Object)enclosures, (String)"enclosures");
        super(enclosures);
        IElementType[] iElementTypeArray = new IElementType[]{HCLElementTypes.L_CURLY, HCLElementTypes.R_CURLY, HCLElementTypes.L_PAREN, HCLElementTypes.R_PAREN, HCLElementTypes.L_BRACKET, HCLElementTypes.R_BRACKET};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
        Object[] objectArray = new Character[]{Character.valueOf('$'), Character.valueOf('%')};
        this.templateChars = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)HCLCapability.INTERPOLATION_LANGUAGE);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return (Lexer)new HCLLexer(enumSet);
    }

    @Override
    @NotNull
    protected MLCompletionLexer.LexingResult getLexingResult(@NotNull List<? extends MLCompletionLexeme> lexemes, @NotNull Lexer lexer2) {
        Intrinsics.checkNotNullParameter(lexemes, (String)"lexemes");
        Intrinsics.checkNotNullParameter((Object)lexer2, (String)"lexer");
        CharSequence charSequence = lexer2.getBufferSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getBufferSequence(...)");
        return new MLCompletionLexer.LexingResult(lexemes, new MLCompletionLexer.LexingContext(charSequence));
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            collector2.bracket(StringsKt.first((CharSequence)text2), offset);
            return;
        }
        if (Intrinsics.areEqual((Object)token, (Object)HCLElementTypes.DOUBLE_QUOTED_STRING) && StringsKt.startsWith$default((CharSequence)text2, (char)'\"', (boolean)false, (int)2, null)) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, '\"', offset, null, 4, null);
            this.handleHILToken(text2, offset, collector2);
            if (StringsKt.endsWith$default((CharSequence)text2, (char)'\"', (boolean)false, (int)2, null)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, '\"', offset + text2.length() - 1, null, 4, null);
            }
        }
    }

    private final void handleHILToken(String text2, int offset, MLCompletionLexerAdapter.LexemesCollector collector2) {
        Iterable $this$forEach$iv = this.templateChars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char templateChar = ((Character)element$iv).charValue();
            boolean bl = false;
            String templateStart = templateChar + "{";
            int startIndex = StringsKt.indexOf$default((CharSequence)text2, (String)templateStart, (int)0, (boolean)false, (int)6, null);
            while (startIndex != -1) {
                if (startIndex == 0 || text2.charAt(startIndex - 1) != templateChar) {
                    collector2.stringTemplate('{', offset + startIndex + 1, templateStart);
                    int endIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'}', (int)startIndex, (boolean)false, (int)4, null);
                    if (endIndex != -1) {
                        MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector2, '}', offset + endIndex, null, 4, null);
                    }
                }
                startIndex = StringsKt.indexOf$default((CharSequence)text2, (String)templateStart, (int)(startIndex + 1), (boolean)false, (int)4, null);
            }
        }
    }
}

