/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface Configurable
extends UnnamedConfigurable {
    public static final ExtensionPointName<ConfigurableEP<Configurable>> APPLICATION_CONFIGURABLE = new ExtensionPointName("com.intellij.applicationConfigurable");
    public static final ProjectExtensionPointName<ConfigurableEP<Configurable>> PROJECT_CONFIGURABLE = new ProjectExtensionPointName("com.intellij.projectConfigurable");

    @NlsContexts.ConfigurableName
    @Contract(pure=true)
    public String getDisplayName();

    @ApiStatus.Internal
    @Nullable
    default public String getDisplayNameFast() {
        return this.getDisplayName();
    }

    @Contract(pure=true)
    @Nullable
    @NonNls
    default public String getHelpTopic() {
        return null;
    }

    default public void focusOn(@NotNull @Nls String label) {
        if (label == null) {
            Configurable.$$$reportNull$$$0(0);
        }
    }

    public static boolean isFieldModified(@NotNull JTextField textField, @NotNull String initialValue) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(1);
        }
        if (initialValue == null) {
            Configurable.$$$reportNull$$$0(2);
        }
        return !StringUtil.equals((CharSequence)textField.getText().trim(), (CharSequence)initialValue);
    }

    public static boolean isFieldModified(@NotNull JTextField textField, int initialValue, @NotNull UINumericRange range) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(3);
        }
        if (range == null) {
            Configurable.$$$reportNull$$$0(4);
        }
        try {
            int currentValue = Integer.parseInt(textField.getText().trim());
            return range.fit(currentValue) == currentValue && currentValue != initialValue;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFieldModified(@NotNull JTextField textField, int initialValue) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(5);
        }
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != initialValue;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isCheckboxModified(@NotNull JCheckBox checkbox, boolean initialValue) {
        if (checkbox == null) {
            Configurable.$$$reportNull$$$0(6);
        }
        return checkbox.isSelected() != initialValue;
    }

    @Deprecated(forRemoval=true)
    default public boolean isModified(@NotNull JTextField textField, @NotNull String initialValue) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(7);
        }
        if (initialValue == null) {
            Configurable.$$$reportNull$$$0(8);
        }
        return Configurable.isFieldModified(textField, initialValue);
    }

    @Deprecated(forRemoval=true)
    default public boolean isModified(@NotNull JTextField textField, int initialValue, @NotNull UINumericRange range) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(9);
        }
        if (range == null) {
            Configurable.$$$reportNull$$$0(10);
        }
        return Configurable.isFieldModified(textField, initialValue, range);
    }

    @Deprecated(forRemoval=true)
    default public boolean isModified(@NotNull JToggleButton toggleButton, boolean initialValue) {
        if (toggleButton == null) {
            Configurable.$$$reportNull$$$0(11);
        }
        return toggleButton.isSelected() != initialValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialValue";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkbox";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toggleButton";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/Configurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "focusOn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldModified";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCheckboxModified";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TopComponentProvider {
        default public boolean isAvailable() {
            return true;
        }

        @NotNull
        public Component getCenterComponent(@NotNull TopComponentController var1);
    }

    public static interface TopComponentController {
        public static final TopComponentController EMPTY = new TopComponentController(){

            @Override
            public void setLeftComponent(@Nullable Component component) {
            }

            @Override
            public void showProgress(boolean start) {
            }

            @Override
            public void showProject(boolean hasProject) {
            }
        };

        public void setLeftComponent(@Nullable Component var1);

        public void showProgress(boolean var1);

        public void showProject(boolean var1);
    }

    @ApiStatus.Internal
    public static interface ClassCastChecker {
        public <T> boolean tryToCast(@NotNull Class<T> var1);
    }

    public static interface SingleEditorConfiguration {
        @NotNull
        public Dimension getDialogInitialSize();
    }

    @ApiStatus.Experimental
    public static interface InnerWithModifiableParent {
        @NotNull
        public List<Configurable> getModifiableParents();
    }

    public static interface WithEpDependencies {
        @NotNull
        public @Unmodifiable Collection<BaseExtensionPointName<?>> getDependencies();
    }

    public static interface VariableProjectAppLevel {
        public boolean isProjectLevel();
    }

    public static interface NoMargin {
    }

    public static interface Promo {
        @NotNull
        public Icon getPromoIcon();
    }

    public static interface Beta {
    }

    public static interface NoScroll {
    }

    @FunctionalInterface
    public static interface Composite {
        @NotNull
        public @NotNull Configurable @NotNull [] getConfigurables();
    }
}

