/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.PopupShowOptions;
import com.intellij.openapi.ui.popup.PopupShowOptionsBuilder;
import com.intellij.openapi.ui.popup.PopupShowOptionsImpl;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JBPopup
extends Disposable,
LightweightWindow {
    @NonNls
    public static final String KEY = "JBPopup";

    public void showUnderneathOf(@NotNull Component var1);

    public void show(@NotNull RelativePoint var1);

    default public void show(@NotNull PopupShowOptions showOptions) {
        if (showOptions == null) {
            JBPopup.$$$reportNull$$$0(0);
        }
        PopupShowOptionsImpl options = ((PopupShowOptionsBuilder)showOptions).build();
        Component owner = options.getOwner();
        int aScreenX = options.getScreenX();
        int aScreenY = options.getScreenY();
        this.showInScreenCoordinates(owner, new Point(aScreenX, aScreenY));
    }

    public void showInScreenCoordinates(@NotNull Component var1, @NotNull Point var2);

    @NotNull
    public Point getBestPositionFor(@NotNull DataContext var1);

    public void showInBestPositionFor(@NotNull DataContext var1);

    public void showInBestPositionFor(@NotNull Editor var1);

    public void showInCenterOf(@NotNull Component var1);

    public void showInFocusCenter();

    public void show(@NotNull Component var1);

    public void showCenteredInCurrentWindow(@NotNull Project var1);

    public void closeOk(@Nullable InputEvent var1);

    public void cancel();

    public void setRequestFocus(boolean var1);

    public void cancel(@Nullable InputEvent var1);

    public boolean canClose();

    public boolean isVisible();

    @NotNull
    public JComponent getContent();

    default public void setBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            JBPopup.$$$reportNull$$$0(1);
        }
        this.setLocation(bounds.getLocation());
        this.setSize(bounds.getSize());
    }

    public void setLocation(@NotNull Point var1);

    default public void setSize(@Nullable Point location, @NotNull Dimension size) {
        if (size == null) {
            JBPopup.$$$reportNull$$$0(2);
        }
    }

    public void setSize(@NotNull Dimension var1);

    public Dimension getSize();

    public void setCaption(@NlsContexts.PopupTitle @NotNull String var1);

    public void setCaptionIcon(@Nullable Icon var1);

    public void setCaptionIconPosition(boolean var1);

    public boolean isPersistent();

    public boolean isModalContext();

    public boolean isNativePopup();

    public void setUiVisible(boolean var1);

    default public void setUserData(@NotNull List<Object> userData) {
        if (userData == null) {
            JBPopup.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Class<T> var1);

    public boolean isFocused();

    public boolean isCancelKeyEnabled();

    public void addListener(@NotNull JBPopupListener var1);

    public void removeListener(@NotNull JBPopupListener var1);

    public boolean isDisposed();

    public Component getOwner();

    public void setMinimumSize(@Nullable Dimension var1);

    public void setFinalRunnable(@Nullable Runnable var1);

    public void moveToFitScreen();

    @NotNull
    public Point getLocationOnScreen();

    public void pack(boolean var1, boolean var2);

    public void setAdText(@NlsContexts.PopupAdvertisement String var1, @JdkConstants.HorizontalAlignment int var2);

    @Deprecated(forRemoval=true)
    default public void setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            JBPopup.$$$reportNull$$$0(4);
        }
    }

    default public void setUiDataProvider(@NotNull UiDataProvider dataProvider) {
        if (dataProvider == null) {
            JBPopup.$$$reportNull$$$0(5);
        }
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent var1);

    default public boolean dispatchInputMethodEvent(@NotNull InputMethodEvent e) {
        if (e == null) {
            JBPopup.$$$reportNull$$$0(6);
        }
        return false;
    }

    default public boolean canShow() {
        return !this.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/popup/JBPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setBounds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUserData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDataProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setUiDataProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchInputMethodEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

