/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/config/MnConfigKeyNameBinder;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "<init>", "()V", "bindsTo", "", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "configKeyText", "", "matchesPrefix", "prefixText", "matchesPart", "keyPart", "text", "bindsToKeyProperty", "keyProperty", "matchesFirstChar", "keyName", "toUniform", "matches", "intellij.micronaut"})
public final class MnConfigKeyNameBinder
implements MetaConfigKeyManager.ConfigKeyNameBinder {
    @NotNull
    public static final MnConfigKeyNameBinder INSTANCE = new MnConfigKeyNameBinder();

    private MnConfigKeyNameBinder() {
    }

    public boolean bindsTo(@NotNull MetaConfigKey key, @NotNull String configKeyText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.matchesFirstChar(string, configKeyText)) {
            return false;
        }
        String string2 = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String uniformedConfigKeyText = this.toUniform(string2, configKeyText);
        boolean exactMatch = Intrinsics.areEqual((Object)key.getName(), (Object)uniformedConfigKeyText);
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (key.isAccessType(accessTypeArray)) {
            return exactMatch;
        }
        accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
        if (key.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length))) {
            return exactMatch || StringUtil.startsWith((CharSequence)uniformedConfigKeyText, (CharSequence)(key.getName() + "."));
        }
        accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        if (key.isAccessType(accessTypeArray)) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)uniformedConfigKeyText, (char)'[')) {
                return false;
            }
            String string3 = StringUtil.substringBefore((String)uniformedConfigKeyText, (String)"[");
            Intrinsics.checkNotNull((Object)string3);
            String beforeIndexAccess = string3;
            beforeIndexAccess = StringsKt.removeSuffix((String)beforeIndexAccess, (CharSequence)".");
            return Intrinsics.areEqual((Object)key.getName(), (Object)beforeIndexAccess);
        }
        throw new IllegalArgumentException("unknown access type for " + key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchesPrefix(@NotNull MetaConfigKey key, @NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.matchesFirstChar(string, prefixText)) return false;
        CharSequence charSequence = key.getName();
        String string2 = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringUtil.startsWith((CharSequence)charSequence, (CharSequence)this.toUniform(string2, prefixText))) return false;
        return true;
    }

    public boolean matchesPart(@NotNull String keyPart, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)keyPart, (String)"keyPart");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)keyPart, (Object)"*") || this.matchesFirstChar(keyPart, text) && this.matches(keyPart, text);
    }

    @Nullable
    public String bindsToKeyProperty(@NotNull MetaConfigKey key, @Nullable String keyProperty, @NotNull String configKeyText) {
        ConfigKeyParts parts;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (key.isAccessType(accessTypeArray)) {
            return null;
        }
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String keyName = string;
        if (!this.matchesFirstChar(keyName, configKeyText)) {
            return null;
        }
        ConfigKeyParts configKeyParts = parts = ConfigKeyParts.splitToParts((MetaConfigKey)key, (String)configKeyText, (boolean)true);
        return configKeyParts != null ? configKeyParts.getKeyIndexIfMatches(keyName, keyProperty, this::matches) : null;
    }

    private final boolean matchesFirstChar(String keyName, String configKeyText) {
        return ((CharSequence)configKeyText).length() > 0 && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private final String toUniform(String keyName, String configKeyText) {
        String uniformedConfigKeyText = RelaxedNames.camelCaseToHyphen((String)configKeyText);
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(keyName);
        if (mnParametrizedConfigKey == null) {
            Intrinsics.checkNotNull((Object)uniformedConfigKeyText);
            return uniformedConfigKeyText;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        Intrinsics.checkNotNull((Object)uniformedConfigKeyText);
        TextRange textRange = parametrizedConfigKey.getParameterRange(uniformedConfigKeyText);
        if (textRange == null) {
            return uniformedConfigKeyText;
        }
        TextRange parameterRange = textRange;
        String string = uniformedConfigKeyText.substring(0, parameterRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String result = string + "*";
        if (parameterRange.getEndOffset() == uniformedConfigKeyText.length()) {
            return result;
        }
        String string2 = uniformedConfigKeyText.substring(parameterRange.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return result + string2;
    }

    private final boolean matches(String keyName, String configKeyText) {
        return Intrinsics.areEqual((Object)keyName, (Object)this.toUniform(keyName, configKeyText));
    }
}

