/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.config.MnMetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"collectPredefinedKeys", "", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "LOGGER_LEVELS_KEY", "", "LOGGER_LEVELS_DESCRIPTION", "LOG_LEVEL", "LOGGING_LEVELS_CONFIGURER", "getLoggingLevelsKey", "intellij.micronaut"})
public final class PredefinedMetaConfigKeysKt {
    @NotNull
    public static final String LOGGER_LEVELS_KEY = "logger.levels";
    @NotNull
    private static final String LOGGER_LEVELS_DESCRIPTION = "Logger levels severity mapping. For instance, `logger.levels.io.micronaut=INFO`.";
    @NotNull
    private static final String LOG_LEVEL = "io.micronaut.logging.LogLevel";
    @NotNull
    private static final String LOGGING_LEVELS_CONFIGURER = "io.micronaut.logging.PropertiesLoggingLevelsConfigurer";

    @NotNull
    public static final List<MetaConfigKey> collectPredefinedKeys(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.listOfNotNull((Object)PredefinedMetaConfigKeysKt.getLoggingLevelsKey(module));
    }

    private static final MetaConfigKey getLoggingLevelsKey(Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(LOGGING_LEVELS_CONFIGURER, scope);
        if (psiClass == null) {
            return null;
        }
        PsiClass configurer = psiClass;
        try {
            String typeText = "java.util.Map<java.lang.String,io.micronaut.logging.LogLevel>";
            PsiType psiType = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createTypeFromText(typeText, null);
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
            PsiType psiType2 = psiType;
            return (MetaConfigKey)new MnMetaConfigKey((PsiElement)configurer, MetaConfigKey.DeclarationResolveResult.PROPERTY, LOGGER_LEVELS_KEY, new MetaConfigKey.DescriptionText(LOGGER_LEVELS_DESCRIPTION), null, psiType2, MetaConfigKey.AccessType.MAP);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

