/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.icons.AllIcons;
import com.intellij.micronaut.jam.beans.JamPsiClassMicronautBean;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.websocket.MnWebSocket;
import com.intellij.micronaut.provider.websocket.MnWebSocketTargetInfo;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.presentation.HttpUrlPresentation;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketFramework;", "T", "Lcom/intellij/micronaut/jam/websocket/MnWebSocket;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "<init>", "()V", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "group", "endpoint", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Lcom/intellij/navigation/ItemPresentation;", "isValidEndpoint", "", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Z", "getEndpoints", "", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Ljava/lang/Iterable;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Lcom/intellij/psi/PsiElement;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Ljava/lang/Iterable;", "intellij.micronaut"})
public abstract class MnWebSocketFramework<T extends MnWebSocket>
implements EndpointsUrlTargetProvider<T, T> {
    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnWebSocketUtilsKt.hasWebSocketLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        return (ItemPresentation)new HttpUrlPresentation(((MnWebSocket)endpoint).getResourceValue(), ((PsiClass)((JamPsiClassMicronautBean)endpoint).getPsiElement()).getName(), AllIcons.Webreferences.WebSocket, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)((JamPsiClassMicronautBean)endpoint).getPsiElement()) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    public boolean isValidEndpoint(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        return ((JamPsiClassMicronautBean)endpoint).isValid();
    }

    @NotNull
    public Iterable<T> getEndpoints(@NotNull T group) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        return CollectionsKt.listOf(group);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        return ((JamPsiClassMicronautBean)endpoint).getPsiElement();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(((MnWebSocket)endpoint).getResourceValue());
        return CollectionsKt.listOf(new MnWebSocketTargetInfo<T>(UrlConstants.WS_SCHEMES, urlPath, endpoint));
    }
}

