/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.application.options.ModulesCombo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.application.JavaSettingsEditorBase;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TargetPathFragment;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationFragmentedEditor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016JB\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0014J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationFragmentedEditor;", "Lcom/intellij/execution/application/JavaSettingsEditorBase;", "Lcom/intellij/micronaut/run/MnRunConfiguration;", "runConfiguration", "<init>", "(Lcom/intellij/micronaut/run/MnRunConfiguration;)V", "isInplaceValidationSupported", "", "customizeFragments", "", "fragments", "", "Lcom/intellij/execution/ui/SettingsEditorFragment;", "moduleClasspath", "Lcom/intellij/execution/ui/ModuleClasspathCombo;", "commonParameterFragments", "Lcom/intellij/execution/ui/CommonParameterFragments;", "createMainClass", "Lcom/intellij/execution/application/ClassEditorField;", "modulesCombo", "Lcom/intellij/application/options/ModulesCombo;", "intellij.micronaut"})
public final class MnRunConfigurationFragmentedEditor
extends JavaSettingsEditorBase<MnRunConfiguration> {
    public MnRunConfigurationFragmentedEditor(@NotNull MnRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        super((JavaRunConfigurationBase)runConfiguration);
    }

    public boolean isInplaceValidationSupported() {
        return true;
    }

    protected void customizeFragments(@NotNull List<SettingsEditorFragment<MnRunConfiguration, ?>> fragments, @NotNull SettingsEditorFragment<MnRunConfiguration, ModuleClasspathCombo> moduleClasspath, @NotNull CommonParameterFragments<MnRunConfiguration> commonParameterFragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter(moduleClasspath, (String)"moduleClasspath");
        Intrinsics.checkNotNullParameter(commonParameterFragments, (String)"commonParameterFragments");
        SettingsEditorFragment settingsEditorFragment = SettingsEditorFragment.createTag((String)"include.provided", (String)ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), MnRunConfigurationFragmentedEditor::customizeFragments$lambda$0, MnRunConfigurationFragmentedEditor::customizeFragments$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"createTag(...)");
        fragments.add(settingsEditorFragment);
        SettingsEditorFragment settingsEditorFragment2 = commonParameterFragments.programArguments();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment2, (String)"programArguments(...)");
        fragments.add(settingsEditorFragment2);
        fragments.add((SettingsEditorFragment<MnRunConfiguration, ?>)new TargetPathFragment());
        SettingsEditorFragment settingsEditorFragment3 = commonParameterFragments.createRedirectFragment();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment3, (String)"createRedirectFragment(...)");
        fragments.add(settingsEditorFragment3);
        JComponent jComponent = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component(...)");
        SettingsEditorFragment<MnRunConfiguration, ClassEditorField> mainClassFragment = this.createMainClass((ModulesCombo)jComponent);
        fragments.add(mainClassFragment);
        JComponent jComponent2 = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"component(...)");
        ModuleClasspathCombo moduleClasspathCombo = (ModuleClasspathCombo)jComponent2;
        JComponent jComponent3 = mainClassFragment.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"component(...)");
        DefaultJreSelector jreSelector = DefaultJreSelector.Companion.fromSourceRootsDependencies(moduleClasspathCombo, (EditorTextField)jComponent3);
        SettingsEditorFragment settingsEditorFragment4 = CommonJavaFragments.createJrePath((DefaultJreSelector)jreSelector);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment4, (String)"createJrePath(...)");
        SettingsEditorFragment jrePath = settingsEditorFragment4;
        fragments.add(jrePath);
        SettingsEditorFragment settingsEditorFragment5 = this.createShortenClasspath((ModuleClasspathCombo)moduleClasspath.component(), jrePath, true);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment5, (String)"createShortenClasspath(...)");
        fragments.add(settingsEditorFragment5);
    }

    private final SettingsEditorFragment<MnRunConfiguration, ClassEditorField> createMainClass(ModulesCombo modulesCombo) {
        Project project = this.getProject();
        ConfigurationModuleSelector moduleSelector2 = new ConfigurationModuleSelector(modulesCombo, project){

            public boolean isModuleAccepted(Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return MicronautUtils.hasMicronautLibrary(module);
            }
        };
        JavaCodeFragment.VisibilityChecker visibilityChecker = MnRunConfigurationFragmentedEditor::createMainClass$lambda$0;
        ClassBrowser.AppClassBrowser classBrowser = new ClassBrowser.AppClassBrowser(this.getProject(), moduleSelector2);
        ClassEditorField classEditorField = ClassEditorField.createClassField((Project)this.getProject(), null, (JavaCodeFragment.VisibilityChecker)visibilityChecker, (BrowseModuleValueActionListener)((BrowseModuleValueActionListener)classBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)classEditorField, (String)"createClassField(...)");
        ClassEditorField mainClass = classEditorField;
        mainClass.setBackground(UIUtil.getTextFieldBackground());
        mainClass.setShowPlaceholderWhenFocused(true);
        CommonParameterFragments.setMonospaced((Component)((Component)mainClass));
        String string = ExecutionBundle.message((String)"application.configuration.main.class.placeholder", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String placeholder = string;
        mainClass.setPlaceholder((CharSequence)placeholder);
        mainClass.getAccessibleContext().setAccessibleName(placeholder);
        CommandLinePanel.setMinimumWidth((Component)((Component)mainClass), (int)300);
        SettingsEditorFragment mainClassFragment = new SettingsEditorFragment("mainClass", ExecutionBundle.message((String)"application.configuration.main.class", (Object[])new Object[0]), null, (JComponent)mainClass, 20, (arg_0, arg_1) -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$2(MnRunConfigurationFragmentedEditor::createMainClass$lambda$1, arg_0, arg_1), (arg_0, arg_1) -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$4(MnRunConfigurationFragmentedEditor::createMainClass$lambda$3, arg_0, arg_1), arg_0 -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$6(MnRunConfigurationFragmentedEditor::createMainClass$lambda$5, arg_0));
        mainClassFragment.setRemovable(false);
        mainClassFragment.setEditorGetter(arg_0 -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$8(MnRunConfigurationFragmentedEditor::createMainClass$lambda$7, arg_0));
        mainClassFragment.setValidation(arg_0 -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$10(arg_0 -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$9(mainClass, arg_0), arg_0));
        mainClass.addDocumentListener(new DocumentListener(this, mainClass, moduleSelector2, modulesCombo){
            final /* synthetic */ MnRunConfigurationFragmentedEditor this$0;
            final /* synthetic */ ClassEditorField $mainClass;
            final /* synthetic */ createMainClass.moduleSelector.1 $moduleSelector;
            final /* synthetic */ ModulesCombo $modulesCombo;
            {
                this.this$0 = $receiver;
                this.$mainClass = $mainClass;
                this.$moduleSelector = $moduleSelector;
                this.$modulesCombo = $modulesCombo;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = MnRunConfigurationFragmentedEditor.access$getProject(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getProject(...)");
                if (DumbService.Companion.getInstance(project).isDumb()) {
                    return;
                }
                String string = this.$mainClass.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = string;
                if (this.$moduleSelector.getModule() != null && this.$moduleSelector.findClass(text) != null) {
                    return;
                }
                JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(MnRunConfigurationFragmentedEditor.access$getProject(this.this$0), false);
                PsiClass psiClass = configurationModule.findClass(text);
                if (psiClass == null) {
                    return;
                }
                PsiClass psiClass2 = psiClass;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass2));
                if (module != null && this.$moduleSelector.isModuleAccepted(module)) {
                    this.$modulesCombo.setSelectedModule(module);
                }
            }
        });
        return mainClassFragment;
    }

    private static final boolean customizeFragments$lambda$0(MnRunConfiguration it) {
        return it.isProvidedScopeIncluded();
    }

    private static final void customizeFragments$lambda$1(MnRunConfiguration configuration, Boolean value) {
        Intrinsics.checkNotNull((Object)value);
        configuration.setIncludeProvidedScope(value);
    }

    private static final void createMainClass$lambda$9$0(MnRunConfiguration $it) {
        $it.checkClass();
    }

    private static final JavaCodeFragment.VisibilityChecker.Visibility createMainClass$lambda$0(PsiElement declaration, PsiElement psiElement) {
        if (declaration instanceof PsiClass && PsiMethodUtil.hasMainMethod((PsiClass)((PsiClass)declaration))) {
            return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
        }
        return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
    }

    private static final Unit createMainClass$lambda$1(MnRunConfiguration configuration, ClassEditorField component) {
        component.setClassName(configuration.getMainClassName());
        return Unit.INSTANCE;
    }

    private static final void createMainClass$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createMainClass$lambda$3(MnRunConfiguration configuration, ClassEditorField component) {
        configuration.setMainClassName(component.getText());
        return Unit.INSTANCE;
    }

    private static final void createMainClass$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean createMainClass$lambda$5(MnRunConfiguration it) {
        return true;
    }

    private static final boolean createMainClass$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final JComponent createMainClass$lambda$7(ClassEditorField it) {
        Object object = it.getEditor();
        if (object == null || (object = object.getContentComponent()) == null) {
            object = (JComponent)it;
        }
        return object;
    }

    private static final JComponent createMainClass$lambda$8(Function1 $tmp0, Object p0) {
        return (JComponent)$tmp0.invoke(p0);
    }

    private static final List createMainClass$lambda$9(ClassEditorField $mainClass, MnRunConfiguration it) {
        return CollectionsKt.listOf((Object)RuntimeConfigurationException.validate((JComponent)((JComponent)$mainClass), () -> MnRunConfigurationFragmentedEditor.createMainClass$lambda$9$0(it)));
    }

    private static final List createMainClass$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject(MnRunConfigurationFragmentedEditor $this) {
        return $this.getProject();
    }
}

