/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.CommonVersionReader;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationPackages;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader;", "", "<init>", "()V", "VERSIONS_SLICE", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/RuntimeVersions;", "getVersionsForCurrentModuleFromTrace", "module", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVersionsForCurrentModule", "getVersionsFromManifest", "runtimeLibraryPath", "Ljava/io/File;", "kotlinx-serialization-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nVersionReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionReader.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class VersionReader {
    @NotNull
    public static final VersionReader INSTANCE = new VersionReader();
    @NotNull
    private static final WritableSlice<ModuleDescriptor, RuntimeVersions> VERSIONS_SLICE;

    private VersionReader() {
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModuleFromTrace(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        RuntimeVersions runtimeVersions = (RuntimeVersions)trace.get((ReadOnlySlice)VERSIONS_SLICE, (Object)module);
        if (runtimeVersions != null) {
            RuntimeVersions it = runtimeVersions;
            boolean bl = false;
            return it;
        }
        RuntimeVersions runtimeVersions2 = this.getVersionsForCurrentModule(module);
        if (runtimeVersions2 == null) {
            return null;
        }
        RuntimeVersions versions = runtimeVersions2;
        trace.record(VERSIONS_SLICE, (Object)module, (Object)versions);
        return versions;
    }

    private final RuntimeVersions getVersionsForCurrentModule(ModuleDescriptor module) {
        FqName fqName = SerializationPackages.INSTANCE.getPackageFqName();
        Name name = Name.identifier((String)"KSerializer");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(fqName, name));
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor markerClass = classDescriptor;
        return CommonVersionReader.INSTANCE.computeRuntimeVersions(markerClass.getSource());
    }

    @NotNull
    public final RuntimeVersions getVersionsFromManifest(@NotNull File runtimeLibraryPath) {
        Intrinsics.checkNotNullParameter((Object)runtimeLibraryPath, (String)"runtimeLibraryPath");
        return CommonVersionReader.INSTANCE.getVersionsFromManifest(runtimeLibraryPath);
    }

    static {
        WritableSlice writableSlice = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue((Object)writableSlice, (String)"createSimpleSlice(...)");
        VERSIONS_SLICE = writableSlice;
    }
}

