/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileContentImpl(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        this(project, file, file);
    }

    public FileContentImpl(@Nullable Project project, @NotNull VirtualFile file, @Nullable VirtualFile highlightFile) {
        if (file == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        assert (!file.isDirectory());
        this.myFile = file;
        this.myProject = project;
        this.myType = file.getFileType();
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.myHighlightFile)) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public FileType getContentType() {
        FileType fileType = this.myType;
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        return fileType;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            DiffUtil.refreshOnFrameActivation(this.myFile);
        }
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/contents/FileContentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/contents/FileContentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

