/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.DiffContext;
import com.intellij.diff.editor.DefaultDiffFileEditorCustomizerKt;
import com.intellij.diff.editor.DiffEditorEscapeAction;
import com.intellij.diff.editor.DiffEditorEscapeDelegatingAction;
import com.intellij.diff.editor.DiffRequestProcessorEditorCustomizer;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/diff/editor/DefaultDiffFileEditorCustomizer;", "Lcom/intellij/diff/editor/DiffRequestProcessorEditorCustomizer;", "<init>", "()V", "customize", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "context", "Lcom/intellij/diff/DiffContext;", "registerEscapeAction", "intellij.platform.diff.impl"})
public final class DefaultDiffFileEditorCustomizer
implements DiffRequestProcessorEditorCustomizer {
    @Override
    public void customize(@NotNull VirtualFile file, @NotNull FileEditor editor, @NotNull DiffContext context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.registerEscapeAction(editor);
        editor.putUserData(DefaultDiffFileEditorCustomizerKt.getIS_DIFF_FILE_EDITOR(), (Object)true);
        editor.putUserData(FileEditorManagerKeys.SINGLETON_EDITOR_IN_WINDOW, (Object)true);
        editor.putUserData(FileEditorManagerKeys.SHOW_NORTH_PANEL, (Object)false);
    }

    private final void registerEscapeAction(FileEditor editor) {
        AnAction escapeHandler;
        VirtualFile virtualFile = editor.getFile();
        DiffVirtualFileBase diffVirtualFileBase = virtualFile instanceof DiffVirtualFileBase ? (DiffVirtualFileBase)virtualFile : null;
        Object object = escapeHandler = diffVirtualFileBase != null ? diffVirtualFileBase.createEscapeHandler() : null;
        if (escapeHandler != null && !(escapeHandler instanceof DiffEditorEscapeAction)) {
            escapeHandler = (AnAction)new DiffEditorEscapeDelegatingAction(escapeHandler);
        }
        AnAction defaultCloseAction = ActionManager.getInstance().getAction("CloseDiffEditor");
        if (escapeHandler != null) {
            editor.putUserData(DefaultDiffFileEditorCustomizerKt.getCUSTOM_DIFF_ESCAPE_HANDLER(), (Object)escapeHandler);
            escapeHandler.registerCustomShortcutSet(defaultCloseAction.getShortcutSet(), editor.getComponent(), null);
        } else {
            defaultCloseAction.registerCustomShortcutSet(editor.getComponent(), null);
        }
    }
}

