/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffTool;
import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffEditorViewerListener;
import com.intellij.diff.impl.DiffRequestProcessorEditorState;
import com.intellij.diff.impl.DiffRequestProcessorListener;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.impl.ui.DiffToolChooser;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.lang.DiffLangSpecificProvider;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.util.CrossFilePrevNextDifferenceIterableSupport;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextFileIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.RemoteTransferUIManager;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class DiffRequestProcessor
implements DiffEditorViewer,
CheckedDisposable {
    private static final Logger LOG = Logger.getInstance(DiffRequestProcessor.class);
    private static final DataKey<DiffTool> ACTIVE_DIFF_TOOL = DataKey.create((String)"active_diff_tool");
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private List<DiffTool> myToolOrder;
    @Nullable
    private final FrameDiffTool myForcedDiffTool;
    @NotNull
    private final DefaultActionGroup myToolbarGroup;
    @NotNull
    private final DefaultActionGroup myRightToolbarGroup;
    @NotNull
    private final DefaultActionGroup myPopupActionGroup;
    @NotNull
    private final DefaultActionGroup myTouchbarActionGroup;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final JPanel myTopPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    @NotNull
    private final ActionToolbar myRightToolbar;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @NotNull
    private final Wrapper myDiffInfoWrapper;
    @NotNull
    private final Wrapper myRightToolbarWrapper;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MyProgressBar myProgressBar;
    @NotNull
    private final EventDispatcher<DiffRequestProcessorListener> myEventDispatcher;
    @NotNull
    private DiffRequest myActiveRequest;
    @NotNull
    private ViewerState myState;
    @Nullable
    private DiffUserDataKeysEx.ScrollToPolicy myCurrentScrollToPolicy;
    private final boolean myIsNewToolbar;
    @NotNull
    private final DiffNavigator navigator;
    @Nullable
    private ApplyData myQueuedApplyRequest;
    private static final boolean SHOW_VIEWER_ACTIONS_IN_TOUCHBAR = Boolean.getBoolean("touchbar.diff.show.viewer.actions");

    public DiffRequestProcessor(@Nullable Project project) {
        this(project, (UserDataHolder)new UserDataHolderBase());
    }

    public DiffRequestProcessor(@Nullable Project project, @NonNls @NotNull String place) {
        if (place == null) {
            DiffRequestProcessor.$$$reportNull$$$0(0);
        }
        this(project, (UserDataHolder)DiffUtil.createUserDataHolder(DiffUserDataKeys.PLACE, place));
    }

    public DiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        if (context == null) {
            DiffRequestProcessor.$$$reportNull$$$0(1);
        }
        this.myToolOrder = Collections.emptyList();
        this.myEventDispatcher = EventDispatcher.create(DiffRequestProcessorListener.class);
        this.myProject = project;
        this.myContext = new MyDiffContext(context);
        this.myActiveRequest = new LoadingDiffRequest();
        this.mySettings = DiffSettingsHolder.DiffSettings.getSettings((String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myForcedDiffTool = (FrameDiffTool)ObjectUtils.tryCast((Object)this.myContext.getUserData(DiffUserDataKeysEx.FORCE_DIFF_TOOL), FrameDiffTool.class);
        this.myIsNewToolbar = DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_NEW_TOOLBAR, new UserDataHolder[]{this.myContext});
        this.readToolOrderFromSettings();
        DiffTool.EP_NAME.addChangeListener(() -> {
            this.readToolOrderFromSettings();
            this.updateRequest(true);
        }, (Disposable)this);
        DiffToolSubstitutor.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        DiffIgnoredRangeProvider.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        DiffLangSpecificProvider.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        this.myToolbarGroup = new DefaultActionGroup();
        this.myRightToolbarGroup = new DefaultActionGroup();
        this.myPopupActionGroup = new DefaultActionGroup();
        this.myTouchbarActionGroup = new DefaultActionGroup();
        this.myMainPanel = new MyPanel();
        Touchbar.setActions((JComponent)((Object)this.myMainPanel), (ActionGroup)this.myTouchbarActionGroup);
        this.myContentPanel = new Wrapper();
        this.myToolbarStatusPanel = new Wrapper();
        this.myProgressBar = new MyProgressBar();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)this.myToolbarGroup, true);
        this.putContextUserData(DiffUserDataKeysEx.LEFT_TOOLBAR, this.myToolbar);
        if (this.myIsNewToolbar) {
            this.myToolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        }
        this.myToolbar.setTargetComponent((JComponent)this.myContentPanel);
        this.myToolbarWrapper = new Wrapper(this.myToolbar.getComponent());
        this.myRightToolbar = ActionManager.getInstance().createActionToolbar("DiffRightToolbar", (ActionGroup)this.myRightToolbarGroup, true);
        this.myRightToolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        this.myRightToolbar.setTargetComponent(this.myContentPanel.getTargetComponent());
        this.myRightToolbarWrapper = new Wrapper((JComponent)JBUI.Panels.simplePanel((Component)this.myRightToolbar.getComponent()));
        this.myPanel = JBUI.Panels.simplePanel((Component)((Object)this.myMainPanel));
        this.myDiffInfoWrapper = new Wrapper();
        this.myTopPanel = this.buildTopPanel();
        JBSplitter bottomContentSplitter = new JBSplitter(true, "DiffRequestProcessor.BottomComponentSplitter", 0.8f);
        bottomContentSplitter.setFirstComponent((JComponent)this.myContentPanel);
        this.myMainPanel.add(this.myTopPanel, "North");
        this.myMainPanel.add((Component)bottomContentSplitter, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusTraversalPolicy()));
        JComponent bottomPanel = (JComponent)this.myContext.getUserData(DiffUserDataKeysEx.BOTTOM_PANEL);
        if (bottomPanel != null) {
            bottomContentSplitter.setSecondComponent(bottomPanel);
        }
        if (bottomPanel instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)bottomPanel));
        }
        this.myState = EmptyState.INSTANCE;
        this.myContentPanel.setContent((JComponent)DiffUtil.createMessagePanel(((LoadingDiffRequest)this.myActiveRequest).getMessage()));
        this.navigator = new DiffNavigator();
    }

    @NotNull
    private BorderLayoutPanel buildTopPanel() {
        BorderLayoutPanel topPanel;
        if (this.myIsNewToolbar) {
            BorderLayoutPanel rightPanel = JBUI.Panels.simplePanel((Component)this.myRightToolbarWrapper).addToLeft((Component)this.myProgressBar);
            topPanel = JBUI.Panels.simplePanel((Component)this.myDiffInfoWrapper).addToLeft((Component)this.myToolbarWrapper).addToRight((Component)rightPanel);
            GuiUtils.installVisibilityReferent((JComponent)topPanel, (JComponent)this.myToolbar.getComponent());
            GuiUtils.installVisibilityReferent((JComponent)topPanel, (JComponent)this.myRightToolbar.getComponent());
            RemoteTransferUIManager.forceDirectTransfer((JComponent)topPanel);
        } else {
            BorderLayoutPanel statusPanel = JBUI.Panels.simplePanel((Component)this.myToolbarStatusPanel).addToLeft((Component)this.myProgressBar);
            topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarWrapper).addToRight((Component)statusPanel);
            GuiUtils.installVisibilityReferent((JComponent)topPanel, (JComponent)this.myToolbar.getComponent());
        }
        BorderLayoutPanel borderLayoutPanel = topPanel;
        if (borderLayoutPanel == null) {
            DiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return borderLayoutPanel;
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        if (toolbarComponents == null) {
            DiffRequestProcessor.$$$reportNull$$$0(3);
        }
        return toolbarComponents.needTopToolbarBorder;
    }

    public void addListener(@NotNull DiffRequestProcessorListener listener, @Nullable Disposable disposable) {
        if (listener == null) {
            DiffRequestProcessor.$$$reportNull$$$0(4);
        }
        if (disposable != null) {
            this.myEventDispatcher.addListener((EventListener)listener, disposable);
        } else {
            this.myEventDispatcher.addListener((EventListener)listener);
        }
    }

    @RequiresEdt
    protected void reloadRequest() {
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRequest(true);
    }

    @RequiresEdt
    public void updateRequest() {
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRequest(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRequest(boolean bl) {
        void force;
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRequest((boolean)force, this.myCurrentScrollToPolicy);
    }

    @RequiresEdt
    public abstract void updateRequest(boolean var1, @Nullable DiffUserDataKeysEx.ScrollToPolicy var2);

    @NotNull
    private static FrameDiffTool findFittedTool(@NotNull List<? extends DiffTool> tools, @NotNull DiffContext diffContext, @NotNull DiffRequest diffRequest, @Nullable FrameDiffTool forcedDiffTool) {
        if (tools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(5);
        }
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(6);
        }
        if (diffRequest == null) {
            DiffRequestProcessor.$$$reportNull$$$0(7);
        }
        if (forcedDiffTool != null) {
            Object object = forcedDiffTool.canShow(diffContext, diffRequest) ? forcedDiffTool : ErrorDiffTool.INSTANCE;
            if (object == null) {
                DiffRequestProcessor.$$$reportNull$$$0(8);
            }
            return object;
        }
        List<FrameDiffTool> fittedTools = DiffRequestProcessor.filterFittedTools(tools, diffContext, diffRequest);
        FrameDiffTool tool = (FrameDiffTool)ContainerUtil.getFirstItem(fittedTools, (Object)ErrorDiffTool.INSTANCE);
        FrameDiffTool substitutor = DiffRequestProcessor.findToolSubstitutor((DiffTool)tool, diffContext, diffRequest);
        if (substitutor != null) {
            FrameDiffTool frameDiffTool = substitutor;
            if (frameDiffTool == null) {
                DiffRequestProcessor.$$$reportNull$$$0(9);
            }
            return frameDiffTool;
        }
        FrameDiffTool frameDiffTool = tool;
        if (frameDiffTool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(10);
        }
        return frameDiffTool;
    }

    @NotNull
    private static List<FrameDiffTool> filterFittedTools(@NotNull List<? extends DiffTool> tools, @NotNull DiffContext diffContext, @NotNull DiffRequest diffRequest) {
        if (tools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(11);
        }
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(12);
        }
        if (diffRequest == null) {
            DiffRequestProcessor.$$$reportNull$$$0(13);
        }
        ArrayList<FrameDiffTool> result = new ArrayList<FrameDiffTool>();
        for (DiffTool diffTool : tools) {
            try {
                if (!(diffTool instanceof FrameDiffTool)) continue;
                if (diffTool.canShow(diffContext, diffRequest)) {
                    result.add((FrameDiffTool)diffTool);
                    continue;
                }
                if (DiffRequestProcessor.findToolSubstitutor(diffTool, diffContext, diffRequest) == null) continue;
                result.add((FrameDiffTool)diffTool);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        List<FrameDiffTool> list = DiffUtil.filterSuppressedTools(result);
        if (list == null) {
            DiffRequestProcessor.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    private static FrameDiffTool findToolSubstitutor(@NotNull DiffTool tool, @NotNull DiffContext diffContext, @NotNull DiffRequest diffRequest) {
        DiffTool substitutor;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(15);
        }
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(16);
        }
        if (diffRequest == null) {
            DiffRequestProcessor.$$$reportNull$$$0(17);
        }
        return (substitutor = DiffUtil.findToolSubstitutor(tool, diffContext, diffRequest)) instanceof FrameDiffTool ? (FrameDiffTool)substitutor : null;
    }

    @NotNull
    private static List<DiffTool> getAllKnownTools() {
        List list = DiffManagerEx.getInstance().getDiffTools();
        if (list == null) {
            DiffRequestProcessor.$$$reportNull$$$0(18);
        }
        return list;
    }

    @RequiresEdt
    private void readToolOrderFromSettings() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myToolOrder = this.getToolOrderFromSettings(DiffRequestProcessor.getAllKnownTools());
    }

    private void switchToDiffTool(@NotNull DiffTool diffTool) {
        if (diffTool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(19);
        }
        if (this.myForcedDiffTool != null) {
            return;
        }
        if (DiffRequestProcessor.isSameToolOrSubstitutor(diffTool, this.myState.getActiveTool(), this.myContext, this.myActiveRequest)) {
            return;
        }
        DiffUsageTriggerCollector.logToggleDiffTool(this.myProject, diffTool, (String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myToolOrder = DiffRequestProcessor.moveToolToTop(diffTool, this.myToolOrder, this.myContext, this.myActiveRequest);
        this.updateToolOrderSettings(this.myToolOrder);
        this.updateRequest(true);
    }

    @NotNull
    private static List<DiffTool> moveToolToTop(@NotNull DiffTool tool, @NotNull List<DiffTool> oldOrder, @NotNull DiffContext diffContext, @NotNull DiffRequest diffRequest) {
        List<FrameDiffTool> fittedTools;
        FrameDiffTool toolToReplace;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(20);
        }
        if (oldOrder == null) {
            DiffRequestProcessor.$$$reportNull$$$0(21);
        }
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(22);
        }
        if (diffRequest == null) {
            DiffRequestProcessor.$$$reportNull$$$0(23);
        }
        if ((toolToReplace = (FrameDiffTool)ContainerUtil.getFirstItem(fittedTools = DiffRequestProcessor.filterFittedTools(oldOrder, diffContext, diffRequest))) == tool) {
            List<DiffTool> list = oldOrder;
            if (list == null) {
                DiffRequestProcessor.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList<DiffTool> newOrder = new ArrayList<DiffTool>(oldOrder);
        newOrder.remove(tool);
        int index = ContainerUtil.indexOf(newOrder, it -> it == toolToReplace);
        if (index == -1) {
            index = newOrder.size();
        }
        newOrder.add(index, tool);
        ArrayList<DiffTool> arrayList = newOrder;
        if (arrayList == null) {
            DiffRequestProcessor.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private ViewerState createState(@NotNull FrameDiffTool frameTool) {
        if (frameTool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(26);
        }
        FrameDiffTool.DiffViewer viewer = frameTool.createComponent(this.myContext, this.myActiveRequest);
        for (DiffExtension extension : (DiffExtension[])DiffExtension.EP_NAME.getExtensions()) {
            try {
                extension.onViewerCreated(viewer, this.myContext, this.myActiveRequest);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        DiffViewerWrapper wrapper = (DiffViewerWrapper)this.myActiveRequest.getUserData(DiffViewerWrapper.KEY);
        if (wrapper == null) {
            return new DefaultState(viewer, frameTool);
        }
        return new WrapperState(viewer, frameTool, wrapper);
    }

    @RequiresEdt
    protected void applyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.applyRequest(request, force, scrollToChangePolicy, false);
    }

    @RequiresEdt
    protected void applyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy, boolean sync) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        this.navigator.reset();
        force = force || this.myQueuedApplyRequest != null && this.myQueuedApplyRequest.force;
        this.myQueuedApplyRequest = new ApplyData(request, force, scrollToChangePolicy);
        Runnable task = () -> {
            if (this.myQueuedApplyRequest == null || this.myDisposed) {
                return;
            }
            this.doApplyRequest(this.myQueuedApplyRequest.request, this.myQueuedApplyRequest.force, this.myQueuedApplyRequest.scrollToChangePolicy);
            this.myQueuedApplyRequest = null;
        };
        if (sync) {
            task.run();
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(task, ModalityState.current());
        }
    }

    @RequiresEdt
    private void doApplyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!force && request == this.myActiveRequest) {
            return;
        }
        request.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, (Object)scrollToChangePolicy);
        this.doApplyRequest(request);
    }

    @RequiresEdt
    @ApiStatus.Internal
    protected void doApplyRequest(@NotNull DiffRequest request) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertEventDispatchThread();
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myTopPanel.setBorder(null);
            this.myDiffInfoWrapper.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myRightToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                DiffRequestProcessor.onAssigned(this.myActiveRequest, false);
                this.myActiveRequest = request;
                DiffRequestProcessor.onAssigned(this.myActiveRequest, true);
                FrameDiffTool frameTool = null;
                try {
                    frameTool = DiffRequestProcessor.findFittedTool(this.myToolOrder, this.myContext, this.myActiveRequest, this.myForcedDiffTool);
                    this.myState = this.createState(frameTool);
                    try {
                        boolean isLoading;
                        this.myState.init();
                        boolean bl = isLoading = request instanceof LoadingDiffRequest || request instanceof NoDiffRequest;
                        if (!isLoading) {
                            DiffUsageTriggerCollector.logShowDiffTool(this.myProject, (DiffTool)frameTool, (String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
                        }
                    }
                    catch (Throwable e) {
                        this.myState.destroy();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    this.myState = new ErrorState((MessageDiffRequest)new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]), e), (DiffTool)frameTool);
                    this.myState.init();
                }
            });
        });
        ((DiffRequestProcessorListener)this.myEventDispatcher.getMulticaster()).onViewerChanged();
    }

    protected void setWindowTitle(@NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            DiffRequestProcessor.$$$reportNull$$$0(31);
        }
    }

    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(32);
        }
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(33);
        }
        this.myContext.putUserData(key, value);
    }

    @Nullable
    protected Runnable createAfterNavigateCallback() {
        return () -> DiffUtil.minimizeDiffIfOpenedInWindow(this.myPanel);
    }

    @NotNull
    protected List<AnAction> getNavigationActions() {
        List actions = List.of(ActionManager.getInstance().getAction("Diff.NavigationActions"));
        AnAction goToChangeAction = this.createGoToChangeAction();
        if (goToChangeAction != null) {
            actions = ContainerUtil.append(actions, (Object[])new AnAction[]{goToChangeAction});
        }
        List list = actions;
        if (list == null) {
            DiffRequestProcessor.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    protected AnAction createGoToChangeAction() {
        return null;
    }

    protected boolean isWindowFocused() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        return window != null && window.isFocused();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow((Component)this.myContentPanel) || DiffUtil.isFocusedComponentInWindow(this.myToolbar.getComponent()) || this.myIsNewToolbar && DiffUtil.isFocusedComponentInWindow(this.myRightToolbar.getComponent());
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    @NotNull
    protected List<DiffTool> getToolOrderFromSettings(@NotNull List<? extends DiffTool> availableTools) {
        if (availableTools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(35);
        }
        return DiffRequestProcessor.getToolOrderFromSettings(this.getSettings(), availableTools);
    }

    @NotNull
    public static List<DiffTool> getToolOrderFromSettings(@NotNull DiffSettingsHolder.DiffSettings diffSettings, @NotNull List<? extends DiffTool> availableTools) {
        if (diffSettings == null) {
            DiffRequestProcessor.$$$reportNull$$$0(36);
        }
        if (availableTools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(37);
        }
        ArrayList<DiffTool> result = new ArrayList<DiffTool>();
        List<String> savedOrder = diffSettings.getDiffToolsOrder();
        for (String string : savedOrder) {
            DiffTool tool = (DiffTool)ContainerUtil.find(availableTools, t -> t.getClass().getCanonicalName().equals(clazz));
            if (tool == null) continue;
            result.add(tool);
        }
        for (DiffTool diffTool : availableTools) {
            if (result.contains(diffTool)) continue;
            result.add(diffTool);
        }
        ArrayList<DiffTool> arrayList = result;
        if (arrayList == null) {
            DiffRequestProcessor.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    protected void updateToolOrderSettings(@NotNull List<? extends DiffTool> toolOrder) {
        if (toolOrder == null) {
            DiffRequestProcessor.$$$reportNull$$$0(39);
        }
        ArrayList<String> savedOrder = new ArrayList<String>();
        for (DiffTool diffTool : toolOrder) {
            savedOrder.add(diffTool.getClass().getCanonicalName());
        }
        this.getSettings().setDiffToolsOrder(savedOrder);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myDiffInfoWrapper.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myRightToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            DiffRequestProcessor.onAssigned(this.myActiveRequest, false);
            this.myState = EmptyState.INSTANCE;
            this.myActiveRequest = NoDiffRequest.INSTANCE;
        });
    }

    protected void collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myToolbarGroup.removeAll();
        boolean oldToolbar = !this.myIsNewToolbar;
        ArrayList<AnAction> navigationActions = new ArrayList<AnAction>(this.getNavigationActions());
        if (oldToolbar) {
            navigationActions.add((AnAction)new MyChangeDiffToolComboBoxAction());
        } else {
            this.myRightToolbarGroup.add((AnAction)new MyDiffToolChooser());
        }
        DiffUtil.addActionBlock(this.myToolbarGroup, navigationActions);
        if (oldToolbar) {
            DiffUtil.addActionBlock(this.myToolbarGroup, viewerActions, true);
        } else {
            DiffUtil.addActionBlock(this.myRightToolbarGroup, viewerActions, false);
        }
        List requestContextActions = (List)this.myActiveRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, contextActions);
        if (oldToolbar) {
            DiffUtil.addActionBlock(this.myToolbarGroup, new AnAction[]{new ShowInExternalToolActionGroup(), ActionManager.getInstance().getAction("ContextHelp")});
        }
        if (SystemInfo.isMac) {
            this.myTouchbarActionGroup.removeAll();
            this.myTouchbarActionGroup.add(ActionManager.getInstance().getAction("Diff.NavigationActions"));
            if (SHOW_VIEWER_ACTIONS_IN_TOUCHBAR && viewerActions != null) {
                this.myTouchbarActionGroup.addAll(viewerActions);
            }
        }
    }

    protected void collectPopupActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myPopupActionGroup.removeAll();
        DiffUtil.addActionBlock(this.myPopupActionGroup, new AnAction[]{new MyChangeDiffToolActionGroup()});
        DiffUtil.addActionBlock(this.myPopupActionGroup, viewerActions);
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        this.collectToolbarActions(viewerActions);
        ((ActionToolbarImpl)this.myToolbar).reset();
        this.myToolbar.setTargetComponent(this.myContentPanel.getTargetComponent());
        if (this.myIsNewToolbar) {
            this.myRightToolbar.setTargetComponent(this.myContentPanel.getTargetComponent());
            ((ActionToolbarImpl)this.myRightToolbar).reset();
        }
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            DiffRequestProcessor.$$$reportNull$$$0(40);
        }
        return actionToolbar;
    }

    @Override
    public void setToolbarVerticalSizeReferent(@NotNull JComponent component2) {
        if (component2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(41);
        }
        this.myToolbarWrapper.setVerticalSizeReferent(component2);
    }

    protected void buildActionPopup(@Nullable List<? extends AnAction> viewerActions) {
        this.collectPopupActions(viewerActions);
        DiffUtil.registerAction((AnAction)new ShowActionGroupPopupAction(), (JComponent)((Object)this.myMainPanel));
    }

    private void setTitle(@NlsContexts.DialogTitle @Nullable String title) {
        if (this.getContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE) == Boolean.TRUE) {
            return;
        }
        if (title == null) {
            title = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
        }
        this.setWindowTitle(title);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DiffRequestProcessor.$$$reportNull$$$0(42);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myState.getPreferredFocusedComponent();
        JComponent fallback = this.myToolbar.getComponent();
        if (component2 == null || !component2.isFocusable()) {
            JComponent jComponent = fallback;
            if (jComponent == null) {
                DiffRequestProcessor.$$$reportNull$$$0(43);
            }
            return jComponent;
        }
        if (!component2.isShowing() && fallback.isShowing()) {
            JComponent jComponent = fallback;
            if (jComponent == null) {
                DiffRequestProcessor.$$$reportNull$$$0(44);
            }
            return jComponent;
        }
        JComponent jComponent = component2;
        if (jComponent == null) {
            DiffRequestProcessor.$$$reportNull$$$0(45);
        }
        return jComponent;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public DiffRequest getActiveRequest() {
        return this.myActiveRequest;
    }

    @Override
    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(46);
        }
        return diffContext;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            DiffRequestProcessor.$$$reportNull$$$0(47);
        }
        if (!(state instanceof DiffRequestProcessorEditorState)) {
            return;
        }
        DiffRequestProcessorEditorState processorState = (DiffRequestProcessorEditorState)state;
        FrameDiffTool.DiffViewer viewer = this.getActiveViewer();
        if (!(viewer instanceof EditorDiffViewer)) {
            return;
        }
        List editors = ((EditorDiffViewer)viewer).getEditors();
        List<TextEditorState> editorStates = processorState.embeddedEditorStates;
        TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
        for (int i = 0; i < Math.min(editorStates.size(), editors.size()); ++i) {
            textEditorProvider.setStateImpl(this.myProject, (Editor)editors.get(i), editorStates.get(i), true);
        }
    }

    @Override
    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        FrameDiffTool.DiffViewer viewer;
        if (level == null) {
            DiffRequestProcessor.$$$reportNull$$$0(48);
        }
        if (!((viewer = this.getActiveViewer()) instanceof EditorDiffViewer)) {
            FileEditorState fileEditorState = FileEditorState.INSTANCE;
            if (fileEditorState == null) {
                DiffRequestProcessor.$$$reportNull$$$0(49);
            }
            return fileEditorState;
        }
        List editors = ((EditorDiffViewer)viewer).getEditors();
        TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
        return new DiffRequestProcessorEditorState(ContainerUtil.map((Collection)editors, editor -> textEditorProvider.getStateImpl(null, editor, level)));
    }

    @Nullable
    public FrameDiffTool.DiffViewer getActiveViewer() {
        if (this.myState instanceof DefaultState) {
            return ((DefaultState)this.myState).myViewer;
        }
        if (this.myState instanceof WrapperState) {
            return ((WrapperState)this.myState).myViewer;
        }
        return null;
    }

    @NotNull
    protected DiffSettingsHolder.DiffSettings getSettings() {
        DiffSettingsHolder.DiffSettings diffSettings = this.mySettings;
        if (diffSettings == null) {
            DiffRequestProcessor.$$$reportNull$$$0(50);
        }
        return diffSettings;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    @NotNull
    public CheckedDisposable getDisposable() {
        DiffRequestProcessor diffRequestProcessor = this;
        if (diffRequestProcessor == null) {
            DiffRequestProcessor.$$$reportNull$$$0(51);
        }
        return diffRequestProcessor;
    }

    @Override
    @NotNull
    public List<Editor> getEmbeddedEditors() {
        FrameDiffTool.DiffViewer viewer = this.getActiveViewer();
        if (viewer instanceof EditorDiffViewer) {
            EditorDiffViewer editorDiffViewer = (EditorDiffViewer)viewer;
            return new ArrayList<Editor>(editorDiffViewer.getHighlightEditors());
        }
        List<Editor> list = Collections.emptyList();
        if (list == null) {
            DiffRequestProcessor.$$$reportNull$$$0(52);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<VirtualFile> getFilesToRefresh() {
        DiffRequest request = this.getActiveRequest();
        if (request != null) {
            List list = request.getFilesToRefresh();
            if (list == null) {
                DiffRequestProcessor.$$$reportNull$$$0(53);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            DiffRequestProcessor.$$$reportNull$$$0(54);
        }
        return list;
    }

    @Override
    public void fireProcessorActivated() {
        this.updateRequest();
    }

    @Override
    public void addListener(final @NotNull DiffEditorViewerListener listener, @Nullable Disposable disposable) {
        if (listener == null) {
            DiffRequestProcessor.$$$reportNull$$$0(55);
        }
        this.addListener(new DiffRequestProcessorListener(){

            @Override
            public void onViewerChanged() {
                listener.onActiveFileChanged();
            }
        }, disposable);
    }

    private static boolean isSameToolOrSubstitutor(@NotNull DiffTool tool, @NotNull DiffTool activeTool, @NotNull DiffContext diffContext, @NotNull DiffRequest diffRequest) {
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(56);
        }
        if (activeTool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(57);
        }
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(58);
        }
        if (diffRequest == null) {
            DiffRequestProcessor.$$$reportNull$$$0(59);
        }
        if (tool == activeTool) {
            return true;
        }
        return DiffRequestProcessor.findToolSubstitutor(tool, diffContext, diffRequest) == activeTool;
    }

    @RequiresEdt
    protected boolean hasNextChange(boolean bl) {
        ThreadingAssertions.assertEventDispatchThread();
        return false;
    }

    @RequiresEdt
    protected boolean hasPrevChange(boolean bl) {
        ThreadingAssertions.assertEventDispatchThread();
        return false;
    }

    @RequiresEdt
    protected void goToNextChange(boolean bl) {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void goToPrevChange(boolean bl) {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected boolean isNavigationEnabled() {
        ThreadingAssertions.assertEventDispatchThread();
        return false;
    }

    protected void goToNextChangeImpl(boolean fromDifferences, @NotNull Runnable navigationTask) {
        if (navigationTask == null) {
            DiffRequestProcessor.$$$reportNull$$$0(60);
        }
        this.runWithScrollPolicy(fromDifferences, DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE, navigationTask);
    }

    protected void goToPrevChangeImpl(boolean fromDifferences, @NotNull Runnable navigationTask) {
        if (navigationTask == null) {
            DiffRequestProcessor.$$$reportNull$$$0(61);
        }
        this.runWithScrollPolicy(fromDifferences, DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE, navigationTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithScrollPolicy(boolean fromDifferences, @NotNull DiffUserDataKeysEx.ScrollToPolicy lastChange, @NotNull Runnable navigationTask) {
        if (lastChange == null) {
            DiffRequestProcessor.$$$reportNull$$$0(62);
        }
        if (navigationTask == null) {
            DiffRequestProcessor.$$$reportNull$$$0(63);
        }
        if (fromDifferences) {
            assert (this.myCurrentScrollToPolicy == null);
            this.myCurrentScrollToPolicy = lastChange;
            try {
                navigationTask.run();
                this.updateRequest();
            }
            finally {
                this.myCurrentScrollToPolicy = null;
            }
        } else {
            navigationTask.run();
            this.updateRequest();
        }
    }

    private static void onAssigned(@NotNull DiffRequest request, boolean isAssigned) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(64);
        }
        try {
            request.onAssigned(isAssigned);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 10, 14, 18, 24, 25, 34, 38, 40, 42, 43, 44, 45, 46, 49, 50, 51, 52, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 24: 
            case 25: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponents";
                break;
            }
            case 4: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 22: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffContext";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 23: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffRequest";
                break;
            }
            case 15: 
            case 20: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffTool";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldOrder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameTool";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTools";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffSettings";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolOrder";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeTool";
                break;
            }
            case 60: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationTask";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTopPanel";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findFittedTool";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFittedTools";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownTools";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "moveToolToTop";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOrderFromSettings";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedEditors";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToRefresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 24: 
            case 25: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToolbarBottomBorder";
                break;
            }
            case 4: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFittedTool";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterFittedTools";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "switchToDiffTool";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveToolToTop";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyRequest";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doApplyRequest";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getToolOrderFromSettings";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateToolOrderSettings";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarVerticalSizeReferent";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isSameToolOrSubstitutor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "goToNextChangeImpl";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "goToPrevChangeImpl";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "runWithScrollPolicy";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "onAssigned";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 14, 18, 24, 25, 34, 38, 40, 42, 43, 44, 45, 46, 49, 50, 51, 52, 53, 54 -> new IllegalStateException(string);
        };
    }

    private class MyDiffContext
    extends DiffContextEx {
        @NotNull
        private final UserDataHolder myInitialContext;
        @NotNull
        private final UserDataHolder myOwnContext;

        MyDiffContext(UserDataHolder initialContext) {
            if (initialContext == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            this.myOwnContext = new UserDataHolderBase();
            this.myInitialContext = initialContext;
        }

        @Override
        public void reopenDiffRequest() {
            DiffRequestProcessor.this.updateRequest(true);
        }

        @Override
        public void reloadDiffRequest() {
            DiffRequestProcessor.this.reloadRequest();
        }

        @Override
        public void showProgressBar(boolean enabled) {
            if (enabled) {
                DiffRequestProcessor.this.myProgressBar.startProgress();
            } else {
                DiffRequestProcessor.this.myProgressBar.stopProgress();
            }
        }

        @Override
        public void setWindowTitle(@NotNull String title) {
            if (title == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            DiffRequestProcessor.this.setTitle(title);
        }

        @Nullable
        public Project getProject() {
            return DiffRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return DiffRequestProcessor.this.isFocusedInWindow();
        }

        public boolean isWindowFocused() {
            return DiffRequestProcessor.this.isWindowFocused();
        }

        public void requestFocusInWindow() {
            DiffRequestProcessor.this.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            Object data;
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(2);
            }
            if ((data = this.myOwnContext.getUserData(key)) != null) {
                return (T)data;
            }
            return (T)this.myInitialContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(3);
            }
            this.myOwnContext.putUserData(key, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setWindowTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public class MyPanel
    extends JBPanelWithEmptyText
    implements UiDataProvider {
        MyPanel() {
            super((LayoutManager)new BorderLayout());
        }

        @NotNull
        public DiffRequestProcessor getProcessor() {
            DiffRequestProcessor diffRequestProcessor = DiffRequestProcessor.this;
            if (diffRequestProcessor == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            return diffRequestProcessor;
        }

        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffPanelSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            sink.set(DiffDataKeys.NAVIGATION_CALLBACK, (Object)DiffRequestProcessor.this.createAfterNavigateCallback());
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)((DataProvider)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER)));
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)((DataProvider)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER)));
            DataSink.uiDataSnapshot((DataSink)sink, (Object)DiffRequestProcessor.this.myState);
            sink.set(CommonDataKeys.PROJECT, (Object)DiffRequestProcessor.this.myProject);
            sink.set(DiffDataKeys.DIFF_CONTEXT, (Object)DiffRequestProcessor.this.myContext);
            sink.set(DiffDataKeys.DIFF_REQUEST, (Object)DiffRequestProcessor.this.myActiveRequest);
            sink.set(ACTIVE_DIFF_TOOL, (Object)DiffRequestProcessor.this.myState.getActiveTool());
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)(DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) != null ? (String)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) : "reference.dialogs.diff.file"));
            if (DiffRequestProcessor.this.isNavigationEnabled()) {
                sink.set(DiffDataKeys.PREV_NEXT_FILE_ITERABLE, (Object)DiffRequestProcessor.this.navigator);
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference()) {
                sink.set(DiffDataKeys.CROSS_FILE_PREV_NEXT_DIFFERENCE_ITERABLE, (Object)DiffRequestProcessor.this.navigator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$MyPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyProgressBar
    extends JProgressBar {
        private int myProgressCount = 0;

        MyProgressBar() {
            this.setIndeterminate(true);
            this.setVisible(false);
        }

        public void startProgress() {
            ++this.myProgressCount;
            this.setVisible(true);
        }

        public void stopProgress() {
            --this.myProgressCount;
            LOG.assertTrue(this.myProgressCount >= 0);
            if (this.myProgressCount == 0) {
                this.setVisible(false);
            }
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = DiffRequestProcessor.this.getPreferredFocusedComponent();
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)component2, (FocusTraversalPolicy)((Object)this));
        }

        @Nullable
        protected Project getProject() {
            return DiffRequestProcessor.this.myProject;
        }
    }

    private static final class EmptyState
    implements ViewerState {
        private static final EmptyState INSTANCE = new EmptyState();

        private EmptyState() {
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                EmptyState.$$$reportNull$$$0(0);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$EmptyState", "getActiveTool"));
        }
    }

    private static interface ViewerState
    extends UiDataProvider {
        @RequiresEdt
        default public void init() {
            ThreadingAssertions.assertEventDispatchThread();
        }

        @RequiresEdt
        default public void destroy() {
            ThreadingAssertions.assertEventDispatchThread();
        }

        @Nullable
        default public JComponent getPreferredFocusedComponent() {
            return null;
        }

        default public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ViewerState.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public DiffTool getActiveTool();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/diff/impl/DiffRequestProcessor$ViewerState", "uiDataSnapshot"));
        }
    }

    private class DiffNavigator
    implements PrevNextFileIterable,
    CrossFilePrevNextDifferenceIterableSupport {
        @NotNull
        private volatile DiffIterationState myIterationState = DiffIterationState.NONE;

        private DiffNavigator() {
        }

        @Override
        public boolean canGoPrev(boolean fastCheckOnly) {
            return DiffRequestProcessor.this.hasPrevChange(fastCheckOnly);
        }

        @Override
        public boolean canGoNext(boolean fastCheckOnly) {
            return DiffRequestProcessor.this.hasNextChange(fastCheckOnly);
        }

        @Override
        public void goPrev(boolean showLastChange) {
            DiffRequestProcessor.this.goToPrevChange(showLastChange);
            this.myIterationState = DiffIterationState.NONE;
        }

        @Override
        public void goNext(boolean showFirstChange) {
            DiffRequestProcessor.this.goToNextChange(showFirstChange);
            this.myIterationState = DiffIterationState.NONE;
        }

        @Override
        public boolean canGoNextNow() {
            return this.myIterationState == DiffIterationState.NEXT;
        }

        @Override
        public boolean canGoPrevNow() {
            return this.myIterationState == DiffIterationState.PREV;
        }

        @Override
        public void prepareGoNext(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DiffNavigator.$$$reportNull$$$0(0);
            }
            DiffNavigator.notifyMessage(dataContext, (JComponent)DiffRequestProcessor.this.myContentPanel, true);
            this.myIterationState = DiffIterationState.NEXT;
        }

        @Override
        public void prepareGoPrev(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                DiffNavigator.$$$reportNull$$$0(1);
            }
            DiffNavigator.notifyMessage(dataContext, (JComponent)DiffRequestProcessor.this.myContentPanel, false);
            this.myIterationState = DiffIterationState.PREV;
        }

        @Override
        public void reset() {
            this.myIterationState = DiffIterationState.NONE;
        }

        private static void notifyMessage(@NotNull DataContext dataContext, @NotNull JComponent contentPanel2, boolean next) {
            if (dataContext == null) {
                DiffNavigator.$$$reportNull$$$0(2);
            }
            if (contentPanel2 == null) {
                DiffNavigator.$$$reportNull$$$0(3);
            }
            if (!UIUtil.isShowing((Component)contentPanel2)) {
                return;
            }
            Editor editor = (Editor)dataContext.getData(DiffDataKeys.CURRENT_EDITOR);
            String message = DiffUtil.createNotificationText(next ? DiffBundle.message((String)"press.again.to.go.to.the.next.file", (Object[])new Object[0]) : DiffBundle.message((String)"press.again.to.go.to.the.previous.file", (Object[])new Object[0]), DiffBundle.message((String)"notification.you.can.disable.this.feature.in.0", (Object[])new Object[]{DiffUtil.getSettingsConfigurablePath()}));
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)message));
            Point point = new Point(contentPanel2.getWidth() / 2, next ? contentPanel2.getHeight() - JBUIScale.scale((int)40) : JBUIScale.scale((int)40));
            if (editor == null || editor.isDisposed()) {
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                HintHint hintHint = DiffNavigator.createNotifyHint(contentPanel2, point, next);
                hint.show(contentPanel2, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
            } else {
                int x = SwingUtilities.convertPoint((Component)contentPanel2, (Point)point, (Component)editor.getComponent()).x;
                JComponent header = editor.getHeaderComponent();
                int shift = editor.getScrollingModel().getVerticalScrollOffset() - (header != null ? header.getHeight() : 0);
                LineRange changeRange = (LineRange)dataContext.getData(DiffDataKeys.CURRENT_CHANGE_RANGE);
                LogicalPosition position = changeRange == null ? new LogicalPosition(editor.getCaretModel().getLogicalPosition().line + (next ? 1 : 0), 0) : new LogicalPosition(next ? changeRange.end : changeRange.start, 0);
                int y = editor.logicalPositionToXY((LogicalPosition)position).y - shift;
                Point editorPoint = new Point(x, y);
                HintHint hintHint = DiffNavigator.createNotifyHint(editor.getComponent(), editorPoint, !next);
                HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, editorPoint, 42, 0, false, hintHint);
            }
        }

        @NotNull
        private static HintHint createNotifyHint(@NotNull JComponent component2, @NotNull Point point, boolean above) {
            if (component2 == null) {
                DiffNavigator.$$$reportNull$$$0(4);
            }
            if (point == null) {
                DiffNavigator.$$$reportNull$$$0(5);
            }
            HintHint hintHint = new HintHint((Component)component2, point).setPreferredPosition(above ? Balloon.Position.above : Balloon.Position.below).setAwtTooltip(true).setFont(StartupUiUtil.getLabelFont().deriveFont(1)).setBorderColor(HintUtil.getHintBorderColor()).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
            if (hintHint == null) {
                DiffNavigator.$$$reportNull$$$0(6);
            }
            return hintHint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DiffNavigator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DiffNavigator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotifyHint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGoNext";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGoPrev";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyMessage";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotifyHint";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        private static enum DiffIterationState {
            NEXT,
            PREV,
            NONE;

        }
    }

    private class DefaultState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;

        DefaultState(@NotNull FrameDiffTool.DiffViewer viewer, FrameDiffTool tool) {
            if (viewer == null) {
                DefaultState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                DefaultState.$$$reportNull$$$0(1);
            }
            this.myViewer = viewer;
            this.myTool = tool;
        }

        @Override
        @RequiresEdt
        public void init() {
            ThreadingAssertions.assertEventDispatchThread();
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents = this.myViewer.init();
            FrameDiffTool.DiffInfo diffInfo = toolbarComponents.diffInfo;
            if (diffInfo != null) {
                DiffRequestProcessor.this.myDiffInfoWrapper.setContent(diffInfo.getComponent());
            } else {
                DiffRequestProcessor.this.myDiffInfoWrapper.setContent(null);
            }
            DiffRequestProcessor.this.buildToolbar(toolbarComponents.toolbarActions);
            DiffRequestProcessor.this.buildActionPopup(toolbarComponents.popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents)) {
                DiffRequestProcessor.this.myTopPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ThreadingAssertions.assertEventDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                DefaultState.$$$reportNull$$$0(2);
            }
            return frameDiffTool;
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                DefaultState.$$$reportNull$$$0(3);
            }
            sink.set(DiffDataKeys.DIFF_VIEWER, (Object)this.myViewer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class WrapperState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;
        @NotNull
        private final FrameDiffTool.DiffViewer myWrapperViewer;

        WrapperState(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull FrameDiffTool tool, DiffViewerWrapper wrapper) {
            if (viewer == null) {
                WrapperState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                WrapperState.$$$reportNull$$$0(1);
            }
            if (wrapper == null) {
                WrapperState.$$$reportNull$$$0(2);
            }
            this.myViewer = viewer;
            this.myTool = tool;
            this.myWrapperViewer = wrapper.createComponent(DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest, this.myViewer);
        }

        @Override
        @RequiresEdt
        public void init() {
            ThreadingAssertions.assertEventDispatchThread();
            DiffRequestProcessor.this.myContentPanel.setContent(this.myWrapperViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents1 = this.myViewer.init();
            FrameDiffTool.ToolbarComponents toolbarComponents2 = this.myWrapperViewer.init();
            DiffRequestProcessor.this.buildToolbar(WrapperState.mergeActions(toolbarComponents1.toolbarActions, toolbarComponents2.toolbarActions));
            DiffRequestProcessor.this.buildActionPopup(WrapperState.mergeActions(toolbarComponents1.popupActions, toolbarComponents2.popupActions));
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents1.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents1)) {
                DiffRequestProcessor.this.myTopPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Nullable
        private static List<AnAction> mergeActions(@Nullable List<AnAction> actions1, @Nullable List<AnAction> actions2) {
            if (actions1 == null && actions2 == null) {
                return null;
            }
            if (ContainerUtil.isEmpty(actions1)) {
                return actions2;
            }
            if (ContainerUtil.isEmpty(actions2)) {
                return actions1;
            }
            ArrayList<AnAction> result = new ArrayList<AnAction>(actions1);
            result.add((AnAction)Separator.getInstance());
            for (AnAction action2 : actions2) {
                if (!(action2 instanceof Separator) && actions1.contains(action2)) continue;
                result.add(action2);
            }
            return result;
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ThreadingAssertions.assertEventDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
                Disposer.dispose((Disposable)this.myWrapperViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myWrapperViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                WrapperState.$$$reportNull$$$0(3);
            }
            return frameDiffTool;
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                WrapperState.$$$reportNull$$$0(4);
            }
            sink.set(DiffDataKeys.WRAPPING_DIFF_VIEWER, (Object)this.myWrapperViewer);
            sink.set(DiffDataKeys.DIFF_VIEWER, (Object)this.myViewer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ApplyData {
        @NotNull
        private final DiffRequest request;
        private final boolean force;
        @Nullable
        private final DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy;

        ApplyData(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (request == null) {
                ApplyData.$$$reportNull$$$0(0);
            }
            this.request = request;
            this.force = force;
            this.scrollToChangePolicy = scrollToChangePolicy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ApplyData", "<init>"));
        }
    }

    private class MyChangeDiffToolComboBoxAction
    extends ComboBoxAction
    implements DumbAware {
        private MyChangeDiffToolComboBoxAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyChangeDiffToolComboBoxAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyChangeDiffToolComboBoxAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            if (DiffRequestProcessor.this.myForcedDiffTool != null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            DiffTool activeTool = (DiffTool)e.getData(ACTIVE_DIFF_TOOL);
            DiffContext diffContext = (DiffContext)e.getData(DiffDataKeys.DIFF_CONTEXT);
            DiffRequest diffRequest = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
            if (activeTool == null || diffContext == null || diffRequest == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setText(activeTool.getName());
            for (DiffTool diffTool : DiffRequestProcessor.filterFittedTools(DiffRequestProcessor.getAllKnownTools(), diffContext, diffRequest)) {
                if (DiffRequestProcessor.isSameToolOrSubstitutor(diffTool, activeTool, diffContext, diffRequest)) continue;
                presentation.setEnabledAndVisible(true);
                return;
            }
            presentation.setEnabledAndVisible(false);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
            if (button == null) {
                MyChangeDiffToolComboBoxAction.$$$reportNull$$$0(2);
            }
            if (context == null) {
                MyChangeDiffToolComboBoxAction.$$$reportNull$$$0(3);
            }
            DiffContext diffContext = (DiffContext)context.getData(DiffDataKeys.DIFF_CONTEXT);
            DiffRequest diffRequest = (DiffRequest)context.getData(DiffDataKeys.DIFF_REQUEST);
            if (diffContext == null || diffRequest == null) {
                return new DefaultActionGroup();
            }
            DefaultActionGroup group = new DefaultActionGroup();
            for (DiffTool diffTool : DiffRequestProcessor.filterFittedTools(DiffRequestProcessor.getAllKnownTools(), diffContext, diffRequest)) {
                group.add((AnAction)new DiffToolToggleAction(diffTool));
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                MyChangeDiffToolComboBoxAction.$$$reportNull$$$0(4);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolComboBoxAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "button";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolComboBoxAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopupActionGroup";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyDiffToolChooser
    extends DiffToolChooser {
        private MyDiffToolChooser() {
            super((Project)ObjectUtils.chooseNotNull((Object)DiffRequestProcessor.this.myProject, (Object)DiffRequestProcessor.this.myContext.getProject()));
        }

        @Override
        public void onSelected(@NotNull Project project, @NotNull DiffTool diffTool) {
            if (project == null) {
                MyDiffToolChooser.$$$reportNull$$$0(0);
            }
            if (diffTool == null) {
                MyDiffToolChooser.$$$reportNull$$$0(1);
            }
            DiffRequestProcessor.this.switchToDiffTool(diffTool);
        }

        @Override
        @NotNull
        public List<DiffTool> getTools() {
            return new ArrayList<FrameDiffTool>(DiffRequestProcessor.filterFittedTools(DiffRequestProcessor.getAllKnownTools(), DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest));
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            DiffTool diffTool = DiffRequestProcessor.this.myState.getActiveTool();
            if (diffTool == null) {
                MyDiffToolChooser.$$$reportNull$$$0(2);
            }
            return diffTool;
        }

        @Override
        @Nullable
        public DiffTool getForcedDiffTool() {
            return DiffRequestProcessor.this.myForcedDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffTool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$MyDiffToolChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyDiffToolChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "onSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class ShowInExternalToolActionGroup
    extends ActionGroup
    implements DumbAware {
        private ShowInExternalToolActionGroup() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowInExternalTool");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowInExternalToolActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInExternalToolActionGroup.$$$reportNull$$$0(1);
            }
            this.getShowActions().get(0).actionPerformed(e);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInExternalToolActionGroup.$$$reportNull$$$0(2);
            }
            Presentation presentation = e.getPresentation();
            if (!ExternalDiffTool.isEnabled()) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            List<ShowInExternalToolAction> actions = this.getShowActions();
            presentation.setEnabled(ExternalDiffTool.canShow(DiffRequestProcessor.this.myActiveRequest));
            presentation.setPerformGroup(actions.size() == 1);
            presentation.putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)presentation.isPerformGroup());
            presentation.setPopupGroup(true);
            presentation.setVisible(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List<ShowInExternalToolAction> actions = this.getShowActions();
            if (actions.size() <= 1) {
                if (AnAction.EMPTY_ARRAY == null) {
                    ShowInExternalToolActionGroup.$$$reportNull$$$0(3);
                }
                return AnAction.EMPTY_ARRAY;
            }
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ShowInExternalToolActionGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private @Unmodifiable @NotNull List<ShowInExternalToolAction> getShowActions() {
            Map<ExternalDiffSettings.ExternalToolGroup, List<ExternalDiffSettings.ExternalTool>> externalTools = ExternalDiffSettings.getInstance().getExternalTools();
            List diffTools = externalTools.getOrDefault((Object)ExternalDiffSettings.ExternalToolGroup.DIFF_TOOL, Collections.emptyList());
            List list = ContainerUtil.map(diffTools, x$0 -> new ShowInExternalToolAction((ExternalDiffSettings.ExternalTool)x$0));
            if (list == null) {
                ShowInExternalToolActionGroup.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$ShowInExternalToolActionGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ShowInExternalToolActionGroup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShowActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyChangeDiffToolActionGroup
    extends ActionGroup
    implements DumbAware {
        private MyChangeDiffToolActionGroup() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyChangeDiffToolActionGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    MyChangeDiffToolActionGroup.$$$reportNull$$$0(1);
                }
                return AnAction.EMPTY_ARRAY;
            }
            if (DiffRequestProcessor.this.myForcedDiffTool != null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    MyChangeDiffToolActionGroup.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }
            DiffTool activeTool = (DiffTool)e.getData(ACTIVE_DIFF_TOOL);
            DiffContext diffContext = (DiffContext)e.getData(DiffDataKeys.DIFF_CONTEXT);
            DiffRequest diffRequest = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
            if (activeTool == null || diffContext == null || diffRequest == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    MyChangeDiffToolActionGroup.$$$reportNull$$$0(3);
                }
                return AnAction.EMPTY_ARRAY;
            }
            ArrayList<DiffToolToggleAction> actions = new ArrayList<DiffToolToggleAction>();
            for (DiffTool diffTool : DiffRequestProcessor.filterFittedTools(DiffRequestProcessor.getAllKnownTools(), diffContext, diffRequest)) {
                if (DiffRequestProcessor.isSameToolOrSubstitutor(diffTool, activeTool, diffContext, diffRequest)) continue;
                actions.add(new DiffToolToggleAction(diffTool));
            }
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                MyChangeDiffToolActionGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolActionGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class ShowActionGroupPopupAction
    extends DumbAwareAction {
        ShowActionGroupPopupAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowSettingsPopup");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowActionGroupPopupAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowActionGroupPopupAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(DiffRequestProcessor.this.myPopupActionGroup.getChildrenCount() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowActionGroupPopupAction.$$$reportNull$$$0(2);
            }
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(DiffBundle.message((String)"diff.actions", (Object[])new Object[0]), (ActionGroup)DiffRequestProcessor.this.myPopupActionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup.showInCenterOf((Component)DiffRequestProcessor.this.myPanel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$ShowActionGroupPopupAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ShowActionGroupPopupAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ErrorState
    implements ViewerState {
        @Nullable
        private final DiffTool myDiffTool;
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;

        ErrorState(@Nullable MessageDiffRequest request, DiffTool diffTool) {
            if (request == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            this.myDiffTool = diffTool;
            this.myViewer = ErrorDiffTool.INSTANCE.createComponent(DiffRequestProcessor.this.myContext, (DiffRequest)request);
        }

        @Override
        @RequiresEdt
        public void init() {
            ThreadingAssertions.assertEventDispatchThread();
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(init2.toolbarActions);
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ThreadingAssertions.assertEventDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = this.myDiffTool != null ? this.myDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                ErrorState.$$$reportNull$$$0(1);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @Deprecated
    protected static abstract class DelegatingNavigationAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final AnAction delegate;

        DelegatingNavigationAction(@NotNull String actionId) {
            if (actionId == null) {
                DelegatingNavigationAction.$$$reportNull$$$0(0);
            }
            this.delegate = ActionManager.getInstance().getAction(actionId);
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = this.delegate.getActionUpdateThread();
            if (actionUpdateThread == null) {
                DelegatingNavigationAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DelegatingNavigationAction.$$$reportNull$$$0(2);
            }
            this.delegate.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DelegatingNavigationAction.$$$reportNull$$$0(3);
            }
            this.delegate.actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DelegatingNavigationAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DelegatingNavigationAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @Deprecated
    protected class MyPrevChangeAction
    extends DelegatingNavigationAction {
        public MyPrevChangeAction(DiffRequestProcessor this$0) {
            super("Diff.PrevChange");
        }
    }

    @Deprecated
    protected class MyNextChangeAction
    extends DelegatingNavigationAction {
        public MyNextChangeAction(DiffRequestProcessor this$0) {
            super("Diff.NextChange");
        }
    }

    @Deprecated
    protected class MyPrevDifferenceAction
    extends DelegatingNavigationAction {
        public MyPrevDifferenceAction(DiffRequestProcessor this$0) {
            super("PreviousDiff");
        }
    }

    @Deprecated
    protected class MyNextDifferenceAction
    extends DelegatingNavigationAction {
        public MyNextDifferenceAction(DiffRequestProcessor this$0) {
            super("NextDiff");
        }
    }

    private final class DiffToolToggleAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final DiffTool myDiffTool;

        private DiffToolToggleAction(DiffTool tool) {
            if (tool == null) {
                DiffToolToggleAction.$$$reportNull$$$0(0);
            }
            super(tool.getName());
            this.myDiffTool = tool;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DiffToolToggleAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffToolToggleAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabledAndVisible(DiffRequestProcessor.this.myForcedDiffTool == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffToolToggleAction.$$$reportNull$$$0(3);
            }
            DiffRequestProcessor.this.switchToDiffTool(this.myDiffTool);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class ShowInExternalToolAction
    extends DumbAwareAction {
        @NotNull
        private final ExternalDiffSettings.ExternalTool myExternalTool;

        private ShowInExternalToolAction(ExternalDiffSettings.ExternalTool externalTool) {
            if (externalTool == null) {
                ShowInExternalToolAction.$$$reportNull$$$0(0);
            }
            super(DiffBundle.message((String)"action.use.external.tool.text", (Object[])new Object[]{externalTool.getName()}));
            this.myExternalTool = externalTool;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInExternalToolAction.$$$reportNull$$$0(1);
            }
            try {
                ExternalDiffTool.showRequest(e.getProject(), DiffRequestProcessor.this.myActiveRequest, this.myExternalTool);
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalTool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ShowInExternalToolAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

