/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class DiffWindowBase {
    @NotNull
    @NonNls
    public static final String DEFAULT_DIALOG_GROUP_KEY = "DiffContextDialog";
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffDialogHints myHints;
    private DiffRequestProcessor myProcessor;
    private WindowWrapper myWrapper;

    public DiffWindowBase(@Nullable Project project, @NotNull DiffDialogHints hints) {
        if (hints == null) {
            DiffWindowBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myHints = hints;
    }

    protected void init() {
        if (this.myWrapper != null) {
            return;
        }
        this.myProcessor = this.createProcessor();
        String dialogGroupKey = (String)ObjectUtils.notNull((Object)((String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY)), (Object)DEFAULT_DIALOG_GROUP_KEY);
        this.myWrapper = new WindowWrapperBuilder(DiffUtil.getWindowMode(this.myHints), (JComponent)new MyPanel(this.myProcessor.getComponent())).setProject(this.myProject).setParent(this.myHints.getParent()).setDimensionServiceKey(dialogGroupKey).setInitialSize(JBUI.DialogSizes.extraLarge()).setMaximizable(true).setPreferredFocusedComponent(() -> this.myProcessor.getPreferredFocusedComponent()).setOnShowCallback(() -> this.myProcessor.updateRequest()).build();
        this.myWrapper.setImages((List)DiffUtil.DIFF_FRAME_ICONS.getValue());
        Disposer.register((Disposable)this.myWrapper, (Disposable)this.myProcessor);
        Consumer wrapperHandler = this.myHints.getWindowConsumer();
        if (wrapperHandler != null) {
            wrapperHandler.consume((Object)this.myWrapper);
        }
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProcessor);
        appConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                DiffRequest request;
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((request = DiffWindowBase.this.myProcessor.getActiveRequest()) != null) {
                    VirtualFile[] files = VfsUtilCore.toVirtualFileArray((Collection)request.getFilesToRefresh());
                    DiffUtil.refreshOnFrameActivation(files);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/diff/impl/DiffWindowBase$1", "applicationActivated"));
            }
        });
    }

    public void show() {
        this.init();
        this.myWrapper.show();
    }

    @NotNull
    protected abstract DiffRequestProcessor createProcessor();

    protected WindowWrapper getWrapper() {
        return this.myWrapper;
    }

    protected DiffRequestProcessor getProcessor() {
        return this.myProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/impl/DiffWindowBase", "<init>"));
    }

    private static class MyPanel
    extends JPanel {
        MyPanel(@NotNull JComponent content) {
            if (content == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)content, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/impl/DiffWindowBase$MyPanel", "<init>"));
        }
    }
}

