/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.dir;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirDiffViewer
implements FrameDiffTool.DiffViewer {
    private final DirDiffPanel myDirDiffPanel;
    private final JComponent myComponent;
    private final String myHelpID;

    DirDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            DirDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            DirDiffViewer.$$$reportNull$$$0(1);
        }
        this(context, DirDiffViewer.createDiffElement((DiffContent)request.getContents().get(0)), DirDiffViewer.createDiffElement((DiffContent)request.getContents().get(1)), (DirDiffSettings)ObjectUtils.notNull((Object)((DirDiffSettings)context.getUserData(DirDiffSettings.KEY)), (Object)new DirDiffSettings()), "reference.dialogs.diff.folder");
    }

    DirDiffViewer(final @NotNull DiffContext context, @NotNull DiffElement element1, @NotNull DiffElement element2, @NotNull DirDiffSettings settings, @Nullable @NonNls String helpID) {
        if (context == null) {
            DirDiffViewer.$$$reportNull$$$0(2);
        }
        if (element1 == null) {
            DirDiffViewer.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            DirDiffViewer.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            DirDiffViewer.$$$reportNull$$$0(5);
        }
        this.myHelpID = helpID;
        DirDiffTableModel model = new DirDiffTableModel(context.getProject(), element1, element2, settings);
        this.myDirDiffPanel = new DirDiffPanel(model, new DirDiffWindow(){

            @Override
            @NotNull
            public Disposable getDisposable() {
                DirDiffViewer dirDiffViewer = DirDiffViewer.this;
                if (dirDiffViewer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dirDiffViewer;
            }

            @Override
            public void setTitle(@NotNull String title) {
                if (title == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context instanceof DiffContextEx) {
                    ((DiffContextEx)context).setWindowTitle(title);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/tools/dir/DirDiffViewer$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisposable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/tools/dir/DirDiffViewer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setTitle";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
        this.myComponent = UiDataProvider.wrapComponent((JComponent)this.myDirDiffPanel.getPanel(), sink -> {
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)this.myHelpID);
            DataSink.uiDataSnapshot((DataSink)sink, (Object)this.myDirDiffPanel);
        });
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = Arrays.asList(this.myDirDiffPanel.getActions());
        components.statusPanel = this.myDirDiffPanel.extractFilterPanel();
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            DirDiffViewer.$$$reportNull$$$0(6);
        }
        return toolbarComponents;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDirDiffPanel);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DirDiffViewer.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDirDiffPanel.getTable();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            DirDiffViewer.$$$reportNull$$$0(8);
        }
        if (request == null) {
            DirDiffViewer.$$$reportNull$$$0(9);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(0))) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(1))) {
            return false;
        }
        return !(contents.get(0) instanceof EmptyContent) || !(contents.get(1) instanceof EmptyContent);
    }

    private static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            DirDiffViewer.$$$reportNull$$$0(10);
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return true;
        }
        return content instanceof FileContent && content.getContentType() instanceof ArchiveFileType && ((FileContent)content).getFile().isValid() && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    @NotNull
    private static DiffElement createDiffElement(@NotNull DiffContent content) {
        if (content == null) {
            DirDiffViewer.$$$reportNull$$$0(11);
        }
        if (content instanceof EmptyContent) {
            return new DiffElement(){

                public String getPath() {
                    return "";
                }

                @NotNull
                public String getName() {
                    return "Nothing";
                }

                public long getSize() {
                    return -1L;
                }

                public long getTimeStamp() {
                    return -1L;
                }

                public boolean isContainer() {
                    return true;
                }

                public DiffElement[] getChildren() {
                    return EMPTY_ARRAY;
                }

                public byte[] getContent() {
                    return null;
                }

                public Object getValue() {
                    return null;
                }
            };
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file = ((DirectoryContent)content).getFile();
            VirtualFileDiffElement virtualFileDiffElement = VirtualFileDiffElement.createElement(file, file);
            if (virtualFileDiffElement == null) {
                DirDiffViewer.$$$reportNull$$$0(12);
            }
            return virtualFileDiffElement;
        }
        if (content instanceof FileContent && content.getContentType() instanceof ArchiveFileType) {
            VirtualFile file = ((FileContent)content).getFile();
            VirtualFileDiffElement virtualFileDiffElement = VirtualFileDiffElement.createElement(file, file);
            if (virtualFileDiffElement == null) {
                DirDiffViewer.$$$reportNull$$$0(13);
            }
            return virtualFileDiffElement;
        }
        throw new IllegalArgumentException(String.valueOf(content.getClass()) + " " + String.valueOf(content.getContentType()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/dir/DirDiffViewer";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/dir/DirDiffViewer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canShowContent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDiffElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 12, 13 -> new IllegalStateException(string);
        };
    }
}

