/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions.popup;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffElement;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FilterComponent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/diff/impl/dir/actions/popup/ExcludeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "excludeFileFromScope", "", "diffElement", "Lcom/intellij/ide/diff/DiffElement;", "", "sourceContentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "filterQuery", "relativePath", "isDir", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nExcludeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcludeAction.kt\ncom/intellij/openapi/diff/impl/dir/actions/popup/ExcludeAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1915#2,2:58\n*S KotlinDebug\n*F\n+ 1 ExcludeAction.kt\ncom/intellij/openapi/diff/impl/dir/actions/popup/ExcludeAction\n*L\n26#1:58,2\n*E\n"})
public final class ExcludeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DirDiffTableModel dirDiffTableModel = (DirDiffTableModel)e.getData(DirDiffPanel.DIR_DIFF_MODEL);
        if (dirDiffTableModel == null) {
            return;
        }
        DirDiffTableModel dirDiffModel = dirDiffTableModel;
        Object object = dirDiffModel.getSourceDir().getValue();
        VirtualFile sourceContentRoot = object instanceof VirtualFile ? (VirtualFile)object : null;
        Object object2 = dirDiffModel.getTargetDir().getValue();
        VirtualFile targetContentRoot = object2 instanceof VirtualFile ? (VirtualFile)object2 : null;
        FilterComponent filterComponent = (FilterComponent)e.getData(DirDiffPanel.DIR_DIFF_FILTER);
        if (filterComponent == null) {
            return;
        }
        FilterComponent filter = filterComponent;
        String filterQuery = null;
        filterQuery = filter.getFilter();
        DirDiffElement selectedSeparator = dirDiffModel.getSelectedSeparator();
        if (selectedSeparator != null) {
            String string2 = selectedSeparator.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = filterQuery;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"element");
            filterQuery = this.excludeFileFromScope(string2, string3, true);
        } else {
            List<DirDiffElementImpl> list = dirDiffModel.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSelectedElements(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DirDiffElementImpl it = (DirDiffElementImpl)element$iv;
                boolean bl = false;
                if (it.isSource() && sourceContentRoot != null) {
                    DiffElement diffElement = it.getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)diffElement, (String)"getSource(...)");
                    String string4 = filterQuery;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"element");
                    filterQuery = this.excludeFileFromScope((DiffElement<Object>)diffElement, sourceContentRoot, string4);
                    continue;
                }
                if (targetContentRoot == null) continue;
                DiffElement diffElement = it.getTarget();
                Intrinsics.checkNotNullExpressionValue((Object)diffElement, (String)"getTarget(...)");
                String string5 = filterQuery;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"element");
                filterQuery = this.excludeFileFromScope((DiffElement<Object>)diffElement, targetContentRoot, string5);
            }
        }
        if ((string = filterQuery) == null) {
            string = "";
        }
        filter.setFilter(string);
        filter.userTriggeredFilter();
    }

    private final String excludeFileFromScope(DiffElement<Object> diffElement, VirtualFile sourceContentRoot, String filterQuery) {
        Object object = diffElement.getValue();
        VirtualFile virtualFile = object instanceof VirtualFile ? (VirtualFile)object : null;
        if (virtualFile == null) {
            return filterQuery;
        }
        VirtualFile file = virtualFile;
        String string = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)sourceContentRoot);
        if (string == null) {
            return filterQuery;
        }
        String relativePath = string;
        return this.excludeFileFromScope(relativePath, filterQuery, file.isDirectory());
    }

    private final String excludeFileFromScope(String relativePath, String filterQuery, boolean isDir) {
        String pattern = "!" + relativePath + (isDir ? "*" : "");
        if (StringsKt.isBlank((CharSequence)filterQuery)) {
            return pattern;
        }
        return filterQuery + "&" + pattern;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

