/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerListener;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB/\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/ex/SimpleLineStatusTracker;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "Lcom/intellij/openapi/vcs/ex/Range;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "rendererBuilder", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lkotlin/jvm/functions/Function1;)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "toRange", "block", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "ourData", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "getOurData", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/DocumentTracker$BlockData;", "setBaseRevision", "", "vcsContent", "", "intellij.platform.diff.impl"})
public final class SimpleLineStatusTracker
extends LineStatusTrackerBase<Range> {
    @Nullable
    private final VirtualFile virtualFile;

    public SimpleLineStatusTracker(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(project, document);
        this.virtualFile = FileDocumentManager.getInstance().getFile(document);
    }

    public SimpleLineStatusTracker(@Nullable Project project, @NotNull Document document, @NotNull Function1<? super SimpleLineStatusTracker, ? extends LineStatusMarkerRenderer> rendererBuilder) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(rendererBuilder, (String)"rendererBuilder");
        this(project, document);
        final LineStatusMarkerRenderer renderer = (LineStatusMarkerRenderer)rendererBuilder.invoke((Object)this);
        this.getListeners().addListener((EventListener)new LineStatusTrackerListener(){

            @Override
            public void onRangesChanged() {
                renderer.scheduleUpdate();
            }
        });
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    @NotNull
    protected Range toRange(@NotNull DocumentTracker.Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new Range(block.getStart(), block.getEnd(), block.getVcsStart(), block.getVcsEnd(), null);
    }

    @Override
    @NotNull
    protected DocumentTracker.BlockData getOurData(@NotNull DocumentTracker.Block $this$ourData) {
        Intrinsics.checkNotNullParameter((Object)$this$ourData, (String)"<this>");
        return DocumentTracker.BlockData.Empty.INSTANCE;
    }

    @RequiresEdt
    public final void setBaseRevision(@NotNull CharSequence vcsContent) {
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        this.setBaseRevisionContent(vcsContent, null);
    }
}

