/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion.common;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.platform.trialPromotion.common.TrialDeclinedReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u0015J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/trialPromotion/common/TrialAvailabilityCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "eventGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eligibleForAutoTrialField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "errorCodeField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/platform/trialPromotion/common/TrialDeclinedReason;", "checkStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "hadLicenseRecentlyEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "requestDeclinedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "requestFailedEvent", "trialAvailableEvent", "checkStarted", "", "eligibleForAutoTrial", "hadLicenseRecently", "requestDeclined", "errorCode", "", "requestFailed", "trialAvailable", "getGroup", "intellij.platform.trialPromotion.common"})
public final class TrialAvailabilityCollector
extends CounterUsagesCollector {
    @NotNull
    public static final TrialAvailabilityCollector INSTANCE = new TrialAvailabilityCollector();
    @NotNull
    private static final EventLogGroup eventGroup = new EventLogGroup("trial.license.availability.check", 2, "FUS", "Events related to the trial license availability checks.", null, 16, null);
    @NotNull
    private static final BooleanEventField eligibleForAutoTrialField = EventFields.Boolean((String)"eligible_for_auto_trial", (String)"`true` means that the user is considered new to the product and is eligible for automatic trial if it is available.");
    @NotNull
    private static final EnumEventField<TrialDeclinedReason> errorCodeField = EventFields.Enum$default((String)"error_code", TrialDeclinedReason.class, null, (int)4, null);
    @NotNull
    private static final EventId1<Boolean> checkStartedEvent = eventGroup.registerEvent("check_started", (EventField)eligibleForAutoTrialField, "Check started for the user without active subscription.");
    @NotNull
    private static final EventId hadLicenseRecentlyEvent = eventGroup.registerEvent("had_license_recently", "Trial is not available because there is at least one license in user's JBA that is active or expired recently.");
    @NotNull
    private static final EventId2<Boolean, TrialDeclinedReason> requestDeclinedEvent = eventGroup.registerEvent("request_declined", (EventField)eligibleForAutoTrialField, (EventField)errorCodeField, "Trial is not available, request is declined by the server.");
    @NotNull
    private static final EventId1<Boolean> requestFailedEvent = eventGroup.registerEvent("request_failed", (EventField)eligibleForAutoTrialField, "Trial is not available because of error. E.g.: the server is unreachable.");
    @NotNull
    private static final EventId1<Boolean> trialAvailableEvent = eventGroup.registerEvent("available", (EventField)eligibleForAutoTrialField, "Trial is available.");

    private TrialAvailabilityCollector() {
    }

    public final void checkStarted(boolean eligibleForAutoTrial) {
        checkStartedEvent.log((Object)eligibleForAutoTrial);
    }

    public final void hadLicenseRecently() {
        hadLicenseRecentlyEvent.log();
    }

    public final void requestDeclined(boolean eligibleForAutoTrial, @NotNull String errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        requestDeclinedEvent.log((Object)eligibleForAutoTrial, (Object)TrialDeclinedReason.Companion.fromErrorCode(errorCode));
    }

    public final void requestFailed(boolean eligibleForAutoTrial) {
        requestFailedEvent.log((Object)eligibleForAutoTrial);
    }

    public final void trialAvailable(boolean eligibleForAutoTrial) {
        trialAvailableEvent.log((Object)eligibleForAutoTrial);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return eventGroup;
    }
}

